/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsProduct;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConnectionField;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPauDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSaiuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimStrxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RfCableRI
extends AbstractCableRI {
    private static final String name = "RfCable";
    public static final int NAMING_CONVENTION_SLOT = 0;
    public static final int NAMING_CONVENTION_NON_SLOT = 1;
    public static final int NAMING_CONVENTION_RRU_RRUW = 2;
    private String objectALdn;
    private BemMo objectAMo;
    private int objectAConnector;
    private String objectBLdn;
    private BemMo objectBMo;
    private int objectBConnector;
    private int electricalUlDelay;
    private int electricalDlDelay;
    private int ulAttenuation;
    private int dlAttenuation;
    private NalNameValue[] cableAttributes = null;
    private String ldn;
    private MoHandler moHandler = null;

    public RfCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, int n7) throws BemException {
        super(rbs, name);
        Object object;
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.objectBConnector = n2;
        this.electricalUlDelay = n3;
        this.electricalDlDelay = n4;
        this.ulAttenuation = n5;
        this.dlAttenuation = n6;
        this.moHandler = rbs.getMoHandler();
        String string3 = "";
        String string4 = "";
        if (string.indexOf(MimSlot.MOTYPENAME) == -1 && rbs.getRbsType().equals(RbsProduct.RBS_3018.NAME)) {
            if (string.indexOf(MimRuDeviceGroup.MOTYPENAME) > 0) {
                string4 = string.substring(0, string.indexOf(MimRuDeviceGroup.MOTYPENAME));
            } else if (string.indexOf(MimFuDeviceGroup.MOTYPENAME) > 0) {
                string4 = string.substring(0, string.indexOf(MimFuDeviceGroup.MOTYPENAME));
            } else if (string.indexOf(MimRruDeviceGroup.MOTYPENAME) > 0) {
                string4 = string.substring(0, string.indexOf(MimRruDeviceGroup.MOTYPENAME));
            }
            string3 = string4.substring(string4.lastIndexOf("="), string4.length() - 1);
            string3 = string3.substring(1, string3.length());
            object = this.getNameA(n);
            string3 = string3 + "_" + (String)object;
        } else if (n7 == 1) {
            string3 = this.getBoardName(string) + "_" + this.getNameA(n) + "-" + this.getBoardName(string2) + "_" + this.getNameB(n2);
        } else if (n7 == 0) {
            string3 = this.getSubrackId(string) + "_" + this.getSlotNumber(string) + "_" + this.getNameA(n);
        }
        this.objectAMo = this.moHandler.getMo(string);
        this.objectBMo = this.moHandler.getMo(string2);
        object = new CableMoi(MimRfCable.MOTYPENAME, "A_AND_B", "connectedToObjectARef", this.getObjectParent(this.objectAMo), "objectAConnector", new Integer[]{new Integer(n), new Integer(0)}, "connectedToObjectBRef", this.getObjectParent(this.objectBMo), "objectBConnector", new Integer[]{new Integer(n2)}, string3);
        this.ldn = ((MoInstance)object).getLdn();
    }

    public RfCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, int n8) throws BemException {
        super(rbs, name);
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.objectBConnector = n2;
        this.electricalUlDelay = n3;
        this.electricalDlDelay = n4;
        this.ulAttenuation = n5;
        this.dlAttenuation = n6;
        this.moHandler = rbs.getMoHandler();
        String string4 = "";
        String string5 = "";
        if (string.indexOf(MimSlot.MOTYPENAME) == -1 && rbs.getRbsType().equals(RbsProduct.RBS_3018.NAME)) {
            if (string.indexOf(MimRuDeviceGroup.MOTYPENAME) > 0) {
                string5 = string.substring(0, string.indexOf(MimRuDeviceGroup.MOTYPENAME));
                string4 = string5.substring(string5.lastIndexOf("="), string5.length() - 1);
                string4 = string4.substring(1, string4.length());
                string4 = string4 + "_" + this.getNameA(n);
            } else if (string.indexOf(MimFuDeviceGroup.MOTYPENAME) > 0) {
                string5 = string.substring(0, string.indexOf(MimFuDeviceGroup.MOTYPENAME));
                string4 = string5.substring(string5.lastIndexOf("="), string5.length() - 1);
                string4 = string4.substring(1, string4.length());
                string4 = string4 + "_" + this.getNameA(n);
            } else if (string.indexOf(MimRruDeviceGroup.MOTYPENAME) > 0) {
                string4 = this.getAuType(string) + Integer.toString(n7) + string3 + "_" + this.getConnectorAName(n);
            }
        } else if (n8 == 2) {
            string4 = this.getAuType(string) + "_" + Integer.toString(n7) + "_" + string3 + "_" + this.getConnectorAName(n);
        }
        this.objectAMo = this.moHandler.getMo(string);
        this.objectBMo = this.moHandler.getMo(string2);
        MoInstance moInstance = rbs.getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimRfCable.MOTYPENAME, string4);
        this.ldn = fixedRdnMoi.getLdn();
    }

    public RfCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3, int n4, int n5, int n6) throws BemException {
        this(rbs, string, n, string2, n2, n3, n4, n5, n6, 0);
    }

    public void install(String string) throws BemException {
        if (!string.equals("CabinetCableCreationPhase")) {
            return;
        }
        BemMo bemMo = this.moHandler.getMo(this.objectALdn);
        BemMo bemMo2 = this.moHandler.getMo(this.objectBLdn);
        boolean bl = false;
        try {
            bl = this.moHandler.isExisting(bemMo) && this.moHandler.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not access node: " + moHandlerException);
        }
        if (!bl) {
            throw new BemException("RF cable: " + this.ldn + " could not be created.\n" + "Object A ldn: " + this.objectALdn + "\n" + "Object B ldn: " + this.objectBLdn);
        }
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        bemMo = this.getObjectParent(bemMo);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", bemMo);
        vector.add(nalNameValue);
        bemMo2 = this.getObjectParent(bemMo2);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", bemMo2);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(this.objectAConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectBConnector", new Integer(this.objectBConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("electricalUlDelay", new Integer(this.electricalUlDelay));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("electricalDlDelay", new Integer(this.electricalDlDelay));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("ulAttenuation", new Integer(this.ulAttenuation));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("dlAttenuation", new Integer(this.dlAttenuation));
        vector.add(nalNameValue);
        this.reconnectBranch();
        this.createMoIfNotExisting(this.ldn, vector);
        this.setAttributes();
    }

    private void reconnectBranch() throws BemException {
        BemMo bemMo = this.moHandler.getMo(this.ldn);
        try {
            if (bemMo.isExisting()) {
                Integer n;
                boolean bl;
                boolean bl2;
                Integer n2 = (Integer)this.moHandler.getAttribute(bemMo, "objectAConnector");
                boolean bl3 = bl2 = n2 == this.objectAConnector;
                if (!bl2) {
                    this.moHandler.setAttribute(bemMo, "objectAConnector", new Integer(this.objectAConnector));
                }
                boolean bl4 = bl = (n = (Integer)this.moHandler.getAttribute(bemMo, "objectBConnector")) == this.objectBConnector;
                if (!bl) {
                    this.moHandler.setAttribute(bemMo, "objectBConnector", new Integer(this.objectBConnector));
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("RfCableRI.setAttributes()", "setAttributes()", this.ldn, null, exception);
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    private BemMo getObjectParent(BemMo bemMo) {
        BemMo bemMo2 = bemMo;
        if (bemMo.getDN().indexOf("PlugInUnit") != -1) {
            BemMo bemMo3;
            bemMo2 = bemMo3 = bemMo.getParent();
        }
        return bemMo2;
    }

    public String getDisplayName() {
        return "RfCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    private String getConnectorAName(int n) throws BemException {
        String string = null;
        switch (n) {
            case 6: {
                string = "RXA_IO";
                break;
            }
            case 9: {
                string = "RXB_IO";
                break;
            }
            case 12: {
                string = "RXA_IO";
                break;
            }
            default: {
                throw new BemException("Wrong connector A for RfCable: " + n);
            }
        }
        return string;
    }

    private String getAuType(String string) throws BemException {
        int n = string.lastIndexOf(",");
        String string2 = string.substring(0, n);
        int n2 = string2.lastIndexOf("-");
        int n3 = string2.lastIndexOf("=");
        String string3 = string2.substring(n3 + 1, n2);
        return string3;
    }

    private String getBoardName(String string) throws BemException {
        if (string.indexOf(MimRuDeviceGroup.MOTYPENAME) != -1) {
            return "RU";
        }
        if (string.indexOf(MimFuDeviceGroup.MOTYPENAME) != -1) {
            return "FU";
        }
        if (string.indexOf(MimPauDeviceGroup.MOTYPENAME) != -1) {
            return "PAU";
        }
        if (string.indexOf(MimSaiuDeviceGroup.MOTYPENAME) != -1) {
            return "sAIU";
        }
        if (string.indexOf(MimStrxDeviceGroup.MOTYPENAME) != -1) {
            return "sTRX";
        }
        if (string.indexOf(MimConnectionField.MOTYPENAME) != -1) {
            return "CF";
        }
        throw new BemException("Unknown board: " + string);
    }

    public String getNameA(int n) throws BemException {
        String string = null;
        switch (n) {
            case 0: {
                string = "NOT_CONNECTED";
                break;
            }
            case 1: {
                string = "TX_A";
                break;
            }
            case 2: {
                string = "FEEDBACK";
                break;
            }
            case 3: {
                string = "TX_OUT";
                break;
            }
            case 4: {
                string = "ANT_A";
                break;
            }
            case 5: {
                string = "ANT_B";
                break;
            }
            case 6: {
                string = "RX_A1";
                break;
            }
            case 12: {
                string = "RXA_IO";
                break;
            }
            case 7: {
                string = "RX_B";
                break;
            }
            case 8: {
                string = "RX_A2";
                break;
            }
            case 9: {
                string = "RX_B1";
                break;
            }
            case 10: {
                string = "RX_B2";
                break;
            }
            case 11: {
                string = "TX";
                break;
            }
            default: {
                throw new BemException("Wrong connector A for RfCable: " + n);
            }
        }
        return string;
    }

    private String getNameB(int n) throws BemException {
        String string = null;
        switch (n) {
            case 1: {
                string = "TX_IN";
                break;
            }
            case 2: {
                string = "FB_IN";
                break;
            }
            case 3: {
                string = "RX_A";
                break;
            }
            case 4: {
                string = "RX_B";
                break;
            }
            case 5: {
                string = "J1";
                break;
            }
            case 6: {
                string = "H1";
                break;
            }
            case 7: {
                string = "J2";
                break;
            }
            case 8: {
                string = "H2";
                break;
            }
            case 9: {
                string = "J3";
                break;
            }
            case 10: {
                string = "H3";
                break;
            }
            case 11: {
                string = "A1";
                break;
            }
            case 12: {
                string = "A2";
                break;
            }
            case 13: {
                string = "A3";
                break;
            }
            case 14: {
                string = "A4";
                break;
            }
            case 15: {
                string = "A5";
                break;
            }
            case 16: {
                string = "A6";
                break;
            }
            case 17: {
                string = "TX_A";
                break;
            }
            case 18: {
                string = "RX_A1";
                break;
            }
            case 19: {
                string = "RX_B1";
                break;
            }
            case 22: {
                string = "RXB_IO";
                break;
            }
            default: {
                throw new BemException("Wrong connector B for RfCable: " + n);
            }
        }
        return string;
    }

    private String getSlotNumber(String string) {
        return BemUtil.extractRdnId(string, "Slot");
    }

    private String getSubrackId(String string) {
        return BemUtil.extractRdnId(string, "Subrack");
    }

    public void setAttributes(NalNameValue[] nalNameValueArray) throws BemException {
        this.cableAttributes = nalNameValueArray;
    }

    private void setAttributes() throws BemException {
        if (this.cableAttributes == null) {
            return;
        }
        BemMo bemMo = this.moHandler.getMo(this.ldn);
        try {
            if (bemMo.isExisting()) {
                this.moHandler.setAttributes(bemMo, this.cableAttributes);
            }
        }
        catch (Exception exception) {
            throw new BemException("RfCableRI.setAttributes()", "setAttributes()", this.ldn, null, exception);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        try {
            if (bl) {
                BemMo bemMo = this.moHandler.getMo(this.ldn);
                BemMo bemMo2 = (BemMo)this.moHandler.getAttribute(bemMo, "connectedToObjectARef");
                BemMo bemMo3 = this.getObjectParent(this.objectAMo);
                boolean bl2 = ((Object)bemMo2).equals(bemMo3);
                BemMo bemMo4 = (BemMo)this.moHandler.getAttribute(bemMo, "connectedToObjectBRef");
                BemMo bemMo5 = this.getObjectParent(this.objectBMo);
                boolean bl3 = ((Object)bemMo4).equals(bemMo5);
                bl = bl2 && bl3;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.getAction(), moHandlerException.getLdn(), (Throwable)moHandlerException);
        }
        return bl;
    }

    public String toString() {
        return "RfCable: connectedToObjectARef " + this.getObjectParent(this.objectAMo).getDN() + ", " + "objectAConnector" + " " + this.objectAConnector + ", " + "connectedToObjectBRef" + " " + this.getObjectParent(this.objectBMo) + ", " + "objectBConnector" + " " + this.objectBConnector;
    }

    public Object[] getAttributes(String[] stringArray) throws BemException {
        Object[] objectArray = new Object[stringArray.length];
        BemMo bemMo = this.moHandler.getMo(this.ldn);
        try {
            objectArray = this.moHandler.getAttributes(bemMo, stringArray);
        }
        catch (Exception exception) {
            throw new BemException("RfCableRI.getAttributes()", "getAttributes()", this.ldn, null, exception);
        }
        return objectArray;
    }
}

