/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.AddSectorHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ChangeRbbHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.DeleteCarrierHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.DeleteSectorHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyCarrierHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class ModifyManager {
    private AbstractDuwRadioEquipmentCI radioCi;
    private RbbManager rbbManager;
    private SectorCustomerParameterManager scpm;
    private ModifyHandler[] modifyHandlers = new ModifyHandler[5];
    private ServiceValue serviceValue;
    private DeleteSectorHandler deleteSectorHandler;
    private DeleteCarrierHandler deleteCarrierHandler;
    private List downgradedSectors = new ArrayList();

    public ModifyManager(AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        this(abstractDuwRadioEquipmentCI, rbbManager, sectorCustomerParameterManager, 1);
    }

    public ModifyManager(AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager, int n) throws BemException {
        this.radioCi = abstractDuwRadioEquipmentCI;
        this.rbbManager = rbbManager;
        this.scpm = sectorCustomerParameterManager;
        this.deleteSectorHandler = new DeleteSectorHandler(this, n);
        this.deleteCarrierHandler = new DeleteCarrierHandler(this, n);
        this.modifyHandlers[0] = this.deleteSectorHandler;
        this.modifyHandlers[1] = new AddSectorHandler(this, n);
        this.modifyHandlers[2] = new ChangeRbbHandler(this, n);
        this.modifyHandlers[3] = this.deleteCarrierHandler;
        this.modifyHandlers[4] = new ModifyCarrierHandler(this, n);
    }

    public List getAllCpPseudoNames() {
        ArrayList arrayList = new ArrayList();
        if (this.radioCi.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
            for (int i = 0; i < this.modifyHandlers.length; ++i) {
                List list = this.modifyHandlers[i].getAllCpPseudoNames();
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public void checkConsistency() throws BemException {
        if (this.radioCi.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
            for (int i = 0; i < this.modifyHandlers.length; ++i) {
                this.modifyHandlers[i].checkConsistency();
            }
        }
    }

    public void updateScpmIfAppropriate(ServiceValue serviceValue, SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        if (this.radioCi.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
            this.serviceValue = serviceValue;
            for (int i = 0; i < this.modifyHandlers.length; ++i) {
                this.modifyHandlers[i].updateScpmIfAppropriate(sectorCustomerParameterManager);
            }
        }
    }

    public List getRIsToUninstall() throws BemException {
        HashMap hashMap = new HashMap();
        Rbs rbs = this.radioCi.getRbs();
        if (rbs.getRbsStep().equals("STEP_EXPANSION")) {
            for (int i = 0; i < this.modifyHandlers.length; ++i) {
                HashMap hashMap2 = this.modifyHandlers[i].getRIsToUninstall();
                hashMap.putAll(hashMap2);
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        return arrayList;
    }

    public ServiceValue getServiceValue() {
        return this.serviceValue;
    }

    public DeleteSectorHandler getDeleteHandler() {
        return this.deleteSectorHandler;
    }

    public RbbManager getRbbManager() {
        return this.rbbManager;
    }

    public void doModification() throws BemException {
        if (this.radioCi.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
            for (int i = 0; i < this.modifyHandlers.length; ++i) {
                this.modifyHandlers[i].doModification();
            }
        }
    }

    public AbstractDuwRadioEquipmentCI getRadioCI() {
        return this.radioCi;
    }

    public AbstractAntennaSystemCI getAntennaSystemCI() {
        return (AbstractAntennaSystemCI)this.radioCi.getRbs().getConfigItem("AntennaSystemCI");
    }

    public SectorCustomerParameterManager getScpm() {
        return this.scpm;
    }

    public void setDowngradedSector(int n) {
        this.downgradedSectors.add(new Integer(n));
    }

    public boolean isSectorDowngraded(int n) {
        return this.downgradedSectors.contains(new Integer(n));
    }

    public boolean isLocalCellDeleted(int n, int n2) {
        CustomerParameter customerParameter;
        Rbs rbs = this.radioCi.getRbs();
        return rbs.isModifyWiz() && (customerParameter = this.deleteCarrierHandler.getdeleteCarrierCP(n - 1, n2 - 1)) != null && !customerParameter.getValue().equals("");
    }

    public static HashMap RIListToHashMap(List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(((AbstractResourceItem)list.get(i)).getLdn(), list.get(i));
        }
        return hashMap;
    }
}

