/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.CpriLineRateCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParametersUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class SectorCustomerParameters {
    private int sectorNumber;
    private Rbs rbs;
    private AbstractDuwRadioEquipmentCI radioCi;
    private RbbManager rbbManager;
    private Enumeration rbbCp;
    private Enumeration sectorSequenceCp;
    private Enumeration primaryPortIdCp;
    private Enumeration secondaryPortIdCp;
    private CpriLineRateCustomerParameter lineRateCp;
    private Enumeration auUnitTypeCp;
    private Enumeration radioSharedBySectorCp;
    private YesNoCustomerParameter needRuPositionAllocationCp;
    private IntegerParameter cabinetNumberCp;
    private String rbbCpPseudoName;
    private String sectorSequenceCpPseudoName;
    private String primaryPortIdCpPseudoName;
    private String secondaryPortIdCpPseudoName;
    private String lineRateCpPseudoName;
    private String auUnitTypeCpPseudoName;
    private String radioSharedBySectorCpPseudoName;
    private String needRuPositionAllocationCpPseudoName;
    private String cabinetNumberCpPseudoName;
    private boolean listernersEnabled = true;

    public SectorCustomerParameters(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager, int n) throws BemException {
        this.rbs = rbs;
        this.radioCi = abstractDuwRadioEquipmentCI;
        this.rbbManager = rbbManager;
        this.sectorNumber = n;
        this.setupPseudoNames();
        this.createCustomerParameters();
        this.addListeners(sectorCustomerParameterManager);
    }

    protected void setCustomerParameterRestrictions() throws BemException {
        this.addParaRestriction(this.rbbCp, SectorCustomerParametersUtil.getRbbRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.auUnitTypeCp, SectorCustomerParametersUtil.getAuUnitTypeRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.primaryPortIdCp, SectorCustomerParametersUtil.getPrimaryPortIdRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.secondaryPortIdCp, SectorCustomerParametersUtil.getSecondaryPortIdRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.sectorSequenceCp, SectorCustomerParametersUtil.getSectorSequenceRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.radioSharedBySectorCp, SectorCustomerParametersUtil.getRadioSharedBySectorRestriction(this.rbbManager, this.sectorNumber));
        this.addParaRestriction(this.cabinetNumberCp, SectorCustomerParametersUtil.getCabinetNumberRestriction(this.rbbManager, this.sectorNumber));
    }

    private void addParaRestriction(CustomerParameterImpl customerParameterImpl, ParameterRestriction[] parameterRestrictionArray) {
        if (null == customerParameterImpl) {
            return;
        }
        customerParameterImpl.removeAllRestrictions();
        for (int i = 0; i < parameterRestrictionArray.length; ++i) {
            if (null == parameterRestrictionArray[i]) continue;
            customerParameterImpl.addRestriction(parameterRestrictionArray[i]);
        }
    }

    public boolean isIgnored() {
        boolean bl = false;
        if (this.rbbCp.getAccessLevel() == 1 && this.primaryPortIdCp.getAccessLevel() == 1) {
            bl = true;
        }
        return bl;
    }

    private void setupPseudoNames() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        this.rbbCpPseudoName = string + "radioBuildingBlock";
        this.sectorSequenceCpPseudoName = string + "sectorSequenceNumber";
        this.primaryPortIdCpPseudoName = string + "primaryPortId";
        this.secondaryPortIdCpPseudoName = string + "secondaryPortId";
        this.lineRateCpPseudoName = string + "cpriLineRate";
        this.auUnitTypeCpPseudoName = string + "auUnitType";
        this.radioSharedBySectorCpPseudoName = string + "radioSharedBySector";
        this.needRuPositionAllocationCpPseudoName = string + "needRuPositionAllocation";
        this.cabinetNumberCpPseudoName = string + "cabinetNumber";
    }

    private void createCustomerParameters() throws BemException {
        this.rbbCp = new Enumeration(this.rbbCpPseudoName, SectorCustomerParametersUtil.getFullRbbRange());
        this.sectorSequenceCp = new Enumeration(this.sectorSequenceCpPseudoName, SectorCustomerParametersUtil.getFullSectorSequenceRange());
        this.primaryPortIdCp = new Enumeration(this.primaryPortIdCpPseudoName, SectorCustomerParametersUtil.getFullPortIdRange());
        this.secondaryPortIdCp = new Enumeration(this.secondaryPortIdCpPseudoName, SectorCustomerParametersUtil.getFullPortIdRange());
        this.lineRateCp = new CpriLineRateCustomerParameter(this.lineRateCpPseudoName);
        this.auUnitTypeCp = new Enumeration(this.auUnitTypeCpPseudoName, AuUnitType.RANGE_ALL_AUUNITTYPE);
        this.radioSharedBySectorCp = new Enumeration(this.radioSharedBySectorCpPseudoName, SectorCustomerParametersUtil.getFullRadioCanSharedSectorRange());
        this.needRuPositionAllocationCp = new YesNoCustomerParameter(this.needRuPositionAllocationCpPseudoName);
        this.cabinetNumberCp = new IntegerParameter(this.cabinetNumberCpPseudoName, new IntegerRange(1, 7));
        this.rbbCp.setValue("");
        this.sectorSequenceCp.setValue("");
        this.primaryPortIdCp.setValue("");
        this.secondaryPortIdCp.setValue("");
        this.lineRateCp.setValue("");
        this.auUnitTypeCp.setValue("");
        this.radioSharedBySectorCp.setValue("");
        this.needRuPositionAllocationCp.setDefaultValue("NO");
        this.radioCi.addParameter(this.rbbCp);
        this.radioCi.addParameter(this.sectorSequenceCp);
        this.radioCi.addParameter(this.primaryPortIdCp);
        this.radioCi.addParameter(this.secondaryPortIdCp);
        this.radioCi.addParameter(this.lineRateCp);
        this.radioCi.addParameter(this.auUnitTypeCp);
        this.radioCi.addParameter(this.radioSharedBySectorCp);
        this.radioCi.addParameter(this.needRuPositionAllocationCp);
        this.radioCi.addParameter(this.cabinetNumberCp);
    }

    public String getRbbValue() {
        return this.rbbCp.getValue();
    }

    public String getLineRateValue() {
        return this.lineRateCp.getValue();
    }

    public String getSectorSequenceValue() {
        return this.sectorSequenceCp.getValue();
    }

    public boolean needRuPositionAllocation() {
        return "YES".equals(this.needRuPositionAllocationCp.getValue());
    }

    public void setNeedRuPositionAllocation(String string) {
        this.needRuPositionAllocationCp.setValue(string);
    }

    public String getPrimaryPortIdValue() {
        return this.primaryPortIdCp.getValue();
    }

    public String getSecondaryPortIdValue() {
        return this.secondaryPortIdCp.getValue();
    }

    public void clearSecondaryPortIdValue() {
        this.secondaryPortIdCp.setValue("");
    }

    public void clearRadioSharedBySectorValue() {
        this.setRadioSharedBySectorValue("");
    }

    public void setRadioSharedBySectorValue(String string) {
        this.radioSharedBySectorCp.setValue(string);
    }

    public String getAuUnitTypeValue() {
        return this.auUnitTypeCp.getValue();
    }

    public String getAuUnitTypeLoadedValue() {
        return this.auUnitTypeCp.getLoadedValue();
    }

    public boolean getNeedRuPositionAllocationLoadedValue() {
        return "YES".equals(this.needRuPositionAllocationCp.getLoadedValue());
    }

    public String getRadioSharedBySectorValue() {
        return this.radioSharedBySectorCp.getValue();
    }

    public String getCabinetNumberValue() {
        return this.cabinetNumberCp.getValue();
    }

    private boolean isCPset(CustomerParameter customerParameter) throws BemException {
        if (null == customerParameter) {
            throw new BemException("CP is null");
        }
        String string = customerParameter.getValue();
        return !"".equals(string) && !"##UNDEFINED".equals(string);
    }

    public Integer getLineRateMomValue() throws BemException {
        return this.lineRateCp.getLineRateMomValue();
    }

    public boolean isPrimaryPortIdSet() throws BemException {
        return this.isCPset(this.primaryPortIdCp);
    }

    public boolean isRbbNameSet() throws BemException {
        return this.isCPset(this.rbbCp);
    }

    public boolean isSecondaryPortIdSet() throws BemException {
        return this.isCPset(this.secondaryPortIdCp);
    }

    public boolean isLineRateSet() throws BemException {
        return this.isCPset(this.lineRateCp);
    }

    public boolean isAuUnitTypeSet() throws BemException {
        return this.isCPset(this.auUnitTypeCp);
    }

    public boolean isRruInstalledSet() throws BemException {
        if (null == this.auUnitTypeCp) {
            throw new BemException("CP is null");
        }
        return "RRU22".equals(this.auUnitTypeCp.getValue());
    }

    public boolean isAir32Set() {
        boolean bl = false;
        if (this.rbbCp != null && this.auUnitTypeCp != null && this.auUnitTypeCp.getValue().equals("AIR") && this.rbbCp.getValue().equalsIgnoreCase("RBB44_1D")) {
            bl = true;
        }
        return bl;
    }

    public boolean isRadioSharedBySectorSet() throws BemException {
        return this.isCPset(this.radioSharedBySectorCp);
    }

    public boolean isCabinetNumberSet() throws BemException {
        return this.isCPset(this.cabinetNumberCp);
    }

    protected ArrayList getAllCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.rbbCpPseudoName);
        arrayList.add(this.sectorSequenceCpPseudoName);
        arrayList.add(this.primaryPortIdCpPseudoName);
        arrayList.add(this.secondaryPortIdCpPseudoName);
        arrayList.add(this.lineRateCpPseudoName);
        arrayList.add(this.auUnitTypeCpPseudoName);
        arrayList.add(this.radioSharedBySectorCpPseudoName);
        arrayList.add(this.needRuPositionAllocationCpPseudoName);
        arrayList.add(this.cabinetNumberCpPseudoName);
        return arrayList;
    }

    protected void clearRbbDependentCPs() {
        this.sectorSequenceCp.setValue("");
        this.primaryPortIdCp.setValue("");
        this.secondaryPortIdCp.setValue("");
        this.auUnitTypeCp.setValue("");
        this.lineRateCp.setValue("");
        this.radioSharedBySectorCp.setValue("");
        this.clearCabinetNumberValue();
    }

    protected void clearSectorDependentCPs() {
        this.rbbCp.setValue("");
        this.clearRbbDependentCPs();
        this.needRuPositionAllocationCp.setValue("NO");
    }

    protected void clearCabinetNumberValue() {
        this.cabinetNumberCp.setLoadedValue("##UNDEFINED");
        this.cabinetNumberCp.resetValue();
    }

    private void addListeners(SectorCustomerParameterManager sectorCustomerParameterManager) {
        this.rbbCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.sectorSequenceCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.primaryPortIdCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.secondaryPortIdCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.auUnitTypeCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.lineRateCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
        this.radioSharedBySectorCp.addCustomerParameterListener(new GenericSectorCPListener(this.sectorNumber, this.rbbManager, sectorCustomerParameterManager));
    }

    public void setLoadedValues(String string, Integer n, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws BemException {
        this.rbbCp.setLoadedValue(string);
        this.lineRateCp.setLoadedValueFromNode(n);
        this.primaryPortIdCp.setLoadedValue(string2);
        this.secondaryPortIdCp.setLoadedValue(string3);
        this.sectorSequenceCp.setLoadedValue(string4);
        this.auUnitTypeCp.setLoadedValue(string5);
        this.radioSharedBySectorCp.setLoadedValue(string6);
        this.needRuPositionAllocationCp.setLoadedValue(string7);
        if (null != string8) {
            this.cabinetNumberCp.setLoadedValue(string8);
        }
    }

    public void disableListeners() {
        this.listernersEnabled = false;
    }

    public void enableListeners() {
        this.listernersEnabled = true;
    }

    private class GenericSectorCPListener
    implements CustomerParameterListener {
        public int sectorNumber;
        private RbbManager rbbManager;
        private SectorCustomerParameterManager scpm;

        public GenericSectorCPListener(int n, RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager) {
            this.sectorNumber = n;
            this.rbbManager = rbbManager;
            this.scpm = sectorCustomerParameterManager;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                if (customerParameter.getAccessLevel() == 0) {
                    return;
                }
                String string = customerParameter.getName();
                if (!this.rbbManager.getRbs().isModifyWiz() && this.isRbbCp(string)) {
                    this.scpm.clearRbbDependentCPs(this.sectorNumber);
                }
                try {
                    this.scpm.setCustomerParameterRestrictions(this.sectorNumber);
                    if (SectorCustomerParameters.this.listernersEnabled) {
                        this.rbbManager.notifyThatRbbsMightBeChanged(this.scpm, true);
                    }
                }
                catch (BemException bemException) {
                    BemLog.exceptionRaised("Error happened when update the RBB", bemException);
                }
                if (((CustomerParameterImpl)customerParameter).getLoadedValue().equals("##UNDEFINED")) {
                    try {
                        SectorCustomerParameters.this.radioCi.getAntennaSystemProvider().setAntennaFeederCPsRestriction(this.sectorNumber);
                    }
                    catch (BemException bemException) {
                        BemLog.exceptionRaised("Error happened when fetching antenna system ci through radioCi", bemException);
                        bemException.printStackTrace();
                    }
                }
                if (this.isAuUnitTypeCp(string)) {
                    try {
                        Object object;
                        String string2 = ((CustomerParameterImpl)customerParameter).getLoadedValue();
                        if ("".equals(string2) || "##UNDEFINED".equals(string2)) {
                            SectorCustomerParameters.this.radioCi.getAntennaSystemProvider().setTypeOfRetRangeRestriction(this.sectorNumber);
                        }
                        String string3 = ((CustomerParameterImpl)customerParameter).getValue();
                        boolean bl = "AIR".equals(string3);
                        if (SectorCustomerParameters.this.rbs.isSiteWiz() && SectorCustomerParameters.this.radioCi.isAntennaSystemProviderOpened()) {
                            object = SectorCustomerParameters.this.radioCi.getAntennaSystemProvider();
                            int n = object.getNumOfSectorAntennas(this.sectorNumber);
                            object.getRetCIComponent().setUniqueHwIdCasecadeParamRange(n, this.sectorNumber, bl);
                        }
                        if (SectorCustomerParameters.this.rbs.isModifyWiz() && "AIR".equals(string3)) {
                            object = AbstractAntennaSystemCI.getSectorPrefix(this.sectorNumber);
                            String string4 = BemUtil.getCustomerParameterName((String)object, "typeOfRet", 1);
                            if (SectorCustomerParameters.this.rbs.isParameterSupported(string4)) {
                                CustomerParameter customerParameter2 = SectorCustomerParameters.this.rbs.getCustomerParameterObject(string4);
                                customerParameter2.setValue("ARETU");
                            }
                        }
                    }
                    catch (BemException bemException) {
                        BemLog.exceptionRaised("Error happened when fetching antenna system ci through radioCi", bemException);
                    }
                }
            }
        }

        private boolean isRbbCp(String string) {
            return string.endsWith("radioBuildingBlock");
        }

        private boolean isAuUnitTypeCp(String string) {
            return string.endsWith("auUnitType");
        }
    }
}

