/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.OilRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RRB01
extends AbstractRadioBuildingBlock {
    public static final String name = "RRB01";
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String OIL_DL_DEFAULT_RDNID_1 = "-DL";
    private static final String OIL_UL_DEFAULT_RDNID_1 = "-UL";
    private static final int NO_OF_CARRIERS = 1;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 1;
    MoHandler moHandler;
    private Rbs rbs;
    private List ris = new ArrayList();
    private Integer dlConnector;
    private Integer ulConnector;
    private RadioInterfaceBoard radioIfBoard;
    private OilRI oilDl = null;
    private OilRI oilUl = null;
    private RruRI rru = null;
    Integer objectACon;
    Integer objectBCon;
    String conUlRefParam;
    String conDlRefParam;
    BemMo objectARef;
    BemMo objectBRef;
    String objARefParam;
    String objBRefParam;
    List freeConnectors = new ArrayList();
    ReservedConnectorRI[] reservedConnectors;
    private ReservedConnectorRI a;
    private ReservedConnectorRI b;
    private ReservedConnectorRI c;
    private ReservedConnectorRI d;
    private ReservedConnectorRI e;
    private ReservedConnectorRI f;
    public MoInstance managedElementMoi;
    public MoInstance equipmentMoi;
    public MoInstance nodeBFunctionMoi;
    public MoInstance sectorMoi;
    public MoInstance sectorAntennaMoi;
    public MoInstance rruMoi;
    public MoInstance rruAuxPiuMoi;
    public MoInstance optLinkDlMoi;
    public MoInstance optLinkUlMoi;
    public String[] sectorRdn = new String[]{"1", "2", "3", "4", "5", "6"};
    private ObifRI obif;
    private String radioIfType;

    public RRB01(Rbs rbs, int n, RadioInterfaceBoard radioInterfaceBoard, RruRI rruRI) throws BemException {
        super(name, n, 1, 0, 1, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.moHandler = rbs.getMoHandler();
        this.radioIfBoard = radioInterfaceBoard;
        this.obif = (ObifRI)radioInterfaceBoard;
        this.radioIfType = radioInterfaceBoard.getType();
        this.rru = rruRI;
        this.createTerminationConnector(n);
        this.createResourceItems(n);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        this.reservedConnectors = new ReservedConnectorRI[6];
        this.reservedConnectors[0] = reservedConnectorRI;
        this.reservedConnectors[1] = reservedConnectorRI2;
        this.reservedConnectors[2] = reservedConnectorRI3;
        this.reservedConnectors[3] = reservedConnectorRI4;
        this.reservedConnectors[4] = reservedConnectorRI5;
        this.reservedConnectors[5] = reservedConnectorRI6;
    }

    public void setRadioIfConnectors(int n, ReservedConnectorRI[] reservedConnectorRIArray) {
        for (int i = 0; i < reservedConnectorRIArray.length; ++i) {
            if (reservedConnectorRIArray[i] == null) continue;
            this.reservedConnectors[n - 1] = reservedConnectorRIArray[i];
        }
    }

    public void createTerminationConnector(int n) throws BemException {
        Integer[] integerArray = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        Integer[] integerArray2 = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        this.dlConnector = integerArray[n - 1];
        this.ulConnector = integerArray2[n - 1];
    }

    private void createResourceItems(int n) throws BemException {
        this.createReservedConnectors();
        if (this.rruMoi != null) {
            this.rru = new RruRI(this.rbs, this.rruMoi.getLdn(), AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[n]);
        }
        this.ris.add(this.rru);
        if (this.rruAuxPiuMoi != null) {
            this.oilDl = new OilRI(this.rbs, n - 1, "Dl", this.optLinkDlMoi.getLdn(), this.objectACon, this.objectBCon, this.conUlRefParam, this.conDlRefParam, this.rruAuxPiuMoi.getLdn());
            this.oilUl = new OilRI(this.rbs, n - 1, "Ul", this.optLinkUlMoi.getLdn(), this.objectACon, this.objectBCon, this.conUlRefParam, this.conDlRefParam, this.rruAuxPiuMoi.getLdn());
        } else {
            String string = this.rru.getAuxPiuLdn();
            String string2 = this.radioIfBoard.getPiuLdn();
            this.objectACon = this.ulConnector;
            this.objectBCon = new Integer(4);
            this.objARefParam = string2;
            this.objBRefParam = string;
            this.oilDl = new OilRI(this.rbs, n - 1, "Dl", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
            this.objectACon = new Integer(4);
            this.objectBCon = this.dlConnector;
            this.objARefParam = string;
            this.objBRefParam = string2;
            this.oilUl = new OilRI(this.rbs, n - 1, "Ul", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
        }
        this.ris.add(this.oilDl);
        this.ris.add(this.oilUl);
    }

    public List getResourceItems() throws BemException {
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.rru);
        arrayList.add(this.oilDl);
        arrayList.add(this.oilUl);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1]);
        return arrayList;
    }

    public int getReservedConnector() {
        return this.reservedConnectors[this.getSectorNo() - 1].getConnector();
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (string.equalsIgnoreCase("A")) {
            n = new Integer(1);
        } else if (string.equalsIgnoreCase("B")) {
            n = new Integer(2);
        } else {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("B")) {
            if (this.rruAuxPiuMoi != null) {
                return this.rruAuxPiuMoi.getLdn();
            }
            return this.rru.getAuxPiuLdn();
        }
        if (string.equalsIgnoreCase("UL") || string.equalsIgnoreCase("DL")) {
            return this.obif.getPiuLdn();
        }
        throw new BemException(this.getClass().getName() + " getTerminationObject(): Type " + string + " not supported");
    }

    public String getRadioInterfaceType() throws BemException {
        return this.radioIfType;
    }

    public String getPrevious() throws BemException {
        String string = "";
        String string2 = this.oilDl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string2);
            BemMo bemMo2 = (BemMo)moHandler.getAttribute(bemMo, "connectedToObjectARef");
            string = bemMo2.getDN();
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return string;
    }

    public Integer getPrimaryPortId() throws BemException {
        Integer n;
        String string = this.oilDl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string);
            n = (Integer)moHandler.getAttribute(bemMo, "objectAConnector");
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return n;
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    protected void initialiseMoiResources(int n) throws BemException {
        this.equipmentMoi = this.rbs.getEquipmentMoi();
        this.nodeBFunctionMoi = this.rbs.getNodeBFunctionMoi();
        this.sectorMoi = new FixedRdnMoi(this.nodeBFunctionMoi, MimSector.MOTYPENAME, this.sectorRdn[n - 1]);
        this.sectorAntennaMoi = new SectorAntennaMoi(this.equipmentMoi, this.sectorMoi, "" + n);
        this.rruAuxPiuMoi = new ChildWithAttributeValues(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(10), "RRU");
        this.rruMoi = new SingleChildMoi(this.rruAuxPiuMoi, MimRruDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.objectACon = this.ulConnector;
        this.objectBCon = this.dlConnector;
        this.conUlRefParam = this.radioIfBoard.getPiuLdn();
        this.objectARef = this.moHandler.getMo(this.conUlRefParam);
        this.conDlRefParam = this.radioIfBoard.getPiuLdn();
        this.objectBRef = this.moHandler.getMo(this.conDlRefParam);
        this.optLinkUlMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", this.objectBRef, "objectBConnector", this.objectBCon, Integer.toString(n) + OIL_UL_DEFAULT_RDNID_1);
        this.optLinkDlMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", this.objectARef, "objectAConnector", this.objectACon, null, null, null, null, Integer.toString(n) + OIL_DL_DEFAULT_RDNID_1);
    }

    private void createReservedConnectors() {
        String string = MimOpticalInterfaceLink.MOTYPENAME;
        String string2 = "objectAConnector";
        this.a = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 1, string, string2);
        this.b = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 2, string, string2);
        this.c = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 3, string, string2);
        this.d = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 5, string, string2);
        this.e = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 6, string, string2);
        this.f = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 7, string, string2);
        this.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        try {
            if (bl) {
                String string;
                String string2;
                String string3;
                BemMo bemMo;
                MoHandler moHandler = this.rbs.getMoHandler();
                if (moHandler.isExisting(bemMo = moHandler.getMo(string3 = (string2 = (string = this.rru.getAuxPiuLdn()).substring(0, string.length() - "RRU-1".length())) + "RRU-2"))) {
                    return false;
                }
                String string4 = string2 + "RRUW-2";
                BemMo bemMo2 = moHandler.getMo(string4);
                if (moHandler.isExisting(bemMo2)) {
                    return false;
                }
                Integer n = this.obif.getConfigurationGroup();
                if (n == 0) {
                    return bl;
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new BemException("", (Throwable)exception);
        }
        return bl;
    }

    public int getNoOfRruAndRruwPerPort() {
        return 1;
    }

    public int getNoOfRrusAndRruws() {
        return 1;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

