/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig.ServerConfigCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class ServerIpAdressRI
extends AbstractResourceItem
implements CustomerParameterListener {
    public static final String name = "ServerIpAdress";
    private static final String[] phases = new String[]{"ServerIpSettingPhase"};
    private static final String DEFAULT_IP_ADDRESS = "";
    private final String ldn;
    private final ParameterRestriction optionalRestiction = new ParameterRestriction("", 2);
    private final ParameterRestriction defaultDomainNameMandatory = new ParameterRestriction("isDefaultDomainName is TRUE", 3);
    private final ParameterRestriction defaultDomainNameIgnored = new ParameterRestriction("isDefaultDomainName is FALSE", 1);
    private final ServerConfigCI serverConfigCI;
    private YesNoCustomerParameter isDefaultDomainNameCP;
    private StringParameter defaultDomainNameCP;
    private IpAddressParameter dhcpServerPrimaryIpAddressCP;
    private IpAddressParameter dhcpServerSecondaryIpAddressCP;
    private IpAddressParameter dnsServerIpAddressCP;
    private StringParameter ossCorbaNameServerAddressCP;
    private IntegerParameter ossCorbaNameServerPortCP;
    private StringParameter alexServerCP;
    private StringParameter slsServerCP;
    private final Vector allCustomerParameters = new Vector();
    private final BemMo dhcpMO;
    private final BemMo ipMo;
    private final BemMo rbsConfigurationMo;

    public ServerIpAdressRI(Rbs rbs, ServerConfigCI serverConfigCI) throws BemException {
        super(name, rbs, phases);
        this.serverConfigCI = serverConfigCI;
        MoInstance moInstance = this.rbs.getMoiRefs().getDhcpMoi();
        MoInstance moInstance2 = this.rbs.getMoiRefs().getIpMoi();
        MoInstance moInstance3 = this.rbs.getMoiRefs().getManagedElementDataMoi();
        this.dhcpMO = super.getMo(moInstance.getLdn());
        this.ipMo = super.getMo(moInstance2.getLdn());
        this.ldn = moInstance3.getLdn();
        this.rbsConfigurationMo = this.getMo(this.rbs.getMoiRefs().getRbsConfigurationMoi().getLdn());
        this.setupCustomerParameters();
    }

    public boolean isInstalled() {
        return true;
    }

    protected boolean shouldRiBeInstalled() {
        boolean bl = false;
        for (int i = 0; i < this.allCustomerParameters.size(); ++i) {
            CustomerParameter customerParameter = (CustomerParameter)this.allCustomerParameters.get(i);
            if (!customerParameter.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            this.updateRbsWithDhcp();
            Vector vector = new Vector();
            this.addChangedSlsValuesToVector(vector);
            this.addChangedAlexValuesToVector(vector);
            if (vector.size() > 0) {
                BemMo bemMo = super.getMo(this.ldn);
                super.setAttributes(bemMo, vector);
            }
            vector = new Vector();
            this.addChangedDnsValuesToVector(vector);
            this.addChangedDefaultDomainValuesToVector(vector);
            if (vector.size() > 0) {
                super.setAttributes(this.ipMo, vector);
            }
            vector = new Vector();
            this.addChangedOssValuesToVector(vector);
            if (vector.size() > 0) {
                super.setAttributes(this.rbsConfigurationMo, vector);
            }
        }
    }

    protected void checkConsistency() throws BemException {
        if (this.dhcpServerPrimaryIpAddressCP.getValue().equals(DEFAULT_IP_ADDRESS) && !this.dhcpServerSecondaryIpAddressCP.getValue().equals(DEFAULT_IP_ADDRESS)) {
            throw new BemException(this.dhcpServerSecondaryIpAddressCP.getName() + " is set to " + this.dhcpServerSecondaryIpAddressCP.getValue() + " and" + this.dhcpServerPrimaryIpAddressCP.getName() + " is not set");
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return name;
    }

    private void setupCustomerParameters() throws BemException {
        this.setupDhcpCustomerParameters();
        this.setupDnsCustomerParameter();
        this.setupDomainNameCustomerParameters();
        this.setupSlsServerCustomerParameter();
        this.setupAlexServerCustomerParameter();
        this.setupOssCorbaNameServiceCustomerParameters();
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string;
        if (parameterEvent.isValueChanged() && (string = customerParameter.getName()).equalsIgnoreCase(this.isDefaultDomainNameCP.getName())) {
            String string2 = this.isDefaultDomainNameCP.getValue();
            boolean bl = string2.equalsIgnoreCase("YES");
            if (bl) {
                this.defaultDomainNameCP.removeRestriction(this.defaultDomainNameIgnored);
                this.defaultDomainNameCP.addRestriction(this.defaultDomainNameMandatory);
            } else {
                this.defaultDomainNameCP.removeRestriction(this.defaultDomainNameMandatory);
                this.defaultDomainNameCP.addRestriction(this.defaultDomainNameIgnored);
            }
        }
    }

    private void setupDomainNameCustomerParameters() throws BemException {
        Boolean bl = null;
        bl = (Boolean)super.getAttribute(this.ipMo, "isDefDomainName");
        boolean bl2 = bl;
        this.isDefaultDomainNameCP = new YesNoCustomerParameter("isDefaultDomainName");
        this.isDefaultDomainNameCP.addRestriction(this.optionalRestiction);
        this.isDefaultDomainNameCP.setLoadedValue(bl.toString());
        this.serverConfigCI.addParameter(this.isDefaultDomainNameCP);
        this.allCustomerParameters.add(this.isDefaultDomainNameCP);
        StringRange stringRange = new StringRange(new Integer(0), new Integer(255));
        this.defaultDomainNameCP = new StringParameter("defaultDomainName", stringRange);
        this.defaultDomainNameCP.setDefaultValue(MimIp.DEFAULT_DEFDOMAINNAME);
        String string = (String)super.getAttribute(this.ipMo, "defDomainName");
        this.defaultDomainNameCP.setLoadedValue(string);
        if (bl2) {
            this.defaultDomainNameCP.addRestriction(this.defaultDomainNameMandatory);
        } else {
            this.defaultDomainNameCP.addRestriction(this.defaultDomainNameIgnored);
        }
        this.serverConfigCI.addParameter(this.defaultDomainNameCP);
        this.allCustomerParameters.add(this.defaultDomainNameCP);
        this.isDefaultDomainNameCP.addCustomerParameterListener(this);
    }

    private void setupOssCorbaNameServiceCustomerParameters() throws BemException {
        Integer n = new Integer(0);
        Integer n2 = new Integer(200);
        this.ossCorbaNameServerAddressCP = new StringParameter("ossCorbaNameServer", new StringRange(n, n2));
        this.ossCorbaNameServerAddressCP.addRestriction(this.optionalRestiction);
        String string = (String)super.getAttribute(this.rbsConfigurationMo, "ossCorbaNameServiceAddress");
        this.ossCorbaNameServerAddressCP.setLoadedValue(string);
        this.ossCorbaNameServerPortCP = new IntegerParameter("ossCorbaNameServerPort", new IntegerRange(0, 65535));
        Integer n3 = (Integer)super.getAttribute(this.rbsConfigurationMo, "ossCorbaNameServicePort");
        this.ossCorbaNameServerPortCP.setLoadedValue(n3);
        this.ossCorbaNameServerPortCP.addRestriction(this.optionalRestiction);
        this.serverConfigCI.addParameter(this.ossCorbaNameServerAddressCP);
        this.allCustomerParameters.add(this.ossCorbaNameServerAddressCP);
        this.serverConfigCI.addParameter(this.ossCorbaNameServerPortCP);
        this.allCustomerParameters.add(this.ossCorbaNameServerPortCP);
    }

    private void setupDhcpCustomerParameters() throws BemException {
        this.dhcpServerPrimaryIpAddressCP = new IpAddressParameter("dhcpServerPrimaryIpAddress", new IpAddressRange());
        this.dhcpServerPrimaryIpAddressCP.addRestriction(this.optionalRestiction);
        this.dhcpServerSecondaryIpAddressCP = new IpAddressParameter("dhcpServerSecondaryIpAddress", new IpAddressRange());
        this.dhcpServerSecondaryIpAddressCP.addRestriction(this.optionalRestiction);
        String[] stringArray = null;
        stringArray = (String[])super.getAttribute(this.dhcpMO, "dhcpServerAddresses");
        String string = DEFAULT_IP_ADDRESS;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        this.dhcpServerPrimaryIpAddressCP.setLoadedValue(string);
        String string2 = DEFAULT_IP_ADDRESS;
        if (stringArray != null && stringArray.length > 1) {
            string2 = stringArray[1];
        }
        this.dhcpServerSecondaryIpAddressCP.setLoadedValue(string2);
        this.serverConfigCI.addParameter(this.dhcpServerPrimaryIpAddressCP);
        this.allCustomerParameters.add(this.dhcpServerPrimaryIpAddressCP);
        this.serverConfigCI.addParameter(this.dhcpServerSecondaryIpAddressCP);
        this.allCustomerParameters.add(this.dhcpServerSecondaryIpAddressCP);
    }

    private void setupDnsCustomerParameter() throws BemException {
        this.dnsServerIpAddressCP = new IpAddressParameter("dnsServerIpAddress", new IpAddressRange());
        this.dnsServerIpAddressCP.addRestriction(this.optionalRestiction);
        String string = DEFAULT_IP_ADDRESS;
        String[] stringArray = null;
        stringArray = (String[])super.getAttribute(this.ipMo, "dnsServerAddresses");
        if (stringArray != null && stringArray.length != 0) {
            string = stringArray[0];
        }
        this.dnsServerIpAddressCP.setLoadedValue(string);
        this.serverConfigCI.addParameter(this.dnsServerIpAddressCP);
        this.allCustomerParameters.add(this.dnsServerIpAddressCP);
    }

    private void setupAlexServerCustomerParameter() throws BemException {
        Integer n = new Integer(0);
        Integer n2 = new Integer(200);
        this.alexServerCP = new StringParameter("documentServerWebAddress", new StringRange(n, n2));
        this.alexServerCP.addRestriction(this.optionalRestiction);
        String string = MimManagedElementData.DEFAULT_DOCUMENTSERVERADDRESS;
        BemMo bemMo = super.getMo(this.ldn);
        string = (String)super.getAttribute(bemMo, "documentServerAddress");
        this.alexServerCP.setLoadedValue(string);
        this.serverConfigCI.addParameter(this.alexServerCP);
        this.allCustomerParameters.add(this.alexServerCP);
    }

    private void setupSlsServerCustomerParameter() throws BemException {
        Integer n = new Integer(0);
        Integer n2 = new Integer(200);
        this.slsServerCP = new StringParameter("singleLogonServer", new StringRange(n, n2));
        this.slsServerCP.addRestriction(this.optionalRestiction);
        String string = MimManagedElementData.DEFAULT_LOGONSERVERADDRESS;
        BemMo bemMo = super.getMo(this.ldn);
        string = (String)super.getAttribute(bemMo, "logonServerAddress");
        this.slsServerCP.setLoadedValue(string);
        this.serverConfigCI.addParameter(this.slsServerCP);
        this.allCustomerParameters.add(this.slsServerCP);
    }

    private void removeOldDhcpAddressesFromRbs() throws BemException {
        String[] stringArray;
        if ((this.dhcpServerPrimaryIpAddressCP.hasValueChanged() || this.dhcpServerSecondaryIpAddressCP.hasValueChanged()) && (stringArray = (String[])super.getAttribute(this.dhcpMO, "dhcpServerAddresses")) != null && stringArray.length != 0) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("ipAddressArray", stringArray)};
            super.action(this.dhcpMO, "removeDhcpServerAddress", nalNameValueArray);
        }
    }

    private void addNewDhcpAddressesToRbs() throws BemException {
        Vector<String> vector = new Vector<String>(0);
        if (!this.dhcpServerPrimaryIpAddressCP.getValue().equals(DEFAULT_IP_ADDRESS)) {
            vector.add(this.dhcpServerPrimaryIpAddressCP.getValue());
            if (!this.dhcpServerSecondaryIpAddressCP.getValue().equals(DEFAULT_IP_ADDRESS)) {
                vector.add(this.dhcpServerSecondaryIpAddressCP.getValue());
            }
            String[] stringArray = null;
            if (vector.size() != 0) {
                stringArray = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray[i] = (String)vector.get(i);
                }
            }
            if (stringArray != null) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("ipAddressArray", stringArray)};
                super.action(this.dhcpMO, "addDhcpServerAddress", nalNameValueArray);
            }
        }
    }

    private void addChangedOssValuesToVector(Vector vector) {
        if (this.ossCorbaNameServerAddressCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("ossCorbaNameServiceAddress", this.ossCorbaNameServerAddressCP.getValue()));
        }
        if (this.ossCorbaNameServerPortCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("ossCorbaNameServicePort", new Integer(this.ossCorbaNameServerPortCP.getValue())));
        }
    }

    private void updateRbsWithDhcp() throws BemException {
        if (this.dhcpServerPrimaryIpAddressCP.hasValueChanged() || this.dhcpServerSecondaryIpAddressCP.hasValueChanged()) {
            this.removeOldDhcpAddressesFromRbs();
            this.addNewDhcpAddressesToRbs();
        }
    }

    private void addChangedSlsValuesToVector(Vector vector) {
        if (this.slsServerCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("logonServerAddress", this.slsServerCP.getValue()));
        }
    }

    private void addChangedAlexValuesToVector(Vector vector) {
        if (this.alexServerCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("documentServerAddress", this.alexServerCP.getValue()));
        }
    }

    private void addChangedDnsValuesToVector(Vector vector) {
        if (this.dnsServerIpAddressCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("dnsServerAddresses", new String[]{this.dnsServerIpAddressCP.getValue()}));
        }
    }

    private void addChangedDefaultDomainValuesToVector(Vector vector) {
        if (this.defaultDomainNameCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("defDomainName", this.defaultDomainNameCP.getValue()));
        }
        if (this.isDefaultDomainNameCP.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("isDefDomainName", this.isDefaultDomainNameCP.getBooleanObject()));
        }
    }
}

