/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.BaseBandPoolData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet12;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet13;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB1B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB3B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4Bb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB6B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB7B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB8B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.DiscBranchBReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuifDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;

public class RadioEquipment6102CI
extends GenericRadioEquipmentCI {
    private static final int MAX_NO_OF_SECTORS = 6;
    private static final int MAX_NO_OF_RUS = 0;
    private static final int MAX_NO_OF_CARRIERS = 4;
    private ReservedConnectorRI[] a = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] b = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] c = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] d = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] e = new ReservedConnectorRI[2];
    private ReservedConnectorRI[] f = new ReservedConnectorRI[2];
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment6102CI(Rbs rbs) {
        super(rbs, 6, 0, 4, false);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"10", "11", "14", "15"});
        this.setBoardPositions(MimRuifDeviceGroup.MOTYPENAME, new String[]{"12", "13"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"4", "5", "6", "7", "8", "9", "16", "17", "18", "19", "20", "21"});
        BaseBandPoolData baseBandPoolData = new BaseBandPoolData(13, 4);
        super.setBaseBandPoolData(baseBandPoolData);
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.getMaxNoOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        this.createReservedConnectors();
        for (int i = 1; i <= n; ++i) {
            Reconfiguration[] reconfigurationArray;
            Object object;
            SectorCapability sectorCapability = new SectorCapability();
            int n2 = 2 * i;
            if (i > 3) {
                n2 = 2 * (i - 3) + 1;
            }
            RuwRI ruwRI = this.ruwSubrack.getSlot(n2);
            RB1B rB1B = new RB1B(this.rbs, i, ruwRI, this.ruif[0], 60);
            RB4B rB4B = new RB4B(this.rbs, i, ruwRI, this.ruif[0], 60);
            RB4Bb rB4Bb = new RB4Bb(this.rbs, i, ruwRI, this.ruif[0], this.ruif[1], 60);
            rB1B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            rB4B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            rB4Bb.setRadioIfConnectors(this.a[1], this.b[0], this.c[1], this.d[0], this.e[1], this.f[0]);
            if (i <= 3) {
                object = this.ruwSubrack.getSlot(n2 + 1);
                reconfigurationArray = new RB3B(this.rbs, i, ruwRI, (RuwRI)object, this.ruif[0], 60, 0, 0, 0, 0);
                RB6B rB6B = new RB6B(this.rbs, i, ruwRI, (RuwRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                RB7B rB7B = new RB7B(this.rbs, i, ruwRI, (RuwRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                RB8B rB8B = new RB8B(this.rbs, i, ruwRI, (RuwRI)object, this.ruif[0], this.ruif[1], 60, 0, 0, 0, 0);
                reconfigurationArray.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB6B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB7B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                rB8B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
                Reconfiguration[] reconfigurationArray2 = new Reconfiguration[]{new DiscBranchBReconfiguration(this.getRbs(), rB1B, (RadioBuildingBlock)reconfigurationArray, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB4B, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB4Bb, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB6B, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB7B, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB8B, i)};
                Reconfiguration[] reconfigurationArray3 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), (RadioBuildingBlock)reconfigurationArray, rB6B, i), new UninitSectorReconfiguration(this.getRbs(), (RadioBuildingBlock)reconfigurationArray, rB7B, i), new UninitSectorReconfiguration(this.getRbs(), (RadioBuildingBlock)reconfigurationArray, rB8B, i)};
                Reconfiguration[] reconfigurationArray4 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB4B, (RadioBuildingBlock)reconfigurationArray, i), new UninitSectorReconfiguration(this.getRbs(), rB4B, rB6B, i), new DiscBranchBReconfiguration(this.getRbs(), rB4B, rB7B, i)};
                Reconfiguration[] reconfigurationArray5 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB4Bb, rB6B, i), new DiscBranchBReconfiguration(this.getRbs(), rB4Bb, rB7B, i)};
                Reconfiguration[] reconfigurationArray6 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB7B, rB6B, i)};
                Reconfiguration[] reconfigurationArray7 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB8B, rB6B, i)};
                sectorCapability.addConfiguration(rB1B, reconfigurationArray2);
                sectorCapability.addConfiguration(rB4B, reconfigurationArray4);
                sectorCapability.addConfiguration(rB4Bb, reconfigurationArray5);
                sectorCapability.addConfiguration((RadioBuildingBlock)reconfigurationArray, reconfigurationArray3);
                sectorCapability.addConfiguration(rB6B);
                sectorCapability.addConfiguration(rB7B, reconfigurationArray6);
                sectorCapability.addConfiguration(rB8B, reconfigurationArray7);
            } else {
                object = new RB4Bb(this.rbs, i, ruwRI, this.ruif[0], this.ruif[1], 60);
                ((RB4Bb)object).setRadioIfConnectors(this.a[0], this.b[1], this.c[0], this.d[1], this.e[0], this.f[1]);
                reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB1B, (RadioBuildingBlock)object, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB4B, i)};
                sectorCapability.addConfiguration(rB1B, reconfigurationArray);
                sectorCapability.addConfiguration((RadioBuildingBlock)object);
                sectorCapability.addConfiguration(rB4B);
            }
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createRadioInterfaceBoard() {
        this.ruif[0] = new RuifRI(this.rbs, 12, this.hubSubrackMoi);
        this.ruif[1] = new RuifRI(this.rbs, 13, this.hubSubrackMoi);
    }

    protected void createSubracks() throws BemException {
        this.ruwSubrack = new RuwSubrackRI(this.rbs, 7, "", "0Z0", 2);
    }

    protected RbsCableSets getRbsCableSets() {
        RbsCableSets rbsCableSets = new RbsCableSets();
        rbsCableSets.addCableSet("RB1B", new CableSet12());
        rbsCableSets.addCableSet("RB4B", new CableSet12());
        rbsCableSets.addCableSet("RB4Bb", new CableSet12());
        rbsCableSets.addCableSet("RB3B", new CableSet13());
        rbsCableSets.addCableSet("RB6B", new CableSet13());
        rbsCableSets.addCableSet("RB7B", new CableSet13());
        rbsCableSets.addCableSet("RB8B", new CableSet13());
        return rbsCableSets;
    }

    private void createReservedConnectors() {
        String string = MimDigitalCable.MOTYPENAME;
        String string2 = "objectAConnector";
        for (int i = 0; i <= 1; ++i) {
            this.a[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 1, string, string2);
            this.b[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 2, string, string2);
            this.c[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 3, string, string2);
            this.d[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 4, string, string2);
            this.e[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 5, string, string2);
            this.f[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 6, string, string2);
        }
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RUIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

