/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.EditorRendererBase;

public class ComboBoxRenderer
extends EditorRendererBase
implements TableCellRenderer,
ActionListener {
    protected JComboBox editor = null;
    private boolean isCellNotEditable = false;

    public ComboBoxRenderer(CustomerParameter customerParameter) {
        super(customerParameter);
    }

    public ComboBoxRenderer(CustomerParameter customerParameter, boolean bl) {
        super(customerParameter);
        this.isCellNotEditable = bl;
    }

    public boolean stopCellEditing() {
        super.stopCellEditing();
        String string = (String)this.editor.getSelectedItem();
        try {
            this.customerParameter.setValue(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.isCellNotEditable) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.editor = this.createCombobox(object);
        if (bl) {
            this.editor.setForeground(jTable.getSelectionForeground());
            this.editor.setBackground(jTable.getSelectionBackground());
        } else {
            this.editor.setForeground(jTable.getForeground());
            this.editor.setBackground(jTable.getBackground());
        }
        if (bl2) {
            Border border = null;
            if (bl) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.editor.setBorder(border);
            if (!bl && jTable.isCellEditable(n, n2)) {
                Color color = UIManager.getColor("Table.focusCellForeground");
                if (color != null) {
                    this.editor.setForeground(color);
                }
                if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.editor.setBackground(color);
                }
            }
        } else {
            this.editor.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        return this.editor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
            String string = (String)this.editor.getSelectedItem();
            this.setCustomerParameterValue(string);
        }
    }

    protected JComboBox createCombobox(Object object) {
        if (object != null && object instanceof Enumeration) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            EnumeratedRange enumeratedRange = (EnumeratedRange)this.customerParameter.getEnabledValueRange();
            List list = enumeratedRange.getRangeValues();
            String[] stringArray = list.toArray(new String[0]);
            String string = customerParameter.getValue();
            int n = this.customerParameter.getAccessLevel();
            if (n == 1) {
                string = "-";
                stringArray = new String[]{"-"};
            }
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            boolean bl = customerParameter.isValidValue(string);
            if (bl) {
                jComboBox.setSelectedItem(string);
            } else {
                String string2 = (String)jComboBox.getSelectedItem();
                this.setCustomerParameterValue(string2);
            }
            this.editor = jComboBox;
            this.editor.addActionListener(this);
        }
        return this.editor;
    }
}

