/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.EditorRendererBase;

public class ComboboxEditorRenderer
extends EditorRendererBase
implements TableCellEditor,
TableCellRenderer,
ActionListener {
    protected JComboBox editor = null;

    public ComboboxEditorRenderer(CustomerParameter customerParameter) {
        super(customerParameter);
    }

    public boolean stopCellEditing() {
        super.stopCellEditing();
        String string = (String)this.editor.getSelectedItem();
        try {
            this.customerParameter.setValue(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editor = this.createCombobox(object);
        return this.editor;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.editor = this.createCombobox(object);
        if (bl2) {
            this.editor.setForeground(jTable.getSelectionForeground());
            this.editor.setBackground(jTable.getSelectionBackground());
        } else {
            this.editor.setForeground(jTable.getForeground());
            this.editor.setBackground(jTable.getBackground());
        }
        return this.editor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
            String string = (String)this.editor.getSelectedItem();
            this.setCustomerParameterValue(string);
        }
    }

    protected JComboBox createCombobox(Object object) {
        if (object != null && object instanceof Enumeration) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            EnumeratedRange enumeratedRange = (EnumeratedRange)this.customerParameter.getEnabledValueRange();
            List list = enumeratedRange.getRangeValues();
            String[] stringArray = list.toArray(new String[0]);
            String string = customerParameter.getValue();
            int n = this.customerParameter.getAccessLevel();
            if (n == 1) {
                string = "-";
                stringArray = new String[]{"-"};
            }
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            boolean bl = customerParameter.isValidValue(string);
            if (bl) {
                jComboBox.setSelectedItem(string);
            } else {
                String string2 = (String)jComboBox.getSelectedItem();
                this.setCustomerParameterValue(string2);
            }
            this.editor = jComboBox;
            this.editor.addActionListener(this);
        }
        return this.editor;
    }
}

