/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.EditorRendererBase;
import se.ericsson.wcdma.rbs.bem.common.gui.TextFieldEditor;
import se.ericsson.wcdma.rbs.bem.common.gui.TooltipFactory;

public class TextFieldRenderer
extends EditorRendererBase
implements TableCellRenderer {
    protected JTextField renderer = null;
    private boolean isCellNotEditable = false;

    public TextFieldRenderer(CustomerParameter customerParameter) {
        super(customerParameter);
    }

    public TextFieldRenderer(CustomerParameter customerParameter, boolean bl) {
        super(customerParameter);
        this.isCellNotEditable = bl;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.isCellNotEditable) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null && object instanceof CustomerParameter) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            TextFieldEditor textFieldEditor = new TextFieldEditor(customerParameter);
            String string = TooltipFactory.generateTooltip(customerParameter);
            textFieldEditor.setToolTipText(string);
            String string2 = customerParameter.getValue();
            if (string2.equals("##UNDEFINED")) {
                int n3 = customerParameter.getAccessLevel();
                if (n3 == 3) {
                    textFieldEditor.setText("*");
                } else {
                    textFieldEditor.setText("");
                }
            } else {
                textFieldEditor.setText(string2);
            }
            textFieldEditor.keyReleased(null);
            if (bl) {
                textFieldEditor.setForeground(jTable.getSelectionForeground());
                textFieldEditor.setBackground(jTable.getSelectionBackground());
            } else {
                textFieldEditor.setForeground(jTable.getForeground());
                textFieldEditor.setBackground(jTable.getBackground());
            }
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                textFieldEditor.setBorder(border);
                if (!bl && jTable.isCellEditable(n, n2)) {
                    Color color = UIManager.getColor("Table.focusCellForeground");
                    if (color != null) {
                        textFieldEditor.setForeground(color);
                    }
                    if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                        textFieldEditor.setBackground(color);
                    }
                }
            } else {
                textFieldEditor.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            this.renderer = textFieldEditor;
        }
        return this.renderer;
    }
}

