/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.SystemColor;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import se.ericsson.wcdma.support.gui.gengui.ComponentLayout;
import se.ericsson.wcdma.support.gui.gengui.GenLabel;
import se.ericsson.wcdma.support.gui.gengui.MandatoryLabel;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;

abstract class AbstractGenLabelledField
extends JPanel
implements LocaleChangeListener {
    private GenLabel label = null;
    private boolean mandatory = false;
    private MandatoryLabel mandatoryLabel = null;
    private ComponentLayout layout = null;
    String myBundle = null;
    Locale myLocale;
    private ResourceBundle myResourceBundle = null;
    String toolTipBundle = null;
    String toolTipTag = null;
    String toolTipAddition = "";

    protected AbstractGenLabelledField(String string, String string2) {
        this.setAlignmentX(0.0f);
        this.myBundle = string;
        this.layout = new ComponentLayout();
        this.label = new GenLabel(string, string2);
        if (string2.equals("")) {
            this.label.setVisible(false);
        }
        this.setLayout(this.layout);
        this.add(this.label);
        this.putClientProperty("LANGUAGE_CONTROLLED", "NA");
    }

    protected AbstractGenLabelledField(String string) {
        this.setAlignmentX(0.0f);
        this.layout = new ComponentLayout();
        this.label = new GenLabel(string);
        if (string.equals("")) {
            this.label.setVisible(false);
        }
        this.setLayout(this.layout);
        this.add(this.label);
    }

    public void updateLocale(Locale locale) {
        this.myLocale = locale;
        this.label.updateLocale(locale);
        this.myResourceBundle = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
    }

    String translateString(String string) {
        String string2 = "";
        if (string != null) {
            try {
                string2 = this.myResourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
            }
        }
        return string2;
    }

    public void setMandatory(boolean bl) {
        if (!this.mandatory && bl) {
            this.mandatoryLabel = new MandatoryLabel();
            this.add(this.mandatoryLabel);
            this.mandatory = true;
        } else if (this.mandatory && !bl) {
            this.remove(this.mandatoryLabel);
            this.mandatory = false;
        }
        this.layoutComponent();
    }

    protected GenLabel getLabel() {
        Log.trace("getLabel()");
        return this.label;
    }

    protected abstract Object getFieldComponent();

    protected void setToolTip(String string, String string2) {
        Log.trace("setToolTip(" + string2 + ")");
        this.toolTipBundle = string;
        this.toolTipTag = string2;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    protected void setToolTip(String string) {
        Log.trace("setToolTip(" + string + ")");
        JComponent jComponent = (JComponent)this.getFieldComponent();
        jComponent.setToolTipText(string);
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle resourceBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            JComponent jComponent = (JComponent)this.getFieldComponent();
            if (this.toolTipTag != null) {
                try {
                    jComponent.setToolTipText(resourceBundle.getString(this.toolTipTag) + this.toolTipAddition);
                }
                catch (MissingResourceException missingResourceException) {
                    jComponent.setToolTipText(this.toolTipTag + this.toolTipAddition);
                }
            }
        }
    }

    protected void setToolTip(String string, String string2, String string3) {
        this.toolTipAddition = string3;
        if (null == string2) {
            JComponent jComponent = (JComponent)this.getFieldComponent();
            jComponent.setToolTipText(this.toolTipAddition);
        } else {
            this.setToolTip(string, string2);
        }
    }

    protected void setEditable(boolean bl) {
        Log.trace("setEditable()");
        JComponent jComponent = (JComponent)this.getFieldComponent();
        if (JTextComponent.class.isAssignableFrom(this.getFieldComponent().getClass())) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setEditable(bl);
            if (bl) {
                try {
                    jTextComponent.setBackground(SystemColor.window);
                    jTextComponent.setBorder(((JTextComponent)this.getFieldComponent().getClass().newInstance()).getBorder());
                }
                catch (InstantiationException instantiationException) {
                    Log.logError("Error create text component", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.logError("Error create text component", illegalAccessException);
                }
            } else {
                jTextComponent.setBackground(SystemColor.text);
                jTextComponent.setDisabledTextColor(SystemColor.textText);
                jTextComponent.setBorder(new EmptyBorder(jTextComponent.getBorder().getBorderInsets(jTextComponent)));
            }
        } else {
            jComponent.setEnabled(bl);
        }
    }

    public void setEnabled(boolean bl) {
        JComponent jComponent = (JComponent)this.getFieldComponent();
        jComponent.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    protected void setUnderneath(boolean bl) {
        this.layout.setUnderneath(bl);
        this.layoutComponent();
    }

    protected boolean isSetUnderneath() {
        return this.layout.isSetUnderneath();
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    protected void layoutComponent() {
        this.layout.layoutContainer(this);
        this.updateUI();
    }
}

