/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Dimension;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemComponentLayout;
import se.ericsson.wcdma.support.gui.gengui.MandatoryLabel;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;

public abstract class BemLabelledField
extends JPanel
implements LocaleChangeListener {
    private JLabel label = null;
    private boolean mandatory = false;
    private MandatoryLabel mandatoryLabel = null;
    private BemComponentLayout layout = null;
    String myBundle = null;
    Locale myLocale;
    private ResourceBundle myResourceBundle = null;
    String toolTipBundle = null;
    String toolTipTag = null;

    public BemLabelledField(String string, String string2) {
        BemLog.traceFlow();
        this.setAlignmentX(0.0f);
        this.myBundle = string;
        this.layout = new BemComponentLayout();
        this.label = new JLabel(string2);
        this.setLayout(this.layout);
        this.add(this.label);
        this.putClientProperty("LANGUAGE_CONTROLLED", "NA");
    }

    public BemLabelledField(String string) {
        this.setAlignmentX(0.0f);
        BemLog.traceFlow();
        this.layout = new BemComponentLayout();
        this.label = new JLabel(string);
        this.setLayout(this.layout);
        this.add(this.label);
    }

    public void updateLocale(Locale locale) {
        this.myLocale = locale;
        BemLog.traceFlow();
        this.myResourceBundle = ResourceBundle.getBundle(this.myBundle, locale);
    }

    protected void setSize() {
        JComponent jComponent = (JComponent)this.getFieldComponent();
        Dimension dimension = new Dimension(300, jComponent.getPreferredSize().height + 8);
        if (this.isSetUnderneath()) {
            dimension.height += this.label.getPreferredSize().height;
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    String translateString(String string) {
        String string2 = "";
        if (string != null) {
            try {
                string2 = this.myResourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
            }
        }
        return string2;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    public void setMandatory(boolean bl) {
        BemLog.trace("setMandatory()");
        if (!this.mandatory && bl) {
            this.mandatoryLabel = new MandatoryLabel();
            this.add(this.mandatoryLabel);
            this.mandatory = true;
        } else if (this.mandatory && !bl) {
            this.remove(this.mandatoryLabel);
            this.mandatory = false;
        }
        this.updateUI();
    }

    public JLabel getLabel() {
        BemLog.trace("getLabel()");
        return this.label;
    }

    public abstract Object getFieldComponent();

    public void setToolTip(String string, String string2) {
        BemLog.trace("setToolTip(" + string2 + ")");
        this.toolTipBundle = string;
        this.toolTipTag = string2;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String string) {
        BemLog.trace("setToolTip(" + string + ")");
        JComponent jComponent = (JComponent)this.getFieldComponent();
        jComponent.setToolTipText(string);
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.toolTipBundle, locale);
            JComponent jComponent = (JComponent)this.getFieldComponent();
            if (this.toolTipTag != null) {
                try {
                    jComponent.setToolTipText(resourceBundle.getString(this.toolTipTag));
                }
                catch (MissingResourceException missingResourceException) {
                    jComponent.setToolTipText(this.toolTipTag);
                }
            }
        }
    }

    public void setEditable(boolean bl) {
        BemLog.trace("setEditable()");
        JComponent jComponent = (JComponent)this.getFieldComponent();
        if (jComponent.getClass().getName().equals("javax.swing.JTextField")) {
            JTextField jTextField = (JTextField)jComponent;
            jTextField.setEditable(bl);
            jTextField.setEnabled(bl);
        } else {
            jComponent.setEnabled(bl);
        }
        this.label.setEnabled(bl);
    }

    public void setUnderneath(boolean bl) {
        this.layout.setUnderneath(bl);
        this.setSize();
        this.updateUI();
    }

    boolean isSetUnderneath() {
        return this.layout.isSetUnderneath();
    }
}

