/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.mohandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoOperation;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;

public class MoHandlerImpl
extends Observable
implements MoHandler {
    private static final List moOperationsSeparatedFromDelete = new ArrayList();
    private static final List rollbackMoOperationsSeparatedFromDelete = new ArrayList();
    private static final List mosToUnLock = new ArrayList();
    private static final List moOperations = new ArrayList();
    private static boolean useLargeTransactions = false;
    private static boolean isUndoActivated = false;
    private static TransactionHelper transactionHelper = null;
    private static NalFactory nalFactory = null;
    private NalTransaction currentTransaction = null;
    private static final String CREATE = "Create MO";
    private static final String SET_ATTRIBUTE = "Set attribute";
    private static final String SET_ATTRIBUTE_S = "Set attributes";
    private static final String GET_ATTRIBUTE = "Get attribute";
    private static final String GET_ATTRIBUTE_S = "Get attributes";
    private static final String DELETE = "Delete MO";
    private static final String ACTION = "Action";
    private static final int DELAY_BETWEEN_LOCK_AND_DELETE = 15;

    public MoHandlerImpl() {
        nalFactory = Nal.getFactory();
    }

    public void create(BemMo bemMo) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("create");
                bemMo.create(nalTransaction);
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("CREATE", bemMo.getDN(), nalCmException, "create");
            }
        }
        try {
            this.startTransaction();
            bemMo.create(this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction("Create Mo", "", exception);
            this.retryOperation(bemMo, CREATE, null, null, null, null, null, exception);
        }
    }

    public void create(BemMo bemMo, NalNameValue[] nalNameValueArray) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("create");
                bemMo.create(nalNameValueArray, nalTransaction);
            }
            catch (NalCmException nalCmException) {
                String string = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
                throw new MoHandlerException("CREATE", bemMo.getDN(), nalCmException, "create " + string);
            }
        }
        try {
            this.startTransaction();
            bemMo.create(nalNameValueArray, this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            String string = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
            this.rollbackTransaction("Create mo", string, exception);
            this.retryOperation(bemMo, CREATE, null, null, null, nalNameValueArray, string, exception);
        }
    }

    public void create(BemMo bemMo, Vector vector) throws MoHandlerException {
        Object[] objectArray = new NalNameValue[vector.size()];
        vector.copyInto(objectArray);
        this.create(bemMo, (NalNameValue[])objectArray);
    }

    public void createMoIfNotExisting(String string) throws MoHandlerException {
        BemMo bemMo = this.getMo(string);
        boolean bl = false;
        bl = this.isExisting(bemMo);
        if (!bl) {
            this.create(bemMo);
        }
    }

    public void createMoIfNotExisting(String string, Vector vector) throws MoHandlerException {
        BemMo bemMo = this.getMo(string);
        boolean bl = false;
        bl = this.isExisting(bemMo);
        if (!bl) {
            this.create(bemMo, vector);
        }
    }

    public void createMoIfNotExisting(String string, NalNameValue[] nalNameValueArray) throws MoHandlerException {
        BemMo bemMo = this.getMo(string);
        boolean bl = false;
        bl = this.isExisting(bemMo);
        if (!bl) {
            this.create(bemMo, nalNameValueArray);
        }
    }

    public void delete(BemMo bemMo) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("delete");
                bemMo.delete(nalTransaction);
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("DELETE", bemMo.getDN(), nalCmException, "delete");
            }
        }
        try {
            this.startTransaction();
            bemMo.delete(this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction("Delete mo", "", exception);
            this.retryOperation(bemMo, DELETE, null, null, null, null, null, exception);
        }
    }

    public void deleteMoIfExisting(String string) throws MoHandlerException {
        BemMo bemMo = this.getMo(string);
        if (this.isExisting(bemMo)) {
            this.delete(bemMo);
        }
    }

    public boolean isExisting(BemMo bemMo) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("is existing");
                if (nalTransaction != null) {
                    boolean bl = bemMo.isExisting(nalTransaction);
                    return bl;
                }
                boolean bl = bemMo.isExisting();
                return bl;
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("IS_EXISTING", bemMo.getDN(), nalCmException);
            }
        }
        try {
            boolean bl = bemMo.isExisting();
            return bl;
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("IS_EXISTING", bemMo.getDN(), nalCmException);
        }
    }

    public BemMo getMo(String string) {
        return new BemMoImpl(string);
    }

    public String getDn(BemMo bemMo) {
        return bemMo.getDN();
    }

    public String genLDN(String string, String string2) throws MoHandlerException {
        String string3 = string + "," + string2 + "=" + this.genFreeIdentity(string, string2);
        return string3;
    }

    public BemMo getParent(BemMo bemMo) {
        return bemMo.getParent();
    }

    public BemMo getRoot() throws MoHandlerException {
        try {
            return BemMoImpl.getRoot();
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("GET_ROOT", nalCmException);
        }
    }

    public BemMo[] getChildren(BemMo bemMo, int n, String string, String string2) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("get children");
                if (nalTransaction != null) {
                    BemMo[] bemMoArray = bemMo.getChildren(n, string, string2, nalTransaction);
                    return bemMoArray;
                }
                BemMo[] bemMoArray = bemMo.getChildren(n, string, string2);
                return bemMoArray;
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("GET_CHILDREN", bemMo.getDN(), nalCmException, "get children");
            }
        }
        try {
            BemMo[] bemMoArray = bemMo.getChildren(n, string, string2);
            return bemMoArray;
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("GET_CHILDREN", bemMo.getDN(), nalCmException);
        }
    }

    public BemMo[] getChildren(BemMo bemMo) throws MoHandlerException {
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction(GET_ATTRIBUTE);
                if (nalTransaction != null) {
                    BemMo[] bemMoArray = bemMo.getChildren(nalTransaction);
                    return bemMoArray;
                }
                BemMo[] bemMoArray = bemMo.getChildren();
                return bemMoArray;
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("GET_CHILDREN", bemMo.getDN(), nalCmException, "get children");
            }
        }
        try {
            BemMo[] bemMoArray = bemMo.getChildren();
            return bemMoArray;
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("GET_CHILDREN", bemMo.getDN(), nalCmException);
        }
    }

    public Object getAttribute(BemMo bemMo, String string) throws MoHandlerException {
        Object object = null;
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction(GET_ATTRIBUTE);
                if (nalTransaction != null) {
                    object = bemMo.getAttribute(string, nalTransaction);
                }
                object = bemMo.getAttribute(string);
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("GET_ATTRIBUTE", bemMo.getDN(), nalCmException, string);
            }
        } else {
            try {
                object = bemMo.getAttribute(string);
            }
            catch (Exception exception) {
                String string2 = string;
                object = this.retryOperation(bemMo, GET_ATTRIBUTE, string, null, null, null, string2, exception);
            }
        }
        return object;
    }

    public BemMo getMoAttribute(BemMo bemMo, String string) throws MoHandlerException {
        Object object = this.getAttribute(bemMo, string);
        if (object instanceof BemMo || object == null) {
            return (BemMo)object;
        }
        String string2 = bemMo == null ? "null" : bemMo.getDN();
        String string3 = "Attribute name=" + string + ", value=" + object;
        ClassCastException classCastException = new ClassCastException("Expected attrib of MO type, got " + object.getClass().getName());
        throw new MoHandlerException("getMoAttribute", string2, classCastException, string3);
    }

    public Object[] getAttributes(BemMo bemMo, String[] stringArray) throws MoHandlerException {
        Object[] objectArray = null;
        if (useLargeTransactions) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction(GET_ATTRIBUTE_S);
                if (nalTransaction != null) {
                    objectArray = bemMo.getAttributes(stringArray, nalTransaction);
                }
                objectArray = bemMo.getAttributes(stringArray);
            }
            catch (NalCmException nalCmException) {
                String string = "Attributes: " + this.arrayToString(stringArray);
                throw new MoHandlerException("GET_ATTRIBUTE", bemMo.getDN(), nalCmException, string);
            }
        } else {
            try {
                objectArray = bemMo.getAttributes(stringArray);
            }
            catch (Exception exception) {
                String string = this.arrayToString(stringArray);
                objectArray = (Object[])this.retryOperation(bemMo, GET_ATTRIBUTE_S, null, null, stringArray, null, string, exception);
            }
        }
        return objectArray;
    }

    public void setAttribute(BemMo bemMo, String string, Object object) throws MoHandlerException {
        if (useLargeTransactions) {
            NalNameValue[] nalNameValueArray = new NalNameValue[1];
            try {
                String string2;
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("set attributes");
                nalNameValueArray[0] = Nal.getFactory().getNameValue(string, object);
                if (isUndoActivated && (string2 = this.getLockOrUnlockOperation(nalNameValueArray)) != null) {
                    this.putInUndoList(string2, bemMo, nalNameValueArray, null);
                }
                bemMo.setAttribute(string, object, nalTransaction);
            }
            catch (NalCmException nalCmException) {
                String string3 = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
                throw new MoHandlerException("SET_ATTRIBUTE", bemMo.getDN(), nalCmException, "set attributes " + string3);
            }
        }
        try {
            this.startTransaction();
            bemMo.setAttribute(string, object, this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction(SET_ATTRIBUTE, string + "= " + object, exception);
            String string4 = "Set attribute " + string + " " + object;
            this.retryOperation(bemMo, SET_ATTRIBUTE, string, object, null, null, string4, exception);
        }
    }

    public void setAttributes(BemMo bemMo, NalNameValue[] nalNameValueArray) throws MoHandlerException {
        if (nalNameValueArray.length == 0) {
            BemLog.log(2, bemMo.getLastRDN() + " setAttributes(). No attributes to set.");
            return;
        }
        if (useLargeTransactions) {
            try {
                String string;
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("set attributes");
                if (isUndoActivated && (string = this.getLockOrUnlockOperation(nalNameValueArray)) != null) {
                    this.putInUndoList(string, bemMo, nalNameValueArray, null);
                }
                bemMo.setAttributes(nalNameValueArray, nalTransaction);
            }
            catch (NalCmException nalCmException) {
                String string = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
                throw new MoHandlerException("SET_ATTRIBUTE", bemMo.getDN(), nalCmException, "set attributes " + string);
            }
        }
        try {
            this.startTransaction();
            bemMo.setAttributes(nalNameValueArray, this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            String string = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
            this.rollbackTransaction(SET_ATTRIBUTE_S, string, exception);
            this.retryOperation(bemMo, SET_ATTRIBUTE_S, null, null, null, nalNameValueArray, string, exception);
        }
    }

    public void setAttributes(BemMo bemMo, Vector vector) throws MoHandlerException {
        Object[] objectArray = new NalNameValue[vector.size()];
        vector.copyInto(objectArray);
        this.setAttributes(bemMo, (NalNameValue[])objectArray);
    }

    public Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) throws MoHandlerException {
        Object object = this.action(bemMo, string, nalNameValueArray, -1, false);
        return object;
    }

    public Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray, boolean bl) throws MoHandlerException {
        Object object = this.action(bemMo, string, nalNameValueArray, -1, bl);
        return object;
    }

    public Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray, int n, boolean bl) throws MoHandlerException {
        Object object = null;
        if (useLargeTransactions && !bl) {
            try {
                NalTransaction nalTransaction = transactionHelper.handleStartTransaction("action");
                if (isUndoActivated) {
                    this.putInUndoList(string, bemMo, nalNameValueArray, nalTransaction);
                }
                object = bemMo.action(string, nalNameValueArray, nalTransaction);
            }
            catch (NalCmException nalCmException) {
                StringBuffer stringBuffer = new StringBuffer();
                if (string.equals("fetchRbsConfigurationFiles")) {
                    stringBuffer.append("Parameters: ");
                    for (int i = 0; i < nalNameValueArray.length; ++i) {
                        NalNameValue nalNameValue = nalNameValueArray[i];
                        stringBuffer.append("{").append(nalNameValue.getName()).append(", ");
                        if (nalNameValue.getName().equals("password")) {
                            stringBuffer.append("****").append("}");
                            continue;
                        }
                        stringBuffer.append(nalNameValue.getValue()).append("}");
                    }
                    throw new MoHandlerException("ACTION", bemMo.getDN(), nalCmException, string + " " + stringBuffer.toString());
                }
                stringBuffer.append("Parameters: ").append(this.nameValueArrayToString(nalNameValueArray));
                throw new MoHandlerException("ACTION", bemMo.getDN(), nalCmException, string + " " + stringBuffer.toString());
            }
        }
        try {
            this.startTransaction(n);
            object = bemMo.action(string, nalNameValueArray, this.currentTransaction);
            this.commitTransaction();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (string.equals("fetchRbsConfigurationFiles")) {
                    stringBuffer.append("Parameters: ");
                    for (int i = 0; i < nalNameValueArray.length; ++i) {
                        NalNameValue nalNameValue = nalNameValueArray[i];
                        stringBuffer.append("{").append(nalNameValue.getName()).append(", ");
                        if (nalNameValue.getName().equals("password")) {
                            stringBuffer.append("****").append("},");
                            continue;
                        }
                        stringBuffer.append(nalNameValue.getValue()).append("},");
                    }
                } else {
                    stringBuffer.append("Parameters: ").append(this.nameValueArrayToString(nalNameValueArray));
                }
            }
            catch (Exception exception2) {
                stringBuffer.append("Exception= ").append(exception2.toString());
            }
            this.rollbackTransaction(string, stringBuffer.toString(), exception);
            object = this.retryOperation(bemMo, ACTION, string, null, null, nalNameValueArray, stringBuffer.toString(), exception);
        }
        return object;
    }

    private void commitTransaction() throws MoHandlerException {
        try {
            if (this.currentTransaction == null) {
                throw new MoHandlerException("Error, trying to commit a transaction but no transaction is started", null);
            }
            this.currentTransaction.commit();
            isUndoActivated = false;
            this.currentTransaction = null;
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("COMMIT_TRANSACTION", nalCmException);
        }
    }

    private void rollbackTransaction(String string, String string2) throws MoHandlerException {
        this.rollbackTransaction(string, string2, null);
    }

    private void rollbackTransaction(String string, String string2, Throwable throwable) throws MoHandlerException {
        try {
            if (this.currentTransaction != null) {
                String string3 = "Oper=" + string + ", attribs=" + string2;
                this.currentTransaction.rollback(string3, throwable);
                this.currentTransaction = null;
            }
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("ROLLBACK_TRANSACTION", "", nalCmException, string + " " + string2 + " Rollback cause=" + throwable);
        }
    }

    private void startTransaction() throws MoHandlerException {
        this.startTransaction(-1);
    }

    private void startTransaction(int n) throws MoHandlerException {
        block3: {
            try {
                if (this.currentTransaction == null) {
                    this.currentTransaction = n != -1 ? nalFactory.createTransaction(n) : nalFactory.createTransaction();
                    break block3;
                }
                throw new MoHandlerException("Error, a transaction is already started", null);
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("BEGIN_TRANSACTION", nalCmException);
            }
        }
    }

    private String nameValueArrayToString(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nalNameValueArray != null) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                stringBuffer.append(nalNameValueArray[i]).append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public void orderMoOperation(String string, BemMo bemMo, NalNameValue[] nalNameValueArray) {
        String string2 = "";
        if (nalNameValueArray != null && nalNameValueArray.length > 0) {
            string2 = this.arrayToString(nalNameValueArray);
        }
        Nal.getFactory().getLog().nalTrace(4, this.getClass(), "BemLog orderMoOperation " + string + " " + bemMo + " " + string2);
        if (string.equalsIgnoreCase("lock") || string.equalsIgnoreCase("unInitSector")) {
            MoOperation moOperation = new MoOperation(string, bemMo, nalNameValueArray);
            this.addTosepratedFromDeleteIfNotAdded(moOperation);
        } else if (string.equalsIgnoreCase("unlock")) {
            this.addToUnLockIfNotAdded(bemMo);
        } else {
            this.addToMoOperationsIfNotAdded(string, bemMo, nalNameValueArray);
        }
    }

    public void clearOrderMoOperations() {
        moOperationsSeparatedFromDelete.clear();
        rollbackMoOperationsSeparatedFromDelete.clear();
        mosToUnLock.clear();
        moOperations.clear();
    }

    public void commitOrderredMoOperations() throws MoHandlerException {
        this.commitOrderredMoOperations(true);
    }

    public void commitOrderredMoOperations(boolean bl) throws MoHandlerException {
        BemLogAndScriptUtil bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
        bemLogAndScriptUtil.logStartConfigurationStep("transaction_1");
        this.commitOperationsSeparatedFromDelete();
        bemLogAndScriptUtil.logEndConfigurationStep();
        if (!RegressionTestInDesigntestUtils.getRegressionTest() && moOperationsSeparatedFromDelete.size() > 0 && bl) {
            this.delay(15, "Waiting for equipment to get locked");
        }
        bemLogAndScriptUtil.logStartConfigurationStep("transaction_2");
        this.commitAllMoOperations();
        bemLogAndScriptUtil.logEndConfigurationStep();
        this.commitUnLockOperations();
        this.clearOrderMoOperations();
    }

    public int getTotalNoOfOrerredMoOperations() {
        int n = mosToUnLock.size() + moOperations.size();
        if (moOperationsSeparatedFromDelete.size() > 0) {
            n += moOperationsSeparatedFromDelete.size();
            n += 15;
        }
        return n;
    }

    public void setUseLargeTransactions(boolean bl) {
        useLargeTransactions = bl;
        transactionHelper = TransactionHelper.getInstance(this);
        transactionHelper.init();
    }

    public void setUseUndoList(boolean bl) {
        isUndoActivated = bl;
    }

    public boolean getUseLargeTransactions() {
        return useLargeTransactions;
    }

    private void addTosepratedFromDeleteIfNotAdded(MoOperation moOperation) {
        boolean bl = moOperationsSeparatedFromDelete.contains(moOperation);
        if (!bl) {
            moOperationsSeparatedFromDelete.add(moOperation);
        }
    }

    private void addToUnLockIfNotAdded(BemMo bemMo) {
        boolean bl = mosToUnLock.contains(bemMo);
        if (!bl) {
            mosToUnLock.add(bemMo);
        }
    }

    private void addToMoOperationsIfNotAdded(String string, BemMo bemMo, NalNameValue[] nalNameValueArray) {
        MoOperation moOperation = new MoOperation(string, bemMo, nalNameValueArray);
        boolean bl = moOperations.contains(moOperation);
        if (!bl) {
            moOperations.add(moOperation);
        }
    }

    private void commitOperationsSeparatedFromDelete() throws MoHandlerException {
        String string = "";
        NalNameValue[] nalNameValueArray = null;
        BemMo bemMo = null;
        try {
            if (moOperationsSeparatedFromDelete.size() > 0) {
                Iterator iterator = moOperationsSeparatedFromDelete.iterator();
                this.startTransaction();
                while (iterator.hasNext()) {
                    String string2 = "";
                    MoOperation moOperation = (MoOperation)iterator.next();
                    string = moOperation.getOperation();
                    bemMo = moOperation.getMo();
                    nalNameValueArray = moOperation.getAttributes();
                    if (string.equalsIgnoreCase("lock")) {
                        string2 = "Lock MO " + bemMo.getType();
                        bemMo.setAttribute("administrativeState", new Integer(0), this.currentTransaction);
                        this.putInUndoList("lock", bemMo, nalNameValueArray, null);
                    } else if (string.equalsIgnoreCase("unInitSector")) {
                        bemMo.action("unInitSector", nalNameValueArray, this.currentTransaction);
                        string2 = "Action " + string + " on MO " + bemMo.getType();
                        this.putInUndoList("unInitSector", bemMo, nalNameValueArray, null);
                    }
                    this.reportProgress(string2);
                }
                this.commitTransaction();
            }
        }
        catch (Exception exception) {
            this.rollbackTransaction(string, "");
            BemLogAndScriptUtil bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
            bemLogAndScriptUtil.logEndConfigurationStep();
            throw new MoHandlerException(string, bemMo.getDN(), exception, "");
        }
    }

    private void commitUnLockOperations() throws MoHandlerException {
        BemMo bemMo = null;
        String string = "";
        try {
            string = "Unlocking MOs";
            if (mosToUnLock.size() > 0) {
                Iterator iterator = mosToUnLock.iterator();
                this.startTransaction();
                while (iterator.hasNext()) {
                    this.reportProgress(string);
                    bemMo = (BemMo)iterator.next();
                    bemMo.setAttribute("administrativeState", new Integer(1), this.currentTransaction);
                }
                this.commitTransaction();
            }
        }
        catch (Exception exception) {
            this.rollbackTransaction(string, "");
            throw new MoHandlerException(string, bemMo.getDN(), exception, "");
        }
    }

    private void commitAllMoOperations() throws MoHandlerException {
        String string = "";
        NalNameValue[] nalNameValueArray = null;
        Object object = null;
        try {
            if (moOperations.size() > 0) {
                Iterator iterator = moOperations.iterator();
                this.startTransaction();
                while (iterator.hasNext()) {
                    String string2 = "";
                    MoOperation moOperation = (MoOperation)iterator.next();
                    string = moOperation.getOperation();
                    object = moOperation.getMo();
                    nalNameValueArray = moOperation.getAttributes();
                    if (string.equalsIgnoreCase("create")) {
                        string2 = "Create MO " + object;
                        this.reportProgress(string2);
                        if (nalNameValueArray != null && nalNameValueArray.length > 0) {
                            object.create(nalNameValueArray, this.currentTransaction);
                            continue;
                        }
                        object.create(this.currentTransaction);
                        continue;
                    }
                    if (string.equalsIgnoreCase("delete")) {
                        string2 = "Delete MO " + object;
                        this.reportProgress(string2);
                        if (!object.isExisting()) continue;
                        object.delete(this.currentTransaction);
                        continue;
                    }
                    if (string.equalsIgnoreCase("set attributes")) {
                        string2 = "Set attributes " + this.attributesToString(nalNameValueArray) + "in " + object;
                        this.reportProgress(string2);
                        object.setAttributes(nalNameValueArray, this.currentTransaction);
                        continue;
                    }
                    string2 = "Action " + string + " on MO " + object;
                    this.reportProgress(string2);
                    object.action(string, nalNameValueArray, this.currentTransaction);
                }
                this.commitTransaction();
            }
        }
        catch (Exception exception) {
            Nal.getFactory().getLog().nalTrace(2, this.getClass(), "commitAllMoOperations() BEM - Operation failed : " + string + ", MO: " + object.toString() + (nalNameValueArray != null ? ", AttributeNames=" + Arrays.asList(nalNameValueArray) : "") + " Message: " + exception.getMessage());
            String string3 = "Attributes: " + this.nameValueArrayToString(nalNameValueArray);
            this.rollbackTransaction(string, string3);
            BemLogAndScriptUtil bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
            bemLogAndScriptUtil.logEndConfigurationStep();
            MoHandlerException moHandlerException = new MoHandlerException(string, object.getDN(), exception, string3);
            this.undoOperationsInSeparateTransaction(moHandlerException);
            throw moHandlerException;
        }
    }

    public void undoOperationsInSeparateTransaction(Exception exception) throws MoHandlerException {
        BemLogAndScriptUtil bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
        try {
            bemLogAndScriptUtil.logStartConfigurationStep("undoTransaction_1");
            if (rollbackMoOperationsSeparatedFromDelete.size() > 0) {
                this.startTransaction();
                Iterator iterator = rollbackMoOperationsSeparatedFromDelete.iterator();
                String string = "";
                BemMo bemMo = null;
                NalNameValue[] nalNameValueArray = null;
                while (iterator.hasNext()) {
                    MoOperation moOperation = (MoOperation)iterator.next();
                    string = moOperation.getOperation();
                    bemMo = moOperation.getMo();
                    nalNameValueArray = moOperation.getAttributes();
                    if (string.equalsIgnoreCase("unlock")) {
                        bemMo.setAttribute("administrativeState", new Integer(1), this.currentTransaction);
                        continue;
                    }
                    if (string.equalsIgnoreCase("initSector")) {
                        bemMo.action("initSector", nalNameValueArray, this.currentTransaction);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("set attributes")) continue;
                    bemMo.setAttributes(nalNameValueArray, this.currentTransaction);
                }
                this.commitTransaction();
            }
        }
        catch (NalCmException nalCmException) {
            bemLogAndScriptUtil.logEndConfigurationStep();
            throw new MoHandlerException("ROLLBACK_TRANSACTION", "", nalCmException, "Original Exception" + exception.toString());
        }
        bemLogAndScriptUtil.logEndConfigurationStep();
    }

    private Object retryOperation(BemMo bemMo, String string, String string2, Object object, String[] stringArray, NalNameValue[] nalNameValueArray, String string3, Exception exception) throws MoHandlerException {
        Object[] objectArray = null;
        String string4 = "";
        if (string3 != null) {
            string4 = string3;
        }
        try {
            boolean bl;
            Nal.getFactory().getLog().nalTrace(2, this.getClass(), "BEM - Operation failed : " + string + ", MO: " + ((Object)bemMo).toString() + (string2 != null ? ", AttributeName=" + string2 : "") + (object != null ? ", Value=" + object : "") + (stringArray != null ? ", AttributeNames=" + Arrays.asList(stringArray) : "") + (nalNameValueArray != null ? ", Attributes=" + Arrays.asList(nalNameValueArray) : "") + (exception != null ? ",\n          Exception=" + exception : ""));
            Nal.getFactory().getLog().nalTrace(2, this.getClass(), "BEM - Waiting 3 seconds");
            this.delay();
            Nal.getFactory().getLog().nalTrace(2, this.getClass(), "BEM - Retrying the operation");
            if (!GET_ATTRIBUTE.equals(string) && !GET_ATTRIBUTE_S.equals(string)) {
                this.startTransaction();
            }
            if (CREATE.equals(string)) {
                if (nalNameValueArray == null) {
                    bemMo.create(this.currentTransaction);
                } else {
                    bemMo.create(nalNameValueArray, this.currentTransaction);
                }
            }
            if (DELETE.equals(string)) {
                bemMo.delete(this.currentTransaction);
            } else if (SET_ATTRIBUTE.equals(string)) {
                bemMo.setAttribute(string2, object, this.currentTransaction);
            } else if (SET_ATTRIBUTE_S.equals(string)) {
                bemMo.setAttributes(nalNameValueArray, this.currentTransaction);
            } else if (GET_ATTRIBUTE.equals(string)) {
                objectArray = bemMo.getAttribute(string2, this.currentTransaction);
            } else if (GET_ATTRIBUTE_S.equals(string)) {
                objectArray = bemMo.getAttributes(stringArray);
            } else if (ACTION.equals(string)) {
                bemMo.action(string2, nalNameValueArray, this.currentTransaction);
            }
            if (!GET_ATTRIBUTE.equals(string) && !GET_ATTRIBUTE_S.equals(string)) {
                this.commitTransaction();
            }
            if (bl = false) {
                throw new BemException("Test of failed retry");
            }
        }
        catch (Exception exception2) {
            if (exception != null) {
                string4 = string4 + "\n\n  The original Exception\n" + exception.toString();
            }
            if (!GET_ATTRIBUTE.equals(string) && !GET_ATTRIBUTE_S.equals(string)) {
                this.rollbackTransaction(string, string4, exception2);
            }
            throw new MoHandlerException("retrying due to error", bemMo.getDN(), exception2, string4);
        }
        return objectArray;
    }

    private void delay() {
        try {
            long l = 3000L;
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void delay(int n, String string) {
        NalFactory nalFactory = Nal.getFactory();
        for (int i = 0; i < n; ++i) {
            try {
                long l = 1000L;
                this.reportProgress(string);
                nalFactory.sleep(l);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null) {
                    stringBuffer.append(object.toString());
                } else {
                    stringBuffer.append(" ");
                }
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    private void reportProgress(String string) {
        this.setChanged();
        this.notifyObservers(Nal.getFactory().getNameValue(string, new Integer(1)));
    }

    private String attributesToString(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = nalNameValueArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[Attribute: ");
                stringBuffer.append(nalNameValueArray[i].getName());
                stringBuffer.append("Value: ");
                stringBuffer.append(nalNameValueArray[i].getValue().toString());
                stringBuffer.append("] ");
            }
        }
        return stringBuffer.toString();
    }

    private MoOperation getUndoOperation(String string, BemMo bemMo, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) throws MoHandlerException {
        MoOperation moOperation = null;
        try {
            if (string.equalsIgnoreCase("lock")) {
                moOperation = new MoOperation("unlock", bemMo, nalNameValueArray);
            } else if (string.equalsIgnoreCase("unInitSector")) {
                Object object = null;
                object = nalTransaction == null ? bemMo.getAttribute("numberOfTxBranches") : bemMo.getAttribute("numberOfTxBranches", nalTransaction);
                NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("numberOfTxBranches", object)};
                moOperation = new MoOperation("initSector", bemMo, nalNameValueArray2);
            }
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("getAttribute", bemMo.getDN(), nalCmException, "");
        }
        return moOperation;
    }

    private void putInUndoList(String string, BemMo bemMo, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) throws MoHandlerException {
        MoOperation moOperation = this.getUndoOperation(string, bemMo, nalNameValueArray, nalTransaction);
        rollbackMoOperationsSeparatedFromDelete.add(0, moOperation);
    }

    private String getLockOrUnlockOperation(NalNameValue[] nalNameValueArray) {
        String string = null;
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            String string2 = nalNameValueArray[i].getName();
            if (!string2.equals("administrativeState")) continue;
            Integer n = (Integer)nalNameValueArray[i].getValue();
            if (n == 0) {
                string = "lock";
                break;
            }
            if (n != 1) continue;
            string = "unlock";
            break;
        }
        return string;
    }

    public int genFreeIdentity(String string, String string2) throws MoHandlerException {
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        BemMo[] bemMoArray = this.getChildren(bemMoImpl, 1, string2, "");
        int n = 1;
        if (bemMoArray != null) {
            for (n = 1; n <= bemMoArray.length; ++n) {
                int n2;
                for (n2 = 0; n2 < bemMoArray.length; ++n2) {
                    try {
                        Integer n3 = new Integer(bemMoArray[n2].getId());
                        if (n3 != n) continue;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n2 == bemMoArray.length) break;
            }
        }
        return n;
    }

    public void killTransaction() {
        this.currentTransaction = null;
    }
}

