/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.postcontrol;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConfigurationVersion;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public abstract class BemCvPostController
implements SubInstaller {
    protected String WIZARD_CV_NAME = "";
    protected String WIZARD_CV_TEMP_NAME = "";
    protected String WIZARD_CV_IDENTITY = "";
    protected String WIZARD_CV_OPERATORNAME = "RBS EM";
    protected String WIZARD_CV_OPERATORCOMMENT = "";
    protected String theName = null;
    protected String theDescription = "Creating Configuration Version";
    protected MoHandler theMoHandler = null;
    protected BemMo configVersionMo = null;
    protected static String rollBackCvName = null;
    private Installer theInstaller = null;
    private static final int TOTAL_NR_PROGRESS_REPORTS = 10;
    private int nrProgReports = 10;
    private int TRANSACTION_TIMEOUT_LIMIT_MS = 12000000;
    private static final String ROLLBACK_CV_PREFIX = "CANCEL_";

    public BemCvPostController(Installer installer) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
    }

    public boolean install() throws BemException {
        try {
            this.configVersionMo = this.getConfigurationVersionMo();
            this.reportProgress();
            if (this.isInterrupted()) {
                return false;
            }
            boolean bl = false;
            String string = this.buildCvName();
            bl = this.isCvExisting(string);
            if (!bl) {
                this.createCv(string);
                this.reportProgress();
                this.setCvStartable(string);
                this.reportProgress();
            } else {
                StringBuffer stringBuffer = new StringBuffer("\n Could not create CV named: " + string + " because it already exists.");
                stringBuffer.append("\n Please make a CV manually and set it to startable.");
                this.theInstaller.extendInstallReport(stringBuffer);
            }
            this.reportRemainingProgress("The configuration version was successfully created");
            this.removeExistingCancelCvs();
            if (this.isInterrupted()) {
                return false;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        return true;
    }

    protected void createCv(String string) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string), Nal.getFactory().getNameValue("identity", this.WIZARD_CV_IDENTITY), Nal.getFactory().getNameValue("type", 5), Nal.getFactory().getNameValue("operatorName", this.WIZARD_CV_OPERATORNAME), Nal.getFactory().getNameValue("comment", this.WIZARD_CV_OPERATORCOMMENT)};
        this.action(this.configVersionMo, "create", nalNameValueArray);
    }

    protected void setCvStartable(String string) throws BemException, MoHandlerException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
        this.configVersionMo = this.getConfigurationVersionMo();
        this.action(this.configVersionMo, "setStartable", nalNameValueArray);
    }

    private boolean isCvExistingInRollBackList(String string) throws BemException, MoHandlerException {
        boolean bl = false;
        this.configVersionMo = this.getConfigurationVersionMo();
        String[] stringArray = (String[])this.theMoHandler.getAttribute(this.configVersionMo, "rollbackList");
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void removeCv(String string) throws BemException, MoHandlerException {
        this.configVersionMo = this.getConfigurationVersionMo();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
        this.action(this.configVersionMo, "delete", nalNameValueArray);
    }

    private boolean removeCvFromRollbackIfExisting(String string) throws BemException, MoHandlerException {
        boolean bl = false;
        this.configVersionMo = this.getConfigurationVersionMo();
        bl = this.isCvExistingInRollBackList(string);
        if (bl) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
            this.action(this.configVersionMo, "removeFromRollbackList", nalNameValueArray);
        }
        this.reportProgress();
        return bl;
    }

    protected boolean isInterrupted() {
        return this.theInstaller.isInterrupted();
    }

    protected void reportRemainingProgress(String string) {
        while (this.nrProgReports > 0) {
            this.reportProgress(string);
        }
    }

    protected void reportRemainingProgress() {
        while (this.nrProgReports > 0) {
            this.reportProgress();
        }
    }

    protected void reportProgress(String string) {
        this.theInstaller.reportProgress(this.theName, string);
        --this.nrProgReports;
    }

    protected void reportProgress() {
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.nrProgReports;
    }

    private boolean isCvExisting(String string) throws BemException, MoHandlerException {
        boolean bl = false;
        NalStruct[] nalStructArray = (NalStruct[])this.theMoHandler.getAttribute(this.configVersionMo, "storedConfigurationVersions");
        if (nalStructArray != null) {
            for (int i = 0; i < nalStructArray.length; ++i) {
                String string2 = this.getStoredCvFieldValue(nalStructArray[i], "Name");
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) throws BemException {
        NalTransaction nalTransaction = null;
        Object object = null;
        boolean bl = false;
        try {
            while (!bl) {
                if (this.isInterrupted()) {
                    Nal.getLog().nalTrace(4, this.getClass(), "Action " + string + " on " + bemMo + " interrupted by user");
                    throw new BemException("Action Interrupted by user");
                }
                try {
                    nalTransaction = Nal.getFactory().createTransaction(this.TRANSACTION_TIMEOUT_LIMIT_MS);
                    object = bemMo.action(string, nalNameValueArray, nalTransaction);
                    nalTransaction.commit();
                    bl = true;
                }
                catch (NalCmException nalCmException) {
                    String string2;
                    nalTransaction.rollback("Failed action=" + string + " on mo=" + bemMo.getDN(), nalCmException);
                    Throwable throwable = nalCmException.getCause();
                    String string3 = "";
                    if (throwable instanceof CmException) {
                        string3 = ((CmException)throwable).getRawInfo();
                    }
                    if (-1 != (string2 = nalCmException.toString() + string3).indexOf("ActionNotAllowed")) {
                        Nal.getLog().nalTrace(6, this.getClass(), "Action " + string + " not yet alowed on " + bemMo + ". Retrying ...");
                        Nal.getFactory().sleep(500L);
                        continue;
                    }
                    if (-1 != string2.indexOf("FunctionBusy")) {
                        Nal.getLog().nalTrace(6, this.getClass(), "Action " + string + " blocked by busy " + bemMo + ". Retrying ...");
                        Nal.getFactory().sleep(500L);
                        continue;
                    }
                    if (-1 == string2.indexOf("CELLO_CV_FS_ERROR")) throw nalCmException;
                    Nal.getLog().nalTrace(1, this.getClass(), "Action " + string + " failed, file system is not ready " + bemMo + ". Retrying ...", nalCmException);
                    Nal.getFactory().sleep(500L);
                    continue;
                    return object;
                }
            }
        }
        catch (Exception exception) {
            try {
                String string4 = "Failed calling action " + string + " for Ldn=" + bemMo + "!";
                nalTransaction.rollback(string4, exception);
                throw new BemException(null, "Action->" + string, bemMo.getDN(), this.nameValueArrayToString(nalNameValueArray), exception);
            }
            catch (NalCmException nalCmException) {
                throw new BemException(null, "Action and rollback failed. Action->" + string, bemMo.getDN(), this.nameValueArrayToString(nalNameValueArray), nalCmException);
            }
        }
    }

    private String nameValueArrayToString(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nalNameValueArray != null) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                stringBuffer.append(nalNameValueArray[i]).append(", ");
            }
        }
        return stringBuffer.toString();
    }

    private NalStruct getUpgradePackageAdministrativeData() throws BemException, MoHandlerException {
        NalStruct nalStruct = null;
        this.configVersionMo = this.getConfigurationVersionMo();
        try {
            BemMo bemMo = (BemMo)this.theMoHandler.getAttribute(this.configVersionMo, "currentUpgradePackage");
            nalStruct = (NalStruct)this.theMoHandler.getAttribute(bemMo, "administrativeData");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageAdministrativeData()" + exception.toString());
        }
        return nalStruct;
    }

    private String getUpgradePackageProductNumber(NalStruct nalStruct) throws BemException {
        String string = "";
        try {
            string = (String)nalStruct.getMemberValue("productNumber");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageProductNumber()" + exception.toString());
        }
        String string2 = string.replace('/', '_');
        return string2;
    }

    private String getUpgradePackageRevision(NalStruct nalStruct) throws BemException {
        String string = "";
        try {
            string = (String)nalStruct.getMemberValue("productRevision");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageRevision()" + exception.toString());
        }
        String string2 = string.replace('/', '_');
        return string2;
    }

    private Date getDateFromNode() throws BemException, MoHandlerException {
        Date date = new Date(0L);
        BemMo bemMo = this.theMoHandler.getRoot();
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimManagedElementData.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            BemMo bemMo2 = bemMoArray[0];
            Long l = (Long)this.theMoHandler.getAttribute(bemMo2, "nodeUTCTime");
            date = new Date(l);
        }
        return date;
    }

    private String buildRollbackCvName() throws BemException, MoHandlerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ROLLBACK_CV_PREFIX);
        NalStruct nalStruct = this.getUpgradePackageAdministrativeData();
        stringBuffer.append(this.getUpgradePackageProductNumber(nalStruct));
        stringBuffer.append("_");
        stringBuffer.append(this.getUpgradePackageRevision(nalStruct));
        stringBuffer.append("_");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd'_'HHmmss");
        Date date = this.getDateFromNode();
        stringBuffer.append(simpleDateFormat.format(date));
        String string = stringBuffer.toString();
        int n = string.length();
        if (n > 40) {
            string = string.substring(0, 40);
        }
        return string;
    }

    protected boolean createRollbackCv() throws BemException, MoHandlerException {
        this.reportProgress("Creating temporary configuration version");
        this.configVersionMo = this.getConfigurationVersionMo();
        this.WIZARD_CV_NAME = this.buildRollbackCvName();
        if (this.isInterrupted()) {
            return false;
        }
        ExceptionProperties exceptionProperties = ExceptionProperties.getRevisionProperties();
        exceptionProperties.setProperty("Current Configuration Version", this.WIZARD_CV_NAME);
        this.createCv(this.WIZARD_CV_NAME);
        this.setRollBackCvName(this.WIZARD_CV_NAME);
        this.reportProgress("Creating temporary configuration version");
        this.removeExistingCancelCvs();
        if (this.isInterrupted()) {
            return false;
        }
        this.reportRemainingProgress("Done creating temporary configuration version");
        return !this.isInterrupted();
    }

    protected void removeExistingCancelCvs() throws BemException, MoHandlerException {
        this.reportProgress("Removing old temporary configuration version");
        String[] stringArray = this.getExistingCancelCvNames();
        String string = this.getRollBackCvName();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals(string)) continue;
            boolean bl = this.isCvStartable(string2);
            boolean bl2 = this.isCvLoaded(string2);
            if (bl || bl2) continue;
            this.removeCvFromRollbackIfExisting(string2);
            this.removeCv(string2);
        }
    }

    protected String buildCvName() throws BemException, MoHandlerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.WIZARD_CV_NAME);
        stringBuffer.append("_");
        NalStruct nalStruct = this.getUpgradePackageAdministrativeData();
        stringBuffer.append(this.getUpgradePackageProductNumber(nalStruct));
        stringBuffer.append("_");
        stringBuffer.append(this.getUpgradePackageRevision(nalStruct));
        stringBuffer.append("_");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd'_'HHmmss");
        Date date = this.getDateFromNode();
        stringBuffer.append(simpleDateFormat.format(date));
        String string = stringBuffer.toString();
        int n = string.length();
        if (n > 40) {
            string = string.substring(0, 40);
        }
        return string;
    }

    private String[] getExistingCancelCvNames() throws BemException, MoHandlerException {
        Vector<String> vector = new Vector<String>(1, 0);
        NalStruct[] nalStructArray = (NalStruct[])this.theMoHandler.getAttribute(this.configVersionMo, "storedConfigurationVersions");
        if (nalStructArray.length != 0) {
            for (int i = 0; i < nalStructArray.length; ++i) {
                String string = this.getStoredCvFieldValue(nalStructArray[i], "name");
                if (!string.startsWith(ROLLBACK_CV_PREFIX)) continue;
                vector.add(string);
            }
        }
        String[] stringArray = new String[]{};
        if (vector.size() > 0) {
            stringArray = vector.toArray(stringArray);
        }
        return stringArray;
    }

    private boolean isCvStartable(String string) throws BemException, MoHandlerException {
        boolean bl = false;
        String string2 = (String)this.theMoHandler.getAttribute(this.configVersionMo, "startableConfigurationVersion");
        if (string2 != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean isCvLoaded(String string) throws BemException, MoHandlerException {
        boolean bl = false;
        String string2 = (String)this.theMoHandler.getAttribute(this.configVersionMo, "currentLoadedConfigurationVersion");
        if (string2 != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    public int getTotalNoOfProgressReports() {
        return 10;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }

    private BemMo getConfigurationVersionMo() throws MoHandlerException {
        if (this.configVersionMo == null) {
            BemMo bemMo = this.theMoHandler.getRoot();
            BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 2, MimConfigurationVersion.MOTYPENAME, "");
            this.configVersionMo = bemMoArray[0];
        }
        return this.configVersionMo;
    }

    private String getStoredCvFieldValue(NalStruct nalStruct, String string) throws BemException {
        String string2 = null;
        try {
            NalNameValue nalNameValue = nalStruct.getMember(string);
            string2 = nalNameValue.getValue().toString();
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 == null) {
            throw new BemException(this.getClass().getName(), "getStoredCvFieldValue()", "ConfigurationVersion", "Could not find a field called " + string + " in StoredConfigurationVersions", null);
        }
        return string2;
    }

    public String getRollBackCvName() {
        return rollBackCvName;
    }

    private void setRollBackCvName(String string) {
        rollBackCvName = string;
    }
}

