/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.util;

import java.lang.reflect.Field;
import java.util.ArrayList;

public class MimClassInfo {
    private static final String PACKAGE = "se.ericsson.wcdma.rbs.bem.common.mim";
    private Class mo;
    private String ldn;

    public MimClassInfo(String string) {
        this.ldn = string;
        try {
            this.mo = Class.forName("se.ericsson.wcdma.rbs.bem.common.mim.Mim" + MimClassInfo.getType(string));
        }
        catch (Exception exception) {
            throw new Error("Class Mim" + MimClassInfo.getType(string) + " not found. LDN = " + string);
        }
    }

    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Field[] fieldArray = this.mo.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().startsWith("ATTRNAME_") && !fieldArray[i].getName().startsWith("MEMBERNAME_")) continue;
            try {
                arrayList.add((String)fieldArray[i].get(null));
                continue;
            }
            catch (Exception exception) {
                throw new Error("Attribute " + fieldArray[i].getName() + " not found in MO.\nLDN: " + this.ldn);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public Class getAttributeType(String string) {
        try {
            return this.mo.getDeclaredField("TYPE_" + string.toUpperCase()).getType();
        }
        catch (Exception exception) {
            throw new Error("Attribute " + string + " not found in MO.\nLDN: " + this.ldn);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    private static String getType(String string) {
        int n = string.lastIndexOf(",") + 1;
        int n2 = string.lastIndexOf("=");
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n, n2);
        return string2;
    }

    private static Class tryGetMimClass(String string) {
        try {
            Class<?> clazz = Class.forName("se.ericsson.wcdma.rbs.bem.common.mim.Mim" + MimClassInfo.getType(string));
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Field tryGetAttrnameField(Class clazz, String string) {
        if (clazz == null || string == null) {
            return null;
        }
        try {
            Field field = clazz.getField("ATTRNAME_" + string.toUpperCase());
            if (string.equals(field.get(null))) {
                return field;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isAttributeKnownMissing(String string, String string2) {
        Class clazz = MimClassInfo.tryGetMimClass(string);
        if (clazz == null) {
            return false;
        }
        Field field = MimClassInfo.tryGetAttrnameField(clazz, string2);
        boolean bl = field == null;
        return bl;
    }
}

