/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemCheckBoxSingle;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemRadioButtonField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemStringField;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlFileHandler;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.FileInputViewer;
import se.ericsson.wcdma.support.gui.gengui.SyntaxException;

public class AbstractFlexFileInputController
extends BemWizardGuiController {
    private FileInputViewer myView;
    private WizardCIModel flexModel = null;
    private BemCheckBoxSingle useFileInput = null;
    protected BemStringField filePath = null;
    private BemRadioButtonField configuration = null;
    private JButton browseButton = null;
    private boolean isListenerEnabled = true;
    protected String wizardControllerClassName;
    private static RbsEmPropertiesFileHandler rbsEmProp = RbsEmPropertiesFileHandler.getInstance();
    private static final String ERR_MSG_PARSE = "Error: XML Parsing error. \nProbable cause: {0} \n";

    protected void init() {
        this.myView = (FileInputViewer)((Object)this.getView());
        this.useFileInput = (BemCheckBoxSingle)this.myView.getUseFileInputComponent();
        this.filePath = (BemStringField)this.myView.getFilePathComponent();
        this.browseButton = (JButton)this.myView.getBrowseButtonComponent();
        this.configuration = (BemRadioButtonField)this.myView.getConfigurationRadioButtonComponent();
        UseFileInputListener useFileInputListener = new UseFileInputListener();
        this.useFileInput.setActionListener(useFileInputListener, null);
        BrowseButtonListener browseButtonListener = new BrowseButtonListener();
        this.browseButton.addActionListener(browseButtonListener);
    }

    protected void afterVisible() {
        try {
            this.isListenerEnabled = false;
            this.arrangeGui();
            this.isListenerEnabled = true;
        }
        catch (Exception exception) {
            BemException bemException = new BemException("Failed setting up window for input in afterVisible()", (Throwable)exception);
            this.getEasyPopUp().displayError(bemException);
        }
    }

    protected boolean checkSyntax() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseXML() {
        boolean bl = false;
        XmlFileHandler xmlFileHandler = null;
        ServiceValue serviceValue = null;
        ServiceCommon.initate();
        try {
            xmlFileHandler = XmlFileHandler.getInstance();
            serviceValue = xmlFileHandler.startParsing(this.filePath.getValue(), this.wizardHelp.getDtdFilePath());
            this.flexModel.setServiceValue(serviceValue);
            if (serviceValue.hasDeprecationWarnings()) {
                String string = serviceValue.getDeprecationReport();
                super.displayDetailedWarningOkDialog("Deprecation warning\n\nSome of the parameters in input file relate to an old format.\nThese parameters have been successfully converted to the latest format.", string);
            }
            bl = true;
        }
        catch (BemXmlException bemXmlException) {
            String string = MessageFormat.format(ERR_MSG_PARSE, bemXmlException.getMessage());
            System.out.println(string);
            this.getEasyPopUp().displayError(bemXmlException);
            bl = false;
        }
        finally {
            xmlFileHandler = null;
            serviceValue = null;
        }
        return bl;
    }

    protected void setWindowTitle(String string) {
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(this.wizardControllerClassName));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string, string2, string3));
    }

    private void arrangeGui() throws SyntaxException {
        boolean bl = this.flexModel.getUseFileInput();
        this.useFileInput.setValue(bl);
        if (bl) {
            this.filePath.setMandatory(true);
            this.filePath.setEnabled(true);
            this.filePath.setValue(this.flexModel.getFilePath());
            this.browseButton.setEnabled(true);
            this.configuration.setEnabled(true);
        } else {
            this.filePath.setMandatory(false);
            this.filePath.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.configuration.setEnabled(false);
        }
        String string = rbsEmProp.getProperty("XML_PATH");
        if (string != null) {
            this.filePath.setValue(string);
        } else {
            this.filePath.setValue("");
        }
        boolean bl2 = this.flexModel.getUseWizard();
        if (bl2) {
            this.configuration.setValue(WizardLanguageHelp.getTranslation("NCONF_FIL_WIZARD"));
        } else {
            this.configuration.setValue(WizardLanguageHelp.getTranslation("NCONF_FIL_AUTOMATIC"));
        }
    }

    protected boolean updateModel() {
        try {
            Boolean bl = this.useFileInput.getValue("");
            this.flexModel.setUseFileInput(bl);
            String string = this.filePath.getValue();
            this.flexModel.setFilePath(string);
            String string2 = this.configuration.getValue();
            int n = string2.compareTo(WizardLanguageHelp.getTranslation("NCONF_FIL_WIZARD"));
            if (n == 0) {
                this.flexModel.setUseWizard(true);
            } else {
                this.flexModel.setUseWizard(false);
            }
            return true;
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Exception message header", "Failed in FileInputController.updateModel()");
            this.getEasyPopUp().displayError(bemException);
            return false;
        }
    }

    protected FileInputViewer getFileInputView() {
        return this.myView;
    }

    protected boolean next() {
        String string = this.filePath.getValue();
        JFileChooser jFileChooser = new JFileChooser(string);
        File file = jFileChooser.getCurrentDirectory();
        rbsEmProp.setProperty("XML_PATH", file.getPath());
        rbsEmProp.storeBemPropInFile();
        boolean bl = super.next();
        return bl;
    }

    protected void setFlexModel(WizardCIModel wizardCIModel) {
        this.flexModel = wizardCIModel;
    }

    protected WizardCIModel getFlexModel() {
        return this.flexModel;
    }

    protected void setErrorTitle(String string) {
    }

    class BrowseButtonListener
    implements ActionListener {
        BrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractFlexFileInputController.this.isListenerEnabled) {
                String string = AbstractFlexFileInputController.this.filePath.getValue();
                JFileChooser jFileChooser = new JFileChooser(string);
                BemFileFilter bemFileFilter = new BemFileFilter("xml", "XML files");
                jFileChooser.setFileFilter(bemFileFilter);
                jFileChooser.setDialogTitle("Open Configuration File");
                int n = jFileChooser.showOpenDialog(AbstractFlexFileInputController.this.browseButton);
                if (n == 0) {
                    String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    AbstractFlexFileInputController.this.filePath.setValue(string2);
                }
            }
        }
    }

    class UseFileInputListener
    implements ActionListener {
        UseFileInputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractFlexFileInputController.this.isListenerEnabled) {
                Boolean bl = AbstractFlexFileInputController.this.useFileInput.getValue("");
                if (bl.booleanValue()) {
                    AbstractFlexFileInputController.this.filePath.setMandatory(true);
                    AbstractFlexFileInputController.this.filePath.setEnabled(true);
                    AbstractFlexFileInputController.this.filePath.setFocus();
                    AbstractFlexFileInputController.this.browseButton.setEnabled(true);
                    AbstractFlexFileInputController.this.configuration.setEnabled(true);
                } else {
                    AbstractFlexFileInputController.this.filePath.setMandatory(false);
                    AbstractFlexFileInputController.this.filePath.setEnabled(false);
                    AbstractFlexFileInputController.this.browseButton.setEnabled(false);
                    AbstractFlexFileInputController.this.configuration.setEnabled(false);
                }
            }
        }
    }
}

