/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;

public final class WizardLanguageHelp {
    private static int currentEnvironment = 2;
    private static boolean doTranslation = true;
    private static Properties nconfProperties = new Properties();
    private static boolean propertyFileLoaded = false;
    private static String propertiesFilePath = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemclientmisc/bemclientcommon/src/se/ericsson/wcdma/rbs/bem/common/resources/language/RbsLanguage.properties";
    private static String tooltipPropertiesFilePath = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemclientmisc/bemclientcommon/src/se/ericsson/wcdma/rbs/bem/common/resources/language/RbsTooltip.properties";
    private static final String FILE_NOT_FOUND_ERROR = "WizardLanguageHelp - Properties file is missing. Description: ";
    private static final String IO_ERROR = "WizardLanguageHelp - IOException when reading properties file. Description: ";
    private static final String MAJOR_ERROR = "WizardLanguageHelp - Runtime Exception when reading properties file. Description: ";

    private WizardLanguageHelp() {
    }

    public static void setEnvironment(int n) {
        currentEnvironment = n;
    }

    public static void setEnvironment(int n, boolean bl) {
        currentEnvironment = n;
        doTranslation = bl;
    }

    public static int getEnvironment() {
        return currentEnvironment;
    }

    public static void setPropertiesFilePath(String string) {
        propertiesFilePath = string;
    }

    public static String getPropertiesFilePath() {
        return propertiesFilePath;
    }

    public static String getTranslation(String string) {
        if (currentEnvironment == 1 && doTranslation) {
            String string2;
            if (!propertyFileLoaded) {
                WizardLanguageHelp.loadProperties();
            }
            if ((string2 = nconfProperties.getProperty(string)) != null) {
                return string2;
            }
            return string;
        }
        return string;
    }

    private static void loadProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFilePath);
            nconfProperties.load(fileInputStream);
            fileInputStream.close();
            FileInputStream fileInputStream2 = new FileInputStream(tooltipPropertiesFilePath);
            nconfProperties.load(fileInputStream2);
            fileInputStream2.close();
            propertyFileLoaded = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(FILE_NOT_FOUND_ERROR + fileNotFoundException.getMessage());
            propertyFileLoaded = false;
        }
        catch (IOException iOException) {
            System.out.println(IO_ERROR + iOException.getMessage());
            propertyFileLoaded = false;
        }
        catch (Exception exception) {
            System.out.println(MAJOR_ERROR + exception.getMessage());
            propertyFileLoaded = false;
        }
    }
}

