/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class EcPortView
extends BemWizardGuiView {
    private TitledBorder tableTitledBorder;
    private final JPanel mainPanel = new JPanel();
    private final JPanel dynamicPanel = new JPanel();
    private final JPanel tablePanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private final JButton addButton = new JButton(WizardLanguageHelp.getTranslation("NCONF_BUTTON_ADD_EC_PORT"));
    private final JButton removeButton = new JButton(WizardLanguageHelp.getTranslation("NCONF_BUTTON_REMOVE_EC_PORT"));
    private CustomerParameterTableModel tableModel = null;
    private CustomerParameterTable table = null;
    private JScrollPane sp = null;

    protected void init() {
        super.init();
        this.setupView();
    }

    private void setupView() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.mainPanel);
        this.tableTitledBorder = new TitledBorder(WizardLanguageHelp.getTranslation("NCONF_CABINET_EC_BUS"));
        this.tablePanel.setBorder(this.tableTitledBorder);
        this.tablePanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.mainPanel.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.mainPanel.add((Component)this.dynamicPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        this.tablePanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.removeButton);
        this.removeButton.setEnabled(false);
    }

    public void setTableParameters(Object[][] objectArray, String[] stringArray) {
        this.tableModel = new CustomerParameterTableModel(objectArray, stringArray);
        if (this.table == null) {
            this.createTable(this.tableModel);
        } else {
            this.table.setModel(this.tableModel);
        }
    }

    private void createTable(CustomerParameterTableModel customerParameterTableModel) {
        this.table = new CustomerParameterTable(customerParameterTableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EcPortView.this.table.getSelectedRowCount() > 0) {
                    CustomerParameter customerParameter = (CustomerParameter)EcPortView.this.table.getModel().getValueAt(EcPortView.this.table.getSelectedRow(), 0);
                    EcPortView.this.removeButton.setEnabled(customerParameter.getAccessLevel() != 0);
                } else {
                    EcPortView.this.removeButton.setEnabled(false);
                }
            }
        });
        this.table.setRowHeight(this.getFont().getSize() + 8);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        Dimension dimension = this.table.calculatePreferredScrollableViewportSize(10);
        this.sp = new JScrollPane(this.table);
        this.sp.setPreferredSize(dimension);
        this.tablePanel.add((Component)this.sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public CustomerParameterTable getTable() {
        return this.table;
    }

    public CustomerParameterTableModel getTableModel() {
        return this.tableModel;
    }

    public void addRow(Vector vector) {
        this.tableModel.addRow(vector);
    }

    public void deleteRow(int n) {
        this.tableModel.deleteRowAt(n);
    }

    protected String getSubHeading() {
        return "NCONF_SUBHEADER_EC_BUS_CONFIGURATION";
    }
}

