/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.AbstractPowerSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.AbstractPowerSupplyCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EquippedSectorRadioInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.AbstractFlexFinishController;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiCheckAndShowWarning;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control.CabinetProgressDlgFlexController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view.FinishFlexView;

public class CabinetFlexFinishController
extends AbstractFlexFinishController {
    private FinishFlexView view;
    private Rbs rbs;
    private RadioEquipmentProvider rep;
    private boolean duwRbsWithRbb;
    private boolean supportSystemAvailable = false;
    private TrueFalseCustomerParameter supportSystemControl;

    public CabinetFlexFinishController() {
        super(CabinetFlexModel.getInstance(), WizardHelp.getTheInstance());
    }

    protected void init() {
        this.view = (FinishFlexView)this.getView();
    }

    protected void beforeVisible() {
        this.rbs = CabinetFlexModel.getInstance().getRbs();
        this.setFlexModel(CabinetFlexModel.getInstance());
        try {
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)((Object)this.rbs.getConfigItem("PowerSystemCI"));
            if (powerSupplyProvider != null && powerSupplyProvider.isSupportSystemAvailable()) {
                this.supportSystemAvailable = true;
                if (this.rbs.isParameterSupported("supportSystemControl")) {
                    this.supportSystemControl = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl");
                }
            }
            this.updateCabinetBasic();
            this.updateSupportSystemControl();
            this.updateAbsoluteTimeSynchEnabled();
            this.updateGpsOutEnabled();
            this.updateClimateSystem();
            this.updatePowerSupply();
            this.updateDigitalBuildingBlock();
            if (!DuwUtil.hasDuw()) {
                this.updateEtbBoards();
            }
            this.updateRadioEquipment();
            this.updateEcPort();
            this.view.updateGui();
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("An error has occured", bemException);
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", bemException.toString(), "Setting up window for input", bemException);
            this.displayError(wizardException);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            this.displayError(wizardException);
        }
    }

    private void updateRadioBuildingBlock() throws BemException {
        int n = this.rbs.getMaxNumberOfSectors();
        ArrayList<Enumeration> arrayList = new ArrayList<Enumeration>();
        ArrayList<Enumeration> arrayList2 = new ArrayList<Enumeration>();
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        for (int i = 1; i <= n; ++i) {
            String string = this.getRbbName(i);
            String string2 = this.getRadioIfTypeName(i);
            if (!this.rbs.isParameterSupported(string) || !this.rbs.isParameterSupported(string2)) continue;
            enumeration = (Enumeration)this.rbs.getCustomerParameterObject(string);
            enumeration2 = (Enumeration)this.rbs.getCustomerParameterServerObject(string2);
            arrayList.add(enumeration);
            arrayList2.add(enumeration2);
        }
        this.view.setRadioEquipment(arrayList, arrayList2);
    }

    private void updateRadioEquipment() throws BemException {
        if (this.duwRbsWithRbb) {
            this.updateDuwRadioEquipment();
        } else {
            this.updateRadioBuildingBlock();
            this.updateSector();
        }
    }

    private void updateEcPort() throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
        ArrayList<EcPortInfo> arrayList = new ArrayList<EcPortInfo>();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            if (DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType())) {
                if (!ecPortInfo.getcascadingOrderParameter().hasValueChanged()) continue;
                arrayList.add(ecPortInfo);
                continue;
            }
            if (!ecPortInfo.getHubPositionParameter().hasValueChanged()) continue;
            arrayList.add(ecPortInfo);
        }
        this.view.setEcPortInfo(arrayList);
    }

    private String getRadioIfTypeName(int n) {
        if (n < 7) {
            return "1radioIfType";
        }
        return "2radioIfType";
    }

    private String getRbbName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "radioBuildingBlock";
    }

    private void updateEtbBoards() throws BemException {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        for (String string : stringArray = etmBoardProvider.getAllPossibleEtmBoards()) {
            CustomerParameter customerParameter;
            String string2;
            if (!this.rbs.isParameterSupported(string) || (string2 = (customerParameter = this.rbs.getCustomerParameterObject(string)).getValue()).equals("")) continue;
            hashMap.put(EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(string), customerParameter.getValue());
        }
        this.view.setEtmBoards(hashMap);
    }

    private void updatePowerSupply() throws BemException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        CustomerParameter customerParameter = null;
        if (this.rbs.isConfigurationItemSupported("PowerSystemCI")) {
            ConfigurationItem configurationItem = this.rbs.getConfigItem("PowerSystemCI");
            if (configurationItem instanceof AbstractPowerSupplyCI) {
                customerParameter = this.rbs.getCustomerParameterObject("CAB1_configurePowerSupply");
                string8 = customerParameter.getValue();
                customerParameter = this.rbs.getCustomerParameterObject("CAB1_noOfPsu");
                string = customerParameter.getValue();
                customerParameter = this.rbs.getCustomerParameterObject("CAB1_configureBatteryBackup");
                string5 = customerParameter.getValue();
                customerParameter = this.rbs.getCustomerParameterObject("CAB1_batteryCapacity");
                string7 = customerParameter.getValue();
            } else if (configurationItem instanceof AbstractPowerSystemCI && this.rbs.getCustomerParameter("supportSystemControl").equalsIgnoreCase("TRUE")) {
                customerParameter = this.rbs.getCustomerParameterObject("CAB1_configurePowerSupply");
                if (customerParameter.getAccessLevel() != 1) {
                    string8 = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_noOfPsu")).getAccessLevel() != 1) {
                    string = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_configureBatteryBackup")).getAccessLevel() != 1) {
                    string5 = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_batteryType")).getAccessLevel() != 1) {
                    string6 = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_noOfPdu")).getAccessLevel() != 1) {
                    string2 = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_noOfBfu")).getAccessLevel() != 1) {
                    string3 = customerParameter.getValue();
                }
                if ((customerParameter = this.rbs.getCustomerParameterObject("CAB1_multiplePowerSystem")).getAccessLevel() != 1) {
                    string4 = customerParameter.getValue();
                }
            }
        }
        this.view.setPowerSupply(string8, string, string2, string3, string4, string5, string7, string6);
    }

    private void updateCabinetBasic() throws BemException {
        CustomerParameterImpl customerParameterImpl;
        String string = this.rbs.getRbsType();
        String string2 = "";
        if (this.rbs.isParameterSupported("redundantControlSystem")) {
            customerParameterImpl = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject("redundantControlSystem");
            string2 = customerParameterImpl.getValue();
        }
        customerParameterImpl = (IpAddressParameter)this.rbs.getCustomerParameterObject("ipAddress");
        IpAddressParameter ipAddressParameter = (IpAddressParameter)this.rbs.getCustomerParameterObject("subnetMask");
        IpAddressParameter ipAddressParameter2 = (IpAddressParameter)this.rbs.getCustomerParameterObject("defaultRouter");
        String string3 = ipAddressParameter2.getValue();
        if (string3.equals("##UNDEFINED")) {
            string3 = "";
        }
        this.duwRbsWithRbb = this.duwRbsWithRbb();
        this.view.setCabinetBasic(string, string2, customerParameterImpl.getValue(), ipAddressParameter.getValue(), string3, this.duwRbsWithRbb);
    }

    private void updateSupportSystemControl() throws BemException {
        if (this.supportSystemAvailable && this.rbs.isParameterSupported("supportSystemControl")) {
            String string = this.rbs.getCustomerParameter("supportSystemControl");
            this.view.setSupportSystemControl(string);
        } else {
            this.view.setSupportSystemControl(null);
        }
    }

    private void updateAbsoluteTimeSynchEnabled() throws BemException {
        if (this.supportSystemAvailable && DuwUtil.hasDuw() && this.rbs.getRbsData().isRbs6000()) {
            String string = this.rbs.getCustomerParameter("absoluteTimeSynchEnabled");
            this.view.setAbsoluteTimeSynchronizationEnabled(string);
        } else {
            this.view.setAbsoluteTimeSynchronizationEnabled(null);
        }
    }

    private void updateGpsOutEnabled() throws BemException {
        if (this.supportSystemAvailable && DuwUtil.hasDuw() && this.rbs.getRbsData().isRbs6000()) {
            this.view.setGpsOutEnabled(this.rbs.getCustomerParameter("gpsOutEnabled"));
            if (DuwUtil.hasDualDuws()) {
                this.view.setGpsOutEnabledOnSlot2(this.rbs.getCustomerParameter("gpsOutEnabledOnSlot2"));
            }
        } else {
            this.view.setGpsOutEnabled(null);
        }
    }

    private void updateClimateSystem() throws BemException {
        if (this.supportSystemControl != null && this.rbs.isParameterSupported("CAB1_climateSystem")) {
            if (this.supportSystemControl.getValue().equalsIgnoreCase("TRUE")) {
                String string = this.rbs.getCustomerParameter("CAB1_climateSystem");
                this.view.setClimateSystem(string);
                String string2 = this.rbs.getCustomerParameter("climateRegulationSystem");
                this.view.setClimateRegulationSystem(string2);
            }
        } else {
            this.view.setClimateSystem(null);
            this.view.setClimateRegulationSystem(null);
        }
    }

    private void updateDigitalBuildingBlock() throws BemException {
        if (this.rbs.isParameterSupported("digitalBuildingBlock")) {
            if (DuwUtil.hasDualDuws() && this.rbs.getRbsData().isRbs6000()) {
                String string = this.rbs.getCustomerParameter("digitalBuildingBlock");
                this.view.setDigitalBuildBlock(string);
            }
        } else {
            this.view.setDigitalBuildBlock(null);
        }
    }

    protected void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Cabinet Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean finish() {
        WizardCIModel wizardCIModel = super.getFlexModel();
        boolean bl = wizardCIModel.getUseWizard();
        boolean bl2 = wizardCIModel.getUseFileInput();
        if (bl2 && !bl) {
            try {
                if (!GuiCheckAndShowWarning.checkIPAddressAndShowWarning(this.rbs, this)) {
                    return false;
                }
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised(bemException);
            }
        }
        super.finish();
        super.confirmNodeRestart();
        BemLogAndScriptUtil.getInstance().logStartConfigurationProcedure("Cabinet");
        this.startDialog(false, "NCONF_WIZARD_WINDOW_TITLE", null, ProgressDialogView.class, CabinetProgressDlgFlexController.class);
        this.setCancelEnabled(false);
        return false;
    }

    public String getWizardName() {
        return "Cabinet";
    }

    private void updateSector() throws BemException {
        int n = this.rbs.getMaxNumberOfSectors();
        ArrayList<YesNoCustomerParameter> arrayList = new ArrayList<YesNoCustomerParameter>();
        ArrayList<Enumeration> arrayList2 = new ArrayList<Enumeration>();
        Enumeration enumeration = null;
        YesNoCustomerParameter yesNoCustomerParameter = null;
        for (int i = 1; i <= n; ++i) {
            String string;
            String string2 = this.getCreateSectorName(i);
            if (this.rbs.isParameterSupported(string2)) {
                yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string2);
                arrayList.add(yesNoCustomerParameter);
            }
            if (!this.rbs.isParameterSupported(string = this.getRadioIfTypeName(i))) continue;
            enumeration = (Enumeration)this.rbs.getCustomerParameterServerObject(string);
            arrayList2.add(enumeration);
        }
        if (this.rbs.isParameterSupported("carrierAllocationMode")) {
            CarrierAllocationModeParameter carrierAllocationModeParameter = (CarrierAllocationModeParameter)this.rbs.getCustomerParameterObject("carrierAllocationMode");
            this.view.setCarrierAllocationMode(carrierAllocationModeParameter.getValue());
        }
        this.view.setRadioIfTypes(arrayList2);
        this.view.setRadioEquipment(arrayList);
    }

    private String getCreateSectorName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "createSector";
    }

    private void updateDuwRadioEquipment() {
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rep;
        EquippedSectorRadioInfo[] equippedSectorRadioInfoArray = radioEquipmentProviderWithRbb.getEquippedSectorsRadioInfo();
        String[] stringArray = new String[equippedSectorRadioInfoArray.length];
        String[] stringArray2 = new String[equippedSectorRadioInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = equippedSectorRadioInfoArray[i].getSectorNumber();
            String string2 = equippedSectorRadioInfoArray[i].getRadioBuildingBlockName();
            String string3 = equippedSectorRadioInfoArray[i].getLineRate();
            String string4 = equippedSectorRadioInfoArray[i].getAuUnitType();
            stringArray[i] = "Create Sector: ";
            stringArray2[i] = "Sector number: " + string + "    Radio building block: " + string2 + "    Line rate: " + string3 + "    Unit type: " + string4;
        }
        this.view.setEquippedSectorRadioInfo(stringArray, stringArray2);
    }

    private boolean duwRbsWithRbb() throws BemException {
        this.rep = this.rbs.getRadioEquipmentProvider();
        return this.rep != null && this.rep instanceof RadioEquipmentProviderWithRbb;
    }
}

