/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.SlotListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.SlotListRange;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

class EtmParameterAdaptor {
    private final SlotListener slotListener = new SlotListener();
    private final EtmListener etmListener = new EtmListener();
    private final Rbs rbs;
    private final Map etmBoards = new HashMap();
    private final Map slots = new HashMap();
    private String[] slotPositions = new String[0];

    public EtmParameterAdaptor(Rbs rbs) {
        this.rbs = rbs;
        this.initEtmBoards();
        this.initSlots();
    }

    public void print() {
        Iterator iterator = this.etmBoards.keySet().iterator();
        System.out.println("ETM boards:");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CustomerParameter customerParameter = (CustomerParameter)this.etmBoards.get(string);
            System.out.println(string + " = " + customerParameter.getValue());
        }
    }

    public Map getSlots() {
        return this.slots;
    }

    private void initSlots() {
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        for (String string : this.slotPositions) {
            Object[] objectArray = etmBoardProvider.getAllPossibleEtmBoardsForSlot(string);
            Arrays.sort(objectArray);
            Enumeration enumeration = new Enumeration(string, (String[])objectArray);
            this.slots.put(string, enumeration);
            for (String string2 : this.etmBoards.keySet()) {
                SlotListParameter slotListParameter = (SlotListParameter)this.etmBoards.get(string2);
                if (!slotListParameter.isValueSet(string)) continue;
                enumeration.setValue(string2);
                break;
            }
            enumeration.addCustomerParameterListener(this.slotListener);
        }
    }

    private void initEtmBoards() {
        String[] stringArray;
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        for (String string : stringArray = etmBoardProvider.getAllPossibleEtmBoards()) {
            if (!this.rbs.isParameterSupported(string)) continue;
            try {
                SlotListParameter slotListParameter = (SlotListParameter)this.rbs.getCustomerParameterObject(string);
                slotListParameter.addCustomerParameterListener(this.etmListener);
                this.etmBoards.put(EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(string), slotListParameter);
                SlotListRange slotListRange = (SlotListRange)slotListParameter.getSupportedValueRange();
                EnumeratedRange enumeratedRange = (EnumeratedRange)slotListRange.getElementRange();
                List list = enumeratedRange.getRangeValues();
                if (list.size() <= this.slotPositions.length) continue;
                this.slotPositions = list.toArray(new String[0]);
            }
            catch (BemException bemException) {
                System.out.println(bemException);
            }
        }
    }

    protected void removeListeners() {
        for (Object object : this.slots.keySet()) {
            CustomerParameter customerParameter = (CustomerParameter)this.slots.get(object);
            customerParameter.removeCustomerParameterListener(this.slotListener);
        }
        for (CustomerParameter customerParameter : this.etmBoards.keySet()) {
            CustomerParameter customerParameter2 = (CustomerParameter)this.etmBoards.get(customerParameter);
            customerParameter2.removeCustomerParameterListener(this.etmListener);
        }
    }

    private class SlotListener
    implements CustomerParameterListener {
        private SlotListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            Object[] objectArray;
            Object object;
            HashMap<Object, Object[]> hashMap = new HashMap<Object, Object[]>();
            for (Iterator iterator : EtmParameterAdaptor.this.slots.keySet()) {
                Object object2 = (Enumeration)EtmParameterAdaptor.this.slots.get(iterator);
                if (object2 == null || (object = ((CustomerParameterImpl)object2).getValue()) == null || ((String)object).equals("") || ((String)object).equals("##UNDEFINED")) continue;
                objectArray = (Object[])hashMap.get(object);
                if (objectArray == null) {
                    objectArray = new ArrayList();
                    hashMap.put(object, objectArray);
                }
                objectArray.add(iterator);
            }
            for (Object object2 : EtmParameterAdaptor.this.etmBoards.keySet()) {
                object = (SlotListParameter)EtmParameterAdaptor.this.etmBoards.get(object2);
                if (hashMap.containsKey(object2)) continue;
                ((SlotListParameter)object).setValue("");
            }
            for (Object object2 : EtmParameterAdaptor.this.etmBoards.keySet()) {
                object = (SlotListParameter)EtmParameterAdaptor.this.etmBoards.get(object2);
                if (!hashMap.containsKey(object2)) continue;
                objectArray = ((List)hashMap.get(object2)).toArray(new String[0]);
                Object[] objectArray2 = ((SlotListParameter)object).getAllSlots();
                Arrays.sort(objectArray2);
                Arrays.sort(objectArray);
                if (Arrays.equals(objectArray2, objectArray)) continue;
                try {
                    ((ListParameter)object).setValue((String[])objectArray);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class EtmListener
    implements CustomerParameterListener {
        private EtmListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            Iterator iterator = EtmParameterAdaptor.this.etmBoards.keySet().iterator();
            boolean bl = true;
            while (iterator.hasNext() && bl) {
                String[] stringArray;
                String string = (String)iterator.next();
                SlotListParameter slotListParameter = (SlotListParameter)EtmParameterAdaptor.this.etmBoards.get(string);
                if (slotListParameter == null) continue;
                for (String string2 : stringArray = slotListParameter.getAllSlots()) {
                    Enumeration enumeration = (Enumeration)EtmParameterAdaptor.this.slots.get(string2);
                    if (enumeration == null) continue;
                    if (enumeration.getValue().equals(string)) {
                        bl = false;
                        continue;
                    }
                    enumeration.setValue("");
                }
            }
        }
    }
}

