/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.precontrol;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.precontrol.AbstractDuwPlugAndPlayPreController;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;

public class CreateSecondaryDuwPreController
extends AbstractDuwPlugAndPlayPreController {
    private boolean inTest = false;
    private boolean nodeHasDuw = false;

    public CreateSecondaryDuwPreController(Installer installer) {
        super(installer);
        this.description = "Create Secondary DUW precontrolller";
        this.totalReports = 5;
        this.name = this.getClass().getName();
    }

    public CreateSecondaryDuwPreController() {
        this(null);
    }

    private boolean inTest() {
        return this.inTest;
    }

    public void setTest(boolean bl) {
        this.inTest = bl;
    }

    public synchronized boolean install() throws WizardException {
        this.installer.reportProgress(this.name, this.description);
        --this.totalReports;
        try {
            this.nodeHasDuw = DuwUtil.hasDuw();
            if (!this.nodeHasDuw) {
                return false;
            }
            boolean bl = this.checkIfAddDuwParameterInXML();
            boolean bl2 = this.inTest();
            if (!bl && !bl2) {
                return true;
            }
            this.checkCabinetExist();
            this.prepareSecondaryDuwForPlugAndPlay();
            this.installer.reportProgress(this.name, "Preparing for plug and play , waiting for auto configuration to go idle.");
            --this.totalReports;
            Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play , waiting for auto configuration to go idle.");
            if (BemLanguageHelp.getEnvironment() != 1) {
                this.waitForAutoConfigurationStatusToBecomeIdle();
            }
            this.installer.reportProgress(this.name, "Preparing for plug and play , setting slots on RPU MOs.");
            --this.totalReports;
            Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play ,  setting slots on RPU MOs.");
            super.setslotsOnRPUMOs();
            this.installer.reportProgress(this.name, "Preparing for plug and play , waiting for start up of board.");
            --this.totalReports;
            Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play , waiting for start up of board.");
            if (BemLanguageHelp.getEnvironment() != 1) {
                super.waitForAutoConfiguration();
            }
            Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play , setting piuGroupNumber.");
            super.setPiuGroupNumberAttribute(DuwUtil.getPiugroupStartNumber());
            super.unlock(DuwUtil.getSecondaryDuwPiuLdn(), "administrativeState");
            DuwUtil.unSetup();
        }
        catch (Exception exception) {
            throw new WizardException(exception.toString());
        }
        return true;
    }

    private boolean checkIfAddDuwParameterInXML() throws BemException {
        String string;
        ModifyModel modifyModel = ModifyModel.getInstance();
        ServiceValue serviceValue = modifyModel.getServiceValue();
        ServiceNameValue serviceNameValue = serviceValue.getAttribute("AddDuwBoardslot");
        if (serviceNameValue != null && (string = (String)serviceNameValue.getValue()).equals("2")) {
            BemLog.log(7, this.name + " checkIfAddDuwParameterInXML() AddDuw was ordered for adding of SDUW");
            return true;
        }
        return false;
    }

    private void checkCabinetExist() throws BemException {
        Rbs rbs = RbsFactory.getRbs(null, new MoHandlerImpl(), "STEP_EXPANSION");
        if (!rbs.getRbsData().isRbs6000()) {
            return;
        }
        ModifyModel modifyModel = ModifyModel.getInstance();
        ServiceValue serviceValue = modifyModel.getServiceValue();
        ServiceNameValue serviceNameValue = serviceValue.getAttribute("AddDuwBoardcabinetNumber");
        if (null != serviceNameValue) {
            String string = (String)serviceNameValue.getValue();
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
            String string2 = new FixedRdnMoi(singleChildMoi, MimCabinet.MOTYPENAME, string).getLdn();
            BemMo bemMo = super.getMo(string2);
            String string3 = "cabinetNumber";
            String string4 = String.valueOf(2);
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), string3, string4, serviceNameValue.getInputSource());
            if (rbs.getRbsType().equals(RbsInfo.RBS_6601W.NAME)) {
                int n = 1;
                int n2 = 2;
                String string5 = MessageFormat.format("EcPort{0}_", String.valueOf(n));
                String string6 = MessageFormat.format("EcPort{0}_", String.valueOf(n2));
                ServiceNameValue serviceNameValue3 = serviceValue.getAttribute(string5 + "cascadingOrder");
                ServiceNameValue serviceNameValue4 = serviceValue.getAttribute(string6 + "cascadingOrder");
                if (DuwUtil.isPrimaryDuwV2() && null != serviceNameValue3 && null != serviceNameValue4 && (serviceNameValue3.getValue().equals("1") && serviceNameValue4.getValue().equals("2") || serviceNameValue3.getValue().equals("2") && serviceNameValue4.getValue().equals("1")) || DuwUtil.isPrimaryDuwV1()) {
                    serviceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
                    return;
                }
                string4 = String.valueOf(1);
                serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), string3, string4, serviceNameValue.getInputSource());
                serviceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
                return;
            }
            if (rbs.getRbsType().equals(RbsInfo.RBS_6302W.NAME) && DuwUtil.isPrimaryDuwV1()) {
                serviceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
                return;
            }
            if (!bemMo.isExisting()) {
                throw new BemException("cabinetNumber_" + string + " is not existed, can not add secondary DUW for the cabinet " + string);
            }
        }
    }

    private void prepareSecondaryDuwForPlugAndPlay() throws BemException {
        this.installer.reportProgress(this.name, "Preparing for plug and play , reconfiguring programs.");
        --this.totalReports;
        Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play ,  reconfiguring programs.");
        this.addRedundancyRepToSwAllocationIfExisting();
        this.reconfigureProgramPreparePrimaryDuw();
        this.startImmediateActionOnProgramMosPrimaryDuw();
        this.installer.reportProgress(this.name, "Preparing for plug and play , adding slot 2 to SW allocation for DUW.");
        --this.totalReports;
        Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play , adding slot 2 to SW allocation for DUW.");
        this.addSecondDuwSlotToSwAllocation();
        this.installer.reportProgress(this.name, "Preparing for plug and play , creating InterPiuLink.");
        --this.totalReports;
        Nal.getLog().nalTrace(3, this.getClass(), "Preparing for plug and play , creating InterPiuLink.");
        this.createInterPiuLinkCable();
        this.unlockInterPiuLinkCable();
    }

    private void waitForAutoConfigurationStatusToBecomeIdle() throws BemException {
        Integer n;
        Nal.getLog().nalTrace(6, this.getClass(), "Waiting for autoConfigurationStatus to become IDLE.");
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimManagedElementData.MOTYPENAME, "1");
        BemMo bemMo = super.getMo(singleChildMoi.getLdn());
        long l = System.currentTimeMillis() + 600000L;
        while ((n = (Integer)bemMo.getAttribute("autoConfigurationStatus")) != 0) {
            if (super.isInterrupted()) {
                Nal.getLog().nalTrace(2, this.getClass(), "Waiting for autoConfigurationStatus, interupted by user.");
                break;
            }
            if (l < System.currentTimeMillis()) {
                Nal.getLog().nalTrace(1, this.getClass(), "Waiting for autoConfigurationStatus, auto-configuration is still in progress after having waited for 10 minutes.");
                throw new BemException("SYSTEM BUSY, PLUG AND PLAY IN PROGRESS");
            }
            this.delay_ms(5000);
        }
    }
}

