/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.EthernetSwitchCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LagManager
extends CustomerParameterImpl {
    private Rbs rbs;
    private String pseudoName;
    private String value = "";
    private List<CustomerParameter> cpObjectList = new ArrayList<CustomerParameter>();
    private EthernetSwitchProvider ethernetSwitchProvider;

    public LagManager(String string) {
        super(string, new StringRange(0, 1000));
    }

    public LagManager(Rbs rbs, String string) throws BemException {
        super(string, new StringRange(0, 1000));
        this.rbs = rbs;
        this.pseudoName = string;
        this.ethernetSwitchProvider = (EthernetSwitchProvider)this.rbs.getProvider(EthernetSwitchProvider.class);
        this.buildGuiCustomerParameter();
    }

    public boolean counterReachedLimit() {
        return ((EthernetSwitchCI)this.ethernetSwitchProvider).lagCounterReachedLimit();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public List<CustomerParameter> getCustomerParameterObjects() {
        return this.cpObjectList;
    }

    public void createCICustomerParamater(String string, String string2) throws BemException {
        this.ethernetSwitchProvider.createCP(this.pseudoName + "_" + string + "_" + "lagId", string);
        this.ethernetSwitchProvider.createCP(this.pseudoName + "_" + string + "_" + "action", string2);
        this.buildGuiCustomerParameter();
    }

    public void buildGuiCustomerParameter() throws BemException {
        this.cpObjectList = new ArrayList<CustomerParameter>();
        this.value = "";
        if (this.pseudoName.equals("linkAggregationGroup")) {
            ArrayList arrayList = this.rbs.getCustomerParameterPseudoName(this.pseudoName);
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            CustomerParameter customerParameter = null;
            CustomerParameter customerParameter2 = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                customerParameter = this.rbs.getCustomerParameterObject((String)iterator.next());
                bl = customerParameter.getValue().equals("DELETE");
                if (iterator.hasNext()) {
                    customerParameter2 = this.rbs.getCustomerParameterObject((String)iterator.next());
                }
                if (bl) continue;
                this.cpObjectList.add(customerParameter2);
                this.value = this.value + "[" + customerParameter2.getValue().toLowerCase() + "]";
                if (!iterator.hasNext()) continue;
                this.value = this.value + ",";
            }
        }
    }
}

