/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.AbstractFlexFinishController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.OamPostProgressDlgController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.FinishFlexView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;

public class OamFinishController
extends AbstractFlexFinishController {
    private FinishFlexView view;
    private Rbs rbs;
    private OamCIModel model;
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private final String[] ipAtmHeading = new String[]{"IP over ATM (DEFAULT O&M Link)", "IP over ATM (REDUNDANT O&M Link)"};
    private final String[] PSEUDO_PREFIX = new String[]{"firstOAMatm_", "secondOAMatm_"};
    private final String[] PSEUDO_SLOT;
    private final String[] PSEUDO_TERMINATION_TYPE;
    private final String[] PSEUDO_LINE;
    private final String[] PSEUDO_SLOTS_IN_FRACTION;
    private final String[] PSEUDO_VPI;
    private final String[] PSEUDO_VP_PCR;
    private final String[] PSEUDO_VP_MCR;
    private final String[] PSEUDO_VP_SC;
    private final String[] PSEUDO_VCI;
    private final String[] PSEUDO_VC_SC;
    private final String[] PSEUDO_ADDRESS;
    private final String[] PSEUDO_SUBNETMASK;
    private final String[] PSEUDO_REQUIRED_NUMBER_OF_LINKS;

    public OamFinishController() {
        super(OamCIModel.getInstance(), WizardHelp.getTheInstance());
        String[] stringArray = new String[2];
        stringArray[0] = this.PSEUDO_PREFIX[0] + "etbSlot";
        stringArray[1] = this.PSEUDO_PREFIX[1] + "etbSlot";
        this.PSEUDO_SLOT = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[0] = this.PSEUDO_PREFIX[0] + "terminationType";
        stringArray2[1] = this.PSEUDO_PREFIX[1] + "terminationType";
        this.PSEUDO_TERMINATION_TYPE = stringArray2;
        String[] stringArray3 = new String[2];
        stringArray3[0] = this.PSEUDO_PREFIX[0] + "physicalLine";
        stringArray3[1] = this.PSEUDO_PREFIX[1] + "physicalLine";
        this.PSEUDO_LINE = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[0] = this.PSEUDO_PREFIX[0] + "timeSlotsInFraction";
        stringArray4[1] = this.PSEUDO_PREFIX[1] + "timeSlotsInFraction";
        this.PSEUDO_SLOTS_IN_FRACTION = stringArray4;
        String[] stringArray5 = new String[2];
        stringArray5[0] = this.PSEUDO_PREFIX[0] + "externalVpi";
        stringArray5[1] = this.PSEUDO_PREFIX[1] + "externalVpi";
        this.PSEUDO_VPI = stringArray5;
        String[] stringArray6 = new String[2];
        stringArray6[0] = this.PSEUDO_PREFIX[0] + "vpPeakCellRate";
        stringArray6[1] = this.PSEUDO_PREFIX[1] + "vpPeakCellRate";
        this.PSEUDO_VP_PCR = stringArray6;
        String[] stringArray7 = new String[2];
        stringArray7[0] = this.PSEUDO_PREFIX[0] + "vpMinimumCellRate";
        stringArray7[1] = this.PSEUDO_PREFIX[1] + "vpMinimumCellRate";
        this.PSEUDO_VP_MCR = stringArray7;
        String[] stringArray8 = new String[2];
        stringArray8[0] = this.PSEUDO_PREFIX[0] + "vpServiceCategory";
        stringArray8[1] = this.PSEUDO_PREFIX[1] + "vpServiceCategory";
        this.PSEUDO_VP_SC = stringArray8;
        String[] stringArray9 = new String[2];
        stringArray9[0] = this.PSEUDO_PREFIX[0] + "externalVci";
        stringArray9[1] = this.PSEUDO_PREFIX[1] + "externalVci";
        this.PSEUDO_VCI = stringArray9;
        String[] stringArray10 = new String[2];
        stringArray10[0] = this.PSEUDO_PREFIX[0] + "vcServiceCategory";
        stringArray10[1] = this.PSEUDO_PREFIX[1] + "vcServiceCategory";
        this.PSEUDO_VC_SC = stringArray10;
        String[] stringArray11 = new String[2];
        stringArray11[0] = this.PSEUDO_PREFIX[0] + "atmIpAddress";
        stringArray11[1] = this.PSEUDO_PREFIX[1] + "atmIpAddress";
        this.PSEUDO_ADDRESS = stringArray11;
        String[] stringArray12 = new String[2];
        stringArray12[0] = this.PSEUDO_PREFIX[0] + "atmSubnetMask";
        stringArray12[1] = this.PSEUDO_PREFIX[1] + "atmSubnetMask";
        this.PSEUDO_SUBNETMASK = stringArray12;
        String[] stringArray13 = new String[2];
        stringArray13[0] = this.PSEUDO_PREFIX[0] + "requiredNumberOfLinks";
        stringArray13[1] = this.PSEUDO_PREFIX[1] + "requiredNumberOfLinks";
        this.PSEUDO_REQUIRED_NUMBER_OF_LINKS = stringArray13;
    }

    protected void init() {
        AbstractView abstractView = this.getView();
        this.view = (FinishFlexView)abstractView;
        this.model = OamCIModel.getInstance();
        super.setFlexModel(this.model);
        super.init();
        this.rbs = OamCIModel.getInstance().getRbs();
        super.init();
    }

    protected void afterVisible() {
        super.afterVisible();
        this.view.clearVariables();
        try {
            this.updateIpOverEthernet();
            this.updateEthernetSwitch();
            this.updateIpOverGigabitEthernet();
            this.updateLink();
            this.updateGigabitEthernetPort();
            this.updateAtmPort();
            this.updateIpRouting();
            this.updateServer();
            this.updateTimeSetting();
            this.updateNetworkSync();
            this.updateCpriBasedSync();
            this.view.updateGui();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("FinishController", "afterVisible()", null, "Getting changed customer parameters", exception);
            this.displayError(wizardException);
        }
    }

    private void updateCpriBasedSync() throws BemException {
        if (this.rbs.isParameterSupported("configureCpriBasedSync") && this.rbs.isParameterSupported("administrativeState") && this.rbs.isParameterSupported("syncNodePriority") && this.rbs.isParameterSupported("syncRiPortCandidate")) {
            String string = this.rbs.getCustomerParameter("configureCpriBasedSync");
            String string2 = this.rbs.getCustomerParameter("administrativeState");
            String string3 = this.rbs.getCustomerParameter("syncNodePriority");
            String string4 = this.rbs.getCustomerParameter("syncRiPortCandidate");
            if (string != null && !string3.equals("##UNDEFINED") && !string4.equals("##UNDEFINED")) {
                this.view.setCpriBasedSyncConfigInformativeText(string, string2, string3, string4);
            }
        }
    }

    private void updateGigabitEthernetPort() throws BemException {
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && this.rbs.isParameterSupported("gigaBitEthernetPort")) {
            String string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption");
            String string2 = this.rbs.getCustomerParameter("gigaBitEthernetPort");
            String string3 = this.rbs.getCustomerParameter("gigaBitEthernetPortCreate");
            if (string.equals("atm") && string3.equals("YES")) {
                this.view.setGigabitEthernetPortInformativeText(string2);
            }
        }
    }

    protected void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("O&M Access Configuration page {0}({1})", string2, string3));
    }

    protected boolean finish() {
        super.finish();
        boolean bl = super.finishReconnecting("OamAccess", "NCONF_OAM_WIZARD_WINDOW_TITLE", ProgressDialogView.class, OamPostProgressDlgController.class);
        return bl;
    }

    private void updateNetworkSync() throws BemException {
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            Integer n = i + 1;
            String string = MessageFormat.format("Y_{0}_", n);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = string + "synchPriority";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string6);
            string2 = customerParameter.getValue();
            string6 = string + "synchSlot";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            string3 = customerParameter.getValue();
            string6 = string + "synchGuiBoard";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            string4 = customerParameter.getValue();
            string6 = string + "synchPort";
            customerParameter = this.rbs.getCustomerParameterObject(string6);
            string5 = customerParameter.getValue();
            this.view.setNetworkSyncInformativeText(i, string2, string3, string4, string5);
        }
    }

    private void updateTimeSetting() throws BemException {
        String[] stringArray = new String[]{"localTimeZone", "daylightSavingTime", "primaryNtpServerIpAddress", "primaryNtpServiceActive", "secondaryNtpServerIpAddress", "secondaryNtpServiceActive"};
        String[] stringArray2 = this.getValuesArray(stringArray);
        this.view.setTimeSettingInformativeText(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], stringArray2[4], stringArray2[5]);
    }

    private void updateServer() throws BemException {
        String[] stringArray = new String[]{"dhcpServerPrimaryIpAddress", "dhcpServerSecondaryIpAddress", "dnsServerIpAddress", "isDefaultDomainName", "defaultDomainName", "singleLogonServer", "documentServerWebAddress", "ossCorbaNameServer", "ossCorbaNameServerPort"};
        String[] stringArray2 = this.getValuesArray(stringArray);
        this.view.setServerInformativeText(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], stringArray2[4], stringArray2[5], stringArray2[6], stringArray2[7], stringArray2[8]);
    }

    private String[] getValuesArray(String[] stringArray) throws BemException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            stringArray2[i] = customerParameter.getValue();
        }
        return stringArray2;
    }

    private void updateIpRouting() throws BemException {
        int n = 0;
        while (true) {
            Integer n2 = ++n;
            String string = MessageFormat.format("R_{0}_", n2);
            String string2 = string + "routeIpAddress";
            if (!this.rbs.isParameterSupported(string2)) break;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
            if (customerParameter.getAccessLevel() == 1) continue;
            String string3 = this.rbs.getCustomerParameter(string2);
            String string4 = this.rbs.getCustomerParameter(string + "routeSubnetMask");
            String string5 = this.rbs.getCustomerParameter(string + "hopIpAddress");
            String string6 = this.rbs.getCustomerParameter(string + "routeMetric");
            String string7 = this.rbs.getCustomerParameter(string + "redistribute");
            this.view.setIpRoutingInformativeText(string3, string4, string5, string6, string7);
        }
    }

    private void updateIpOverEthernet() throws BemException {
        if (this.rbs.isParameterSupported("ipAddress")) {
            String string = this.rbs.getCustomerParameter("ipAddress");
            String string2 = this.rbs.getCustomerParameter("subnetMask");
            this.view.setIpOverEthernetInformativeText(string, string2);
        }
    }

    private void updateEthernetSwitch() throws BemException {
        String string;
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && !DuwUtil.hasDuw() && (string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption")).equals("ipV4")) {
            String[] stringArray = this.rbs.getCustomerParameter("EthernetSwitchvlan");
            this.view.setEthernetSwitchInformativeText((String)stringArray, "");
            stringArray = new String[7];
            String[] stringArray2 = new String[7];
            String[] stringArray3 = new String[7];
            String[] stringArray4 = new String[7];
            String[] stringArray5 = new String[7];
            String[] stringArray6 = new String[7];
            for (int i = 0; i < 7; ++i) {
                stringArray[i] = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_administrativeState", i + 1));
                if (stringArray[i].equals("Locked")) {
                    int n = i;
                    stringArray[n] = stringArray[n] + "  ";
                }
                stringArray2[i] = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_systemPort", i + 1));
                stringArray3[i] = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_lagId", i + 1));
                stringArray4[i] = "";
                stringArray5[i] = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressVid", i + 1));
                stringArray6[i] = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressPriority", i + 1));
            }
            this.view.setEthernetSwitchPortInformativeText(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6);
        }
    }

    private void updateIpOverGigabitEthernet() throws BemException {
        String string;
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && (string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption")).equals("ipV4")) {
            String string2 = null;
            if (this.rbs.isParameterSupported("gigaBitEthernetPort")) {
                string2 = this.rbs.getCustomerParameter("gigaBitEthernetPort");
                this.view.setGigabitEthernetInformativeText(string2);
            }
            if (this.rbs.isParameterSupported("IpSec_configType")) {
                String string3 = this.rbs.getCustomerParameter("IpSec_configType");
                this.view.setIpsecStatusInformativeText(string3);
                if (string3.equals("NON_IPSEC")) {
                    String string4 = this.rbs.getCustomerParameter("OamIpHost_configurationMode");
                    String string5 = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                    String string6 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
                    String string7 = this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0");
                    String string8 = this.rbs.getCustomerParameter("OamIpHost_oamVid");
                    String string9 = this.rbs.getCustomerParameter("OamIpHost_DhcpClientIdentifier_clientIdentifierType");
                    String string10 = this.rbs.getCustomerParameter("OamIpHost_DhcpClientIdentifier_clientIdentifier");
                    this.view.setIpHostLinkInformativeText(string4, string5, string6, string7, string8, string9, string10);
                    String string11 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
                    String string12 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncSubnetMask");
                    String string13 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_defaultRouter0");
                    String string14 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncVid");
                    this.view.setIpOverGigabitEthernetInformativeText(string11, string12, string13, string14, string2);
                } else if (string3.equals("IPSEC_SINGLE_LINK")) {
                    String string15 = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                    String string16 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
                    String string17 = this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0");
                    String string18 = this.rbs.getCustomerParameter("OamIpHost_oamVid");
                    String string19 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
                    this.view.setIpsecOamInformativeText(string15, string16, string17, string18, string19);
                    String string20 = this.rbs.getCustomerParameter("Iub_ipAddressHostEt");
                    String string21 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
                    String string22 = this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0");
                    String string23 = this.rbs.getCustomerParameter("OamIpHost_oamVid");
                    String string24 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
                    this.view.setIpsecSyncInformativeText(string20, string21, string22, string23, string24);
                } else if (string3.equals("IPSEC_DUAL_LINK")) {
                    String string25 = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                    String string26 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
                    String string27 = this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0");
                    String string28 = this.rbs.getCustomerParameter("OamIpHost_oamVid");
                    String string29 = this.rbs.getCustomerParameter("OamIpHost_outerOamIpAddressHostEt");
                    this.view.setIpsecOamInformativeText(string25, string26, string27, string28, string29);
                    String string30 = this.rbs.getCustomerParameter("Iub_ipAddressHostEt");
                    String string31 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncSubnetMask");
                    String string32 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_defaultRouter0");
                    String string33 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncVid");
                    String string34 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
                    this.view.setIpsecSyncInformativeText(string30, string31, string32, string33, string34);
                }
            }
        }
    }

    private void updateAtmPort() throws BemException {
        int n = 0;
        while (true) {
            String string = "";
            Integer n2 = ++n;
            String string2 = MessageFormat.format("ATM{0}_", n2);
            String string3 = string2 + "etbSlot";
            if (!this.rbs.isParameterSupported(string3)) break;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
            if (customerParameter.getAccessLevel() == 1) continue;
            String string4 = this.rbs.getCustomerParameter(string3);
            String string5 = this.rbs.getCustomerParameter(string2 + "physicalLine");
            String string6 = this.rbs.getCustomerParameter(string2 + "terminationType");
            String string7 = this.rbs.getCustomerParameter(string2 + "timeSlotsInFraction");
            AtmPortProvider atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
            boolean bl = atmPortProvider.isFractional(string4, string6);
            if (bl) {
                string = string7;
            }
            this.view.setAtmPortInformativeText(string4, string6, string5, string);
        }
    }

    private void updateLink() throws BemException {
        String string;
        String string2 = "";
        AtmPortProvider atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        for (int i = 0; i < this.PSEUDO_SLOT.length && this.rbs.isParameterSupported(string = this.PSEUDO_SLOT[i]) && !(string2 = this.rbs.getCustomerParameter(this.PSEUDO_SLOT[i])).equals("None"); ++i) {
            String string3 = this.rbs.getCustomerParameter(this.PSEUDO_TERMINATION_TYPE[i]);
            String string4 = this.rbs.getCustomerParameter(this.PSEUDO_LINE[i]);
            String string5 = this.rbs.getCustomerParameter(this.PSEUDO_SLOTS_IN_FRACTION[i]);
            String string6 = this.rbs.getCustomerParameter(this.PSEUDO_VCI[i]);
            String string7 = this.rbs.getCustomerParameter(this.PSEUDO_VC_SC[i]);
            String string8 = this.rbs.getCustomerParameter(this.PSEUDO_VP_PCR[i]);
            String string9 = this.rbs.getCustomerParameter(this.PSEUDO_VP_MCR[i]);
            String string10 = this.rbs.getCustomerParameter(this.PSEUDO_VPI[i]);
            String string11 = this.rbs.getCustomerParameter(this.PSEUDO_VP_SC[i]);
            String string12 = this.rbs.getCustomerParameter(this.PSEUDO_ADDRESS[i]);
            String string13 = this.rbs.getCustomerParameter(this.PSEUDO_SUBNETMASK[i]);
            String string14 = "No";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(this.PSEUDO_REQUIRED_NUMBER_OF_LINKS[i]);
            boolean bl = atmPortProvider.isFractional(string2, string3);
            String string15 = "N.A.";
            if (bl) {
                string14 = "Yes";
                string15 = string5;
            }
            boolean bl2 = atmPortProvider.isIma(string2, string3);
            String string16 = null;
            if (bl2) {
                string16 = customerParameter.getValue();
            }
            this.view.setLinkInformativeText(this.ipAtmHeading[i], string2, string3, bl2, string4, string16, string14, string15, string10, string8, string9, string11, string6, string7, string12, string13);
        }
    }

    protected String getWizardName() {
        return "Oam";
    }
}

