/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.precontrol;

import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpHostLink;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.precontrol.PreconditionsPreController;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;

public class OamPreconditionsPreController
extends PreconditionsPreController {
    private final String description = "Evaluating preconditions for O&M Access Wizard";
    private final Installer installer;
    private final int totalReports = 5;

    public OamPreconditionsPreController(Installer installer) {
        super(installer, WizardCommon.WIZARD_PRECONDITIONS_OAM);
        this.theName = this.getClass().getName();
        this.theDescription = this.description;
        this.installer = installer;
    }

    public boolean install() throws WizardException {
        if (this.installer.isInterrupted()) {
            return false;
        }
        int n = this.totalReports;
        this.installer.reportProgress(this.theName, this.theDescription);
        --n;
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.checkIfCabinetWizardIsRun();
            bl2 = this.checkIfOamWizardIsRun();
        }
        catch (Exception exception) {
            throw new WizardException("Checking preconditions", (Throwable)exception);
        }
        if (!bl && !bl2) {
            throw new WizardException("Cabinet wizard is not run");
        }
        if (this.installer.isInterrupted()) {
            return false;
        }
        while (n > 0) {
            this.installer.reportProgress(this.theName, this.theDescription);
            --n;
        }
        return false;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    private boolean checkIfCabinetWizardIsRun() throws Exception {
        boolean bl = false;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        RootMoi rootMoi = new RootMoi();
        String string = rootMoi.getLdn();
        BemMo bemMo = moHandlerImpl.getMo(string);
        Object object = null;
        object = moHandlerImpl.getAttribute(bemMo, "productName");
        String string2 = (String)object;
        if (string2 != null && !string2.equals("")) {
            bl = true;
        }
        return bl;
    }

    private boolean checkIfOamWizardIsRun() throws Exception {
        boolean bl = true;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo[] bemMoArray = null;
        BemMo[] bemMoArray2 = null;
        BemMo[] bemMoArray3 = null;
        try {
            BemMo bemMo = moHandlerImpl.getRoot();
            bemMoArray = moHandlerImpl.getChildren(bemMo, 10, MimIpAtmLink.MOTYPENAME, "");
            bemMoArray2 = moHandlerImpl.getChildren(bemMo, 10, MimIpAccessHostEt.MOTYPENAME, "");
            bemMoArray3 = moHandlerImpl.getChildren(bemMo, 10, MimIpHostLink.MOTYPENAME, "");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("checkIfOamWizardIsRun() Can not read from the RBS.", (Throwable)moHandlerException);
        }
        if (!(bemMoArray != null && bemMoArray.length != 0 || bemMoArray2 != null && bemMoArray2.length != 0 || bemMoArray3 != null && bemMoArray3.length != 0)) {
            bl = false;
        }
        return bl;
    }
}

