/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.duwrbb.CellAndCarrierDuwRbbCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.RbsLocalCellViewer;

public class RbsLocalCellController
extends BemWizardGuiController {
    private RbsLocalCellViewer myView = null;
    private final List customerParameterNames = new ArrayList();
    private WizardCIModel wizardCiModel;
    private static final String[] rowNames = new String[]{"Create cell:", "Local cell ID:", "Number of TX branches:", "Number of RX branches:", "Cell range (m):"};
    private Rbs rbs = null;
    private RadioEquipmentProvider[] radioEquipmentProvider = new RadioEquipmentProvider[2];
    private boolean firstTimeGuiIsShown = true;
    private int[] equipedSectors;

    protected void init() {
        this.myView = (RbsLocalCellViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            this.rbs = this.wizardCiModel.getRbs();
            if (this.rbs.isParameterSupported("carrierAllocationMode") && this.rbs.getRbsData().isRbs6000() && this.rbs.getRbsData().getSupportsCarrierAllocationModes()) {
                this.myView.setCarrierAllocationModeParameter((CarrierAllocationModeParameter)this.rbs.getCustomerParameterObject("carrierAllocationMode"));
            }
            this.radioEquipmentProvider[0] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
            int[] nArray = this.radioEquipmentProvider[0].getEquippedSectors();
            if (this.rbs.isPantherHybridRbs()) {
                this.radioEquipmentProvider[1] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, 1);
                int[] nArray2 = this.radioEquipmentProvider[1].getEquippedSectors();
                this.equipedSectors = WizardHelp.mergeIntArray(nArray, nArray2);
            } else {
                this.equipedSectors = nArray;
            }
            int n = this.rbs.getMaxNumberOfCarriers();
            if (n > 4) {
                n = 4;
            }
            for (int n2 : this.equipedSectors) {
                this.arrangeSectors(n2, n);
            }
            for (int i = 0; i < this.rbs.getMaxNumberOfSectors(); ++i) {
                if (this.isSectorEquiped(i + 1)) continue;
                this.myView.removeUnconfiguredSectorTable(i + 1);
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
        this.firstTimeGuiIsShown = false;
    }

    private boolean isSectorEquiped(int n) {
        for (int i = 0; i < this.equipedSectors.length; ++i) {
            if (n != this.equipedSectors[i]) continue;
            return true;
        }
        return false;
    }

    private void arrangeSectors(int n, int n2) throws BemException {
        String string = Integer.valueOf(n).toString();
        Object[][] objectArray = new Object[rowNames.length][n2];
        String[] stringArray = new String[n2 + 1];
        stringArray[0] = " ";
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1;
            String string2 = Integer.valueOf(n3).toString();
            String string3 = "";
            stringArray[i + 1] = MessageFormat.format("Cell={0}", string2);
            String string4 = MessageFormat.format("S{0}_C{1}_", string, String.valueOf(n3));
            string3 = string4 + "cellCreated";
            boolean bl2 = this.rbs.isParameterSupported(string3);
            if (bl2) {
                bl = this.rbs.isParameterSupported(string3);
            }
            if (!bl) continue;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
            objectArray[0][i] = customerParameter;
            int n4 = 0;
            boolean bl3 = false;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n4 = this.radioEquipmentProvider[1].getMaxNumberOfCarriers(n);
                bl3 = this.radioEquipmentProvider[1] instanceof RadioEquipmentProviderWithRbb;
            } else {
                n4 = this.radioEquipmentProvider[0].getMaxNumberOfCarriers(n);
                bl3 = this.radioEquipmentProvider[0] instanceof RadioEquipmentProviderWithRbb;
            }
            if (this.firstTimeGuiIsShown && n3 <= n4 && !this.wizardCiModel.getUseFileInput() && customerParameter.getAccessLevel() != 1 && !bl3) {
                customerParameter.setValue("YES");
            }
            this.customerParameterNames.add(string3);
            string3 = string4 + "cellIdentity";
            customerParameter = this.rbs.getCustomerParameterObject(string3);
            objectArray[1][i] = customerParameter;
            this.customerParameterNames.add(string3);
            string3 = string4 + "numberOfTxBranches";
            customerParameter = this.rbs.getCustomerParameterObject(string3);
            objectArray[2][i] = customerParameter;
            this.customerParameterNames.add(string3);
            string3 = string4 + "numberOfRxBranches";
            customerParameter = this.rbs.getCustomerParameterObject(string3);
            objectArray[3][i] = customerParameter;
            this.customerParameterNames.add(string3);
            string3 = string4 + "cellRange";
            customerParameter = this.rbs.getCustomerParameterObject(string3);
            objectArray[4][i] = customerParameter;
            this.customerParameterNames.add(string3);
        }
        if (bl) {
            this.myView.setSectorTableParameters(n, objectArray, rowNames, stringArray);
        }
    }

    private void checkCellIdUnique() throws BemException {
        Vector<String> vector = new Vector<String>();
        for (int n : this.equipedSectors) {
            String string = Integer.valueOf(n).toString();
            boolean bl = false;
            for (int i = 0; i < this.rbs.getMaxNumberOfCarriers(); ++i) {
                int n2 = i + 1;
                String string2 = Integer.valueOf(n2).toString();
                String string3 = "";
                String string4 = MessageFormat.format("S{0}_C{1}_", string, String.valueOf(n2));
                string3 = string4 + "cellCreated";
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
                bl = this.rbs.isParameterSupported(string3);
                if (!bl || !customerParameter.getValue().equals("YES")) continue;
                string3 = string4 + "cellIdentity";
                customerParameter = this.rbs.getCustomerParameterObject(string3);
                String string5 = customerParameter.getValue();
                if (vector.contains(string5)) {
                    throw new CustomerParameterException(" Cell Id: " + string5 + " is not unique ! " + " Sector=" + n + "; Cell=" + string2, customerParameter);
                }
                if (string5 == null || string5.equals("##UNDEFINED")) continue;
                vector.add(string5);
            }
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            ConfigurationItem configurationItem = this.rbs.getConfigItem("CellAndCarrierCI");
            CellAndCarrierManager.updateInteractionBetweenCarrierRIAndRbsLocalCellRI((CellAndCarrierCI)configurationItem);
            ConfigurationItem configurationItem2 = this.rbs.getConfigItem("CellAndCarrierCI", 1);
            CellAndCarrierManager.updateInteractionBetweenCarrierRIAndRbsLocalCellRI((CellAndCarrierDuwRbbCI)configurationItem2);
            configurationItem.checkConsistency(this.customerParameterNames);
            this.rbs.checkConsistency("RadioEquipmentCI");
            if (this.rbs.isPantherHybridRbs()) {
                this.checkCellIdUnique();
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

