/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.MixedModeRadioParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorDataViewer;

public class SectorDataController
extends BemWizardGuiController {
    private SectorDataViewer myView;
    private final List customerParameterNames = new ArrayList();
    private WizardCIModel wizardCiModel;

    protected void init() {
        this.myView = (SectorDataViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            int n;
            Rbs rbs = this.wizardCiModel.getRbs();
            RadioEquipmentProvider[] radioEquipmentProviderArray = new RadioEquipmentProvider[2];
            int[][] nArrayArray = new int[2][];
            int n2 = 0;
            for (int i = 0; i < radioEquipmentProviderArray.length && (rbs.isPantherHybridRbs() || i != 1); ++i) {
                if (i == 1) {
                    n2 = 1;
                }
                radioEquipmentProviderArray[i] = (RadioEquipmentProvider)rbs.getProvider(RadioEquipmentProvider.class, n2);
                nArrayArray[i] = radioEquipmentProviderArray[i].getEquippedSectors();
            }
            int[] nArray = WizardHelp.mergeIntArray(nArrayArray[0], nArrayArray[1]);
            if (radioEquipmentProviderArray[0] instanceof RadioEquipmentProviderWithRbb || radioEquipmentProviderArray[1] != null && radioEquipmentProviderArray[1] instanceof RadioEquipmentProviderWithRbb) {
                this.myView.initiateMainPanel();
            }
            if ((n = nArray.length) > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("Latitude:");
                arrayList.add("Lat hemisphere:");
                arrayList.add("Longitude:");
                arrayList.add("Geo datum:");
                arrayList.add("Height");
                arrayList.add("Noise figure");
                arrayList.add("Sector group");
                if (rbs.getRbsData().isRbs6000() && DuwUtil.hasDuw()) {
                    arrayList.add("Mixed mode radio");
                }
                String[] stringArray = arrayList.toArray(new String[0]);
                Object[][] objectArray = new Object[stringArray.length][n];
                String[] stringArray2 = new String[n + 1];
                stringArray2[0] = " ";
                for (int i = 0; i < n; ++i) {
                    int n3 = nArray[i];
                    String string = String.valueOf(n3);
                    String string2 = "";
                    stringArray2[i + 1] = MessageFormat.format("Sector={0}", string);
                    String string3 = MessageFormat.format("S{0}_", string);
                    string2 = string3 + "latitude";
                    CustomerParameter customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[0][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "latHemisphere";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[1][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "longitude";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[2][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "geoDatum";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[3][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "height";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[4][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "noiseFigure";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[5][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "sectorGroup";
                    customerParameter = rbs.getCustomerParameterObject(string2);
                    objectArray[6][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    if (!rbs.getRbsData().isRbs6000() || !DuwUtil.hasDuw()) continue;
                    string2 = string3 + "mixedModeRadio";
                    MixedModeRadioParameter mixedModeRadioParameter = (MixedModeRadioParameter)rbs.getCustomerParameterObject(string2);
                    objectArray[7][i] = mixedModeRadioParameter;
                    this.customerParameterNames.add(string2);
                }
                this.myView.setSectorTableParameters(objectArray, stringArray, stringArray2);
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.myView.editingStopped();
            Rbs rbs = this.wizardCiModel.getRbs();
            rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

