/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.precontrol;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.precontrol.AbstractCreateRbsPreController;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;

public class SiteCreateRbsPreController
extends AbstractCreateRbsPreController
implements SubInstaller {
    public SiteCreateRbsPreController(Installer installer) {
        super(installer, SiteCIModel.getInstance(), "STEP_SITE", WizardHelp.getTheInstance(), WizardCommon.WIZARD_PRECONDITIONS_SITE);
    }

    protected void openConfigurationItems(Rbs rbs) throws BemException {
        OpenCIs.openSiteCIs(rbs);
    }

    protected boolean shallBeNoWizard() throws BemException {
        Rbs rbs = this.model.getRbs();
        return this.isFlexibleAllocationMode(rbs) || this.isMultiCabinet(rbs);
    }

    private boolean isFlexibleAllocationMode(Rbs rbs) throws BemException {
        return rbs.isParameterSupported("carrierAllocationMode") && rbs.getCustomerParameter("carrierAllocationMode").equals("Flexible");
    }

    private boolean isMultiCabinet(Rbs rbs) throws BemException {
        return this.checkCabinetNumberInSectors(rbs) || this.checkCabinetNumberInCabinets(rbs);
    }

    private boolean checkCabinetNumberInSectors(Rbs rbs) throws BemException {
        int n = rbs.getMaxNumberOfSectors();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = MessageFormat.format("S{0}_", new Integer(i + 1));
            String string3 = string2 + "cabinetNumber";
            if (!rbs.isParameterSupported(string3) || "##UNDEFINED".equals(string = rbs.getCustomerParameter(string3)) || string.equals("1")) continue;
            return true;
        }
        return false;
    }

    private boolean checkCabinetNumberInCabinets(Rbs rbs) throws BemException {
        if (DuwUtil.isDualBoxConfiguration(rbs.getRbsType()) || DuwUtil.isCascadingSupport(rbs.getRbsType())) {
            return false;
        }
        for (int i = 0; i < rbs.getNoOfCabinets(); ++i) {
            String string;
            int n = Integer.parseInt(rbs.getCabinetNumberList().get(i).toString());
            String string2 = MessageFormat.format("CAB{0}_", new Integer(n));
            String string3 = string2 + "cabinetNumber";
            if (!rbs.isParameterSupported(string3) || "##UNDEFINED".equals(string = rbs.getCustomerParameter(string3)) || string.equals("1")) continue;
            return true;
        }
        return false;
    }
}

