/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.support.gui.EmasGuilibMediator;

public class EmasProgressMonitor {
    private EmasProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private final Component parentComponent;
    private String note;
    private final Object title;
    private final Object message;
    private final long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int lastDisp;
    private int reportDelta;
    private static final Vector openProgressMonitors = new Vector();

    public EmasProgressMonitor(Component component, Object object, Object object2, String string, int n, int n2) {
        this(component, object, object2, string, n, n2, null);
    }

    private EmasProgressMonitor(Component component, Object object, Object object2, String string, int n, int n2, EmasProgressMonitor emasProgressMonitor) {
        this.min = n;
        this.max = n2;
        this.parentComponent = component;
        this.reportDelta = (this.max - this.min) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.title = object;
        this.message = object2;
        this.note = string;
        if (emasProgressMonitor != null) {
            this.root = emasProgressMonitor.root != null ? emasProgressMonitor.root : emasProgressMonitor;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
        openProgressMonitors.add(this);
    }

    public void setProgress(int n) {
        if (n >= this.max) {
            this.close();
        } else if (n >= this.lastDisp + this.reportDelta) {
            this.lastDisp = n;
            if (this.myBar != null) {
                this.myBar.setValue(n);
                this.repaintImmediately();
            } else {
                int n2;
                long l = System.currentTimeMillis();
                long l2 = (int)(l - this.T0);
                if (l2 >= (long)this.millisToDecideToPopup && (n2 = n > this.min ? (int)(l2 * (long)(this.max - this.min) / (long)(n - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                    this.myBar = new JProgressBar();
                    this.myBar.setMinimum(this.min);
                    this.myBar.setMaximum(this.max);
                    this.myBar.setValue(n);
                    if (this.note != null) {
                        this.noteLabel = new JLabel(this.note);
                    }
                    this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                    this.dialog = this.pane.createDialog(this.parentComponent, this.title.toString());
                    this.dialog.show();
                    this.repaintImmediately();
                }
            }
        }
    }

    private void repaintImmediately() {
        Container container = this.dialog.getContentPane();
        if (container instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                container.paintAll(container.getGraphics());
            } else {
                container.repaint();
            }
        } else {
            container.repaint(0, 0, container.getWidth(), container.getHeight());
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
        openProgressMonitors.remove(this);
    }

    public static void closeAllOpenProgressMonitors() {
        for (int i = 0; i < openProgressMonitors.size(); ++i) {
            EmasProgressMonitor emasProgressMonitor = (EmasProgressMonitor)openProgressMonitors.get(i);
            emasProgressMonitor.close();
        }
        openProgressMonitors.clear();
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
            this.repaintImmediately();
        }
    }

    public String getNote() {
        return this.note;
    }

    public void resetProgressBar() {
        this.myBar.setValue(this.min);
        this.lastDisp = this.min;
    }

    private static class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, new Object[]{new JPanel()}, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component component, String string) {
            if (null == component) {
                component = EmasGuilibMediator.getReference().getMainWindowReference();
            }
            Frame frame = JOptionPane.getFrameForComponent(component);
            final JDialog jDialog = new JDialog(frame, string, false);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressOptionPane.this.setValue(null);
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (jDialog.isVisible() && propertyChangeEvent.getSource() == ProgressOptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            return jDialog;
        }
    }
}

