/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractComponent;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractComponentController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.Application;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.ComponentPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.ComponentSniffer;
import se.ericsson.wcdma.support.gui.guilib.infra.DialogModalPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.HelpManager;
import se.ericsson.wcdma.support.gui.guilib.infra.LanguageManager;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.wcdma.support.gui.guilib.infra.Resources;
import se.ericsson.wcdma.support.gui.guilib.infra.ViewContainer;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardModalPresenter;

abstract class AbstractPresenter {
    private static Vector disabledComponents = new Vector();
    private static DisableMouseListener disableMouseListener = new DisableMouseListener();
    private AbstractPresenter parentPresenter;
    private AbstractApplication application;
    private boolean visible = true;
    private boolean enabled = true;
    private Class viewClass;
    private Class controllerClass;
    private Object creationParameter = null;
    private AbstractView view;
    private AbstractController controller;
    private ComponentSniffer sniffer;
    private LanguageManager languageManager;
    private HelpManager helpManager;
    private Vector childPresenters = new Vector();
    private ViewContainer viewContainer;
    private String title;
    private String titleKey;
    private Object[] titleArgs;
    private String status;
    private String statusKey;
    private Object[] statusArgs;
    private Vector localeChangeListeners = new Vector();
    private boolean beenVisible;
    private boolean isDisposed = false;
    private static String prefix = "";

    static AbstractPresenter createPresenter(AbstractPresenter abstractPresenter, AbstractApplication abstractApplication, Class clazz, Class clazz2, Class clazz3, Object object) {
        AbstractPresenter abstractPresenter2 = null;
        try {
            abstractPresenter2 = (AbstractPresenter)clazz.newInstance();
            Log.trace("Presenter created: " + abstractPresenter2 + " Parent presenter: " + abstractPresenter);
            if (abstractPresenter != null) {
                abstractPresenter.addChildPresenter(abstractPresenter2);
            }
            abstractPresenter2.init(abstractPresenter, abstractApplication, clazz2, clazz3, object);
        }
        catch (Throwable throwable) {
            String string = "Could not create presenter: " + clazz;
            Log.logError(string, throwable);
            if (abstractPresenter != null && abstractPresenter2 != null) {
                abstractPresenter.removeChildPresenter(abstractPresenter2);
            }
            Log.assertion(false, string);
        }
        return abstractPresenter2;
    }

    AbstractPresenter() {
    }

    abstract void init();

    abstract ViewContainer createViewContainer();

    void setLocation(int n, int n2) {
        this.viewContainer.setLocation(n, n2);
    }

    Point getLocation() {
        return ((Component)((Object)this.viewContainer)).getLocation();
    }

    void addChildPresenter(AbstractPresenter abstractPresenter) {
        this.childPresenters.addElement(abstractPresenter);
        Log.trace("Child presenter added: (" + this.childPresenters.size() + ") " + abstractPresenter);
    }

    private void addDisabledComponent(Component component) {
        disabledComponents.add(component);
    }

    void addLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        if (this.localeChangeListeners.indexOf(localeChangeListener) != -1) {
            Log.logWarning("Language listener already added " + localeChangeListener.getClass());
            return;
        }
        this.localeChangeListeners.addElement(localeChangeListener);
    }

    void addStatusBar() {
        if (this.viewContainer != null) {
            this.viewContainer.addStatusBar();
        }
    }

    boolean canStop() {
        return this.canStopChildPresenters() && this.controller.canStop();
    }

    private boolean canStopChildPresenters() {
        boolean bl = true;
        Enumeration enumeration = this.childPresenters.elements();
        while (enumeration.hasMoreElements()) {
            if (((AbstractPresenter)enumeration.nextElement()).canStop()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    AbstractHandler createHandler(Class clazz) {
        AbstractHandler abstractHandler = null;
        try {
            abstractHandler = (AbstractHandler)clazz.newInstance();
            abstractHandler.init(this);
            abstractHandler.init();
        }
        catch (Throwable throwable) {
            String string = "Could not create handler: " + clazz;
            Log.logError(string, throwable);
            Log.assertion(false, string);
        }
        return abstractHandler;
    }

    AbstractController createController(Class clazz) {
        AbstractController abstractController = null;
        try {
            abstractController = (AbstractController)clazz.newInstance();
            abstractController.init(this);
        }
        catch (Throwable throwable) {
            String string = "Could not create controller: " + clazz;
            Log.logError(string, throwable);
            Log.assertion(false, string);
        }
        return abstractController;
    }

    AbstractView createView(Class clazz) {
        AbstractView abstractView = null;
        try {
            abstractView = (AbstractView)clazz.newInstance();
            abstractView.init(this);
        }
        catch (Throwable throwable) {
            String string = "Could not create view: " + clazz;
            Log.logError(string, throwable);
            Log.assertion(false, string);
        }
        return abstractView;
    }

    void dispose() {
        if (this.sniffer != null) {
            this.sniffer.dispose();
            this.sniffer = null;
        }
        this.localeChangeListeners.clear();
        if (this.viewContainer != null) {
            Component component = this.viewContainer.getComponent();
            if (component instanceof RootPaneContainer) {
                JComponent jComponent = (JComponent)((RootPaneContainer)((Object)component)).getGlassPane();
                jComponent.removeMouseListener(disableMouseListener);
            }
            this.viewContainer.dispose();
            this.viewContainer = null;
        }
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = null;
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
        if (this.languageManager != null) {
            this.languageManager.dispose();
        }
        this.languageManager = null;
        disableMouseListener = null;
        this.helpManager = null;
        this.parentPresenter = null;
        this.application = null;
    }

    AbstractApplication getApplication() {
        return this.application;
    }

    Vector getChildPresenters() {
        return (Vector)this.childPresenters.clone();
    }

    Class getClassForName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            String string2 = "Could not create class: " + string;
            Log.logError(string2, throwable);
            Log.assertion(false, string2);
        }
        return clazz;
    }

    ComponentSniffer getComponentSniffer() {
        return this.sniffer;
    }

    AbstractController getController() {
        return this.controller;
    }

    Class getControllerClass() {
        return this.controllerClass;
    }

    Object getCreationParameter() {
        return this.creationParameter;
    }

    AbstractHelp getHelp() {
        return this.helpManager.getHelpHandler();
    }

    LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    Object getParameter(String string) {
        if (this.controller instanceof AbstractComponentController) {
            return null;
        }
        Object object = null;
        if (this.creationParameter instanceof JApplet) {
            object = ((JApplet)this.creationParameter).getParameter(string);
        } else {
            Object[][] objectArray = (Object[][])this.creationParameter;
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        if (string.equals((String)objectArray[i][0])) {
                            object = objectArray[i][1];
                            return object;
                        }
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        String string2 = "Parameter key not instance of java.lang.String";
                        Log.logError(string2, classCastException);
                        Log.assertion(false, string2);
                    }
                }
            }
        }
        return object;
    }

    AbstractPresenter getParentPresenter() {
        return this.parentPresenter;
    }

    AbstractPresenter getResourcePresenter() {
        if (this instanceof ComponentPresenter || this instanceof ApplicationPresenter) {
            return this;
        }
        AbstractPresenter abstractPresenter = this.getParentPresenter();
        while (!(abstractPresenter instanceof ComponentPresenter) && !(abstractPresenter instanceof ApplicationPresenter)) {
            abstractPresenter = abstractPresenter.getParentPresenter();
        }
        return abstractPresenter;
    }

    Resources getResources() {
        return this.getApplication();
    }

    String getStatus() {
        return this.status;
    }

    private String getString(String string, boolean bl) {
        String string2 = "";
        if (this.languageManager != null) {
            string2 = this.languageManager.getString(string, bl);
        }
        return string2;
    }

    String getTitle() {
        return this.title;
    }

    AbstractView getView() {
        return this.view;
    }

    Class getViewClass() {
        return this.viewClass;
    }

    ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    JFrame getJFrame() {
        return this.viewContainer instanceof JFrame ? (JFrame)((Object)this.viewContainer) : null;
    }

    private void init(AbstractPresenter abstractPresenter, AbstractApplication abstractApplication, Class clazz, Class clazz2, Object object) {
        this.parentPresenter = abstractPresenter;
        this.application = abstractApplication;
        this.viewClass = clazz;
        this.controllerClass = clazz2;
        this.creationParameter = object;
        if (object instanceof AbstractComponent) {
            ((ComponentPresenter)this).setComponent((AbstractComponent)object);
        }
        this.viewContainer = this.createViewContainer();
        this.view = this.createView(clazz);
        this.controller = this.createController(clazz2);
        this.sniffer = new ComponentSniffer(this);
        this.languageManager = (LanguageManager)this.createHandler(LanguageManager.class);
        this.sniffer.addComponentHandler(this.languageManager);
        String string = abstractApplication.getEnvironment().getProperty("gsl.help.helphandler.class");
        if (string != null && !string.equals("")) {
            this.helpManager = (HelpManager)this.createHandler(HelpManager.class);
            this.sniffer.addComponentHandler(this.helpManager);
        }
        this.init();
        if (!this.isDisposed) {
            this.sniffer.sniff();
            this.updateLocale(abstractApplication.getLocale());
            this.sniffer.updateLocale(abstractApplication.getLocale());
            this.updateLocaleTitleAndStatus(abstractApplication.getLocale());
        }
    }

    final void setIsDisposed(boolean bl) {
        this.isDisposed = bl;
    }

    final boolean isDisposed() {
        return this.isDisposed;
    }

    boolean isDefaultEnabling() {
        return false;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private boolean isModal() {
        return this instanceof DialogModalPresenter || this instanceof WizardModalPresenter;
    }

    boolean isVisible() {
        return this.visible;
    }

    void removeChildPresenter(AbstractPresenter abstractPresenter) {
        Log.trace("Child presenter removed (" + this.childPresenters.size() + ") " + abstractPresenter);
        Log.assertion(this.childPresenters.removeElement(abstractPresenter), "Could not remove child presenter: " + abstractPresenter);
    }

    private void removeDisabledComponent(Component component) {
        Log.assertion(disabledComponents.remove(component), "Disabled component could not be removed: " + component);
    }

    void removeLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        for (int i = 0; i < this.localeChangeListeners.size(); ++i) {
            if (localeChangeListener != this.localeChangeListeners.elementAt(i)) continue;
            this.localeChangeListeners.remove(i);
            return;
        }
    }

    void setController(AbstractController abstractController) {
        this.controller = abstractController;
    }

    void setEnabled(boolean bl, boolean bl2) {
        if (this.enabled != bl) {
            this.enabled = bl;
            if (this.isDefaultEnabling()) {
                this.setEnabledDefault(bl);
            } else {
                this.setEnabledCustom(bl);
            }
        }
        if (bl2) {
            Enumeration enumeration = this.childPresenters.elements();
            while (enumeration.hasMoreElements()) {
                ((AbstractPresenter)enumeration.nextElement()).setEnabled(bl, true);
            }
        }
    }

    void setEnabledDefault(boolean bl) {
        if (!bl) {
            this.setCursor(Application.WAIT_CURSOR, false);
        }
        if (this.viewContainer != null) {
            this.viewContainer.setEnabled(bl);
        }
        if (bl) {
            this.setCursor(Application.DEFAULT_CURSOR, false);
        }
    }

    void setEnabledCustom(boolean bl) {
        if (!bl) {
            this.setCursor(Application.WAIT_CURSOR, false);
        }
        if (this.viewContainer != null) {
            Component component = this.viewContainer.getComponent();
            if (component instanceof RootPaneContainer) {
                JComponent jComponent = (JComponent)((RootPaneContainer)((Object)component)).getGlassPane();
                if (bl) {
                    this.removeDisabledComponent(component);
                    jComponent.removeMouseListener(disableMouseListener);
                } else {
                    this.addDisabledComponent(component);
                    jComponent.addMouseListener(disableMouseListener);
                }
                jComponent.setVisible(!bl);
            } else if (component != null) {
                component.setEnabled(bl);
            }
        }
        if (bl) {
            this.setCursor(Application.DEFAULT_CURSOR, false);
        }
    }

    void setCursor(Cursor cursor, boolean bl) {
        if (this.viewContainer != null) {
            this.viewContainer.getComponent().setCursor(cursor);
        }
        if (bl) {
            Enumeration enumeration = this.childPresenters.elements();
            while (enumeration.hasMoreElements()) {
                ((AbstractPresenter)enumeration.nextElement()).setCursor(cursor, true);
            }
        }
    }

    void setStatus(String string) {
        this.statusKey = null;
        this.statusArgs = null;
        this.status = string != null && !string.equals("") ? string : "";
        if (this.viewContainer != null) {
            this.viewContainer.setStatus(this.status);
        }
    }

    void setStatus(String string, Object[] objectArray) {
        this.statusKey = string;
        this.statusArgs = objectArray;
        if (string != null && !string.equals("")) {
            this.status = this.getString(string, true);
            if (objectArray != null) {
                this.status = MessageFormat.format(this.status, objectArray);
            }
        } else {
            this.status = "";
        }
        if (this.viewContainer != null) {
            this.viewContainer.setStatus(this.status);
        }
    }

    void setTitle() {
        String string;
        BemLaunchable bemLaunchable;
        if (this.application != null && (bemLaunchable = this.application.getBemLaunchable()) != null && (string = bemLaunchable.getWindowsTitle()) != null) {
            this.setTitleNoTranslation(string);
            return;
        }
    }

    void setTitle(String string, Object[] objectArray) {
        this.titleKey = string;
        this.titleArgs = objectArray;
        if (string != null && !string.equals("")) {
            this.title = this.getString(string, true);
            if (objectArray != null) {
                this.title = MessageFormat.format(this.title, objectArray);
            }
        } else {
            this.title = "";
        }
        if (this.viewContainer != null) {
            this.viewContainer.setTitle(prefix + this.title);
        }
    }

    void setTitleNoTranslation(Object object) {
        String string = this.title = object == null ? "" : object.toString();
        if (this.viewContainer != null) {
            this.viewContainer.setTitle(prefix + this.title);
        }
    }

    public void setPrefix(Object object) {
        prefix = object.toString() + " - ";
        if (this.viewContainer != null) {
            this.viewContainer.setTitle(prefix + this.title);
        }
    }

    void setVisible(boolean bl, boolean bl2) {
        this.beenVisible = bl2;
        this.setVisible(bl);
    }

    void setVisible(boolean bl) {
        this.visible = bl;
        if (!this.beenVisible && bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractPresenter.this.controller.beforeVisible();
                }
            });
            if (this.isDisposed()) {
                return;
            }
        }
        if (this.viewContainer != null) {
            this.viewContainer.setVisible(bl);
        }
        if (!this.isModal() && !this.beenVisible && bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractPresenter.this.controller.afterVisible();
                }
            });
            if (this.isDisposed()) {
                return;
            }
        }
        if (!this.beenVisible && bl) {
            this.beenVisible = true;
        }
        Enumeration enumeration = this.childPresenters.elements();
        while (enumeration.hasMoreElements()) {
            AbstractPresenter abstractPresenter = (AbstractPresenter)enumeration.nextElement();
            abstractPresenter.setVisible(bl);
        }
    }

    void bringToFront() {
        if (this.viewContainer != null) {
            this.viewContainer.bringToFront();
        }
    }

    void setView(AbstractView abstractView) {
        this.view = abstractView;
    }

    void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
    }

    synchronized void stop() {
        if (this.parentPresenter != null) {
            this.parentPresenter.stopChildPresenter(this);
        } else if (this.canStop()) {
            this.stopNoCheck();
        }
    }

    synchronized void stopNoCheck() {
        if (this.parentPresenter != null) {
            this.parentPresenter.stopChildPresenterNoCheck(this);
        } else {
            this.stopThisNoCheck();
        }
    }

    synchronized void stopChildPresenter(AbstractPresenter abstractPresenter) {
        if (abstractPresenter.canStop()) {
            this.stopChildPresenterNoCheck(abstractPresenter);
        }
    }

    synchronized void stopChildPresenterNoCheck(AbstractPresenter abstractPresenter) {
        this.removeChildPresenter(abstractPresenter);
        abstractPresenter.setVisible(false);
        abstractPresenter.stopThisNoCheck();
        abstractPresenter.dispose();
    }

    private void stopThisNoCheck() {
        Enumeration enumeration = ((Vector)this.childPresenters.clone()).elements();
        while (enumeration.hasMoreElements()) {
            this.stopChildPresenterNoCheck((AbstractPresenter)enumeration.nextElement());
        }
        if (this.controller != null) {
            this.controller.stop();
        }
    }

    private void updateChildPresenters(Locale locale) {
        Enumeration enumeration = this.childPresenters.elements();
        while (enumeration.hasMoreElements()) {
            ((AbstractPresenter)enumeration.nextElement()).updateLocale(locale);
        }
    }

    private void updateLocaleListeners(Locale locale) {
        for (int i = 0; i < this.localeChangeListeners.size(); ++i) {
            ((LocaleChangeListener)this.localeChangeListeners.elementAt(i)).updateLocale(locale);
        }
    }

    void updateLocale(Locale locale) {
        this.sniffer.updateLocale(locale);
        this.updateLocaleTitleAndStatus(locale);
        this.updateLocaleListeners(locale);
        this.updateChildPresenters(locale);
        if (this.viewContainer != null) {
            this.viewContainer.doValidate();
        }
    }

    private void updateLocaleTitleAndStatus(Locale locale) {
        this.setTitle(this.titleKey, this.titleArgs);
        this.setStatus(this.statusKey, this.statusArgs);
    }

    protected void updateTitle() {
        Log.trace("Updating title...");
        this.setTitle(this.titleKey, this.titleArgs);
        Enumeration enumeration = this.childPresenters.elements();
        while (enumeration.hasMoreElements()) {
            ((AbstractPresenter)enumeration.nextElement()).updateTitle();
        }
    }

    void updateLookAndFeel() {
        if (this.viewContainer != null) {
            ComponentToolkit.updateLookAndFeel(this.viewContainer.getComponent());
        }
        Enumeration enumeration = this.childPresenters.elements();
        while (enumeration.hasMoreElements()) {
            ((AbstractPresenter)enumeration.nextElement()).updateLookAndFeel();
        }
    }

    public void sniff(Component component) {
        this.sniffer.sniff(component);
    }

    private static class DisableMouseListener
    implements MouseListener {
        private DisableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Toolkit.getDefaultToolkit().beep();
            mouseEvent.consume();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }
    }
}

