/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessAutoConfigMoImpl;
import se.ericsson.cello.iptransport.IpAccessHostMoEnum;
import se.ericsson.cello.iptransport.IpAccessHostSpbMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMoImpl;
import se.ericsson.cello.iptransport.IpValidator;
import se.ericsson.cello.iptransport.SpmBuildIF;
import se.ericsson.cello.iptransport.ipadm_gpbhostmi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessHostSpbMoImpl
extends CelloMao
implements IpAccessHostSpbMo {
    private MoData data;
    private FroProxy genIpacHostSpbProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipadm_gpbhostmi.class.getName()));
    private static final int MAX_NUMBER_OF_HOSTS = 128;
    protected static final String PIU_FRO_ID = "piuFroId";
    protected static final String DH_FRO_ID = "dhFroId";
    protected static final String AUTOCONFIG_FRO_ID = "autoConfigFroId";
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static Class[] ipInterfaceClassName = new Class[]{IpInterfaceMo.class};
    private static final int MO_DATA_REVISION_51 = 5001;
    private static final int MO_DATA_REVISION_LATEST = 5001;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpAccessHostSpb", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkCardinality((String)"IpAccessHostSpb", (int)128);
        IpValidator.checkCombinedHostCardinality(managedObject, "IpAccessHostSpb");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAccessHostSpb", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"IpAccessHostSpb");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"autoConfig", (AttrList)attrList, (boolean)false, (int)2, (int)1, (int)2, (String)"IpAccessHostSpb");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipInterface", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClassName, (String)"IpAccessHostSpb");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"spmId", (AttrList)attrList, (boolean)true, (Class[])new Class[]{SpmBuildIF.class, PiuDeviceMo.class}, (String)"IpAccessHostSpb");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ipDefaultTtl", (AttrList)attrList, (boolean)false, (int)64, (int)1, (int)255, (String)"IpAccessHostSpb");
        int n4 = IpAccessHostSpbMoImpl.checkAndGetIpReassemblyTimeout(attrList);
        ManagedObject managedObject5 = null;
        String string3 = "0.0.0.0";
        ManagedObject managedObject6 = null;
        String string4 = "0.0.0.0";
        boolean bl = false;
        if (n2 == 1) {
            managedObject5 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"autoConfigIdentity", (AttrList)attrList, (boolean)true, (String[])IpAccessHostMoEnum.ipAutoConfigClassName, (String)"IpAccessHostSpb");
            managedObject6 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"autoConfigIdentity2", (AttrList)attrList, (boolean)false, (String[])IpAccessHostMoEnum.ipAutoConfigClassName, (String)"IpAccessHostSpb");
            if (managedObject6 != null) {
                bl = true;
            }
            string3 = "";
            string4 = "";
        } else if (n2 == 2) {
            string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress", (AttrList)attrList, (boolean)true, (String)"0.0.0.0", (String)"IpAccessHostSpb");
            new IpAddress(string3);
            int n5 = 0;
            n5 = ((IpInterfaceMo)managedObject3).getNetworkPrefixLength(coordinator);
            new HostIpAddress(string3, n5);
            string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress2", (AttrList)attrList, (boolean)false, (String)"0.0.0.0", (String)"IpAccessHostSpb");
            if (string3.equals(string4)) {
                throw new ValueOutOfRangeException("Attributes ipAddress1 and ipAddress2 may not be the same", "IpAccessHostSpb");
            }
            if (!string4.equals("0.0.0.0")) {
                bl = true;
                new IpAddress(string4);
            }
        }
        ManagedObject managedObject7 = null;
        if (bl) {
            managedObject7 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"interface2", (AttrList)attrList, (boolean)true, (Class[])ipInterfaceClassName, (String)"IpAccessHostSpb");
            if (managedObject7 != null) {
                IpValidator.checkInterfacesNotSameInstance(managedObject3, managedObject7);
            }
            int n6 = 0;
            if (n2 == 2) {
                n6 = ((IpInterfaceMo)managedObject3).getNetworkPrefixLength(coordinator);
                new HostIpAddress(string4, n6);
            }
        }
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAccessHostSpb");
        return new IpAccessHostSpbMoImpl(managedObject, string, string2, n, n2, managedObject5, managedObject6, managedObject4, string3, bl, string4, managedObject3, managedObject7, n3, n4, coordinator, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    private static int checkAndGetIpReassemblyTimeout(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("ipReasmTimeout");
        if (n != -1) {
            if (attrList.contains(new String[]{"reassemblyTimeout"})) {
                throw new ConfigurationMismatchException("Both ipReasmTimeout and reassemblyTimeout supplied ", "IpAccessHostSpb", "ipReasmTimeout");
            }
            return 1000 * MoAttributeValidator.checkAndGetIntegerAttribute((String)"ipReasmTimeout", (AttrList)attrList, (boolean)false, (int)60, (int)0, (int)Integer.MAX_VALUE, (String)"IpAccessHostSpb");
        }
        return MoAttributeValidator.checkAndGetIntegerAttribute((String)"reassemblyTimeout", (AttrList)attrList, (boolean)false, (int)60000, (int)1, (int)120000, (String)"IpAccessHostSpb");
    }

    private IpAccessHostSpbMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, String string3, boolean bl, String string4, ManagedObject managedObject5, ManagedObject managedObject6, int n3, int n4, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpAccessHostSpb", string, coordinator);
        this.genIpacHostSpbProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        if (managedObject2 != null) {
            ((IpAccessAutoConfigMoImpl)managedObject2).reserve(this, coordinator);
        }
        if (managedObject3 != null) {
            ((IpAccessAutoConfigMoImpl)managedObject3).reserve(this, coordinator);
        }
        ((Reservable)managedObject5).reserve((ManagedObject)this, coordinator);
        if (managedObject6 != null) {
            ((Reservable)managedObject6).reserve((ManagedObject)this, coordinator);
        }
        int n5 = 0;
        int n6 = 0;
        if (managedObject4 instanceof PiuDeviceMo) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
            n5 = ((PiuDeviceMo)managedObject4).getFroId(coordinator);
            n6 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject4.getParent());
        } else {
            n5 = ((SpmBuildIF)managedObject4).getSpmInstanceId(coordinator);
            n6 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject4);
        }
        int n7 = this.createSpbFro(coordinator, n5, n6, n, n3, n4, n2, managedObject2, managedObject3, string3, string4, bl, managedObject5, managedObject6, initialMaoContext);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n7));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.setRevision(5001);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n7);
        ServiceLocatorFacade.getRepository().addService((Object)this, IpAccessHostSpbMo.class, coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAccessHostSpbMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genIpacHostSpbProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5001);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("froId");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
        ServiceLocatorFacade.getRepository().addService((Object)this, IpAccessHostSpbMo.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        ManagedObject managedObject2;
        ManagedObject managedObject3;
        ManagedObject managedObject4;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("IpAccessHostSpb");
        }
        int n = (Integer)this.getAttribute("administrativeState", coordinator);
        if (n != 0) {
            throw new MoCanNotBeDeletedException("Not possible to delete unlocked IpAccessHostSpb");
        }
        ManagedObject managedObject5 = (ManagedObject)this.getAttribute("spmId", coordinator);
        if (managedObject5 != null && managedObject5 instanceof PiuDeviceMo) {
            ((Reservable)managedObject5).release((ManagedObject)this, coordinator);
        }
        if ((managedObject4 = (ManagedObject)this.getAttribute("autoConfigIdentity", coordinator)) != null) {
            ((Reservable)managedObject4).release((ManagedObject)this, coordinator);
        }
        if ((managedObject3 = (ManagedObject)this.getAttribute("autoConfigIdentity2", coordinator)) != null) {
            ((Reservable)managedObject3).release((ManagedObject)this, coordinator);
        }
        if ((managedObject2 = (ManagedObject)this.getAttribute("ipInterface", coordinator)) != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
        }
        if ((managedObject = (ManagedObject)this.getAttribute("interface2", coordinator)) != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        ServiceLocatorFacade.getRepository().removeService((Object)this, IpAccessHostSpbMo.class, null);
        this.genIpacHostSpbProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getIpAccessHostSpbId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("IpAccessHostSpbId", coordinator);
    }

    public int getAutoConfig(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("autoConfig", coordinator);
    }

    public ManagedObject getAutoConfigIdentity(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("autoConfigIdentity", coordinator);
    }

    public ManagedObject getSpmId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("spmId", coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress", coordinator);
    }

    public void setIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress", string, coordinator);
    }

    public int getIpDefaultTtl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipDefaultTtl", coordinator);
    }

    public void setIpDefaultTtl(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipDefaultTtl", new Integer(n), coordinator);
    }

    public int getIpReasmTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipReasmTimeout", coordinator);
    }

    public void setIpReasmTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipReasmTimeout", new Integer(n), coordinator);
    }

    public int getReassemblyTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("reassemblyTimeout", coordinator);
    }

    public void setReassemblyTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("reassemblyTimeout", new Integer(n), coordinator);
    }

    public int getPmIcmpInDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInDestUnreachs", coordinator);
    }

    public int getPmIcmpInEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchos", coordinator);
    }

    public int getPmIcmpInEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchoReps", coordinator);
    }

    public int getPmIcmpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInErrors", coordinator);
    }

    public int getPmIcmpInMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInMsgs", coordinator);
    }

    public int getPmIcmpInParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInParamProbs", coordinator);
    }

    public int getPmIcmpInRedirects(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInRedirects", coordinator);
    }

    public int getPmIcmpInSrcQuenchs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInSrcQuenchs", coordinator);
    }

    public int getPmIcmpInTimeExcds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInTimeExcds", coordinator);
    }

    public int getPmIcmpOutDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutDestUnreachs", coordinator);
    }

    public int getPmIcmpOutEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchos", coordinator);
    }

    public int getPmIcmpOutEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchoReps", coordinator);
    }

    public int getPmIcmpOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutErrors", coordinator);
    }

    public int getPmIcmpOutMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutMsgs", coordinator);
    }

    public int getPmIcmpOutParmProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutParmProbs", coordinator);
    }

    public int getPmIpFragFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragFails", coordinator);
    }

    public int getPmIpFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragCreates", coordinator);
    }

    public int getPmIpFragOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragOKs", coordinator);
    }

    public int getPmIpInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInAddrErrors", coordinator);
    }

    public int getPmIpInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDiscards", coordinator);
    }

    public int getPmIpInDelivers(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDelivers", coordinator);
    }

    public int getPmIpInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInHdrErrors", coordinator);
    }

    public int getPmIpInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInReceives", coordinator);
    }

    public int getPmIpInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInUnknownProtos", coordinator);
    }

    public int getPmIpOutRequests(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutRequests", coordinator);
    }

    public int getPmIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutDiscards", coordinator);
    }

    public int getPmIpReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmFails", coordinator);
    }

    public int getPmIpReasmOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOKs", coordinator);
    }

    public int getPmIpReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmReqds", coordinator);
    }

    public int getPmUdpInDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInDatagrams", coordinator);
    }

    public int getPmUdpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInErrors", coordinator);
    }

    public int getPmUdpNoPorts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpNoPorts", coordinator);
    }

    public int getPmUdpOutDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpOutDatagrams", coordinator);
    }

    public ManagedObject getAutoConfigIdentity2(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("autoConfigIdentity2", coordinator);
    }

    public ManagedObject getInterface2(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("interface2", coordinator);
    }

    public String getIpAddress2(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress2", coordinator);
    }

    public void setIpAddress2(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress2", string, coordinator);
    }

    public ManagedObject getIpInterface(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipInterface", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Map map = null;
        PmData pmData = null;
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            StructParameter structParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = this.getReservedBy(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoConfigIdentity")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface1");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(AUTOCONFIG_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessAutoConfig", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "autoConfigIdentity");
            }
            if (stringArray[i].equalsIgnoreCase("autoConfigIdentity2")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface2");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(AUTOCONFIG_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessAutoConfig", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "autoConfigIdentity2");
            }
            if (stringArray[i].equalsIgnoreCase("ipInterface")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface1");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpInterface", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "ipInterface");
            }
            if (stringArray[i].equalsIgnoreCase("interface2")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = null;
                structParameter = (StructParameter)map.get("interface2");
                if (structParameter == null || (signedIntParameter = (SignedIntParameter)structParameter.get(DH_FRO_ID)).getValue() == 0) continue;
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String)"IpInterface", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "interface2");
            }
            if (stringArray[i].equalsIgnoreCase("spmId")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (StructParameter)map.get("location");
                signedIntParameter = (SignedIntParameter)structParameter.get("spmId");
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String[])new String[]{"Spm", "PiuDevice"}, (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "spmId");
            }
            if (stringArray[i].equalsIgnoreCase("activeSpmId")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (StructParameter)map.get("activeLocation");
                signedIntParameter = (SignedIntParameter)structParameter.get("spmId");
                objectArray[i] = MaoFroTypeConverter.froId2MaoInstance((String[])new String[]{"Spm", "PiuDevice"}, (int)signedIntParameter.getValue(), (Coordinator)coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostSpb", "activeSpmId");
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoConfig")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("autoConfig");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                structParameter = (StructParameter)(map = this.getAttrFromRes(map, coordinator)).get("interface1");
                if (structParameter != null) {
                    signedIntParameter = (StringParameter)structParameter.get("ipAddress1");
                    objectArray[i] = signedIntParameter.getValue();
                    continue;
                }
                objectArray[i] = "0.0.0.0";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress2")) {
                structParameter = (StructParameter)(map = this.getAttrFromRes(map, coordinator)).get("interface2");
                if (structParameter != null) {
                    signedIntParameter = (StringParameter)structParameter.get("ipAddress2");
                    objectArray[i] = signedIntParameter.getValue();
                    continue;
                }
                objectArray[i] = "0.0.0.0";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("ipDefaultTtl");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipReasmTimeout")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("reassemblyTimeout");
                objectArray[i] = new Integer(structParameter.getValue() / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reassemblyTimeout")) {
                map = this.getAttrFromRes(map, coordinator);
                structParameter = (SignedIntParameter)map.get("reassemblyTimeout");
                objectArray[i] = new Integer(structParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInReceives")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInReceives"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInHdrErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInHdrErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInAddrErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInAddrErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInUnknownProtos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInUnknownProtos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDiscards")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDelivers")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpInDelivers"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutRequests")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpOutRequests"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutDiscards")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpOutDiscards"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmReqds")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmReqds"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmOKs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmOKs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmFails")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpReasmFails"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragOKs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragOKs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragFails")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragFails"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragCreates")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIpFragCreates"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInMsgs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInMsgs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInDestUnreachs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInDestUnreachs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInTimeExcds")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInTimeExcds"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInParamProbs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInParamProbs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInSrcQuenchs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInSrcQuenchs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInRedirects")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInRedirects"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInEchos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchoReps")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpInEchoReps"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutMsgs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutMsgs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutDestUnreachs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutDestUnreachs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutParmProbs")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutParmProbs"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchos")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutEchos"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchoReps")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmIcmpOutEchoReps"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInDatagrams")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpInDatagrams"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpNoPorts")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpNoPorts"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInErrors")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpInErrors"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpOutDatagrams")) {
                pmData = this.getPmFromRes(pmData, coordinator);
                objectArray[i] = new Integer(pmData.getValue("pmUdpOutDatagrams"));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostSpb");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private PmData getPmFromRes(PmData pmData, Coordinator coordinator) throws MoAccessException {
        if (pmData == null) {
            return this.getPmAttributes(coordinator);
        }
        return pmData;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            ManagedObject managedObject;
            Integer n3;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostSpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpAccessHostSpb");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpAccessHostSpb", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostSpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "IpAccessHostSpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"IpAccessHostSpb");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostSpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ipDefaultTtl", "IpAccessHostSpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ipDefaultTtl", (int)n, (int)1, (int)255, (String)"IpAccessHostSpb");
                arrayList.add(new SignedIntParameter("ipDefaultTtl", n));
                this.sendNotification("ipDefaultTtl", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipReasmTimeout")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostSpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ipReasmTimeout", "IpAccessHostSpb");
                }
                n = (Integer)objectArray[i];
                if (n < 0) {
                    throw new ValueOutOfRangeException("ipReasmTimeout", "IpAccessHostGpb");
                }
                arrayList.add(new SignedIntParameter("reassemblyTimeout", n * 1000));
                this.sendNotification("ipReasmTimeout", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reassemblyTimeout")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostSpbMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("reassemblyTimeout", "IpAccessHostSpb");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"reassemblyTimeout", (int)n, (int)1, (int)120000, (String)"IpAccessHostSpb");
                arrayList.add(new SignedIntParameter("reassemblyTimeout", n));
                this.sendNotification("reassemblyTimeout", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                if (this.getAdministrativeState(coordinator) != 0) {
                    throw new FroNotLockedException("IpAccessHostSpb", "AdministrativeState need to be locked when setting ip address");
                }
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostSpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ipAddress", "IpAccessHostSpb");
                }
                string = (String)objectArray[i];
                n3 = (Integer)this.getAttribute("autoConfig", coordinator);
                if (n3 != 2) {
                    throw new OperationNotAllowedException("ipAddress can not be set if autoConfig is configured", "IpAccessHostSpb");
                }
                managedObject = (ManagedObject)this.getAttribute("ipInterface", coordinator);
                if (managedObject == null) {
                    throw new OperationNotAllowedException("ipAddress can not be set if ipInterface is not configured", "IpAccessHostSpb");
                }
                n2 = 0;
                n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
                new HostIpAddress(string, n2);
                arrayList.add(new StringParameter("ipAddress1", string, 15));
                IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostSpb", coordinator);
                this.sendNotification("ipAddress", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress2")) {
                if (this.getAdministrativeState(coordinator) != 0) {
                    throw new FroNotLockedException("IpAccessHostSpb", "AdministrativeState need to be locked when setting ip address");
                }
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostSpbMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ipAddress2", "IpAccessHostSpb");
                }
                string = (String)objectArray[i];
                n3 = (Integer)this.getAttribute("autoConfig", coordinator);
                if (n3 != 2) {
                    throw new OperationNotAllowedException("ipAddress2 can not be set if autoConfig is configured ", "IpAccessHostSpb");
                }
                managedObject = (ManagedObject)this.getAttribute("interface2", coordinator);
                if (managedObject == null) {
                    throw new OperationNotAllowedException("ipAddress2 can not be set if interface2 is not configured", "IpAccessHostSpb");
                }
                n2 = 0;
                n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
                new HostIpAddress(string, n2);
                arrayList.add(new StringParameter("ipAddress2", string, 15));
                IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostSpb", coordinator);
                this.sendNotification("ipAddress2", string, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostSpb");
        }
        if (arrayList.size() > 0) {
            this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private int createSpbFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5, int n6, ManagedObject managedObject, ManagedObject managedObject2, String string, String string2, boolean bl, ManagedObject managedObject3, ManagedObject managedObject4, InitialMaoContext initialMaoContext) throws MoAccessException {
        StringParameter stringParameter;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StructParameter structParameter = new StructParameter("location");
        structParameter.add((Parameter)new SignedIntParameter(PIU_FRO_ID, n2));
        structParameter.add((Parameter)new SignedIntParameter("spmId", n));
        arrayList.add(structParameter);
        arrayList.add(new SignedIntParameter("administrativeState", n3));
        arrayList.add(new SignedIntParameter("ipDefaultTtl", n4));
        arrayList.add(new SignedIntParameter("reassemblyTimeout", n5));
        arrayList.add(new SignedIntParameter("autoConfig", n6));
        arrayList.add(this.createStructParameter("interface1", n6, managedObject, string, managedObject3, coordinator));
        if (bl) {
            arrayList.add(this.createStructParameter("interface2", n6, managedObject2, string2, managedObject4, coordinator));
        }
        FroData froData = this.genIpacHostSpbProxy.create(coordinator, arrayList);
        Map map = froData.getParameters();
        StructParameter structParameter2 = (StructParameter)map.get("interface1");
        StringParameter stringParameter2 = (StringParameter)structParameter2.get("ipAddress1");
        IpValidator.validateAddressTowardsInterface(stringParameter2.getValue(), managedObject3, "IpAccessHostSpb", coordinator);
        StructParameter structParameter3 = (StructParameter)map.get("interface2");
        if (structParameter3 != null && !(stringParameter = (StringParameter)structParameter3.get("ipAddress2")).getValue().equals("0.0.0.0")) {
            IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject4, "IpAccessHostSpb", coordinator);
        }
        return froData.getFroId();
    }

    private StructParameter createStructParameter(String string, int n, ManagedObject managedObject, String string2, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = new StructParameter(string);
        int n2 = 0;
        if (managedObject != null) {
            n2 = ((IpAccessAutoConfigMoImpl)managedObject).getFroId(coordinator);
        }
        structParameter.add((Parameter)new SignedIntParameter(AUTOCONFIG_FRO_ID, n2));
        if (string.equals("interface1")) {
            structParameter.add((Parameter)new StringParameter("ipAddress1", string2, 15));
        } else {
            structParameter.add((Parameter)new StringParameter("ipAddress2", string2, 15));
        }
        IpInterfaceMoImpl ipInterfaceMoImpl = (IpInterfaceMoImpl)managedObject2;
        structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, ipInterfaceMoImpl.getFroId(coordinator)));
        return structParameter;
    }

    private StructParameter createStructParameter(String string, ManagedObject managedObject, String string2, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = new StructParameter(string);
        int n = 0;
        if (managedObject != null) {
            n = ((IpAccessAutoConfigMoImpl)managedObject).getFroId(coordinator);
        }
        structParameter.add((Parameter)new SignedIntParameter(AUTOCONFIG_FRO_ID, n));
        if (string.equals("interface1")) {
            structParameter.add((Parameter)new StringParameter("ipAddress1", string2, 15));
        } else {
            structParameter.add((Parameter)new StringParameter("ipAddress2", string2, 15));
        }
        int n2 = 0;
        if (managedObject2 != null) {
            n2 = ((IpInterfaceMoImpl)managedObject2).getFroId(coordinator);
        }
        structParameter.add((Parameter)new SignedIntParameter(DH_FRO_ID, n2));
        return structParameter;
    }

    public void actionRemoveInterface1(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.releaseAutoConfigId("autoConfigIdentity2", "autoConfigIdentity", coordinator);
        ManagedObject managedObject = (ManagedObject)this.getAttribute("ipInterface", coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        StructParameter structParameter = this.createStructParameter("interface1", null, "0.0.0.0", null, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionRemoveInterface2(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.releaseAutoConfigId("autoConfigIdentity", "autoConfigIdentity2", coordinator);
        ManagedObject managedObject = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        StructParameter structParameter = this.createStructParameter("interface2", null, "0.0.0.0", null, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private void releaseAutoConfigId(String string, String string2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)this.getAttribute(string, coordinator);
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute(string2, coordinator);
        if (managedObject2 != null) {
            if (managedObject != null) {
                if (!managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
                    ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
                }
            } else {
                ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
            }
        }
    }

    public void actionAddInterface1AutoConfigOff(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipInterface");
        }
        if (string == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipAddress1");
        }
        if (!managedObject.getType().equals("IpInterface")) {
            throw new WrongAttributeTypeException("ipInterface", "IpAccessHostSpb");
        }
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("ipInterface", coordinator);
        if (managedObject2 != null) {
            throw new OperationNotAllowedException("ipInterface must be removed before a new can be added ", "IpAccessHostSpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject3 != null) {
            IpValidator.checkInterfacesNotSameInstance(managedObject, managedObject3);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 2 && managedObject3 != null) {
            throw new OperationNotAllowedException("ipInterface with autoConfig off can not be set when autoConfig is on and an interface2 exists ", "IpAccessHostSpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        int n2 = 0;
        n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
        new HostIpAddress(string, n2);
        IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostSpb", coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface1", null, string, managedObject, coordinator));
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionAddInterface2AutoConfigOff(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface2");
        }
        if (string == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipAddress2");
        }
        if (!managedObject.getType().equals("IpInterface")) {
            throw new WrongAttributeTypeException("interface2", "IpAccessHostSpb");
        }
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject2 != null) {
            throw new OperationNotAllowedException("interface2 must be removed before a new can be added ", "IpAccessHostSpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("ipInterface", coordinator);
        if (managedObject3 != null) {
            IpValidator.checkInterfacesNotSameInstance(managedObject3, managedObject);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 2 && managedObject3 != null) {
            throw new OperationNotAllowedException("interface2 with autoConfig off can not be set when autoConfig is on and an ipInterface exists ", "IpAccessHostSpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        int n2 = 0;
        n2 = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
        new HostIpAddress(string, n2);
        IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostSpb", coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface2", null, string, managedObject, coordinator));
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void actionAddInterface1AutoConfigOn(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "ipInterface");
        }
        if (managedObject2 == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "autoConfigIdentity");
        }
        if (!managedObject.getType().equals("IpInterface")) {
            throw new WrongAttributeTypeException("ipInterface", "IpAccessHostSpb");
        }
        if (!managedObject2.getType().equals("IpAccessAutoConfig")) {
            throw new WrongAttributeTypeException("autoConfigIdentity", "IpAccessHostSpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("ipInterface", coordinator);
        if (managedObject3 != null) {
            throw new OperationNotAllowedException("ipInterface must be removed before a new can be added ", "IpAccessHostSpb");
        }
        ManagedObject managedObject4 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject4 != null) {
            IpValidator.checkInterfacesNotSameInstance(managedObject, managedObject4);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 1 && managedObject4 != null) {
            throw new OperationNotAllowedException("ipInterface with autoConfig on can not be set when autoConfig is off and an interface2 exists ", "IpAccessHostSpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface1", managedObject2, "0.0.0.0", managedObject, coordinator));
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        Map map = this.genIpacHostSpbProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        StructParameter structParameter = (StructParameter)map.get("interface1");
        StringParameter stringParameter = (StringParameter)structParameter.get("ipAddress1");
        IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject, "IpAccessHostSpb", coordinator);
    }

    public void actionAddInterface2AutoConfigOn(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Integer n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "interface2");
        }
        if (managedObject2 == null) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "autoConfigIdentity2");
        }
        if (!managedObject.getType().equals("IpInterface")) {
            throw new WrongAttributeTypeException("interface2", "IpAccessHostSpb");
        }
        if (!managedObject2.getType().equals("IpAccessAutoConfig")) {
            throw new WrongAttributeTypeException("autoConfigIdentity2", "IpAccessHostSpb");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("interface2", coordinator);
        if (managedObject3 != null) {
            throw new OperationNotAllowedException("interface2 must be removed before a new can be added ", "IpAccessHostSpb");
        }
        ManagedObject managedObject4 = (ManagedObject)this.getAttribute("ipInterface", coordinator);
        if (managedObject4 != null) {
            IpValidator.checkInterfacesNotSameInstance(managedObject4, managedObject);
        }
        if ((n = (Integer)this.getAttribute("autoConfig", coordinator)) != 1 && managedObject4 != null) {
            throw new OperationNotAllowedException("interface2 with autoConfig on can not be set when autoConfig is off and an ipInterface exists ", "IpAccessHostSpb");
        }
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(this.createStructParameter("interface2", managedObject2, "0.0.0.0", managedObject, coordinator));
        this.genIpacHostSpbProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        Map map = this.genIpacHostSpbProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        StructParameter structParameter = (StructParameter)map.get("interface2");
        StringParameter stringParameter = (StringParameter)structParameter.get("ipAddress2");
        IpValidator.validateAddressTowardsInterface(stringParameter.getValue(), managedObject, "IpAccessHostSpb", coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genIpacHostSpbProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private PmData getPmAttributes(Coordinator coordinator) throws MoAccessException {
        PmData pmData = this.genIpacHostSpbProxy.getPmAttributes(coordinator, this.getFroId(coordinator));
        return pmData;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public ManagedObject getActiveSpmId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeSpmId", coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            if (signedIntParameter != null) {
                this.sendNotification("administrativeState", new Integer(signedIntParameter.getValue()), null);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not in property file");
        }
    }

    public String getType() {
        return "IpAccessHostSpb";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }
}

