/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Hashtable;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.InternalEthernetPortMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.IpSystemMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VlanBuildIF;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class VlanInfo {
    private int vid = 1;
    private boolean hasVid = false;
    private boolean vlan = false;
    private boolean hasVlan = false;
    private ManagedObject vlanRef = null;
    private boolean hasVlanRef = false;
    private ManagedObject ipInterfaceMo = null;
    private ManagedObject parent = null;
    private String IP_VID = "vid";
    private String IP_VLAN = "vLan";
    private String IP_VLAN_REF = "vlanRef";
    private String typeName = " ";
    private static final int VID_MIN = 0;
    private static final int VID_DEFAULT = 1;
    private static final int VID_MAX = 4094;
    private static final int VID_MIN_VLANID = 1;
    private static final boolean V_LAN_DEFAULT = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public VlanInfo(AttrList attrList, ManagedObject managedObject, ManagedObject managedObject2) {
        if (managedObject instanceof IpSystemMo) {
            this.ipInterfaceMo = (Ipv6InterfaceMo)managedObject2;
            this.parent = managedObject;
            this.IP_VID = "vid";
            this.IP_VLAN = "vLan";
            this.IP_VLAN_REF = "vlanRef";
            this.typeName = "Ipv6Interface";
        } else {
            this.ipInterfaceMo = (IpInterfaceMo)managedObject2;
            this.parent = managedObject;
            this.IP_VID = "vid";
            this.IP_VLAN = "vLan";
            this.IP_VLAN_REF = "vlanRef";
            this.typeName = "IpInterface";
        }
        this.hasVid = VlanInfo.hasAttr(this.IP_VID, attrList);
        this.hasVlan = VlanInfo.hasAttr(this.IP_VLAN, attrList);
        this.hasVlanRef = VlanInfo.hasAttr(this.IP_VLAN_REF, attrList);
    }

    public VlanInfo(String[] stringArray, Object[] objectArray, ManagedObject managedObject) throws WrongAttributeTypeException {
        if (managedObject instanceof IpInterfaceMo) {
            this.ipInterfaceMo = (IpInterfaceMo)managedObject;
            this.parent = managedObject.getParent();
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            this.ipInterfaceMo = (Ipv6InterfaceMo)managedObject;
            this.parent = managedObject.getParent();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(this.IP_VID)) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? VlanInfo.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException(this.IP_VID, this.typeName);
                }
                this.hasVid = true;
                this.vid = (Integer)objectArray[i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.IP_VLAN)) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? VlanInfo.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException(this.IP_VLAN, this.typeName);
                }
                this.hasVlan = true;
                this.vlan = (Boolean)objectArray[i];
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase(this.IP_VLAN_REF)) continue;
            if (null != objectArray[i] && !(objectArray[i] instanceof VlanBuildIF)) {
                throw new WrongAttributeTypeException(this.IP_VLAN_REF, this.typeName);
            }
            this.hasVlanRef = true;
            this.vlanRef = (ManagedObject)objectArray[i];
        }
    }

    public void setAttrCheck(Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        if (!(this.hasVid || this.hasVlan || this.hasVlanRef)) {
            return;
        }
        if (!this.hasVlanRef) {
            this.vlanRef = this.getVlanRef(this.ipInterfaceMo, coordinator);
        }
        if (this.isBackplane(coordinator)) {
            if (null != this.vlanRef && this.hasVlan && this.vlan) {
                throw new OperationNotAllowedException(this.IP_VLAN + " Unexpected value for vlan while configuring backplane ports", this.typeName);
            }
            if (this.hasVlanRef && null == this.vlanRef) {
                throw new OperationNotAllowedException(this.IP_VLAN_REF + " is mandatory when configuring backplane ports", this.typeName);
            }
        } else if (this.isFrontPorts(coordinator)) {
            if (this.hasVlanRef) {
                if (null != this.vlanRef) {
                    this.hasVid = true;
                    this.hasVlan = true;
                    this.vid = 1;
                    this.vlan = false;
                } else {
                    if (!this.hasVid) {
                        this.vid = this.getVid(this.ipInterfaceMo, coordinator);
                    }
                    if (!this.hasVlan) {
                        this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
                    }
                }
            } else if (null != this.getVlanRef(this.ipInterfaceMo, coordinator)) {
                if (this.hasVid) {
                    this.vid = 1;
                }
                if (this.hasVlan) {
                    this.vlan = false;
                }
            } else {
                if (!this.hasVid) {
                    this.vid = this.getVid(this.ipInterfaceMo, coordinator);
                }
                if (!this.hasVlan) {
                    this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
                }
            }
        } else if (this.isMFXBoard()) {
            this.NoAttributeAssert(this.hasVlanRef, this.IP_VLAN_REF, " is *NOT* applicable when configuring MFX board");
            if (!this.hasVid) {
                this.vid = this.getVid(this.ipInterfaceMo, coordinator);
            }
            if (!this.hasVlan) {
                this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
            }
        }
        MoAttributeValidator.checkIntegerAttribute((String)this.IP_VID, (int)this.vid, (int)0, (int)4094, (String)this.typeName);
    }

    public void creationCheck(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        if (this.isBackplane(coordinator)) {
            this.vlanRef = MoAttributeValidator.checkAndGetReferenceAttribute((String)this.IP_VLAN_REF, (AttrList)attrList, (boolean)true, (Class)VlanBuildIF.class, (String)"Vlan");
            this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
            if (null != this.vlanRef && this.vlan) {
                throw new OperationNotAllowedException(this.IP_VLAN + " cannot take *TRUE* when configuring backplane ports", this.typeName);
            }
        } else if (this.isFrontPorts(coordinator)) {
            this.vlanRef = MoAttributeValidator.checkAndGetReferenceAttribute((String)this.IP_VLAN_REF, (AttrList)attrList, (boolean)false, (Class)VlanBuildIF.class, (String)"Vlan");
            if (this.hasVlanRef && null != this.vlanRef) {
                this.vid = 1;
                this.vlan = false;
            } else {
                this.vid = MoAttributeValidator.checkAndGetIntegerAttribute((String)this.IP_VID, (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)4094, (String)this.typeName);
                this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
            }
        } else if (this.isMFXBoard()) {
            this.NoAttributeAssert(this.hasVlanRef, "vlanRef", " is *NOT* applicable when configuring MFX board");
            this.vid = MoAttributeValidator.checkAndGetIntegerAttribute((String)this.IP_VID, (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)4094, (String)this.typeName);
            this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
        }
    }

    public void sendAVC(Coordinator coordinator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Constable> arrayList2 = new ArrayList<Constable>();
        if (this.hasVid) {
            arrayList.add(this.IP_VID);
            arrayList2.add(new Integer(this.vid));
        }
        if (this.hasVlan) {
            arrayList.add(this.IP_VLAN);
            arrayList2.add(Boolean.valueOf(this.vlan));
        }
        if (this.hasVlanRef) {
            arrayList.add(this.IP_VLAN_REF);
            arrayList2.add((Constable)this.vlanRef);
        }
        NotificationSender.instance().pushAVC(this.ipInterfaceMo, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Object[arrayList2.size()]), coordinator);
    }

    public void creationCheck(ManagedObject managedObject, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        if (this.isBackplane(managedObject, coordinator)) {
            this.vlanRef = MoAttributeValidator.checkAndGetReferenceAttribute((String)this.IP_VLAN_REF, (AttrList)attrList, (boolean)true, (Class)VlanBuildIF.class, (String)"Vlan");
            this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
            if (null != this.vlanRef && this.vlan) {
                throw new OperationNotAllowedException(this.IP_VLAN + " cannot take *TRUE* when configuring backplane ports", this.typeName);
            }
        } else if (this.isFrontPorts(managedObject, coordinator)) {
            this.vlanRef = MoAttributeValidator.checkAndGetReferenceAttribute((String)this.IP_VLAN_REF, (AttrList)attrList, (boolean)false, (Class)VlanBuildIF.class, (String)"Vlan");
            if (this.hasVlanRef && null != this.vlanRef) {
                this.vid = 1;
                this.vlan = false;
            } else {
                this.vid = MoAttributeValidator.checkAndGetIntegerAttribute((String)this.IP_VID, (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)4094, (String)this.typeName);
                this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
            }
        } else if (this.isMFXBoard()) {
            this.NoAttributeAssert(this.hasVlanRef, "vlanRef", " is *NOT* applicable when configuring MFX board");
            this.vid = MoAttributeValidator.checkAndGetIntegerAttribute((String)this.IP_VID, (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)4094, (String)this.typeName);
            this.vlan = MoAttributeValidator.checkAndGetBooleanAttribute((String)this.IP_VLAN, (AttrList)attrList, (boolean)false, (boolean)false, (String)this.typeName);
        }
    }

    public void setAttrCheck(ManagedObject managedObject, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        if (!(this.hasVid || this.hasVlan || this.hasVlanRef)) {
            return;
        }
        if (!this.hasVlanRef) {
            this.vlanRef = this.getVlanRef(this.ipInterfaceMo, coordinator);
        }
        if (this.isBackplane(managedObject, coordinator)) {
            if (null != this.vlanRef && this.hasVlan && this.vlan) {
                throw new OperationNotAllowedException(this.IP_VLAN + " Unexpected value for vlan while configuring backplane ports", this.typeName);
            }
            if (this.hasVlanRef && null == this.vlanRef) {
                throw new OperationNotAllowedException(this.IP_VLAN_REF + " is mandatory when configuring backplane ports", this.typeName);
            }
        } else if (this.isFrontPorts(managedObject, coordinator)) {
            if (this.hasVlanRef) {
                if (null != this.vlanRef) {
                    this.hasVid = true;
                    this.hasVlan = true;
                    this.vid = 1;
                    this.vlan = false;
                } else {
                    if (!this.hasVid) {
                        this.vid = this.getVid(this.ipInterfaceMo, coordinator);
                    }
                    if (!this.hasVlan) {
                        this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
                    }
                }
            } else if (null != this.getVlanRef(this.ipInterfaceMo, coordinator)) {
                if (this.hasVid) {
                    this.vid = 1;
                }
                if (this.hasVlan) {
                    this.vlan = false;
                }
            } else {
                if (!this.hasVid) {
                    this.vid = this.getVid(this.ipInterfaceMo, coordinator);
                }
                if (!this.hasVlan) {
                    this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
                }
            }
        } else if (this.isMFXBoard()) {
            this.NoAttributeAssert(this.hasVlanRef, this.IP_VLAN_REF, " is *NOT* applicable when configuring MFX board");
            if (!this.hasVid) {
                this.vid = this.getVid(this.ipInterfaceMo, coordinator);
            }
            if (!this.hasVlan) {
                this.vlan = this.getVLan(this.ipInterfaceMo, coordinator);
            }
        }
        MoAttributeValidator.checkIntegerAttribute((String)this.IP_VID, (int)this.vid, (int)0, (int)4094, (String)this.typeName);
    }

    public void storeIntoMoData(MoData moData, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        if (!this.hasVlanRef) {
            return;
        }
        if (null != this.vlanRef) {
            ((Reservable)this.vlanRef).reserve(this.ipInterfaceMo, coordinator);
        }
        if (null != (managedObject = (ManagedObject)this.ipInterfaceMo.getAttribute(this.IP_VLAN_REF, coordinator))) {
            ((Reservable)managedObject).release(this.ipInterfaceMo, coordinator);
        }
        ((ReferenceAttribute)moData.getAttribute(this.IP_VLAN_REF)).setValue(this.vlanRef);
    }

    private boolean isMFXBoard() {
        return this.parent instanceof InternalEthernetPortMo;
    }

    private boolean isMFGorIPGBoard() {
        return this.parent instanceof GigaBitEthernetMo;
    }

    private boolean isBackplane(Coordinator coordinator) throws MoAccessException {
        return this.isMFGorIPGBoard() && ((GigaBitEthernetMo)this.parent).getLinkType(coordinator) == 1;
    }

    private boolean isFrontPorts(Coordinator coordinator) throws MoAccessException {
        return this.isMFGorIPGBoard() && ((GigaBitEthernetMo)this.parent).getLinkType(coordinator) == 0;
    }

    private boolean isUntaggedVlan(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = (Boolean)managedObject.getAttribute(this.IP_VLAN, coordinator);
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.IP_VLAN_REF, coordinator);
        return false == bl && null == managedObject2;
    }

    private void NoAttributeAssert(boolean bl, String string, String string2) throws OperationNotAllowedException {
        if (bl) {
            throw new OperationNotAllowedException(string + string2, this.typeName);
        }
    }

    private boolean isBackplane(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (this.parent instanceof IpSystemMo) {
            if (managedObject != null) {
                return ((GigaBitEthernetMo)managedObject).getLinkType(coordinator) == 1;
            }
            return false;
        }
        return this.isMFGorIPGBoard() && ((GigaBitEthernetMo)this.parent).getLinkType(coordinator) == 1;
    }

    private boolean isFrontPorts(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (this.parent instanceof IpSystemMo) {
            if (managedObject != null) {
                return ((GigaBitEthernetMo)managedObject).getLinkType(coordinator) == 0;
            }
            return false;
        }
        return this.isMFGorIPGBoard() && ((GigaBitEthernetMo)this.parent).getLinkType(coordinator) == 0;
    }

    public Hashtable packVlanInfo(Coordinator coordinator) throws MoAccessException {
        Hashtable<String, SignedIntParameter> hashtable = new Hashtable<String, SignedIntParameter>();
        hashtable.put(this.IP_VID, new SignedIntParameter(this.IP_VID, this.vid));
        hashtable.put(this.IP_VLAN, new SignedIntParameter(this.IP_VLAN, this.vlan));
        int n = 0;
        if (null != this.vlanRef) {
            n = ((FroInfo)this.vlanRef).getFroId(coordinator);
        }
        hashtable.put(this.IP_VLAN_REF, new SignedIntParameter(this.IP_VLAN_REF, n));
        return hashtable;
    }

    private static boolean hasAttr(String string, AttrList attrList) {
        return -1 != attrList.indexOf(string);
    }

    private int getVid(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof IpInterfaceMo) {
            return ((IpInterfaceMo)managedObject).getVid(coordinator);
        }
        return ((Ipv6InterfaceMo)managedObject).getVid(coordinator);
    }

    private boolean getVLan(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof IpInterfaceMo) {
            return ((IpInterfaceMo)managedObject).getVLan(coordinator);
        }
        return ((Ipv6InterfaceMo)managedObject).getVLan(coordinator);
    }

    private ManagedObject getVlanRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof IpInterfaceMo) {
            return ((IpInterfaceMo)managedObject).getVlanRef(coordinator);
        }
        return ((Ipv6InterfaceMo)managedObject).getVlanRef(coordinator);
    }

    public int getVid() {
        return this.vid;
    }

    public boolean getVlan() {
        return this.vlan;
    }

    public ManagedObject getVlanRef() {
        return this.vlanRef;
    }
}

