/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.jar;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import se.ericsson.crbs.omf.aue.common.jar.PackageHelper;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class PackageHelperImpl
implements PackageHelper {
    private static final Class THIS_CLASS = PackageHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final String cxcNumber;
    private final String cxcRevision;
    private final String jarFilePath;

    public PackageHelperImpl(String propertiesFile) throws IOException {
        String cxcNumberReadFromProperiesFile;
        String tmpCxcNumber = null;
        String tmpCxcRevision = null;
        String tmpJarFilePath = null;
        logger.traceDebug(THIS_CLASS, "Reading from propertyfile: " + propertiesFile);
        try {
            ResourceBundle step1Bundle = ResourceBundle.getBundle(propertiesFile);
            logger.traceDebug(THIS_CLASS, "AUE Step1 Bundle: " + step1Bundle);
            cxcNumberReadFromProperiesFile = step1Bundle.getString("cxcNumber");
            logger.traceDebug(THIS_CLASS, "CXC number read from properties file: " + AueUtil.doubleQuote(cxcNumberReadFromProperiesFile));
            tmpCxcRevision = step1Bundle.getString("cxcRevision");
            logger.traceDebug(THIS_CLASS, "CXC revision read from properties file: " + AueUtil.doubleQuote(tmpCxcRevision));
        }
        catch (Exception e) {
            throw new IOException("Could not read propererty " + propertiesFile);
        }
        tmpCxcNumber = AueUtil.replaceInString(cxcNumberReadFromProperiesFile, "/", "%");
        logger.traceDebug(THIS_CLASS, "Converted onverted cxcNumber: " + AueUtil.doubleQuote(tmpCxcNumber));
        tmpJarFilePath = JAR_FILE_LOCATION_PATH + tmpCxcNumber + "_" + tmpCxcRevision + ".jar";
        if (!new File(tmpJarFilePath).exists()) {
            tmpCxcNumber = AueUtil.replaceInString(cxcNumberReadFromProperiesFile, "/", "_");
            tmpJarFilePath = JAR_FILE_LOCATION_PATH + tmpCxcNumber + "_" + tmpCxcRevision + ".jar";
        }
        this.cxcNumber = tmpCxcNumber;
        this.cxcRevision = tmpCxcRevision;
        this.jarFilePath = tmpJarFilePath;
        logger.traceDebug(THIS_CLASS, "JAR file location: " + AueUtil.doubleQuote(this.jarFilePath));
    }

    public String getCxcNumber() {
        return this.cxcNumber;
    }

    public String getCxcRevision() {
        return this.cxcRevision;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }
}

