/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.util;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.AueUtilHelper;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;

public class AueUtilHelperImpl
implements AueUtilHelper {
    private static final Class THIS_CLASS = AueUtilHelperImpl.class;
    private static final String PERFORMED_UPGRADES_LOW_CASE = "performedUpgrades".toLowerCase(Locale.getDefault());
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String NEW_LINE = "\n";
    protected static final String REASON_STR = " Reason: ";
    private static AueUtilHelper instance = new AueUtilHelperImpl();

    public static AueUtilHelper instance() {
        return instance;
    }

    private AueUtilHelperImpl() {
    }

    public String quote(String strToQuote) {
        return "'" + strToQuote + "'";
    }

    public String doubleQuote(String strToDoubleQuote) {
        return "\"" + strToDoubleQuote + "\"";
    }

    public String convertToString(Throwable throwable) {
        ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return arrayStream.toString();
    }

    public String getExceptionMessage(Throwable throwable) {
        StringBuffer exceptionMessage = new StringBuffer();
        exceptionMessage.append(" Class: ").append(throwable.getClass().getName());
        if (throwable instanceof CrbsAueException) {
            CrbsAueException crbsAueException = (CrbsAueException)((Object)throwable);
            if (crbsAueException.getRootCause() != null) {
                exceptionMessage.append(", Caused by: ");
                exceptionMessage.append(this.getExceptionMessage(crbsAueException.getRootCause()));
            }
            exceptionMessage.insert(0, this.doubleQuote(crbsAueException.getTopMessage()));
        } else if (throwable instanceof AueException) {
            AueException aueException = (AueException)throwable;
            if (aueException.getRootCause() != null) {
                exceptionMessage.append(", Caused by: ");
                exceptionMessage.append(this.getExceptionMessage(aueException.getRootCause()));
            }
            exceptionMessage.insert(0, this.doubleQuote(aueException.getMessage()));
        } else if (throwable instanceof MoAccessException) {
            MoAccessException moAccessException = (MoAccessException)throwable;
            if (moAccessException.getCause() != null) {
                exceptionMessage.append(", Caused by: ");
                exceptionMessage.append(this.getExceptionMessage(moAccessException.getCause()));
            }
            exceptionMessage.insert(0, this.doubleQuote(moAccessException.getVariablesAsString()));
            exceptionMessage.insert(1, this.doubleQuote(moAccessException.getReasonTag()));
        } else {
            if (throwable.getCause() != null) {
                exceptionMessage.append(", Caused by: ");
                exceptionMessage.append(this.getExceptionMessage(throwable.getCause()));
            }
            exceptionMessage.insert(0, this.doubleQuote(throwable.getMessage()));
        }
        return exceptionMessage.toString();
    }

    public String appendReason(String msgToAppendTo, Throwable throwable) {
        return msgToAppendTo + REASON_STR + this.getExceptionMessage(throwable);
    }

    public String replaceInString(String stringToBeReplace, String oldValue, String newValue) {
        int currentIndex = 0;
        int startIndex = 0;
        StringBuffer strBuf = new StringBuffer(stringToBeReplace);
        while (currentIndex != -1) {
            currentIndex = strBuf.indexOf(oldValue, startIndex);
            if (currentIndex <= -1) continue;
            strBuf.replace(currentIndex, currentIndex + oldValue.length(), newValue);
            startIndex = currentIndex + newValue.length();
        }
        return strBuf.toString();
    }

    public String replaceInLdn(String ldn, String oldValue, String newValue) {
        ArrayList<String> changedLdnElementsList = new ArrayList<String>();
        String correctedLdn = this.replaceInString(ldn, " ", "");
        String manipulatedOldValue = oldValue + "=";
        String manipulatedNewValue = newValue + "=";
        StringTokenizer tokenizer = new StringTokenizer(correctedLdn, ",");
        while (tokenizer.hasMoreElements()) {
            String ldnElement = (String)tokenizer.nextElement();
            if (ldnElement.startsWith(manipulatedOldValue)) {
                String correctedValue = this.replaceInString(ldnElement, manipulatedOldValue, manipulatedNewValue);
                changedLdnElementsList.add(correctedValue);
                continue;
            }
            changedLdnElementsList.add(ldnElement);
        }
        StringBuffer newLdnBuffer = new StringBuffer();
        for (int i = 0; i < changedLdnElementsList.size(); ++i) {
            newLdnBuffer.append(changedLdnElementsList.get(i));
            if (i >= changedLdnElementsList.size() - 1) continue;
            newLdnBuffer.append(",");
        }
        return newLdnBuffer.toString();
    }

    public String getLastLdnElement(String ldn) {
        String lastLdnElement = "";
        if (this.isLdn(ldn)) {
            String correctedLdn = this.replaceInString(ldn, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedLdn, ",");
            while (commaTokenizer.hasMoreElements()) {
                lastLdnElement = (String)commaTokenizer.nextElement();
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(lastLdnElement, "=");
            lastLdnElement = equalsTokenizer.hasMoreElements() ? (String)equalsTokenizer.nextElement() : "";
        } else {
            lastLdnElement = "";
        }
        return lastLdnElement;
    }

    public String getRdnElement(String ldn) {
        String rdn = "";
        if (this.isLdn(ldn)) {
            String correctedLdn = this.replaceInString(ldn, " ", "");
            rdn = correctedLdn.substring(correctedLdn.lastIndexOf(44) + 1);
        }
        return rdn;
    }

    public String getRdnAttributeValue(String ldn) {
        logger.traceEnter(THIS_CLASS, "getRdnAttributeValue() " + ldn);
        String rdnElement = "";
        if (this.isLdn(ldn)) {
            rdnElement = this.getRdnElement(ldn);
            rdnElement = rdnElement.substring(rdnElement.lastIndexOf(61) + 1);
        }
        logger.traceReturn(THIS_CLASS, "getRdnAttributeValue() " + rdnElement);
        return rdnElement;
    }

    public boolean isLdn(String stringToBeCkecked) {
        boolean stringIsLdn = true;
        try {
            String correctedString = this.replaceInString(stringToBeCkecked, " ", "");
            StringTokenizer commaTokenizer = new StringTokenizer(correctedString, ",");
            int numberOfCommas = commaTokenizer.countTokens();
            while (commaTokenizer.hasMoreElements()) {
                String possibleLdnElement = (String)commaTokenizer.nextElement();
                int index = possibleLdnElement.indexOf("=");
                stringIsLdn = stringIsLdn && index > 0 && index < possibleLdnElement.length() - 1;
            }
            StringTokenizer equalsTokenizer = new StringTokenizer(correctedString, "=");
            stringIsLdn = stringIsLdn && equalsTokenizer.countTokens() == numberOfCommas + 1;
        }
        catch (Exception e) {
            logger.traceGeneral(THIS_CLASS, "The String " + this.doubleQuote(stringToBeCkecked) + " is not a valid LDN.");
            stringIsLdn = false;
        }
        return stringIsLdn;
    }

    public void appendToFile(String filePath, String message) {
        this.writeToFile(filePath, message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filePath, String message, boolean append) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            FileOutputStream fos = null;
            try {
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(filePath, append);
                if (message.endsWith(NEW_LINE)) {
                    fos.write(message.getBytes());
                } else {
                    fos.write((message + NEW_LINE).getBytes());
                }
                fos.close();
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception ignoreToo) {}
            }
        }
    }

    public long getUsedMemory() {
        System.gc();
        System.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        return totalMemory - freeMemory;
    }

    public void storePerformedUpgradeSequence(boolean isStep1, String aueName, String fromVersionStr, String fromUpStr, String toVersionStr, String toUpStr, String timeStamp, int timeConsumption, int memoryConsumption) throws SQLException, CrbsAueException {
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        dbWrapper.openConnection();
        if (!AueUtilHelperImpl.doesPerformedUpgradesTableExist(dbWrapper)) {
            AueUtilHelperImpl.createPerformedUpgradesTable(dbWrapper);
        } else if (AueUtilHelperImpl.doesPerformedUpgradesTableNeedUpgrade(dbWrapper)) {
            List performedUpgradesList = AueUtilHelperImpl.getPerformedUpgradesDataBeforeUpgrade(dbWrapper);
            AueUtilHelperImpl.dropPerformedUpgradesTable(dbWrapper);
            AueUtilHelperImpl.createPerformedUpgradesTable(dbWrapper);
            this.insertIntoPerformedUpgradesDataAfterUpgrade(performedUpgradesList, dbWrapper);
        }
        String layer = "MAO";
        if (isStep1) {
            layer = "FRO";
        }
        this.insertIntoPerformedUpgradesTable(aueName, layer, fromVersionStr, fromUpStr, toVersionStr, toUpStr, timeStamp, timeConsumption, memoryConsumption, dbWrapper);
    }

    public AueUtil.FromAndToUpHolder getFromAndToUp(CollectorContext collectorContext) throws MoAccessException {
        ConfigurationVersionMo cvMo = (ConfigurationVersionMo)collectorContext.getMoAccessor().lookup(CONFIGURATION_VERSION_LDN);
        UpgradePackageMo currUpMo = (UpgradePackageMo)cvMo.getCurrentUpgradePackage(null);
        String fromUp = AueUtilHelperImpl.getUpNumberAndRevisionString(currUpMo);
        String toUp = "?";
        MoIterator upMoIterator = collectorContext.getMoAccessor().lookupType("UpgradePackage");
        while (upMoIterator.hasMoreElements()) {
            UpgradePackageMo upMo = (UpgradePackageMo)upMoIterator.nextMo();
            if (upMo.getState(null) != 2) continue;
            toUp = AueUtilHelperImpl.getUpNumberAndRevisionString(upMo);
        }
        return new AueUtil.FromAndToUpHolder(fromUp, toUp);
    }

    private static String getUpNumberAndRevisionString(UpgradePackageMo upMo) throws MoAccessException {
        Struct administrativeData = upMo.getAdministrativeData(null);
        String fromUpNumber = (String)administrativeData.getValue("productNumber");
        String fromUpRevision = (String)administrativeData.getValue("productRevision");
        return fromUpNumber + "/" + fromUpRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToVersionFromPreviousUpgrade(String aueName) {
        MomInfo resultBasedOnToVersion;
        String result;
        block12: {
            String currentTimeStamp = "";
            result = null;
            resultBasedOnToVersion = null;
            try {
                DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
                dbWrapper.openConnection();
                if (!AueUtilHelperImpl.doesPerformedUpgradesTableExist(dbWrapper)) break block12;
                StringBuffer selectSqlBuf = new StringBuffer(500);
                selectSqlBuf.append("SELECT toVersion, timeStamp FROM ").append("performedUpgrades").append(" WHERE aueName = ").append(this.quote(aueName));
                ResultSet resultSet = null;
                try {
                    resultSet = dbWrapper.executeQuery(selectSqlBuf.toString());
                    while (resultSet.next()) {
                        String dbToVersion = resultSet.getString(1);
                        String dbTimeStamp = resultSet.getString(2);
                        if (currentTimeStamp.equalsIgnoreCase("") || dbTimeStamp.compareToIgnoreCase(currentTimeStamp) > 0) {
                            currentTimeStamp = dbTimeStamp;
                            result = dbToVersion;
                        }
                        MomInfo momInfo = MomInfo.getMomInfo(dbToVersion);
                        if (resultBasedOnToVersion != null && momInfo.intValue() <= resultBasedOnToVersion.intValue()) continue;
                        resultBasedOnToVersion = momInfo;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Exception e) {
                currentTimeStamp = "";
            }
        }
        if (!(result == null || resultBasedOnToVersion != null && result.equals(resultBasedOnToVersion.toString()))) {
            return null;
        }
        return result;
    }

    private static boolean doesPerformedUpgradesTableExist(DbWrapper dbWrapper) throws SQLException {
        return dbWrapper.doTableExist(PERFORMED_UPGRADES_LOW_CASE);
    }

    private static void createPerformedUpgradesTable(DbWrapper dbWrapper) throws SQLException {
        Sql.CreateTable createPerfUpgrades = new Sql.CreateTable(PERFORMED_UPGRADES_LOW_CASE, new Sql.CreateTable.ColumnSpec[]{new Sql.CreateTable.ColumnSpec("aueName", Sql.MomDataType.MOM_STRING, 0, null, true), new Sql.CreateTable.ColumnSpec("layer", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("fromVersion", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("fromUp", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("toVersion", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("toUp", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("timeStamp", Sql.MomDataType.MOM_STRING, 0, null, true), new Sql.CreateTable.ColumnSpec("timeConsumption", Sql.MomDataType.MOM_S32, 0, null, false), new Sql.CreateTable.ColumnSpec("memoryConsumption", Sql.MomDataType.MOM_S32, 0, null, false)});
        logger.traceDebug(THIS_CLASS, createPerfUpgrades.toString());
        dbWrapper.executeUpdate(createPerfUpgrades);
    }

    private void insertIntoPerformedUpgradesTable(String aueName, String layer, String fromVersionStr, String fromUpStr, String toVersionStr, String toUpStr, String timeStamp, int timeConsumption, int memoryConsumption, DbWrapper dbWrapper) throws SQLException {
        String insertUpInfo = "INSERT INTO performedUpgrades (aueName, layer, fromVersion, fromUp, toVersion, toUp, timeStamp, timeConsumption, memoryConsumption) VALUES (" + this.quote(aueName) + ", " + this.quote(layer) + ", " + this.quote(fromVersionStr) + ", " + this.quote(fromUpStr) + ", " + this.quote(toVersionStr) + ", " + this.quote(toUpStr) + ", " + this.quote(timeStamp) + ", " + timeConsumption + ", " + (memoryConsumption < 0 ? 0 : memoryConsumption) + ")";
        logger.traceDebug(THIS_CLASS, insertUpInfo);
        dbWrapper.executeUpdate(insertUpInfo);
    }

    private static void dropPerformedUpgradesTable(DbWrapper dbWrapper) throws SQLException {
        dbWrapper.executeUpdate("DROP TABLE performedUpgrades");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesPerformedUpgradesTableNeedUpgrade(DbWrapper dbWrapper) throws SQLException {
        ResultSet resultSet = null;
        boolean upgradeNeeded = true;
        try {
            resultSet = dbWrapper.executeQuery("SELECT * FROM " + PERFORMED_UPGRADES_LOW_CASE);
            upgradeNeeded = resultSet.getMetaData().getColumnCount() == 7;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return upgradeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getPerformedUpgradesDataBeforeUpgrade(DbWrapper dbWrapper) throws SQLException {
        ResultSet resultSet = null;
        try {
            ArrayList<PerformedUpgradesData> performedUpgradesList = new ArrayList<PerformedUpgradesData>();
            resultSet = dbWrapper.executeQuery("SELECT aueName, layer, fromVersion, toVersion, timeStamp, timeConsumption, memoryConsumption FROM " + PERFORMED_UPGRADES_LOW_CASE);
            while (resultSet.next()) {
                PerformedUpgradesData pud = new PerformedUpgradesData();
                int col = 1;
                pud.aueName = resultSet.getString(col++);
                pud.layer = resultSet.getString(col++);
                pud.fromVersion = resultSet.getString(col++);
                pud.toVersion = resultSet.getString(col++);
                pud.timeStamp = resultSet.getString(col++);
                pud.timeConsumption = resultSet.getInt(col++);
                pud.memoryConsumption = resultSet.getInt(col++);
                performedUpgradesList.add(pud);
            }
            ArrayList<PerformedUpgradesData> arrayList = performedUpgradesList;
            return arrayList;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
    }

    private void insertIntoPerformedUpgradesDataAfterUpgrade(List performedUpgradesList, DbWrapper dbWrapper) throws SQLException, CrbsAueException {
        PerformedUpgradesData pud = null;
        Iterator pudIterator = performedUpgradesList.iterator();
        while (pudIterator.hasNext()) {
            pud = (PerformedUpgradesData)pudIterator.next();
            this.insertIntoPerformedUpgradesTable(pud.aueName, pud.layer, pud.fromVersion, pud.fromUp, pud.toVersion, pud.toUp, pud.timeStamp, pud.timeConsumption, pud.memoryConsumption, dbWrapper);
        }
    }

    private static class PerformedUpgradesData {
        private String aueName;
        private String layer;
        private String fromVersion;
        private String fromUp = "-";
        private String toVersion;
        private String toUp = "-";
        private String timeStamp;
        private int timeConsumption;
        private int memoryConsumption;

        private PerformedUpgradesData() {
        }
    }
}

