/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.ChangeNotificationAction;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class ChangeNotifAction
implements MoDataAction {
    private final Class loggerClass;
    private final AbstractLogger logger;

    public ChangeNotifAction(Class loggerClass) {
        this.loggerClass = loggerClass;
        this.logger = LoggingService.getLogger(loggerClass.getName());
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        String moTypeName = moDataWrapper.getMoTypeName();
        this.logger.traceEnter(this.loggerClass, "perform(" + moTypeName + ")");
        Enumeration enume = moDataWrapper.getAllPersistentAttributes();
        ArrayList<String> list = new ArrayList<String>();
        while (enume.hasMoreElements()) {
            Attribute attr = (Attribute)enume.nextElement();
            if (attr.getNotificationType() != 1) continue;
            list.add(new String(attr.getName()));
        }
        if (list.size() > 0) {
            this.doCppAction(list, moDataWrapper, converterContext, coordinator);
        }
        this.logger.traceReturn(this.loggerClass, "perform(" + moTypeName + ")");
    }

    private void doCppAction(ArrayList list, MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        for (int i = 0; i < list.size(); ++i) {
            String attr = (String)list.get(i);
            try {
                ChangeNotificationAction acc = new ChangeNotificationAction(attr, false);
                acc.perform(moDataWrapper, converterContext, coordinator);
                continue;
            }
            catch (AueException auee) {
                this.logger.traceError(this.loggerClass, auee.getMessage(), auee);
                throw new CrbsAueException(auee.getMessage());
            }
        }
    }
}

