/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorCompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected RunnableFuture newTaskFor(Runnable runnable, Object object) {
        return new FutureTask(runnable, object);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    public Future submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    public Future submit(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, object);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    public Future submit(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doInvokeAny(Collection collection, boolean bl, long l2) throws InterruptedException, ExecutionException, TimeoutException {
        if (collection == null) {
            throw new NullPointerException();
        }
        int n2 = collection.size();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Future> arrayList = new ArrayList<Future>(n2);
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(this);
        try {
            ExecutionException executionException = null;
            long l3 = bl ? Utils.nanoTime() : 0L;
            Iterator iterator = collection.iterator();
            arrayList.add(executorCompletionService.submit((Callable)iterator.next()));
            --n2;
            int n3 = 1;
            while (true) {
                Object object;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n2 > 0) {
                        --n2;
                        arrayList.add(executorCompletionService.submit((Callable)iterator.next()));
                        ++n3;
                    } else {
                        if (n3 == 0) {
                            if (executionException != null) throw executionException;
                            break;
                        }
                        if (bl) {
                            future = executorCompletionService.poll(l2, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l4 = Utils.nanoTime();
                            l2 -= l4 - l3;
                            l3 = l4;
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n3;
                try {
                    object = future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                Object var17_17 = null;
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ((Future)iterator2.next()).cancel(true);
                }
                return object;
                break;
            }
            executionException = new ExecutionException();
            throw executionException;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Iterator iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                ((Future)iterator.next()).cancel(true);
            }
        }
    }

    public Object invokeAny(Collection collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    public Object invokeAny(Collection collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection collection) throws InterruptedException {
        Object object;
        block11: {
            Iterator iterator;
            if (collection == null) {
                throw new NullPointerException();
            }
            ArrayList<RunnableFuture> arrayList = new ArrayList<RunnableFuture>(collection.size());
            boolean bl = false;
            try {
                Future future;
                object = collection.iterator();
                while (object.hasNext()) {
                    future = this.newTaskFor((Callable)object.next());
                    arrayList.add((RunnableFuture)future);
                    this.execute((Runnable)((Object)future));
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    future = (Future)object.next();
                    if (future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {}
                }
                bl = true;
                object = arrayList;
                Object var8_9 = null;
                if (bl) break block11;
                iterator = arrayList.iterator();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!bl) {
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        Future future = (Future)iterator2.next();
                        future.cancel(true);
                    }
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.cancel(true);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List invokeAll(Collection collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        Object object;
        boolean bl;
        ArrayList<RunnableFuture> arrayList;
        block21: {
            ArrayList<RunnableFuture> arrayList2;
            block20: {
                Iterator iterator;
                ArrayList<RunnableFuture> arrayList3;
                block19: {
                    if (collection == null || timeUnit == null) {
                        throw new NullPointerException();
                    }
                    long l3 = timeUnit.toNanos(l2);
                    arrayList = new ArrayList<RunnableFuture>(collection.size());
                    bl = false;
                    try {
                        Iterator iterator2 = collection.iterator();
                        while (iterator2.hasNext()) {
                            arrayList.add(this.newTaskFor((Callable)iterator2.next()));
                        }
                        long l4 = Utils.nanoTime();
                        Iterator iterator3 = arrayList.iterator();
                        while (iterator3.hasNext()) {
                            this.execute((Runnable)iterator3.next());
                            long l5 = Utils.nanoTime();
                            if ((l3 -= l5 - (l4 = l5)) > 0L) continue;
                            arrayList3 = arrayList;
                            Object var17_18 = null;
                            if (bl) return arrayList3;
                            iterator = arrayList.iterator();
                            break block19;
                        }
                        object = arrayList.iterator();
                        while (object.hasNext()) {
                            Future future = (Future)object.next();
                            if (future.isDone()) continue;
                            if (l3 <= 0L) {
                                arrayList2 = arrayList;
                                break block20;
                            }
                            try {
                                future.get(l3, TimeUnit.NANOSECONDS);
                            }
                            catch (CancellationException cancellationException) {
                            }
                            catch (ExecutionException executionException) {
                            }
                            catch (TimeoutException timeoutException) {
                                ArrayList<RunnableFuture> arrayList4 = arrayList;
                                Object var17_20 = null;
                                if (bl) return arrayList4;
                                Iterator iterator4 = arrayList.iterator();
                                while (true) {
                                    if (!iterator4.hasNext()) {
                                        return arrayList4;
                                    }
                                    Future future2 = (Future)iterator4.next();
                                    future2.cancel(true);
                                }
                            }
                            long l6 = Utils.nanoTime();
                            l3 -= l6 - l4;
                            l4 = l6;
                        }
                        bl = true;
                        object = arrayList;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var17_22 = null;
                        if (!bl) {
                            Iterator iterator5 = arrayList.iterator();
                            while (iterator5.hasNext()) {
                                Future future = (Future)iterator5.next();
                                future.cancel(true);
                            }
                        }
                        throw throwable;
                    }
                }
                while (iterator.hasNext()) {
                    Future future = (Future)iterator.next();
                    future.cancel(true);
                }
                return arrayList3;
            }
            Object var17_19 = null;
            if (bl) return arrayList2;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.cancel(true);
            }
            return arrayList2;
        }
        Object var17_21 = null;
        if (bl) return object;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            future.cancel(true);
        }
        return object;
    }
}

