/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.HashMap;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.orb.AbstractRebindRetryStrategy;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class ImRRebindRetryStrategy
extends AbstractRebindRetryStrategy {
    private final RebindRetryStrategy delegate;
    private Logger logger;
    private ORB orb;
    private static final String IMR_LOCATE_CALL = "imr_locate_call";

    public ImRRebindRetryStrategy(RebindRetryStrategy delegate, ORB orb, Logger logger) {
        super(logger);
        this.orb = orb;
        this.logger = logger;
        this.delegate = delegate;
        if (logger.isDebugEnabled()) {
            logger.debug("ImRRebindRetryStrategy created with a delegate rebind strategy of " + delegate);
        }
    }

    public ParsedIOROperations getOriginalIOR() {
        return this.delegate.getOriginalIOR();
    }

    public void pushIOR(ParsedIOROperations ior) {
        this.delegate.pushIOR(ior);
    }

    public void setOriginalIOR(ParsedIOROperations ior) {
        this.delegate.setOriginalIOR(ior);
    }

    public boolean doTryRebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        Repository imr;
        boolean success = this.delegate.try_rebind(callback, failingIOR, cause, serviceContexts);
        if (success) {
            return true;
        }
        Integer orbTypeId = failingIOR.getORBTypeId();
        if (orbTypeId == null || orbTypeId != 1245790976) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate: foreign IOR detected");
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delegate: JacORB IOR detected");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delegate: attempting to contact ImR");
        }
        if ((imr = this.locateImR()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unable to rebind as no ImR could be located.");
            }
            return false;
        }
        ParsedIOROperations parsedIOR = this.createIOR(imr, failingIOR);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rebind to server object hosted at the ImR using " + callback);
        }
        callback.setIMRQuerying();
        return callback.rebind(parsedIOR);
    }

    protected ParsedIOROperations createIOR(Repository imr, ParsedIOROperations ior) {
        byte[] object_key = ior.get_object_key();
        TaggedProfile[] newTaggedProfiles = this.createProfile(imr, object_key);
        ParsedIOR parsedIOR = new ParsedIOR(this.orb, new IOR(ior.getTypeId(), newTaggedProfiles));
        return parsedIOR;
    }

    private TaggedProfile[] createProfile(Repository imr, byte[] object_key) {
        ParsedIOR imrIOR = ((Delegate)((ObjectImpl)((Object)imr))._get_delegate()).getParsedIOR();
        List imrProfiles = imrIOR.getProfiles();
        TaggedProfile[] newTaggedProfiles = new TaggedProfile[imrProfiles.size()];
        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
        for (int i2 = 0; i2 < imrProfiles.size(); ++i2) {
            Profile etfProfile = ((Profile)imrProfiles.get(i2)).copy();
            etfProfile.set_object_key(object_key);
            etfProfile.marshal(taggedProfileHolder, null);
            newTaggedProfiles[i2] = taggedProfileHolder.value;
        }
        return newTaggedProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository locateImR() {
        Repository imr = null;
        do {
            try {
                HashMap<String, String> currentCtxt = new HashMap<String, String>();
                currentCtxt.put(IMR_LOCATE_CALL, "true");
                Delegate.getInvocationContext().push(currentCtxt);
                imr = this.orb.getImR();
                long serverID = -1L;
                if (this.orb.getImRServerImpl() != null) {
                    serverID = this.orb.getImRServerImpl().id();
                }
                imr.ping(serverID);
                break;
            }
            catch (Exception e2) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: failed to contact ImR");
                }
                imr = null;
            }
            finally {
                Delegate.getInvocationContext().pop();
            }
        } while (this.orb.imrDead(imr));
        return imr;
    }

    protected boolean checkExceptionStatus(SystemException e2) {
        return e2.completed == CompletionStatus.COMPLETED_NO;
    }
}

