/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.imrutility.imr.Server;
import org.jacorb.imrutility.imr.ServerImpl;
import org.jacorb.imrutility.imr.util.IMRLocator;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ObjectKeyMap;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.RTORB;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.ft.IOGRValidator;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MultipleComponentProfile;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.policies.ClientProtocolPolicy;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.typecode.NullTypeCodeCache;
import org.jacorb.orb.typecode.NullTypeCodeCompactor;
import org.jacorb.orb.typecode.TypeCodeCache;
import org.jacorb.orb.typecode.TypeCodeCompactor;
import org.jacorb.poa.Current;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RPPoolManagerFactory;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;

public final class ORB
extends ORBSingleton
implements POAListener,
Configurable {
    private static final String versionString = "2.3.1.0";
    private static final String dateString = "7-October-2011";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private boolean cacheReferences;
    private String implName;
    private int giopMinorVersion;
    private boolean giopAdd_1_0_Profiles;
    private String hashTableClassName;
    private ProtocolAddressBase imrProxyAddress = null;
    private ProtocolAddressBase iorProxyAddress;
    private final Map initial_references = new HashMap();
    private org.jacorb.poa.POA rootpoa;
    private Current poaCurrent;
    private BasicAdapter basicAdapter;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private final org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private final Map valueFactories = new HashMap();
    private final Map boxedValueHelpers = new HashMap();
    private final ObjectKeyMap objectKeyMap = new ObjectKeyMap(this);
    private IOGRValidator iogrFactory;
    private String[] arguments;
    private final java.lang.Object runSync = new java.lang.Object();
    private boolean run = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private final java.lang.Object shutdown_synch = new java.lang.Object();
    private Repository imr;
    private java.lang.Object[] imrUpdateLock = new java.lang.Object[0];
    private IMRLocator locator;
    private Server activeServerHandler;
    private int imrHeartbeat;
    private ServerImpl imrServerImpl;
    private boolean isImR;
    private boolean useImR;
    private boolean useImREndpoint;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:2.3.1.0";
    private final Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private RTORB rtORB;
    private PolicyManager policyManager;
    private final Map policy_factories = Collections.synchronizedMap(new HashMap());
    private static final HashSet services = new HashSet<String>(Arrays.asList("RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory", "RTORB", "MGM"));
    private boolean bidir_giop = false;
    private final String serverIdStr = String.valueOf((long)(Math.random() * 9.999999999E9));
    private final byte[] serverId = this.serverIdStr.getBytes();
    private RPPoolManagerFactory poolManagerFactory;
    private boolean failOnORBInitializerError;
    private boolean inORBInitializer;
    private String defaultInitRef;
    private boolean passIORComponent;
    private boolean firstConnection = true;
    private Map connectedObjects = new HashMap();

    public ORB() {
        super(false);
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.cacheReferences = this.configuration.getAttributeAsBoolean("jacorb.reference_caching", false);
        this.implName = this.configuration.getAttribute("jacorb.implname", "");
        this.giopMinorVersion = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        this.giopAdd_1_0_Profiles = this.configuration.getAttributeAsBoolean("jacorb.giop.add_1_0_profiles", false);
        this.hashTableClassName = this.configuration.getAttribute("jacorb.hashtable_class", HashMap.class.getName());
        this.isImR = this.configuration.getAttributeAsBoolean("jacorb._is_imr_", false);
        this.imrHeartbeat = this.configuration.getAttributeAsInteger("jacorb.imr.heartbeat", 0);
        this.useImR = this.configuration.getAttributeAsBoolean("jacorb.use_imr", false);
        this.useImREndpoint = this.configuration.getAttributeAsBoolean("jacorb.use_imr_endpoint", true);
        String host = this.configuration.getAttribute("jacorb.imr.ior_proxy_host", null);
        int port = this.configuration.getAttributeAsInteger("jacorb.imr.ior_proxy_port", -1);
        String address = this.configuration.getAttribute("jacorb.imr.ior_proxy_address", null);
        this.imrProxyAddress = this.createAddress(host, port, address);
        host = this.configuration.getAttribute("jacorb.ior_proxy_host", null);
        port = this.configuration.getAttributeAsInteger("jacorb.ior_proxy_port", -1);
        address = this.configuration.getAttribute("jacorb.ior_proxy_address", null);
        this.iorProxyAddress = this.createAddress(host, port, address);
        this.failOnORBInitializerError = this.configuration.getAttributeAsBoolean("jacorb.orb_initializer.fail_on_error", false);
        this.printVersion(this.configuration);
        this.configureObjectKeyMap(this.configuration);
        if (this.poolManagerFactory != null) {
            // empty if block
        }
        this.poolManagerFactory = new RPPoolManagerFactory(this);
        this.iogrFactory = (IOGRValidator)this.configuration.getAttributeAsObject("jacorb.ft.iogr_validator", IOGRValidator.PROPERTY_DEFAULT);
        this.logger.info("using IOGRValidator: " + this.iogrFactory.getClass().getName());
        boolean cacheTypeCodes = this.configuration.getAttributeAsBoolean("jacorb.cacheTypecodes", false);
        boolean compactTypeCodes = this.configuration.getAttributeAsBoolean("jacorb.compactTypecodes", false);
        if (cacheTypeCodes) {
            if (ObjectUtil.isAtLeastJDK15) {
                try {
                    this.typeCodeCache = (TypeCodeCache)this.configuration.getAttributeAsObject("jacorb.cacheTypecodes.class", "org.jacorb.orb.typecode.JDK15TypeCodeCache");
                }
                catch (ConfigurationException e2) {
                    // empty catch block
                }
            }
            if (this.typeCodeCache == null) {
                this.typeCodeCache = (TypeCodeCache)this.configuration.getAttributeAsObject("jacorb.cacheTypecodes.class", "org.jacorb.orb.typecode.JDK14TypeCodeCache");
            }
            this.logger.info("enabled TypeCodeCache: " + this.typeCodeCache.getClass().getName());
        } else {
            this.typeCodeCache = NullTypeCodeCache.getInstance();
        }
        if (compactTypeCodes) {
            if (ObjectUtil.isAtLeastJDK15) {
                try {
                    this.typeCodeCompactor = (TypeCodeCompactor)this.configuration.getAttributeAsObject("jacorb.compactTypecodes.class", "org.jacorb.orb.typecode.JDK15TypeCodeCompactor");
                }
                catch (ConfigurationException e3) {
                    // empty catch block
                }
            }
            if (this.typeCodeCompactor == null) {
                this.typeCodeCompactor = (TypeCodeCompactor)this.configuration.getAttributeAsObject("jacorb.compactTypecodes.class", "org.jacorb.orb.typecode.JDK14TypeCodeCompactor");
            }
            this.logger.info("enabled TypeCodeCompactor: " + this.typeCodeCompactor.getClass().getName());
        } else {
            this.typeCodeCompactor = NullTypeCodeCompactor.getInstance();
        }
        this.passIORComponent = config.getAttributeAsBoolean("jacorb.imr.passIORcomponent", false);
    }

    private ProtocolAddressBase createAddress(String host, int port, String addressString) {
        ProtocolAddressBase address;
        try {
            if (addressString == null) {
                if (host != null || port != -1) {
                    address = new IIOPAddress();
                    address.configure(this.configuration);
                    if (host != null) {
                        ((IIOPAddress)address).setHostname(host);
                    }
                    if (port != -1) {
                        ((IIOPAddress)address).setPort(port);
                    }
                } else {
                    address = null;
                }
            } else {
                address = this.createAddress(addressString);
            }
        }
        catch (Exception ex) {
            this.logger.error("error initializing ProxyAddress", ex);
            throw new INITIALIZE(ex.toString());
        }
        return address;
    }

    private void printVersion(org.jacorb.config.Configuration configuration) {
        boolean printVersion = configuration.getAttributeAsBoolean("jacorb.orb.print_version", true);
        if (!printVersion) {
            return;
        }
        Logger logger = configuration.getNamedLogger("jacorb.orb.print_version");
        logger.info("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\tJacORB V 2.3.1.0, www.jacorb.org\n\t(C) The JacORB project 7-October-2011\n       (Micro Focus Build V150416-14 (CVM Build with Security) )\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public ProtocolAddressBase createAddress(String address) {
        List factorylist = this.getTransportManager().getFactoriesList();
        ProtocolAddressBase result = null;
        Iterator i2 = factorylist.iterator();
        while (i2.hasNext() && result == null) {
            FactoriesBase f2 = (FactoriesBase)i2.next();
            result = f2.create_protocol_address(address);
        }
        return result;
    }

    public Object _getObject(IOR ior) {
        Delegate delegate = new Delegate(this, ior, true);
        return delegate.getReference(null);
    }

    public synchronized Object _getDelegate(ParsedIOR pior) {
        ObjectImpl object;
        String key = pior.getIORString();
        if (this.cacheReferences && (object = (ObjectImpl)this.knownReferences.get(key)) != null) {
            Delegate del = (Delegate)object._get_delegate();
            if (del != null) {
                ParsedIOR delpior = del.getParsedIOR();
                if (delpior == null) {
                    this.knownReferences.remove(key);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removing an invalid reference from cache.");
                    }
                } else if (pior.getEffectiveProfile().is_match(delpior.getEffectiveProfile())) {
                    return object._duplicate();
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove stale reference from cache ");
                }
                this.knownReferences.remove(key);
            }
        }
        Delegate delegate = new Delegate(this, pior);
        object = delegate.getReference(null);
        if (this.cacheReferences) {
            this.knownReferences.put(key, object);
        }
        return object;
    }

    org.jacorb.poa.POA findPOA(Delegate delegate, Object reference) {
        byte[] imrObjectKey;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        String refImplName = null;
        byte[] delegateObjectKey = delegate.getObjectKey();
        try {
            refImplName = POAUtil.extractImplName(delegateObjectKey);
        }
        catch (POAInternalError e2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA", e2);
            }
            return null;
        }
        if (refImplName == null) {
            if (this.implName.length() > 0 || this.serverIdStr.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch - null != " + this.implName);
                }
                return null;
            }
        } else if (!this.implName.equals(refImplName) && !this.serverIdStr.equals(refImplName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch - " + refImplName + " != " + this.implName);
            }
            return null;
        }
        if (this.isImR && !Arrays.equals(imrObjectKey = this.objectKeyMap.mapObjectKey("ImplementationRepository".getBytes()), delegateObjectKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: ImR request to ImR. looking for object key: " + POAUtil.convert(delegateObjectKey) + ". actual ImR has: " + POAUtil.convert(imrObjectKey));
            }
            return null;
        }
        try {
            String res;
            org.jacorb.poa.POA tmp_poa = this.rootpoa;
            String poa_name = POAUtil.extractPOAName(delegateObjectKey);
            List scopes = POAUtil.extractScopedPOANames(poa_name);
            for (int i2 = 0; i2 < scopes.size() && !"".equals(res = (String)scopes.get(i2)); ++i2) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p2) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] objectId = POAUtil.extractOID(reference);
            if (tmp_poa.isSystemId() && !tmp_poa.previouslyGeneratedObjectId(objectId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return tmp_poa;
        }
        catch (Exception e3) {
            this.logger.warn("ignoring unexpected exception during findPOA", e3);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public GIOPConnectionManager getGIOPConnectionManager() {
        if (this.giop_connection_manager == null) {
            this.giop_connection_manager = new GIOPConnectionManager();
            try {
                this.giop_connection_manager.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL(ce.toString());
            }
        }
        return this.giop_connection_manager;
    }

    synchronized void _release(String iorString) {
        if (this.cacheReferences) {
            this.knownReferences.remove(iorString);
        }
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 34: {
                return new MaxHopsPolicy(value);
            }
            case 35: {
                return new QueueOrderPolicy(value);
            }
            case 23: {
                return new RebindPolicy(value);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(value);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(value);
            }
            case 30: {
                return new ReplyEndTimePolicy(value);
            }
            case 26: {
                return new ReplyPriorityPolicy(value);
            }
            case 29: {
                return new ReplyStartTimePolicy(value);
            }
            case 28: {
                return new RequestEndTimePolicy(value);
            }
            case 25: {
                return new RequestPriorityPolicy(value);
            }
            case 27: {
                return new RequestStartTimePolicy(value);
            }
            case 33: {
                return new RoutingPolicy(value);
            }
            case 24: {
                return new SyncScopePolicy(value);
            }
            case 43: {
                return new ClientProtocolPolicy(value);
            }
        }
        PolicyFactory factory = (PolicyFactory)this.policy_factories.get(ObjectUtil.newInteger(type));
        if (factory == null) {
            throw new PolicyError("no factory registered to create policy with type: " + type, 0);
        }
        return factory.create_policy(type, value);
    }

    public boolean hasPolicyFactoryForType(int type) {
        return this.policy_factories.containsKey(ObjectUtil.newInteger(type));
    }

    public ContextList create_context_list() {
        this.work_pending();
        throw new NO_IMPLEMENT();
    }

    public Environment create_environment() {
        this.work_pending();
        throw new NO_IMPLEMENT();
    }

    public OutputStream create_output_stream() {
        this.work_pending();
        return new CDROutputStream(this);
    }

    IOR createIOR(String repId, byte[] objectKey, boolean _transient, org.jacorb.poa.POA poa, Map policy_overrides) {
        if (!_transient && this.useImR && this.useImREndpoint) {
            IOR ior = this.createIOR(repId, objectKey, poa.getImREndpoints());
            if (this.imrProxyAddress != null) {
                for (int i2 = 0; i2 < ior.profiles.length; ++i2) {
                    if (ior.profiles[i2].tag != 0) continue;
                    IIOPProfile profile = new IIOPProfile(ior.profiles[i2].profile_data);
                    try {
                        profile.configure(this.configuration);
                    }
                    catch (ConfigurationException e2) {
                        this.logger.error("Unexpected configuration exception during IOR with ImR endpoints creation", e2);
                    }
                    profile.patchPrimaryAddress(this.imrProxyAddress);
                    ior.profiles[i2] = profile.asTaggedProfile();
                }
            }
            return ior;
        }
        ArrayList profiles = new ArrayList();
        HashMap componentMap = new HashMap();
        this.getProfiles(poa, policy_overrides, componentMap, profiles);
        TaggedProfile[] tps = new TaggedProfile[profiles.size()];
        TaggedComponentSeqHolder tc = new TaggedComponentSeqHolder();
        TaggedProfileHolder tp = new TaggedProfileHolder();
        for (int i3 = 0; i3 < profiles.size(); ++i3) {
            Profile p2 = (Profile)profiles.get(i3);
            p2.set_object_key(objectKey);
            TaggedComponentList c2 = (TaggedComponentList)componentMap.get(ObjectUtil.newInteger(p2.tag()));
            tc.value = c2.asArray();
            p2.marshal(tp, tc);
            tps[i3] = tp.value;
        }
        profiles.clear();
        componentMap.clear();
        componentMap = null;
        profiles = null;
        return new IOR(repId, tps);
    }

    public void getProfiles(org.jacorb.poa.POA poa, Map policy_overrides, Map componentMap, List profiles) {
        IIOPProfile iiopProfile;
        TaggedComponentList multipleComponents;
        block8: {
            int[] profileTags = new int[this.basicAdapter.getEndpointProfiles().size()];
            int n2 = 0;
            Iterator i2 = this.basicAdapter.getEndpointProfiles().iterator();
            while (i2.hasNext()) {
                Profile profile = (Profile)i2.next();
                if (profile instanceof MIOPProfile) continue;
                profiles.add(profile);
                profileTags[n2++] = profile.tag();
                TaggedComponentList profileComponents = new TaggedComponentList();
                profileComponents.addComponent(this.create_ORB_TYPE_ID());
                componentMap.put(ObjectUtil.newInteger(profile.tag()), profileComponents);
                if (!(profile instanceof ProfileBase)) continue;
                if (this.passIORComponent) {
                    profileComponents.addAll(((ProfileBase)profile).getComponents());
                }
                this.patchAddress((ProfileBase)profile);
                if (!poa.isSSLRequired()) continue;
                ((ProfileBase)profile).patchPrimaryAddress(null);
            }
            multipleComponents = new TaggedComponentList();
            componentMap.put(ObjectUtil.newInteger(1), multipleComponents);
            if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
                IORInfoImpl info = new IORInfoImpl(this, poa, componentMap, policy_overrides, profiles);
                this.interceptor_manager.setProfileTags(profileTags);
                try {
                    this.interceptor_manager.getIORIterator().iterate(info);
                }
                catch (Exception e2) {
                    if (!this.logger.isErrorEnabled()) break block8;
                    this.logger.error(e2.getMessage());
                }
            }
        }
        if ((iiopProfile = this.findIIOPProfile(profiles)) != null && (this.giopMinorVersion == 0 || this.giopAdd_1_0_Profiles)) {
            IIOPProfile profile_1_0 = iiopProfile.to_GIOP_1_0();
            profiles.add(profile_1_0);
            TaggedComponentList iiopComponents = (TaggedComponentList)componentMap.get(ObjectUtil.newInteger(0));
            multipleComponents.addAll(iiopProfile.getComponents());
            multipleComponents.addAll(iiopComponents);
            if (this.giopMinorVersion == 0) {
                profiles.remove(iiopProfile);
            }
        }
        if (!multipleComponents.isEmpty()) {
            profiles.add(new MultipleComponentProfile(multipleComponents));
        }
    }

    public IOR createIOR(String repId, byte[] objectKey, EndpointProfile[] endpoints) {
        TaggedProfile[] tps = new TaggedProfile[endpoints.length];
        for (int i2 = 0; i2 < endpoints.length; ++i2) {
            CDROutputStream profileDataStream = new CDROutputStream(this);
            switch (endpoints[i2].encapsulation) {
                case 2: {
                    profileDataStream.write_octet_array(endpoints[i2].addressProfile, 0, endpoints[i2].addressProfile.length);
                    break;
                }
                case 0: {
                    int j2;
                    profileDataStream.write_octet_array(endpoints[i2].addressProfile, 0, endpoints[i2].addressProfile.length);
                    profileDataStream.write_long(objectKey.length);
                    profileDataStream.write_octet_array(objectKey, 0, objectKey.length);
                    profileDataStream.write_long(endpoints[i2].taggedComponents.length);
                    for (j2 = 0; j2 < endpoints[i2].taggedComponents.length; ++j2) {
                        TaggedComponentHelper.write(profileDataStream, endpoints[i2].taggedComponents[j2]);
                    }
                    break;
                }
                case 1: {
                    int j2;
                    profileDataStream.write_octet_array(endpoints[i2].addressProfile, 0, endpoints[i2].addressProfile.length);
                    profileDataStream.write_long(this.swap4Byte(objectKey.length));
                    profileDataStream.write_octet_array(objectKey, 0, objectKey.length);
                    profileDataStream.write_long(this.swap4Byte(endpoints[i2].taggedComponents.length));
                    for (j2 = 0; j2 < endpoints[i2].taggedComponents.length; ++j2) {
                        profileDataStream.write_ulong(this.swap4Byte(endpoints[i2].taggedComponents[j2].tag));
                        profileDataStream.write_long(this.swap4Byte(endpoints[i2].taggedComponents[j2].component_data.length));
                        profileDataStream.write_octet_array(endpoints[i2].taggedComponents[j2].component_data, 0, endpoints[i2].taggedComponents[j2].component_data.length);
                    }
                    break;
                }
            }
            tps[i2] = new TaggedProfile(endpoints[i2].tag, profileDataStream.getBufferCopy());
        }
        return new IOR(repId, tps);
    }

    private int swap4Byte(int toSwap) {
        return ((toSwap & 0xFF) << 24) + ((toSwap & 0xFF00) << 8) + ((toSwap & 0xFF0000) >> 8) + (toSwap >> 24 & 0xFF);
    }

    private IIOPProfile findIIOPProfile(List profiles) {
        Iterator i2 = profiles.iterator();
        while (i2.hasNext()) {
            Profile p2 = (Profile)i2.next();
            if (!(p2 instanceof IIOPProfile)) continue;
            return (IIOPProfile)p2;
        }
        return null;
    }

    public Context get_default_context() {
        this.work_pending();
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = new Current();
        }
        return this.poaCurrent;
    }

    public Object getReference(org.jacorb.poa.POA poa, byte[] object_key, String rep_id, boolean _transient) {
        IOR ior = this.createIOR(rep_id == null ? "IDL:omg.org/CORBA/Object:1.0" : rep_id, object_key, _transient, poa, null);
        if (ior == null && this.logger.isErrorEnabled()) {
            this.logger.error("Interal error: createIOR returns null");
        }
        Delegate delegate = new Delegate(this, ior);
        return delegate.getReference(poa);
    }

    public org.jacorb.poa.POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = org.jacorb.poa.POA._POA_init(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.getTransportManager(), this.getGIOPConnectionManager());
            try {
                this.rootpoa.configure(this.configuration);
                this.basicAdapter.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INITIALIZE("ConfigurationException: " + ce.toString());
            }
            this.rootpoa._addPOAEventListener(this);
        }
        return this.rootpoa;
    }

    public boolean isIMR() {
        return this.isImR;
    }

    public boolean useIMR() {
        return this.useImR;
    }

    private boolean findImR() {
        Repository newImR;
        block13: {
            newImR = null;
            try {
                newImR = RepositoryHelper.narrow(this.resolve_initial_references("ImplementationRepository"));
            }
            catch (InvalidName e2) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Failed to resolve initial references for the Implementation Repository");
                }
            }
            catch (Exception e3) {
                if (!this.logger.isInfoEnabled()) break block13;
                this.logger.info("Failed to resolve initial references for the Implementation Repository");
            }
        }
        if (newImR != null && newImR._non_existent()) {
            newImR = null;
        }
        if (newImR == null && this.rootpoa != null) {
            try {
                if (this.locator == null) {
                    this.locator = new IMRLocator(this);
                }
                this.locator.findIMRs();
                List retrievedIMRs = this.locator.getIMRs();
                for (int i2 = 0; i2 < retrievedIMRs.size() && newImR == null; ++i2) {
                    try {
                        newImR = RepositoryHelper.narrow((Object)retrievedIMRs.get(i2));
                        if (newImR == null || this.isImRAlive(newImR)) continue;
                        newImR = null;
                        continue;
                    }
                    catch (Exception e4) {
                        this.logger.warn("findIMR: An exception occured during ImR validation", e4);
                        newImR = null;
                    }
                }
            }
            catch (Exception e5) {
                this.logger.error("IMRLocator got an exception finding ImRs", e5);
                newImR = null;
            }
        }
        if (newImR != null) {
            this.imr = newImR;
            return true;
        }
        return false;
    }

    private boolean isImRAlive(Repository imr) {
        try {
            long serverID = -1L;
            if (this.getImRServerImpl() != null) {
                serverID = this.getImRServerImpl().id();
                imr.ping(serverID);
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public String[] list_initial_services() {
        this.work_pending();
        ArrayList list = new ArrayList(this.initial_references.size() + services.size());
        list.addAll(services);
        list.addAll(this.initial_references.keySet());
        return list.toArray(new String[list.size()]);
    }

    public void poaCreated(org.jacorb.poa.POA poa) {
        poa._addPOAEventListener(this);
        if (poa.isPersistent()) {
            ++this.persistentPOACount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getImR() {
        java.lang.Object[] objectArray = this.imrUpdateLock;
        synchronized (this.imrUpdateLock) {
            if (this.imr == null) {
                try {
                    this.findImR();
                }
                catch (INTERNAL e2) {
                    this.logger.warn("unexpected exception during getImR", e2);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.imr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imrDead(Repository corpse) {
        java.lang.Object[] objectArray = this.imrUpdateLock;
        synchronized (this.imrUpdateLock) {
            if (corpse != null && !this.imrsEqual(this.imr, corpse)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            boolean result = this.findImR();
            if (result && this.rootpoa != null && !POAUtil.isHolding(this.rootpoa.the_POAManager().get_state())) {
                try {
                    this.rootpoa.reRegisterWithImR();
                }
                catch (Exception e2) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Failed to re-register persistent POAs with a new ImR");
                    }
                    result = false;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected boolean imrsEqual(Repository imr1, Repository imr2) {
        return imr1 == imr2;
    }

    public Server getActiveServerHandler() {
        if (this.activeServerHandler == null) {
            this.imrServerImpl = new ServerImpl(this);
            this.imrServerImpl.heartbeat(this.imrHeartbeat);
            this.activeServerHandler = this.imrServerImpl.installOnRootPOA();
        }
        return this.activeServerHandler;
    }

    public ServerImpl getImRServerImpl() {
        return this.imrServerImpl;
    }

    private void patchAddress(ProfileBase profile) {
        profile.patchPrimaryAddress(this.iorProxyAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream out = new CDROutputStream(this);
        try {
            out.beginEncapsulatedArray();
            out.write_long(1245790976);
            TaggedComponent taggedComponent = new TaggedComponent(0, out.getBufferCopy());
            return taggedComponent;
        }
        finally {
            out.close();
        }
    }

    public void poaStateChanged(org.jacorb.poa.POA poa, int new_state) {
        if ((new_state == 4 || new_state == 3) && poa.isPersistent()) {
            --this.persistentPOACount;
        }
    }

    public void referenceCreated(Object o2) {
    }

    public boolean get_service_information(short service_type, ServiceInformationHolder service_information) {
        throw new NO_IMPLEMENT();
    }

    public Object resolve_initial_references(String identifier) throws InvalidName {
        this.work_pending();
        if (this.initial_references.containsKey(identifier)) {
            return (Object)this.initial_references.get(identifier);
        }
        Object obj = this.resolveConfigInitRef(identifier);
        if (obj == null) {
            if ("RootPOA".equals(identifier)) {
                return this.getRootPOA();
            }
            if ("POACurrent".equals(identifier)) {
                return this.getPOACurrent();
            }
            if ("SecurityCurrent".equals(identifier)) {
                throw new InvalidName("Level2 SecurityImplementation has been removed");
            }
            if ("DynAnyFactory".equals(identifier)) {
                obj = new DynAnyFactoryImpl(this);
            } else {
                if ("PICurrent".equals(identifier)) {
                    return this.piCurrent;
                }
                if ("ORBPolicyManager".equals(identifier)) {
                    if (this.policyManager == null) {
                        this.policyManager = new PolicyManager(this.getConfiguration());
                    }
                    return this.policyManager;
                }
                if ("CodecFactory".equals(identifier)) {
                    obj = new CodecFactoryImpl(this);
                } else if ("RTORB".equals(identifier)) {
                    obj = this.getRTORB();
                } else {
                    if (this.defaultInitRef != null) {
                        return this.string_to_object(this.defaultInitRef + "/" + identifier);
                    }
                    throw new InvalidName();
                }
            }
        }
        if (obj != null) {
            this.initial_references.put(identifier, obj);
        }
        return obj;
    }

    private Object resolveConfigInitRef(String identifier) throws InvalidName {
        String url = this.configuration.getAttribute("ORBInitRef." + identifier, null);
        if (url == null) {
            return null;
        }
        try {
            return this.string_to_object(url);
        }
        catch (Exception e2) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create initial reference for \"" + identifier + "\"\n" + "Please check property \"ORBInitRef." + identifier + '\"', e2);
            }
            throw new InvalidName();
        }
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    private synchronized RTORB getRTORB() {
        if (this.rtORB == null) {
            this.rtORB = new RTORB(this);
        }
        return this.rtORB;
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        this.work_pending();
        if (id == null || id.length() == 0) {
            throw new InvalidName("invalid name: the id may not be null or have zero length.");
        }
        if (this.initial_references.containsKey(id) || services.contains(id)) {
            throw new InvalidName("invalid name: the name " + id + " is already registered");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + id);
        }
        this.initial_references.put(id, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        java.lang.Object object = this.runSync;
        synchronized (object) {
            try {
                while (this.run) {
                    this.runSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] req) {
        this.work_pending();
        for (int i2 = 0; i2 < req.length; ++i2) {
            req[i2].send_oneway();
        }
    }

    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] req) {
        this.work_pending();
        for (int i2 = 0; i2 < req.length; ++i2) {
            req[i2].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll_next_response() {
        this.work_pending();
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Iterator iter = this.requests.iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                if (!req.poll_response()) continue;
                this.request = req;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request get_next_response() {
        this.work_pending();
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request req = null;
            if (this.request != null) {
                this.request.get_response();
                req = this.request;
                this.request = null;
                return req;
            }
            block3: while (true) {
                Iterator iter = this.requests.iterator();
                do {
                    if (!iter.hasNext()) continue block3;
                } while (!(req = (Request)iter.next()).poll_response());
                break;
            }
            req.get_response();
            return req;
        }
    }

    public void addRequest(org.omg.CORBA.Request req) {
        this.requests.add(req);
    }

    public void removeRequest(org.omg.CORBA.Request req) {
        this.requests.remove(req);
    }

    protected void set_parameters(String[] args, Properties props) {
        try {
            this.configure(JacORBConfiguration.getConfiguration(props, this, false));
        }
        catch (ConfigurationException e2) {
            this.logger.error("error during configuration", e2);
            throw new INITIALIZE(e2.getMessage());
        }
        if (args != null) {
            this.arguments = args;
            for (int i2 = 0; i2 < args.length; ++i2) {
                String propertyValue;
                String propertyName;
                String arg = args[i2].trim();
                if (!arg.startsWith("-ORB")) continue;
                if ((arg = arg.substring(1)).equals("ORBDefaultInitRef")) {
                    this.defaultInitRef = args[++i2].trim();
                    continue;
                }
                int equals_pos = arg.indexOf(61);
                if (equals_pos == -1) {
                    String prop;
                    if (arg.indexOf(46) >= 0) {
                        throw new BAD_PARAM("-ORBInitRef.xxx yyy is not a valid format. Use -ORBInitRef name=value");
                    }
                    if (i2 + 1 >= args.length) {
                        throw new BAD_PARAM("Invalid ORBInitRef format: -ORB<option> argument without value");
                    }
                    if ((equals_pos = (prop = args[++i2].trim()).indexOf(61)) < 0) {
                        if (arg.equals("ORBInitRef")) {
                            throw new BAD_PARAM("Invalid ORBInitRef format -ORBInitRef " + prop + ". it should be -ORBInitRef name=value.");
                        }
                        propertyName = arg;
                        propertyValue = prop;
                    } else {
                        propertyName = arg + "." + prop.substring(0, equals_pos);
                        propertyValue = prop.substring(equals_pos + 1);
                        if (propertyValue.length() == 0) {
                            throw new BAD_PARAM("Invalid ORBInitRef format: -ORBInitRef name=value. value may not be omitted.");
                        }
                    }
                } else {
                    propertyName = arg.substring(0, equals_pos);
                    propertyValue = arg.substring(equals_pos + 1);
                    if (propertyValue.length() == 0) {
                        throw new BAD_PARAM("Invalid ORBInitRef format: -ORBInitRef name=value. value may not be omitted.");
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("adding attribute " + propertyName + "=" + propertyValue);
                }
                this.configuration.setAttribute(propertyName, propertyValue);
            }
        }
        this.internalInit();
    }

    protected void set_parameters(Applet app, Properties props) {
        try {
            this.configure(JacORBConfiguration.getConfiguration(props, this, true));
        }
        catch (ConfigurationException e2) {
            this.logger.error("error during configuration", e2);
            throw new INITIALIZE(e2.getMessage());
        }
        this.internalInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInit() {
        this.inORBInitializer = true;
        try {
            List orb_initializers = this.getORBInitializers();
            ORBInitInfoImpl initInfo = new ORBInitInfoImpl(this);
            this.interceptorPreInit(orb_initializers, initInfo);
            this.initClientConnectionManager();
            if (this.cacheReferences) {
                this.initKnownReferencesMap();
            }
            this.interceptorPostInit(orb_initializers, initInfo);
            this.internalInit(initInfo);
        }
        finally {
            this.inORBInitializer = false;
        }
    }

    private void initClientConnectionManager() {
        try {
            this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
            this.clientConnectionManager.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.fatalError("unexpected exception", ce);
            throw new INTERNAL(ce.toString());
        }
    }

    private void initKnownReferencesMap() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Property \"jacorb.hashtable_class\" is set to: " + this.hashTableClassName);
        }
        try {
            this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
        }
        catch (Exception e2) {
            this.logger.fatalError("unable to create known references map", e2);
            throw new INTERNAL(e2.toString());
        }
    }

    private void internalInit(ORBInitInfoImpl info) {
        info.setInvalid();
        List client_interceptors = info.getClientInterceptors();
        List server_interceptors = info.getServerInterceptors();
        List ior_intercept = info.getIORInterceptors();
        this.hasClientInterceptors = !client_interceptors.isEmpty();
        boolean bl = this.hasServerInterceptors = !server_interceptors.isEmpty();
        if (this.hasClientInterceptors || this.hasServerInterceptors || !ior_intercept.isEmpty()) {
            this.interceptor_manager = new InterceptorManager(client_interceptors, server_interceptors, ior_intercept, info.getSlotCount(), this);
        }
        this.policy_factories.putAll(info.getPolicyFactories());
    }

    private void interceptorPreInit(List orb_initializers, ORBInitInfo info) {
        Iterator i2 = orb_initializers.iterator();
        while (i2.hasNext()) {
            ORBInitializer initializer = (ORBInitializer)i2.next();
            try {
                initializer.pre_init(info);
            }
            catch (Exception e2) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(initializer.getClass().getName() + ": aborting due to error during ORBInitializer::pre_init", e2);
                    throw new INITIALIZE(e2.toString());
                }
                this.logger.warn(initializer.getClass().getName() + ": ignoring error during ORBInitializer::pre_init. the ORBInitializer will be removed from the current configuration", e2);
                i2.remove();
            }
        }
    }

    private void interceptorPostInit(List orb_initializers, ORBInitInfo info) {
        Iterator i2 = orb_initializers.iterator();
        while (i2.hasNext()) {
            ORBInitializer initializer = (ORBInitializer)i2.next();
            try {
                initializer.post_init(info);
            }
            catch (Exception e2) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(initializer.getClass().getName() + ": aborting due to error during ORBInitializer::pre_init", e2);
                    throw new INITIALIZE(e2.toString());
                }
                this.logger.warn(initializer.getClass().getName() + ": ignoring error during ORBInitializer::pre_init. the ORBInitializer will be removed from the current configuration", e2);
            }
        }
    }

    private List getORBInitializers() {
        ArrayList orb_initializers = new ArrayList();
        String initializer_prefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
        List prop_names = this.configuration.getAttributeNamesWithPrefix("org.omg.PortableInterceptor.ORBInitializerClass.");
        Iterator i2 = prop_names.iterator();
        while (i2.hasNext()) {
            String prop_name = (String)i2.next();
            String name = this.configuration.getAttribute(prop_name, "");
            if (name.length() == 0 && prop_name.length() > "org.omg.PortableInterceptor.ORBInitializerClass.".length()) {
                name = prop_name.substring("org.omg.PortableInterceptor.ORBInitializerClass.".length());
            }
            if (name == null) continue;
            try {
                java.lang.Object newInstance = ObjectUtil.classForName(name).newInstance();
                if (newInstance instanceof ORBInitializer) {
                    orb_initializers.add(newInstance);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("added ORBInitializer: " + name);
                    continue;
                }
                if (this.failOnORBInitializerError) {
                    this.logger.error("aborting due to wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
                    throw new BAD_PARAM("Wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
                }
                this.logger.warn("ignoring wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
            }
            catch (Exception e2) {
                if (this.failOnORBInitializerError) {
                    this.logger.error("unable to build ORBInitializer from class " + name + ": Aborting", e2);
                    throw new INITIALIZE(e2.toString());
                }
                this.logger.warn("unable to build ORBInitializer from class " + name + ": Ignoring");
            }
        }
        return orb_initializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait_for_completion) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.shutdown_in_progress && !wait_for_completion) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB is already shutting down.");
                }
                return;
            }
            while (this.shutdown_in_progress) {
                try {
                    this.shutdown_synch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.shutdown_in_progress = true;
        }
        if (!this.isRunning()) {
            object = this.shutdown_synch;
            synchronized (object) {
                this.shutdown_in_progress = false;
                this.shutdown_synch.notifyAll();
            }
            return;
        }
        this.logger.info("ORB going down...");
        if (this.useImR && this.imr != null) {
            try {
                if (this.getImRServerImpl() != null) {
                    this.getImRServerImpl().heartbeat(0);
                    this.imr.deregisterAll(this.getImRServerImpl().id());
                }
            }
            catch (NotFound e2) {
                this.logger.error("Internal Error - while shutting down caught ", e2);
            }
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, wait_for_completion);
            this.rootpoa = null;
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.giop_connection_manager != null) {
            this.giop_connection_manager.shutdown(wait_for_completion);
        }
        this.clientConnectionManager.shutdown();
        if (this.cacheReferences) {
            this.knownReferences.clear();
        }
        this.bufferManager.release();
        this.poolManagerFactory.destroy(wait_for_completion);
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        object = this.runSync;
        synchronized (object) {
            this.run = false;
            this.runSync.notifyAll();
        }
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_in_progress = false;
            this.shutdown_synch.notifyAll();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        java.lang.Object object = this.runSync;
        synchronized (object) {
            if (this.run) {
                this.shutdown(true);
            }
        }
        this.destroyed = true;
    }

    public Object string_to_object(String str) {
        this.work_pending();
        if (str == null) {
            return null;
        }
        try {
            ParsedIOR pior = new ParsedIOR(this, str);
            if (pior.isNull()) {
                return null;
            }
            return this._getDelegate(pior);
        }
        catch (Exception e2) {
            this.logger.error("error during string_to_object", e2);
            throw new BAD_PARAM(e2.toString(), 10, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object get_value_def(String repid) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object wrapper) {
        if (!(wrapper instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)wrapper)._get_delegate();
        }
        catch (BAD_INV_ORDER bio) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate(delegate);
        }
        if (((Servant)wrapper)._get_delegate().orb((Servant)wrapper) != this) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate(delegate);
        }
    }

    public String object_to_string(Object obj) {
        this.work_pending();
        if (obj == null) {
            return nullIORString;
        }
        if (obj instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)obj)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public void perform_work() {
        this.work_pending();
    }

    public boolean work_pending() {
        if (!this.isRunning()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ORB has been shutdown");
            }
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public synchronized ValueFactory register_value_factory(String id, ValueFactory factory) {
        return this.valueFactories.put(id, factory);
    }

    public synchronized void unregister_value_factory(String id) {
        this.valueFactories.remove(id);
    }

    public synchronized ValueFactory lookup_value_factory(String id) {
        ValueFactory result = (ValueFactory)this.valueFactories.get(id);
        if (result == null && id.startsWith("IDL")) {
            String valueName = RepositoryID.className(id, null);
            result = this.findValueFactory(valueName);
            this.valueFactories.put(id, result);
        }
        return result;
    }

    private ValueFactory findValueFactory(String valueName) {
        Class result = this.findClass(valueName + "DefaultFactory", true);
        if (result != null) {
            return (ValueFactory)this.instantiate(result);
        }
        Class clazz = this.findClass(valueName, false);
        result = this.findClass(valueName + "Impl", false);
        if (result != null && clazz.isAssignableFrom(result)) {
            if (ValueFactory.class.isAssignableFrom(result)) {
                return (ValueFactory)this.instantiate(result);
            }
            return new JacORBValueFactory(result);
        }
        return null;
    }

    private Class findClass(String name, boolean orgomg) {
        Class result;
        block4: {
            result = null;
            try {
                result = ObjectUtil.classForName(name);
            }
            catch (ClassNotFoundException e2) {
                if (!orgomg || !name.startsWith("org.omg")) break block4;
                try {
                    result = ObjectUtil.classForName("omg.org" + name.substring(7));
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e2) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException e3) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public BoxedValueHelper getBoxedValueHelper(String repId) {
        BoxedValueHelper result = (BoxedValueHelper)this.boxedValueHelpers.get(repId);
        if (result == null) {
            if (this.boxedValueHelpers.containsKey(repId)) {
                return null;
            }
            result = RepositoryID.createBoxedValueHelper(repId, null);
            this.boxedValueHelpers.put(repId, result);
        }
        return result;
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
            try {
                this.transport_manager.configure(this.configuration);
            }
            catch (ConfigurationException e2) {
                throw new INITIALIZE(e2.toString());
            }
        }
        return this.transport_manager;
    }

    public org.omg.CORBA.ExceptionList create_exception_list() {
        this.work_pending();
        return new ExceptionList();
    }

    public org.omg.CORBA.NVList create_list(int count) {
        this.work_pending();
        return new NVList(this, count);
    }

    public org.omg.CORBA.NamedValue create_named_value(String name, Any value, int flags) {
        this.work_pending();
        return new NamedValue(name, value, flags);
    }

    public org.omg.CORBA.NVList create_operation_list(Object obj) {
        this.work_pending();
        if (!(obj instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef oper = (OperationDef)obj;
        return this.create_operation_list(oper);
    }

    public org.omg.CORBA.NVList create_operation_list(OperationDef oper) {
        int no = 0;
        this.work_pending();
        ParameterDescription[] params = oper.params();
        if (params != null) {
            no = params.length;
        }
        NVList list = new NVList(this, no);
        block5: for (int i2 = 0; i2 < no; ++i2) {
            ParameterDescription param = params[i2];
            Any any = this.create_any();
            any.type(param.type);
            switch (param.mode.value()) {
                case 0: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 1);
                    continue block5;
                }
                case 1: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 2);
                    continue block5;
                }
                case 2: {
                    ((org.omg.CORBA.NVList)list).add_value(param.name, any, 3);
                    continue block5;
                }
                default: {
                    throw new BAD_PARAM("Invalid value for ParamaterMode");
                }
            }
        }
        return list;
    }

    private void configureObjectKeyMap(Configuration config) {
        org.jacorb.config.Configuration configuration = (org.jacorb.config.Configuration)config;
        this.objectKeyMap.configureObjectKeyMap(configuration);
    }

    public void addObjectKey(String key_name, String full_path) {
        this.objectKeyMap.addObjectKey(key_name, full_path);
    }

    public void addObjectKey(String key_name, Object target) {
        this.objectKeyMap.addObjectKey(key_name, target);
    }

    public byte[] mapObjectKey(byte[] originalKey) {
        return this.objectKeyMap.mapObjectKey(originalKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunning() {
        java.lang.Object object = this.runSync;
        synchronized (object) {
            return this.run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object obj) {
        this.work_pending();
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("connect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("connect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            if (!this.connectedObjects.containsKey(obj)) {
                ObjectImpl objectImpl = (ObjectImpl)obj;
                HandlerWrapper servant = new HandlerWrapper(objectImpl);
                Object ref = servant._this_object(this);
                objectImpl._set_delegate(((ObjectImpl)ref)._get_delegate());
                this.connectedObjects.put(obj, servant);
                if (this.firstConnection) {
                    this.firstConnection = false;
                    POAManager rootPOAManager = this.getRootPOA().the_POAManager();
                    if (rootPOAManager.get_state() == State.HOLDING) {
                        try {
                            rootPOAManager.activate();
                        }
                        catch (AdapterInactive e2) {
                            this.logger.fatalError("unexpected exception", e2);
                            throw new INTERNAL(e2.toString());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Object obj) {
        this.work_pending();
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("disconnect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("disconnect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            Servant servant = (Servant)this.connectedObjects.get(obj);
            if (servant != null) {
                this.connectedObjects.remove(obj);
                try {
                    this.getRootPOA().deactivate_object(this.getRootPOA().servant_to_id(servant));
                }
                catch (Exception e2) {
                    this.logger.fatalError("unexpected exception", e2);
                    throw new INTERNAL(e2.toString());
                }
            }
        }
    }

    public String getServerIdString() {
        return this.serverIdStr;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public RPPoolManager newRPPoolManager(boolean isSingleThreaded) {
        return this.poolManagerFactory.newRPPoolManager(isSingleThreaded);
    }

    public String getImplName() {
        return this.implName;
    }

    public void notifyTransportListeners(GIOPConnection gc) {
        this.transport_manager.notifyTransportListeners(gc);
    }

    public boolean isIOGR(IOR ior) {
        return this.iogrFactory.isIOGR(ior);
    }

    public String[] getArgs() {
        return this.arguments;
    }

    public int getGIOPMinorVersion() {
        return this.giopMinorVersion;
    }

    static class HandlerWrapper
    extends Servant
    implements InvokeHandler {
        private final InvokeHandler wrappedHandler;

        public HandlerWrapper(ObjectImpl objectImpl) {
            this.wrappedHandler = (InvokeHandler)((java.lang.Object)objectImpl);
        }

        public String[] _all_interfaces(POA poa, byte[] objectID) {
            return ((ObjectImpl)((java.lang.Object)this.wrappedHandler))._ids();
        }

        public OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream input, ResponseHandler handler) throws SystemException {
            return this.wrappedHandler._invoke(method, input, handler);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                if (ORB.this.inORBInitializer) {
                    throw new BAD_INV_ORDER("set_slot/get_slot may not be invoked from within an ORB initializer", 10, CompletionStatus.COMPLETED_NO);
                }
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int id) throws InvalidSlot {
            return this.getTarget().get_slot(id);
        }

        public void set_slot(int id, Any data) throws InvalidSlot {
            this.getTarget().set_slot(id, data);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private final Class implementationClass;

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }

        public Serializable read_value(InputStream is) {
            java.lang.Object implObj = ORB.this.instantiate(this.implementationClass);
            if (implObj instanceof Streamable) {
                StreamableValue value = (StreamableValue)ORB.this.instantiate(this.implementationClass);
                return is.read_value(value);
            }
            if (implObj instanceof CustomValue) {
                ((CustomValue)implObj).unmarshal(new DataInputStream(is));
                return (CustomValue)implObj;
            }
            throw new MARSHAL("Unknown Value type " + implObj);
        }
    }
}

