/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.util.Arrays;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.typecode.TypeCodeCache;

public abstract class AbstractTypeCodeCache
implements TypeCodeCache,
Configurable {
    protected final Map cache = this.newCache();
    private Logger logger;

    protected abstract Map newCache();

    public void cacheTypeCode(String repositoryID, TypeCodeCache.Pair[] entries) {
        TypeCodeCache.Pair[] copy = this.copy(entries);
        this.put(repositoryID, copy);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put into cache: " + repositoryID + " => " + Arrays.asList(copy));
        }
    }

    protected abstract void put(String var1, TypeCodeCache.Pair[] var2);

    public TypeCodeCache.Pair[] getCachedTypeCodes(String repositoryID) {
        TypeCodeCache.Pair[] fromCache = (TypeCodeCache.Pair[])this.cache.get(repositoryID);
        if (fromCache == null) {
            return null;
        }
        TypeCodeCache.Pair[] copy = this.copy(fromCache);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("cache hit: " + repositoryID + " => " + Arrays.asList(copy));
        }
        return copy;
    }

    private TypeCodeCache.Pair[] copy(TypeCodeCache.Pair[] fromCache) {
        TypeCodeCache.Pair[] copy = new TypeCodeCache.Pair[fromCache.length];
        for (int i2 = 0; i2 < fromCache.length; ++i2) {
            copy[i2] = fromCache[i2];
        }
        return copy;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.cdr");
    }
}

