/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.delete;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.delete.RemoverException;
import se.ericsson.cello.configurationversion.file.base.FilePath;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutingBlockingActionEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.DeletingCV_Event;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.storedconfigurationversions.CV_RemovedEvent;
import se.ericsson.cello.configurationversion.main.exception.CVDeleteNotAllowedException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeRollbackListHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStartableConfigurationVersionHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStoredConfigurationVersionsHandler;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.configurationversion.verify.base.VerifyProperties;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class Remover
extends CV_SubFunctionController {
    public Remover(boolean bl) {
        super(bl);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Remover(boolean anIsActivityEventsToBeSent)", "anIsActivityEventsToBeSent: " + bl);
        }
    }

    public Remover() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Remover( )");
        }
    }

    public void remove(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "remove(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            try {
                this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new DeletingCV_Event(this));
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutingBlockingActionEvent(this));
                this.verifyThatRemovalOfCV_IsAllowed(string);
                this.sendOsaCvDeleteCvReq(string);
                this.deleteCMA_CV_DiskFiles(string);
                this.handlePreUpgradedCV_UP_Relation(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.StoredConfigurationVersions, new CV_RemovedEvent(this, string));
            }
            catch (ConfigurationVersionException configurationVersionException) {
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw configurationVersionException;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "remove(String aCV_Name)", "\n\taCV_Name: " + string + "\n\tThrowable caught.", throwable);
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw new RemoverException("Class name: " + this.getClass().getName() + "\n\tremove(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            throw throwable;
        }
        this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
    }

    private void handlePreUpgradedCV_UP_Relation(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "handlePreUpgradedCV_UP_Relation(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            CV_PreUpgradeRelationHandler.getInstance().removeCV(string);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handlePreUpgradedCV_UP_Relation(UpgradePackageMo aCurrentUpgradePackageMo, String aCV_Name)", "Throwable caught", throwable);
            throw new ConfigurationVersionException(throwable.toString());
        }
    }

    private void checkResult(int n) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkResult(int aResult)", "aResult: " + n);
        }
        if (n != 0) {
            SignalHandler signalHandler = new SignalHandler();
            signalHandler.checkResult(n);
        }
    }

    private void concistencyCheck() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "concistencyCheck()");
        }
        try {
            CV_AttributeStoredConfigurationVersionsHandler cV_AttributeStoredConfigurationVersionsHandler = new CV_AttributeStoredConfigurationVersionsHandler();
            Collection collection = cV_AttributeStoredConfigurationVersionsHandler.getCV_Names();
            VerifyProperties verifyProperties = new VerifyProperties();
            String string = verifyProperties.cvCMA_FileDisk + verifyProperties.getCV_CMA_CV_Path();
            File file = new File(string);
            File[] fileArray = null;
            TreeSet<String> treeSet = new TreeSet<String>();
            fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    treeSet.add(fileArray[i].getName());
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "concistencyCheck()", "Node CVs: " + collection + "\n\tCVs on CMA level: " + treeSet);
            }
            Iterator iterator = collection.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                treeSet.remove(string2);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "concistencyCheck()", "Inconsistent CVs (exist on CMA level but not on Node): " + treeSet);
            }
            Iterator iterator2 = treeSet.iterator();
            String string3 = null;
            while (iterator2.hasNext()) {
                string3 = (String)iterator2.next();
                this.deleteCMA_CV_DiskFiles(string3);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "concistencyCheck()", "Throwable caught." + throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tconcistencyCheck()" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void deleteCMA_CV_DiskFiles(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteCMA_CV_DiskFiles(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            VerifyProperties verifyProperties = new VerifyProperties();
            String string2 = verifyProperties.cvCMA_FileDisk + verifyProperties.getCV_CMA_CV_Path() + "/" + string;
            FilePath filePath = new FilePath();
            filePath.removeFilesInDirectory(string2);
            File file = new File(string2);
            if (file.exists() && !file.delete()) {
                Trace.warning(this.getClass(), "deleteCreatedFiles(String aCV_Name)", "Failed to delete the directory: " + string2 + "\n\taCV_Name: " + string);
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteCreatedFiles(String aCV_Name)", "aCV_Name: " + string + "\n\tNo directory did exist on CMA level for this CV.");
            }
            this.concistencyCheck();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteCMA_CV_DiskFiles(String aCV_Name)", "Throwable caught.\n\taCV_Name: " + string + throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tdeleteCMA_CV_DiskFiles(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void sendOsaCvDeleteCvReq(String string) throws FroNotAccessibleException, ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaCvDeleteCvReq(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            int n = osaCvMgmntProxyAccess.sendOsaCvDeleteCvReq(string);
            this.checkResult(n);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvDeleteCvReq(String aCV_Name)", "ConfigurationVersionException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvDeleteCvReq(String aCV_Name)", "FroNotAccessibleException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + froNotAccessibleException.toString());
            }
            throw new RemoverException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvDeleteCvReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tFroNotAccessibleException caught." + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvDeleteCvReq(String aCV_Name)", "Throwable caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + throwable.toString());
            }
            throw new RemoverException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvDeleteCvReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void verifyThatRemovalOfCV_IsAllowed(String string) throws ConfigurationVersionException {
        CV_AttributeStartableConfigurationVersionHandler cV_AttributeStartableConfigurationVersionHandler;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatRemovalOfCV_IsAllowed(String aCV_Name)", "aCV_Name: " + string);
        }
        if ((cV_AttributeStartableConfigurationVersionHandler = new CV_AttributeStartableConfigurationVersionHandler()).isConfiguredAsStartable(string)) {
            throw new CVDeleteNotAllowedException("ConfigurationVersion", "The startable cv can't be deleted");
        }
        CV_AttributeRollbackListHandler cV_AttributeRollbackListHandler = new CV_AttributeRollbackListHandler();
        if (cV_AttributeRollbackListHandler.isConfiguredInRollbackList(string)) {
            throw new CVDeleteNotAllowedException("ConfigurationVersion", "The cv in rollbacklist can't be deleted");
        }
    }
}

