/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.nodeinformation.proxy;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.ApplicationConfigurationElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.ApplicationConfigurationSubElementName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.ApplicationDataElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.BackupRestoreInfoAttributeName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.BackupRestoreInfoElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeID_AttributeName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeID_Element;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationAttributeName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationRootElementName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationSubElementName;
import se.ericsson.cello.configurationversion.file.parser.XML_ParserFactory;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreRevisionAndIndex;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreRevisionAndIndexException;
import se.ericsson.cello.su.xmlparser.base.DomProxy;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class NodeInformationProxy
extends DomProxy {
    private NodeInformationElement myNodeInformationElement = null;

    public NodeInformationProxy(Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "NodeInformationProxy(Integer aVersionValue)", "aVersionValue: " + n);
        }
        this.myNodeInformationElement = new NodeInformationElement(n.toString());
    }

    public NodeInformationProxy(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "NodeInformationProxy(String aFilePathToNodeInformationFile, boolean aValidationIsRequested)", "aFilePathToNodeInformationFile: " + string);
        }
        String string2 = this.getNodeInformationFilePath(string);
        try {
            XML_RootElement xML_RootElement = XML_ParserFactory.instance().parseFile(string2, true);
            if (!(xML_RootElement instanceof NodeInformationElement)) {
                String string3 = "undefined";
                if (xML_RootElement != null) {
                    string3 = xML_RootElement.getClass().getName();
                }
                throw new ConfigurationVersionException("Illegal type of XML file given as input parameter,\n\tNodeInformationProxy(String aFilePathToNodeInformationFile, boolean aValidationIsRequested)\n\tGiven XML file: " + string + "\n\tRoot element type in this file: " + string3);
            }
            this.myNodeInformationElement = (NodeInformationElement)xML_RootElement;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "NodeInformationProxy(String aFilePathToNodeInformationFile, boolean aValidationIsRequested)", "Throwable caught.\n\taFilePathToNodeInformationFile: " + string, throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tNodeInformationProxy(String aFilePathToNodeInformationFile, boolean aValidationIsRequested)" + "\n\tThrowable caught." + "\n\taFilePathToNodeInformationFile: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void addApplicationData(String string, String string2) {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addApplicationData(String aName, String aValue)", "aName: " + string + "\n\taValue: " + string2);
        }
        if (this.myNodeInformationElement.getApplicationConfigurationElement() == null) {
            object = new ApplicationConfigurationElement();
            this.myNodeInformationElement.setApplicationConfigurationElement((ApplicationConfigurationElement)object);
        }
        object = this.myNodeInformationElement.getApplicationConfigurationElement().getApplicationDataElements();
        object.add(new ApplicationDataElement(string, string2));
        this.myNodeInformationElement.getApplicationConfigurationElement().setApplicationDataElements((Collection)object);
    }

    public HashMap getApplicationDatas() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getApplicationDatas( )");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.myNodeInformationElement.getApplicationConfigurationElement() != null) {
            Iterator iterator = this.myNodeInformationElement.getApplicationConfigurationElement().getApplicationDataElements().iterator();
            ApplicationDataElement applicationDataElement = null;
            while (iterator.hasNext()) {
                applicationDataElement = (ApplicationDataElement)iterator.next();
                hashMap.put(applicationDataElement.getName(), applicationDataElement.getValue());
            }
        }
        return hashMap;
    }

    public Enumer getApplicationDatasType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getApplicationDatasType( )");
        }
        return ApplicationConfigurationSubElementName.ApplicationData;
    }

    public String getFDN() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFDN()");
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            return null;
        }
        return this.myNodeInformationElement.getNodeID_Element().getFDN();
    }

    public Enumer getFDN_Name() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFDN_Name()");
        }
        return NodeID_AttributeName.FDN;
    }

    public Enumer getFDN_Type() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFDN_Type()");
        }
        return NodeInformationSubElementName.NodeID;
    }

    public String getIP_Address() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIP_Address()");
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            return null;
        }
        return this.myNodeInformationElement.getNodeID_Element().getIP_Address();
    }

    public Enumer getIP_AddressName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIP_AddressName()");
        }
        return NodeID_AttributeName.IP_Address;
    }

    public Enumer getIP_AddressType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIP_AddressType()");
        }
        return NodeInformationSubElementName.NodeID;
    }

    public String getSite() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSite()");
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            return null;
        }
        return this.myNodeInformationElement.getNodeID_Element().getSite();
    }

    public Enumer getSiteName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSiteName()");
        }
        return NodeID_AttributeName.Site;
    }

    public Enumer getSiteType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSiteType()");
        }
        return NodeInformationSubElementName.NodeID;
    }

    public String getVersion() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getVersion()");
        }
        return this.myNodeInformationElement.getVersion();
    }

    public Enumer getVersionName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getVersionName()");
        }
        return NodeInformationAttributeName.Version;
    }

    public Enumer getVersionType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getVersionType()");
        }
        return NodeInformationRootElementName.NodeInformation;
    }

    public Enumer getRevisionType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRevisionType()");
        }
        return NodeInformationSubElementName.BackupRestoreInfo;
    }

    public Enumer getRevisionName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRevisionName()");
        }
        return BackupRestoreInfoAttributeName.Revision;
    }

    public String getRevision() {
        BackupRestoreInfoElement backupRestoreInfoElement;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRevision()");
        }
        if ((backupRestoreInfoElement = this.myNodeInformationElement.getBackupRestoreInfoElement()) == null) {
            Trace.info(this.getClass(), "getRevision ()", "Could not find any BackupRestore revision information in the backup CV.\n\tRevision '" + BackupRestoreRevisionAndIndex.getOldestBackupRestoreRevision() + "' will be used.");
            return BackupRestoreRevisionAndIndex.getOldestBackupRestoreRevision();
        }
        return backupRestoreInfoElement.getRevision();
    }

    public Enumer getIndexType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIndexType()");
        }
        return this.getRevisionType();
    }

    public Enumer getIndexName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIndexName()");
        }
        return BackupRestoreInfoAttributeName.Index;
    }

    public String getIndex() {
        BackupRestoreInfoElement backupRestoreInfoElement;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIndex()");
        }
        if ((backupRestoreInfoElement = this.myNodeInformationElement.getBackupRestoreInfoElement()) == null) {
            Trace.info(this.getClass(), "getIndex ()", "Could not find any BackupRestore index information in the backup CV.\n\tIndex '" + BackupRestoreRevisionAndIndex.getOldestBackupRestoreIndex() + "' will be used.");
            Integer n = new Integer(BackupRestoreRevisionAndIndex.getOldestBackupRestoreIndex());
            return n.toString();
        }
        return backupRestoreInfoElement.getIndex();
    }

    public void print(PrintStream printStream) throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.myNodeInformationElement.validate();
        this.myNodeInformationElement.print(printStream);
    }

    public void setFDN(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setFDN(String aFDN)", "aFDN: " + string);
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            NodeID_Element nodeID_Element = new NodeID_Element();
            this.myNodeInformationElement.setNodeID_Element(nodeID_Element);
        }
        this.myNodeInformationElement.getNodeID_Element().setFDN(string);
    }

    public void setIP_Address(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIP_Address(String anIP_Address)", "anIP_Address: " + string);
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            NodeID_Element nodeID_Element = new NodeID_Element();
            this.myNodeInformationElement.setNodeID_Element(nodeID_Element);
        }
        this.myNodeInformationElement.getNodeID_Element().setIP_Address(string);
    }

    public void setSite(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setSite(String aSite)", "aSite: " + string);
        }
        if (this.myNodeInformationElement.getNodeID_Element() == null) {
            NodeID_Element nodeID_Element = new NodeID_Element();
            this.myNodeInformationElement.setNodeID_Element(nodeID_Element);
        }
        this.myNodeInformationElement.getNodeID_Element().setSite(string);
    }

    public void setBackupRestoreInformation() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBackupRestoreInformation()");
        }
        this.myNodeInformationElement.setBackupRestoreInfoElement(this.createBackupRestoreInfoElement());
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate()");
        }
        this.myNodeInformationElement.validate();
    }

    private BackupRestoreInfoElement createBackupRestoreInfoElement() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createBackupRestoreInfoElement()");
        }
        BackupRestoreInfoElement backupRestoreInfoElement = null;
        if (BackupRestoreDataHandler.instance().currentVersionEqualTo("1")) {
            return backupRestoreInfoElement;
        }
        backupRestoreInfoElement = new BackupRestoreInfoElement();
        try {
            backupRestoreInfoElement.setBackupRestoreInformation(BackupRestoreRevisionAndIndex.getBackupRestoreRevision(), BackupRestoreRevisionAndIndex.getBackupRestoreIndexString());
        }
        catch (BackupRestoreRevisionAndIndexException backupRestoreRevisionAndIndexException) {
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tMethod: createBackupRestoreInfoElement()" + "\n\tFailed to create the BackupRestoreInfo element." + "\n\tBackupRestoreRevisionAndIndexException caught: " + (Object)((Object)backupRestoreRevisionAndIndexException));
        }
        return backupRestoreInfoElement;
    }

    private String getNodeInformationFilePath(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeInformationFilePath(String aFilePathToNodeInformationFileDir)", "aFilePathToNodeInformationFileDir:" + string);
        }
        String string2 = "nodeinformation2.xml";
        String string3 = string + "/" + string2;
        File file = new File(string3);
        if (!file.exists()) {
            string2 = "nodeinformation.xml";
            string3 = string + "/" + string2;
        }
        BackupRestoreDataHandler.instance().setCurrentFileName(string2);
        return string3;
    }
}

