/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeHandler;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public abstract class CV_MO_AttributeHandler
extends CV_AttributeHandler {
    protected int myTransactionTimeoutValue = 180;

    public CV_MO_AttributeHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_MO_AttributeHandler( )");
        }
    }

    public Struct[] convertSequenceAttributeOfStructAttributesToStructArray(SequenceAttribute sequenceAttribute, Coordinator coordinator) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convertSequenceAttributeOfStructsToArray(SequenceAttribute aSequenceOfStructAttributes, Coordinator aCoordinator)", "aSequenceOfStructAttributes: " + sequenceAttribute + "\n\taCoordinator: " + coordinator);
        }
        try {
            Enumeration enumeration = sequenceAttribute.elements();
            Struct[] structArray = new Struct[sequenceAttribute.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                structArray[n] = ((StructAttribute)enumeration.nextElement()).getValue(coordinator);
                ++n;
            }
            return structArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convertSequenceAttributeOfStructAttributesToStructArray(SequenceAttribute aSequenceOfStructAttributes, Coordinator aCoordinator)", "Throwable caught when trying to convert a SequenceAttribute containing StructAttributes to an array of Struct,\n\taSequenceOfStructAttributes: " + sequenceAttribute + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ConfigurationVersionException("Throwable caught when trying to convert a SequenceAttribute containing StructAttributes to an array of Struct,\n\tClass: " + this.getClass() + "\n\tMethod: convertSequenceAttributeOfStructAttributesToStructArray(" + "SequenceAttribute aSequenceOfStructAttributes, Coordinator aCoordinator)" + "\n\tReason: " + throwable.toString());
        }
    }

    protected StructAttribute[] createAdminProductDataStructAttributeArray(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAdminProductDataStructAttributeArray(Collection aCollectionOfProductDataContainers)", "aCollectionOfProductDataContainers: " + collection);
        }
        Iterator iterator = collection.iterator();
        ProductDataContainer productDataContainer = null;
        StructAttribute structAttribute = null;
        Vector<StructAttribute> vector = new Vector<StructAttribute>(0);
        while (iterator.hasNext()) {
            productDataContainer = (ProductDataContainer)iterator.next();
            structAttribute = this.createAdminProductDataStructAttribute(productDataContainer);
            vector.addElement(structAttribute);
        }
        Object[] objectArray = new StructAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private StructAttribute createAdminProductDataStructAttribute(ProductDataContainer productDataContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAdminProductDataStructAttribute(ProductDataContainer aProductDataContainer)", "aProductDataContainer: " + productDataContainer);
        }
        StructAttribute structAttribute = new StructAttribute("administrativeData", false);
        StringAttribute stringAttribute = new StringAttribute("productNumber", false, productDataContainer.getNumber());
        structAttribute.addElement((Attribute)stringAttribute);
        StringAttribute stringAttribute2 = new StringAttribute("productRevision", false, productDataContainer.getRevision());
        structAttribute.addElement((Attribute)stringAttribute2);
        StringAttribute stringAttribute3 = new StringAttribute("productName", false, productDataContainer.getName());
        structAttribute.addElement((Attribute)stringAttribute3);
        StringAttribute stringAttribute4 = new StringAttribute("productInfo", false, productDataContainer.getInformation());
        structAttribute.addElement((Attribute)stringAttribute4);
        StringAttribute stringAttribute5 = new StringAttribute("productionDate", false, productDataContainer.getDate());
        structAttribute.addElement((Attribute)stringAttribute5);
        return structAttribute;
    }
}

