/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.rollbacklist;

import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutingBlockingActionEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.RemovingCV_FromRollbackListEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.SettingCV_FirstInRollbackListEvent;
import se.ericsson.cello.configurationversion.main.event.rollbacklist.InsertedInRollbackListEvent;
import se.ericsson.cello.configurationversion.main.event.rollbacklist.RemovedFromRollbackListEvent;
import se.ericsson.cello.configurationversion.main.exception.CVDoesNotExistsException;
import se.ericsson.cello.configurationversion.main.exception.CVInvalidCVException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStoredConfigurationVersionsHandler;
import se.ericsson.cello.configurationversion.rollbacklist.RollbackListContentsControllerException;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_UsageResultInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class RollbackListContentsController
extends CV_SubFunctionController {
    public RollbackListContentsController(boolean bl) {
        super(bl);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RollbackListContentsController(boolean anIsActivityEventsToBeSent)", "anIsActivityEventsToBeSent: " + bl);
        }
    }

    public RollbackListContentsController() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RollbackListContentsController()");
        }
    }

    public String[] getRollbackList() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackList()");
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            CV_UsageResultInformation cV_UsageResultInformation = osaCvMgmntProxyAccess.sendOsaCvGetCvUsageReq();
            this.checkResult(cV_UsageResultInformation.result);
            return cV_UsageResultInformation.rollbackList;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw new ConfigurationVersionException(froNotAccessibleException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRollbackList( )", "Throwable caught when trying to get value of attribute 'rollbackList'.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetRollbackList ()" + "\n\tThrowable caught when trying to get value of attribute 'rollbackList'." + "\n\tThrowable: " + throwable.toString());
        }
    }

    public void removeFromRollbackList(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeFromRollbackList(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            try {
                this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new RemovingCV_FromRollbackListEvent(this));
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutingBlockingActionEvent(this));
                this.sendOsaCvRemoveRollbackReq(string);
                String[] stringArray = this.getRollbackList();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.RollbackList, new RemovedFromRollbackListEvent(this, stringArray, string));
            }
            catch (ConfigurationVersionException configurationVersionException) {
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw configurationVersionException;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "removeFromRollbackList(String aCV_Name)", "\n\taCV_Name: " + string + "\n\tThrowable caught.", throwable);
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tremoveFromRollbackList(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            throw throwable;
        }
        this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
    }

    public void setFirstInRollbackList(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setFirstInRollbackList(String aCV_Name)", "aCV_Name: " + string);
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
        try {
            try {
                this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new SettingCV_FirstInRollbackListEvent(this));
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutingBlockingActionEvent(this));
                if (!this.isCV_AllowedToBeInsertedIntoRollbackList(string)) {
                    throw new CVInvalidCVException("ConfigurationVersion", osaCvMgmntProxyAccess.getResultMsg(8));
                }
                this.sendOsaCvSetRollbackReq(string);
                String[] stringArray = this.getRollbackList();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.RollbackList, new InsertedInRollbackListEvent(this, stringArray, string));
                Object var5_6 = null;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw configurationVersionException;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "setFirstInRollbackList(String aCV_Name)", "\n\taCV_Name: " + string + "\n\tThrowable caught.", throwable);
                this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tsetFirstInRollbackList(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            throw throwable;
        }
        this.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        this.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
    }

    private void checkResult(int n) throws ConfigurationVersionException, FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkResult(int aResult)", "aResult: " + n);
        }
        SignalHandler signalHandler = new SignalHandler();
        signalHandler.checkResult(n);
    }

    private boolean isCV_AllowedToBeInsertedIntoRollbackList(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCV_AllowedToBeInsertedIntoRollbackList(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            CV_AttributeStoredConfigurationVersionsHandler cV_AttributeStoredConfigurationVersionsHandler = new CV_AttributeStoredConfigurationVersionsHandler();
            String string2 = cV_AttributeStoredConfigurationVersionsHandler.getCV_Type(string);
            if (string2 != null) {
                SignalHandler signalHandler = new SignalHandler();
                return string2.equals(signalHandler.getCV_TypeName(0)) || string2.equals(signalHandler.getCV_TypeName(2)) || string2.equals(signalHandler.getCV_TypeName(3)) || string2.equals(signalHandler.getCV_TypeName(4)) || string2.equals(signalHandler.getCV_TypeName(5)) || string2.equals(signalHandler.getCV_TypeName(8));
            }
            throw new CVDoesNotExistsException("ConfigurationVersion", osaCvMgmntProxyAccess.getResultMsg(6));
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isCV_AllowedToBeInsertedIntoRollbackList(String aCV_Name)", "\n\taCV_Name: " + string + "\n\tThrowable caught.", throwable);
            throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tisCV_AllowedToBeInsertedIntoRollbackList(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void sendOsaCvRemoveRollbackReq(String string) throws FroNotAccessibleException, ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaCvRemoveRollbackReq(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            int n = osaCvMgmntProxyAccess.sendOsaCvRemoveRollbackReq(string);
            this.checkResult(n);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvRemoveRollbackReq(String aCV_Name)", "ConfigurationVersionException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvRemoveRollbackReq(String aCV_Name)", "FroNotAccessibleException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + froNotAccessibleException.toString());
            }
            throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvRemoveRollbackReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tFroNotAccessibleException caught." + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvRemoveRollbackReq(String aCV_Name)", "Throwable caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + throwable.toString());
            }
            throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvRemoveRollbackReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void sendOsaCvSetRollbackReq(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaCvSetRollbackReq(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            int n = osaCvMgmntProxyAccess.sendOsaCvSetRollbackReq(string);
            this.checkResult(n);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvSetRollbackReq(String aCV_Name)", "ConfigurationVersionException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvSetRollbackReq(String aCV_Name)", "FroNotAccessibleException caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + froNotAccessibleException.toString());
            }
            throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvSetRollbackReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tFroNotAccessibleException caught." + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaCvSetRollbackReq(String aCV_Name)", "Throwable caught.\n\taCV_Name: " + string + "\n\tThrowable data: " + throwable.toString());
            }
            throw new RollbackListContentsControllerException("Class name: " + this.getClass().getName() + "\n\tsendOsaCvSetRollbackReq(String aCV_Name)" + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

