/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.additionalinfo;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceData;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceError;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfo;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceWarning;

public class AdditionalInformationContainer {
    private Vector traceErrors = new Vector();
    private Vector traceInfos = new Vector();
    private Vector traceWarnings = new Vector();

    public void addTrace(TraceData traceData) {
        try {
            if (traceData != null) {
                if (traceData instanceof TraceError) {
                    this.addTraceError((TraceError)traceData);
                } else if (traceData instanceof TraceWarning) {
                    this.addTraceWarning((TraceWarning)traceData);
                } else if (traceData instanceof TraceInfo) {
                    this.addTraceInfo((TraceInfo)traceData);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "addTrace(TraceData aTraceData)", "Throwable caught (ignored).\n\taTraceData: " + traceData + "\n\tException data: " + throwable.toString());
        }
    }

    public void addTraceError(TraceError traceError) {
        if (!this.traceErrorsContains(traceError)) {
            this.traceErrors.add(traceError);
        }
    }

    public void addTraceInfo(TraceInfo traceInfo) {
        if (!this.traceInfosContains(traceInfo)) {
            this.traceInfos.add(traceInfo);
        }
    }

    public void addTraceWarning(TraceWarning traceWarning) {
        if (!this.traceWarningsContains(traceWarning)) {
            this.traceWarnings.add(traceWarning);
        }
    }

    public Vector getTraceErrors() {
        return this.traceErrors;
    }

    public Vector getTraceInfos() {
        return this.traceInfos;
    }

    public Vector getTraceWarnings() {
        return this.traceWarnings;
    }

    public String toString() {
        return "\n\ttraceErrors: " + this.traceErrors + "\n\ttraceWarnings: " + this.traceWarnings + "\n\ttraceInfos: " + this.traceInfos;
    }

    private boolean traceErrorsContains(TraceError traceError) {
        boolean bl = false;
        TraceError traceError2 = null;
        Iterator iterator = this.traceErrors.iterator();
        while (iterator.hasNext()) {
            traceError2 = (TraceError)iterator.next();
            if (!traceError.equalsTo(traceError2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean traceWarningsContains(TraceWarning traceWarning) {
        boolean bl = false;
        TraceWarning traceWarning2 = null;
        Iterator iterator = this.traceWarnings.iterator();
        while (iterator.hasNext()) {
            traceWarning2 = (TraceWarning)iterator.next();
            if (!traceWarning.equalsTo(traceWarning2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean traceInfosContains(TraceInfo traceInfo) {
        boolean bl = false;
        TraceInfo traceInfo2 = null;
        Iterator iterator = this.traceInfos.iterator();
        while (iterator.hasNext()) {
            traceInfo2 = (TraceInfo)iterator.next();
            if (!traceInfo.equalsTo(traceInfo2)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

