/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.handler;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.handler.NodeIP_DataHandlerException;
import se.ericsson.cello.configurationversion.util.handler.NodeIP_DataHandlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.iphostlink.IpHostLinkMO_HandlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.iproutingtable.IP_RoutingTableMO_handlerInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class NodeIP_DataHandler
implements NodeIP_DataHandlerInterface {
    public String getNodeIpv6InterfaceName() throws NodeIP_DataHandlerException {
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            return ipMO_HandlerInterface.getNodeIpv6InterfaceName();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIpv6InterfaceName()", "Throwable caught when attempting to look up the IpMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeIpv6InterfaceName()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeInterfaceName() throws NodeIP_DataHandlerException {
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            return ipMO_HandlerInterface.getNodeInterfaceName();
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeInterfaceName()", "Throwable caught when attempting to look up the IpMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeInterfaceName()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeIpv6Address() throws NodeIP_DataHandlerException {
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            return ipMO_HandlerInterface.getNodeIpv6Address();
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIpv6Address()", "Throwable caught when attempting to look up the IpMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeIpv6Address()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getBroadcastAddress() throws NodeIP_DataHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getBroadcastAddress()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            if (ipMO_HandlerInterface.getIsOaM_CableConfigured()) {
                EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
                return ethernetLinkMO_handlerInterface.getBroadcastAddress();
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getBroadcastAddress()", "RETURNS - 127.0.0.1");
            }
            return "127.0.0.1";
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new NodeIP_DataHandlerException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getBroadcastAddress()", "Throwable caught when attempting to look up the EthernetLinkMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetBroadcastAddress()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getIP_Address() throws NodeIP_DataHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIP_Address()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            if (ipMO_HandlerInterface.getIsOaM_CableConfigured()) {
                EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
                return ethernetLinkMO_handlerInterface.getNodeIP_Address();
            }
            IpHostLinkMO_HandlerInterface ipHostLinkMO_HandlerInterface = ServiceFinder.getIpHostLinkMO_HandlerInterface();
            if (ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                return ipHostLinkMO_HandlerInterface.getIP_Address();
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getIP_Address()", "No IpHostLink Mo exists, RETURNS - null");
            }
            return null;
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new NodeIP_DataHandlerException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getIP_Address()", "Throwable caught when attempting to look up the EthernetLinkMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetIP_Address()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeNextHopIP_Address() throws NodeIP_DataHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeNextHopIP_Address()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            if (ipMO_HandlerInterface.getIsOaM_CableConfigured()) {
                IP_RoutingTableMO_handlerInterface iP_RoutingTableMO_handlerInterface = ServiceFinder.getIP_RoutingTableMO_handlerInterface();
                return iP_RoutingTableMO_handlerInterface.getNodeNextHopIP_Address();
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getSubnetMask()", "RETURNS - 127.0.0.1");
            }
            return "127.0.0.1";
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new NodeIP_DataHandlerException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeNextHopIP_Address()", "Throwable caught when attempting to get nodeNextHopIpAddress.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeNextHopIP_Address()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getSubnetMask() throws NodeIP_DataHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSubnetMask()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            if (ipMO_HandlerInterface.getIsOaM_CableConfigured()) {
                EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
                return ethernetLinkMO_handlerInterface.getNodeSubnetMask();
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getSubnetMask()", "RETURNS - 127.0.0.1");
            }
            return "127.0.0.1";
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new NodeIP_DataHandlerException(ipMO_HandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new NodeIP_DataHandlerException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSubnetMask()", "Throwable caught when attempting to look up the EthernetLinkMo.", throwable);
            throw new NodeIP_DataHandlerException("Class name: " + this.getClass().getName() + "\n\tgetSubnetMask()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

