/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.autoconfiguration;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.intma.PlugNPlayHelperAccess;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.managedelement.SlotBuildIF;
import se.ericsson.cello.su.autoconfiguration.InstallPiuTypeConfirmedEvent;
import se.ericsson.cello.su.autoconfiguration.InstallPiuTypeRejectedEvent;
import se.ericsson.cello.su.autoconfiguration.PiuTypeStateChangeEvent;
import se.ericsson.cello.su.autoconfiguration.PiuTypeSupervisionEvent;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportAccess;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertyListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertySupportAccess;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class PlugNPlayHelper
extends Thread
implements PlugNPlayHelperAccess,
PiuTypePropertyListener,
PiuTypeInstallListener {
    private static PlugNPlayHelper myInstance = null;
    private BlockingQueue myQueue = null;
    private HashMap myAutoInstallRequestData = new HashMap();
    private HashMap myPiuTypeListeners = new HashMap();
    static /* synthetic */ Class class$se$ericsson$cello$managedelement$SlotBuildIF;

    private PlugNPlayHelper() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PlugNPlayHelper()");
        }
    }

    public static synchronized PlugNPlayHelper getInstance() {
        if (Trace.valid(PlugNPlayHelper.class, 20)) {
            Trace.debug(PlugNPlayHelper.class, 20, "getInstance()");
        }
        if (myInstance == null) {
            myInstance = new PlugNPlayHelper();
        }
        return myInstance;
    }

    public void loadModuleFilesInstallState(PiuTypeMo piuTypeMo, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadModuleFilesInstallState(PiuTypeMo aPiuTypeMo, boolean anIsInstalled) ", "aPiuTypeMo: " + piuTypeMo + "\n\tanIsInstalled:" + bl);
        }
        this.myQueue.enqueue((Object)new PiuTypeStateChangeEvent(this, piuTypeMo, bl));
    }

    public void installPiuTypeConfirmed(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installPiuTypeConfirmed(int anActionID) ", "anActionID: " + n);
        }
        this.myQueue.enqueue((Object)new InstallPiuTypeConfirmedEvent(this, n));
    }

    public void installPiuTypeRejected(int n, InstallRejectReason installRejectReason) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installPiuTypeRejected(int anActionID, InstallRejectReason anInstallRejectReason) ", "anActionID: " + n + "\n\tanInstallRejectReason: " + installRejectReason);
        }
        this.myQueue.enqueue((Object)new InstallPiuTypeRejectedEvent(this, n, installRejectReason, ""));
    }

    public void installPiuTypeRejected(int n, InstallRejectReason installRejectReason, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installPiuTypeRejected(int anActionID, InstallRejectReason anInstallRejectReason, String anAdditionalInformation) ", "anActionID: " + n + "\n\tanInstallRejectReason: " + installRejectReason + "\n\tanAdditionalInformation: " + string);
        }
        this.myQueue.enqueue((Object)new InstallPiuTypeRejectedEvent(this, n, installRejectReason, string));
    }

    public void supervisePiuType(PiuTypeAccess piuTypeAccess, PlugNPlayListener plugNPlayListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "supervisePiuType(PiuTypeAccess aPiuType, PlugNPlayListener aPlugNPlayListener)", "aPiuType: " + piuTypeAccess + "\n\taPlugNPlayListener: " + plugNPlayListener);
        }
        this.supervisePiuType((PiuTypeMoSU_Access)piuTypeAccess, plugNPlayListener);
    }

    public void supervisePiuType(PiuTypeMoSU_Access piuTypeMoSU_Access, PlugNPlayListener plugNPlayListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "supervisePiuType(PiuTypeMoSU_Access aPiuType, PlugNPlayListener aPlugNPlayListener)", "aPiuType: " + piuTypeMoSU_Access + "\n\taPlugNPlayListener: " + plugNPlayListener);
        }
        this.initiateQueue();
        this.myQueue.enqueue((Object)new PiuTypeSupervisionEvent(this, piuTypeMoSU_Access, plugNPlayListener));
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ()");
        }
        EventObject eventObject = null;
        while (true) {
            try {
                while (true) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "run()", "Halts execution until a PiuType MO has been installed...");
                    }
                    if ((eventObject = (EventObject)this.myQueue.dequeue()) instanceof PiuTypeSupervisionEvent) {
                        this.handlePiuTypeSupervision((PiuTypeSupervisionEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof PiuTypeStateChangeEvent) {
                        this.handlePiuTypeStateChange((PiuTypeStateChangeEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallPiuTypeConfirmedEvent) {
                        this.handleInstallPiuTypeConfirmed((InstallPiuTypeConfirmedEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallPiuTypeRejectedEvent) {
                        this.handleInstallPiuTypeRejected((InstallPiuTypeRejectedEvent)eventObject);
                        continue;
                    }
                    Trace.error(this.getClass(), "run()", "Unexpected event received (ignored)\n\ttheEvent: " + eventObject);
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run() ", "Throwable: " + throwable, throwable);
                continue;
            }
            break;
        }
    }

    private void addAsListenerOnPiuType(PiuTypeSupervisionEvent piuTypeSupervisionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListenerToPiuType(PiuTypeSupervisionEvent aPiuTypeSupervisionEvent)", "aPiuTypeSupervisionEvent: " + piuTypeSupervisionEvent);
        }
        PiuTypeMo[] piuTypeMoArray = new PiuTypeMo[]{(PiuTypeMo)piuTypeSupervisionEvent.getPiuTypeMo()};
        PiuTypePropertySupportAccess.getInterface().addAsListener(this, piuTypeMoArray);
        this.addAsListenerToMyListenerMap(piuTypeSupervisionEvent);
    }

    private void addAsListenerToMyListenerMap(PiuTypeSupervisionEvent piuTypeSupervisionEvent) {
        LinkedList<PlugNPlayListener> linkedList;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListenerToMyListenerMap(PiuTypeSupervisionEvent aPiuTypeSupervisionEvent)", "aPiuTypeSupervisionEvent: " + piuTypeSupervisionEvent);
        }
        if ((linkedList = (LinkedList<PlugNPlayListener>)this.myPiuTypeListeners.get(piuTypeSupervisionEvent.getPiuTypeMo().getLocalDistinguishedName())) != null) {
            if (!linkedList.contains(piuTypeSupervisionEvent.getPlugAndPlayableUnit())) {
                linkedList.add(piuTypeSupervisionEvent.getPlugAndPlayableUnit());
            }
        } else {
            linkedList = new LinkedList<PlugNPlayListener>();
            linkedList.add(piuTypeSupervisionEvent.getPlugAndPlayableUnit());
            this.myPiuTypeListeners.put(piuTypeSupervisionEvent.getPiuTypeMo().getLocalDistinguishedName(), linkedList);
        }
    }

    private void handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent installPiuTypeConfirmedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent anInstallPiuTypeConfirmedEvent)", "anInstallPiuTypeConfirmedEvent: " + installPiuTypeConfirmedEvent);
        }
        try {
            String string = Integer.toString(installPiuTypeConfirmedEvent.actionID);
            PiuTypeSupervisionEvent piuTypeSupervisionEvent = (PiuTypeSupervisionEvent)this.myAutoInstallRequestData.remove(string);
            if (piuTypeSupervisionEvent != null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent anInstallPiuTypeConfirmedEvent)", "LM files for a PiuType MO has been installed.\n\tStarting auto-configuration of the requesting listener (PlugAndPlayableUnit).\n\tlistener: " + piuTypeSupervisionEvent.getPlugAndPlayableUnit() + "\n\tpiu type: " + piuTypeSupervisionEvent.getPiuTypeMo() + "\n\tanInstallPiuTypeConfirmedEvent: " + installPiuTypeConfirmedEvent);
                }
                this.startAutoConfiguration(piuTypeSupervisionEvent.getPlugAndPlayableUnit());
                Collection collection = this.removeAsListenerOnPiuType(piuTypeSupervisionEvent.getPiuTypeMo());
                if (!collection.isEmpty()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent anInstallPiuTypeConfirmedEvent)", "LM files for a PiuType MO has been installed when previous request(s) has failed.\n\tStarting auto-configuration of all requesting listeners (PlugAndPlayableUnits) for this PiuType.\n\tlisteners: " + collection + "\n\tpiu type: " + piuTypeSupervisionEvent.getPiuTypeMo() + "\n\tanInstallPiuTypeConfirmedEvent: " + installPiuTypeConfirmedEvent);
                    }
                    this.startAutoConfiguration(collection);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent anInstallPiuTypeConfirmedEvent)", "No listener stored for the actionID key: " + string + "," + "\n\tanInstallPiuTypeConfirmedEvent: " + installPiuTypeConfirmedEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallPiuTypeConfirmed(InstallPiuTypeConfirmedEvent anInstallPiuTypeConfirmedEvent)", "anInstallPiuTypeConfirmedEvent: " + installPiuTypeConfirmedEvent + "\n\tThrowable caught.", throwable);
        }
    }

    private void handleInstallPiuTypeRejected(InstallPiuTypeRejectedEvent installPiuTypeRejectedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallPiuTypeRejected(InstallPiuTypeRejectedEvent anInstallPiuTypeRejectedEvent)", "anInstallPiuTypeRejectedEvent: " + installPiuTypeRejectedEvent);
        }
        try {
            String string = Integer.toString(installPiuTypeRejectedEvent.actionID);
            PiuTypeSupervisionEvent piuTypeSupervisionEvent = (PiuTypeSupervisionEvent)this.myAutoInstallRequestData.remove(string);
            if (piuTypeSupervisionEvent != null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleInstallPiuTypeRejected(InstallPiuTypeRejectedEvent anInstallPiuTypeRejectedEvent)", "Installation of LM files for a PiuType MO has failed.\n\tRequesting listener: " + piuTypeSupervisionEvent.getPlugAndPlayableUnit() + "\n\tRequested piu type: " + piuTypeSupervisionEvent.getPiuTypeMo() + "\n\tanInstallPiuTypeRejectedEvent: " + installPiuTypeRejectedEvent);
                }
                this.addAsListenerOnPiuType(piuTypeSupervisionEvent);
                this.sendAlarm(piuTypeSupervisionEvent.getPlugAndPlayableUnit(), piuTypeSupervisionEvent.getPiuTypeMo(), installPiuTypeRejectedEvent.installRejectReason.getValueDescription(), installPiuTypeRejectedEvent.additionalInformation);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallPiuTypeRejected(InstallPiuTypeRejectedEvent anInstallPiuTypeRejectedEvent)", "No listener stored for the actionID key: " + string + "," + "\n\tanInstallPiuTypeRejectedEvent: " + installPiuTypeRejectedEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallPiuTypeRejected(InstallPiuTypeRejectedEvent anInstallPiuTypeRejectedEvent)", "anInstallPiuTypeRejectedEvent: " + installPiuTypeRejectedEvent + "\n\tThrowable caught.", throwable);
        }
    }

    private void handlePiuTypeStateChange(PiuTypeStateChangeEvent piuTypeStateChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePiuTypeStateChange (PiuTypeStateChangeEvent aPiuTypeStateChangeEvent)", "aPiuTypeStateChangeEvent: " + piuTypeStateChangeEvent);
        }
        try {
            Collection collection;
            if (piuTypeStateChangeEvent.isInstalled && !(collection = this.removeAsListenerOnPiuType(piuTypeStateChangeEvent.piuTypeMo)).isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handlePiuTypeStateChange (PiuTypeStateChangeEvent aPiuTypeStateChangeEvent)", "LM files for a PiuType MO has been installed when previous request(s) has failed.\n\tStarting auto-configuration of all requesting listeners (PlugAndPlayableUnits) for this PiuType.\n\tlisteners: " + collection + "\n\tpiu type: " + piuTypeStateChangeEvent.piuTypeMo);
                }
                this.startAutoConfiguration(collection);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handlePiuTypeStateChange (PiuTypeStateChangeEvent aPiuTypeStateChangeEvent)", "aPiuTypeStateChangeEvent: " + piuTypeStateChangeEvent + "\n\tThrowable caught.", throwable);
        }
    }

    private void handlePiuTypeSupervision(PiuTypeSupervisionEvent piuTypeSupervisionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePiuTypeSupervision (PiuTypeSupervisionEvent aPiuTypeSupervisionEvent)", "aPiuTypeSupervisionEvent: " + piuTypeSupervisionEvent);
        }
        try {
            if (piuTypeSupervisionEvent.getPiuTypeMo().getLmFilesInstallState(null) != 2) {
                this.installPiuType(piuTypeSupervisionEvent);
            } else {
                this.startAutoConfiguration(piuTypeSupervisionEvent.getPlugAndPlayableUnit());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handlePiuTypeSupervision(PiuTypeSupervisionEvent aPiuTypeSupervisionEvent)", "aPiuTypeSupervisionEvent: " + piuTypeSupervisionEvent + "\n\tThrowable caught.", throwable);
            this.addAsListenerOnPiuType(piuTypeSupervisionEvent);
            this.sendAlarm(piuTypeSupervisionEvent.getPlugAndPlayableUnit(), piuTypeSupervisionEvent.getPiuTypeMo(), InstallRejectReason.UNSPECIFIED.getValueDescription(), "Internal SW error");
        }
    }

    private void initiateQueue() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "initiateQueue( )");
        }
        if (this.myQueue == null) {
            this.myQueue = new BlockingQueue();
            this.start();
        }
    }

    private void installPiuType(PiuTypeSupervisionEvent piuTypeSupervisionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installPiuType(PiuTypeSupervisionEvent aPiuTypeSupervisionEvent)", "aPiuTypeSupervisionEvent: " + piuTypeSupervisionEvent);
        }
        int n = PiuTypeInstallSupportAccess.getInterface().installPiuType((PiuTypeMo)piuTypeSupervisionEvent.getPiuTypeMo(), this);
        String string = Integer.toString(n);
        this.myAutoInstallRequestData.put(string, piuTypeSupervisionEvent);
    }

    private Collection removeAsListenerOnPiuType(PiuTypeMoSU_Access piuTypeMoSU_Access) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListenerOnPiuType(PiuTypeMoSU_Access aPiuTypeMo)", "aPiuTypeMo: " + piuTypeMoSU_Access);
        }
        PiuTypeMo[] piuTypeMoArray = new PiuTypeMo[]{(PiuTypeMo)piuTypeMoSU_Access};
        PiuTypePropertySupportAccess.getInterface().removeAsListener(this, piuTypeMoArray);
        return this.removeAsListenerFromMyListenerMap(piuTypeMoSU_Access.getLocalDistinguishedName());
    }

    private Collection removeAsListenerFromMyListenerMap(String string) {
        LinkedList linkedList;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListenerFromMyListenerMap(String aPiuTypeLDN)", "aPiuTypeLDN: " + string);
        }
        if ((linkedList = (LinkedList)this.myPiuTypeListeners.remove(string)) == null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "removeAsListenerFromMyListenerMap(String aPiuTypeLDN)", "No slots found for the PiuType key: " + string);
            }
            linkedList = new LinkedList();
        }
        return linkedList;
    }

    private void sendAlarm(PlugNPlayListener plugNPlayListener, PiuTypeMoSU_Access piuTypeMoSU_Access, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendAlarm(PlugNPlayListener aPlugAndPlayableUnit, PiuTypeMoSU_Access aPiuTypeMo, String aReasonForFailure, String anAdditionalFailureInfo)", "aPlugAndPlayableUnit: " + plugNPlayListener + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taReasonForFailure: " + string + "\n\tanAdditionalFailureInfo: " + string2);
        }
        try {
            AdditionalInfo[] additionalInfoArray = null;
            if (!string2.equals("")) {
                additionalInfoArray = new AdditionalInfo[5];
                additionalInfoArray[4] = new AdditionalInfo("Additional failure information", string2);
            } else {
                additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Alarm Cause", "Auto-install for PiuType failed, reason" + string), new AdditionalInfo("PiuType Product number", piuTypeMoSU_Access.getProductNumber(null)), new AdditionalInfo("PiuType Product revision", piuTypeMoSU_Access.getProductRevision(null)), new AdditionalInfo("PiuType LDN", piuTypeMoSU_Access.getLocalDistinguishedName())};
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendAlarm(PlugNPlayListener aPlugAndPlayableUnit, PiuTypeMoSU_Access aPiuTypeMo, String aReasonForFailure, String anAdditionalFailureInfo)", "\n\tSending the alarm.\n\ttheAddInfo: " + SuLib.toString(additionalInfoArray));
            }
            ((SlotMoSU_Access)plugNPlayListener).raiseAutoConfigurationAlarm(additionalInfoArray);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendAlarm(PlugNPlayListener aPlugAndPlayableUnit, PiuTypeMoSU_Access aPiuTypeMo, String aReasonForFailure, String anAdditionalFailureInfo)", "aPlugAndPlayableUnit: " + plugNPlayListener + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taReasonForFailure: " + string + "\n\tanAdditionalFailureInfo: " + string2 + "Failed to send the alarm, see reasons below (ignored due to can't do anything about it)." + "Throwable caught: " + throwable);
        }
    }

    private void startAutoConfiguration(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startAutoConfiguration(Collection aPlugNPlayListeners)", "aPlugNPlayListeners: " + collection);
        }
        PlugNPlayListener plugNPlayListener = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            plugNPlayListener = (PlugNPlayListener)iterator.next();
            this.startAutoConfiguration(plugNPlayListener);
        }
    }

    private void startAutoConfiguration(PlugNPlayListener plugNPlayListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startAutoConfiguration (PlugNPlayListener aPlugNPlayListener)", "aPlugNPlayListener: " + plugNPlayListener);
        }
        try {
            plugNPlayListener.startAutoConfiguration();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "startAutoConfiguration (PlugNPlayListener aPlugNPlayListener)", "aPlugNPlayListener: " + plugNPlayListener + "\n\tThe auto-configuration of the PlugNPlayListener (slot or fan) has failed (for reasons see below)." + "Throwable caught: " + throwable, throwable);
        }
    }

    public void startNodeSlotScan() {
        NodeScan nodeScan = new NodeScan();
        nodeScan.start();
    }

    private static class NodeScan
    implements Runnable {
        private NodeScan() {
        }

        private void start() {
            Thread thread = new Thread((Runnable)this, "AutoCreateMosNodeSlotScan");
            thread.start();
        }

        public void run() {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "Invoking start of auto configuration for all slots in the node");
            }
            Iterator iterator = ServiceLocatorFacade.getRepository().getServices(class$se$ericsson$cello$managedelement$SlotBuildIF == null ? (class$se$ericsson$cello$managedelement$SlotBuildIF = PlugNPlayHelper.class$("se.ericsson.cello.managedelement.SlotBuildIF")) : class$se$ericsson$cello$managedelement$SlotBuildIF);
            SlotBuildIF slotBuildIF = null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    slotBuildIF = (SlotBuildIF)iterator.next();
                    slotBuildIF.startAutoConfiguration();
                }
            }
        }
    }
}

