/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import se.ericsson.cello.moframework.MoDataConvMgr;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.MoDataConverter;
import se.ericsson.cello.su.convert.base.ConverterState;
import se.ericsson.cello.su.convert.base.UpgradeConvertFileInfoContainer;
import se.ericsson.cello.su.convert.base.UpgradeConvertInfoContainer;
import se.ericsson.cello.su.convert.base.UpgradeConvertInfoHandler;
import se.ericsson.cello.su.convert.base.UpgradeMoDataConvertHandler;
import se.ericsson.cello.su.convert.db.ConvertDbTableVersion;
import se.ericsson.cello.su.convert.db.UpgradeConvertDataBaseHandler;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class UpgradeMoDataConverter
implements MoDataConverter {
    private static final String SU_AUE_VERSION_MANIFEST_STRING = "Implementation-Vendor";

    public UpgradeMoDataConverter() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeMoDataConverter");
        }
        MoDataConvMgr.instance().register((MoDataConverter)this);
    }

    public boolean convertMoData(Vector vector, Coordinator coordinator) throws MoDataConversionException {
        HashMap hashMap;
        block11: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "convertMoData(Vector aMoDatas, Coordinator aContext)", "Number of MoDatas: " + vector.size() + "\n\taContext: " + SuLib.toString(coordinator));
            }
            hashMap = null;
            try {
                ConvertDbTableVersion convertDbTableVersion = UpgradeConvertDataBaseHandler.getConvertDbTableToBeUsed();
                if (convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_2)) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "convertMoData(Vector aMoDatas, Coordinator aContext)", "SU temporary converter table exists.\n\ttheConvertDbTableVersion: " + convertDbTableVersion);
                    }
                    hashMap = UpgradeConvertDataBaseHandler.getDbTableInformation(convertDbTableVersion);
                    break block11;
                }
                if (convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_1) || convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_0)) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "convertMoData(Vector aMoDatas, Coordinator aContext)", "SU temporary converter table exists.\n\ttheConvertDbTableVersion: " + convertDbTableVersion);
                    }
                    hashMap = UpgradeConvertInfoHandler.convertDbTableInformationToNewFormat(UpgradeConvertDataBaseHandler.getDbTableInformation(convertDbTableVersion));
                    break block11;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "convertMoData(Vector aMoDatas, Coordinator aContext)", "No SU converter table in database, no convertion of System Upgrade persistent data will be done.");
                }
                return false;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "convertMoData(Vector aMoDatas, Coordinator aContext)", "Throwable caught when retrieving attributes from SU converter table.", throwable);
                throw new MoDataConversionException("Throwable caught when retrieving attributes from SU converter table.\n\tThrowable info: " + throwable);
            }
        }
        boolean bl = this.convertMoData((Collection)vector, hashMap);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "convertMoData(Vector aMoDatas, Coordinator aContext)", "Returning - thePutConverterLastInList: " + bl);
        }
        return bl;
    }

    public static void storeSuConvertInfoInTable(ConverterState converterState, String string, String string2) throws SuConverterException {
        if (Trace.valid(UpgradeMoDataConverter.class, 20)) {
            Trace.debug(UpgradeMoDataConverter.class, 20, "storeSuConvertInfoInTable(ConvertState aConvertState, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision)", "\n\taConvertState: " + converterState + "\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2);
        }
        SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
        String string3 = systemUpgradeConstantsInterface.getNodeUpRootPath();
        String string4 = UpgradePackageCreator.getUpgradeControlFilePath(string3, string, string2);
        HashMap hashMap = UpgradeConvertInfoHandler.createDbTableInformation(converterState, string4);
        UpgradeConvertDataBaseHandler.setDbTableInformation(hashMap);
    }

    public static boolean suConvert_revisionCompatible(String string, String string2) throws SuConverterException {
        if (Trace.valid(UpgradeMoDataConverter.class, 20)) {
            Trace.debug(UpgradeMoDataConverter.class, 20, "suConvert_revisionCompatible(String aNewSU_JarFilePath, String anOldSU_JarFilepath)", "aNewSU_JarFilePath: " + string + "+anOldSU_JarFilepath: " + string2);
        }
        boolean bl = true;
        String string3 = string;
        JarFile jarFile = null;
        Integer n = null;
        Integer n2 = null;
        try {
            jarFile = new JarFile(string3);
            n = UpgradeMoDataConverter.getConvertRevisionFromManifest(jarFile, "new SU jar file");
            string3 = string2;
            jarFile = new JarFile(string3);
            n2 = UpgradeMoDataConverter.getConvertRevisionFromManifest(jarFile, "old SU jar file");
        }
        catch (IOException iOException) {
            Trace.error(UpgradeMoDataConverter.class, "suConvert_revisionCompatible(String aNewSU_JarFilePath, String anOldSU_JarFilepath)", "IOException caught when trying to create JarFile object for file " + string3 + ".", iOException);
            throw new SuConverterException("IOException caught when trying to create JarFile object for file " + string3 + ".");
        }
        catch (SuConverterException suConverterException) {
            throw suConverterException;
        }
        catch (Throwable throwable) {
            Trace.error(UpgradeMoDataConverter.class, "suConvert_revisionCompatible(String aNewSU_JarFilePath, String anOldSU_JarFilepath)", "Throwable caught when trying to create JarFile object for file " + string3 + ".", throwable);
            throw new SuConverterException("Throwable caught when trying to create JarFile object for file " + string3 + ".");
        }
        if (n.compareTo(n2) > 0) {
            bl = false;
        }
        if (Trace.valid(UpgradeMoDataConverter.class, 21)) {
            Trace.debug(UpgradeMoDataConverter.class, 21, "suConvert_revisionCompatible(String aNewSU_JarFilePath, String anOldSU_JarFilepath)", "Returning - theIsCompatible: " + bl);
        }
        return bl;
    }

    public static void deleteSuConvertInfoInTables() throws SuConverterException {
        if (Trace.valid(UpgradeMoDataConverter.class, 20)) {
            Trace.debug(UpgradeMoDataConverter.class, 20, "deleteSuConvertInfoInTables()");
        }
        try {
            UpgradeConvertDataBaseHandler.deleteAllConvertTables();
        }
        catch (SuConverterException suConverterException) {
            Trace.error(UpgradeMoDataConverter.class, "deleteSuConvertInfoInTables()", "SuConverterException caught when deleting su temp tables from database after convert step.", suConverterException);
            throw suConverterException;
        }
        catch (Throwable throwable) {
            Trace.error(UpgradeMoDataConverter.class, "deleteSuConvertInfoInTables()", "Throwable caught when deleting su temp tables from database after convert step.", throwable);
            throw new SuConverterException("Throwable caught when deleting su temp tables from database after convert step. Throwable info: " + throwable);
        }
    }

    public boolean convertMoData(Collection collection, HashMap hashMap) throws MoDataConversionException {
        boolean bl;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convertMoData(Collection aMoDatas, HashMap aDbTableInformation)", "Number of MoDatas: " + collection.size() + "\n\taDbTableInformation: " + hashMap);
        }
        try {
            UpgradeConvertFileInfoContainer.updateAttributeValues(UpgradeConvertInfoHandler.getUpDirPath(hashMap), UpgradeConvertInfoHandler.getConverterState(hashMap));
            UpgradeConvertInfoContainer upgradeConvertInfoContainer = new UpgradeConvertInfoContainer(collection, UpgradeConvertInfoHandler.getPreviousMoDataRevisions(hashMap), UpgradeConvertInfoHandler.getCurrentMoDataRevisions(), UpgradeConvertInfoHandler.getSystemUpgradeMoTypeNames());
            UpgradeMoDataConvertHandler upgradeMoDataConvertHandler = new UpgradeMoDataConvertHandler();
            bl = upgradeMoDataConvertHandler.convert(upgradeConvertInfoContainer);
        }
        catch (SuConverterException suConverterException) {
            throw new MoDataConversionException("SuConverterException caught when handling convert.\n\tSuConverterException info: " + suConverterException);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convertMoData(Vector moData)", "Throwable caught when handling convert.", throwable);
            throw new MoDataConversionException("Throwable caught when handling convert.\n\tThrowable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "convertMoData(Collection aMoDatas, HashMap aDbTableInformation)", "Returning - thePutConverterLastInList: " + bl);
        }
        return bl;
    }

    private static Integer getConvertRevisionFromManifest(JarFile jarFile, String string) throws SuConverterException {
        if (Trace.valid(UpgradeMoDataConverter.class, 20)) {
            Trace.debug(UpgradeMoDataConverter.class, 20, "getConvertRevisionFromManifest(JarFile aJarFile, String aFileLogName)", "aJarFile: " + jarFile + "+aFileLogName: " + string);
        }
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string2 = attributes.getValue(SU_AUE_VERSION_MANIFEST_STRING);
            if (string2 == null) {
                return new Integer(0);
            }
            Integer n = new Integer(attributes.getValue(SU_AUE_VERSION_MANIFEST_STRING));
            if (Trace.valid(UpgradeMoDataConverter.class, 21)) {
                Trace.debug(UpgradeMoDataConverter.class, 21, "suConvert_revisionCompatible(String aNewSU_JarFilePath, String anOldSU_JarFilepath)", "Returning - theConvertRevision: " + n);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(UpgradeMoDataConverter.class, "getConvertRevisionFromManifest(JarFile aJarFile, String aFileLogName)", "NumberFormatException caught when trying to get Manifest information from " + string + ".", numberFormatException);
            throw new SuConverterException("NumberFormatException caught when trying to get Manifest information from " + string + ".");
        }
        catch (IOException iOException) {
            Trace.error(UpgradeMoDataConverter.class, "getConvertRevisionFromManifest(JarFile aJarFile, String aFileLogName)", "IOException caught when trying to get Manifest information from " + string + ".", iOException);
            throw new SuConverterException("IOException caught when trying to get Manifest information from " + string + ".");
        }
        catch (Throwable throwable) {
            Trace.error(UpgradeMoDataConverter.class, "getConvertRevisionFromManifest(JarFile aJarFile, String aFileLogName)", "Throwable caught when trying to get Manifest information from " + string + ".", throwable);
            throw new SuConverterException("IOException caught when trying to get Manifest information from " + string + ".");
        }
    }
}

