/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.su.convert.attribute.BooleanConverterAttribute;
import se.ericsson.cello.su.convert.attribute.FloatConverterAttribute;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.LongConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ReferenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.SequenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StructConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.base.ConverterActionType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class DeleteMoConverterAction
extends ConverterActionBase {
    private String myParentLdn = null;
    private String myId = null;

    public DeleteMoConverterAction(String string, String string2) {
        super(ConverterActionType.DELETE_MO);
        this.myParentLdn = string;
        this.myId = string2;
    }

    protected void execute(Collection collection, String string, Integer n) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(Collection aMoDatas, String aMoTypeName, Integer aNewMoDataRevision)", "Number of MoDatas: " + collection.size() + "\n\taMoTypeName: " + string + "\n\taNewMoDataRevision: " + n);
        }
        try {
            Vector<MoData> vector = new Vector<MoData>(1);
            String string2 = this.createMoLdn(string);
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MoData moData = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                moData = (MoData)iterator.next();
                if (!string2.equals(moData.getLocalDistinguishedName())) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Deleting MO from MoDatas. MO LDN :" + moData.getLocalDistinguishedName());
                }
                this.storeConverterAttributes(moData);
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                moData.delete(coordinator);
                vector.add(moData);
            }
            control.getTerminator().commit();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Removing all MoData that has been deleted from the MoData collection.");
            }
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                collection.remove(iterator2.next());
            }
        }
        catch (SuConvertActionException suConvertActionException) {
            throw suConvertActionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute(MoData aMoData)", "Failed to delete MoData from MoDatas, throwable caught.\n\tParent ldn: " + this.myParentLdn + "\n\tMotypeName: " + string + "\n\tMoID: " + this.myId, throwable);
            throw new SuConvertActionException("Failed to delete MoData from MoDatas, throwable caught. Throwable info: " + throwable);
        }
    }

    public String getParentLdn() {
        return this.myParentLdn;
    }

    public String getId() {
        return this.myId;
    }

    private String createMoLdn(String string) {
        return this.myParentLdn + "," + string + "=" + this.myId;
    }

    private void storeConverterAttributes(MoData moData) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setConverterAttributes(MoData aMoData)", "aMoData: " + SuLib.toString(moData));
        }
        Enumeration enumeration = moData.getAllPersistentAttributes();
        while (enumeration.hasMoreElements()) {
            this.myConverterAttributes.add(this.getConverterAttribute((Attribute)enumeration.nextElement()));
        }
    }

    private ConverterAttributeBase getConverterAttribute(Attribute attribute) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConverterAttribute(Attribute anAttribute)", "anAttribute: " + attribute);
        }
        ConverterAttributeBase converterAttributeBase = null;
        try {
            if (attribute instanceof BooleanAttribute) {
                converterAttributeBase = new BooleanConverterAttribute((BooleanAttribute)attribute);
            } else if (attribute instanceof FloatAttribute) {
                converterAttributeBase = new FloatConverterAttribute((FloatAttribute)attribute);
            } else if (attribute instanceof IntegerAttribute) {
                converterAttributeBase = new IntegerConverterAttribute((IntegerAttribute)attribute);
            } else if (attribute instanceof LongAttribute) {
                converterAttributeBase = new LongConverterAttribute((LongAttribute)attribute);
            } else if (attribute instanceof ReferenceAttribute) {
                converterAttributeBase = new ReferenceConverterAttribute((ReferenceAttribute)attribute);
            } else if (attribute instanceof SequenceAttribute) {
                converterAttributeBase = new SequenceConverterAttribute((SequenceAttribute)attribute);
            } else if (attribute instanceof StringAttribute) {
                converterAttributeBase = new StringConverterAttribute((StringAttribute)attribute);
            } else if (attribute instanceof StructAttribute) {
                converterAttributeBase = new StructConverterAttribute((StructAttribute)attribute);
            }
        }
        catch (ConverterAttributeException converterAttributeException) {
            Trace.error(this.getClass(), " getConverterAttribute(Attribute anAttribute)", "Exception caught when trying to create converter attribute from MoData attribute.", converterAttributeException);
            throw new SuConvertActionException("ConverterAttributeException caught when trying to create converter attribute from MoData attribute.");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConverterAttribute(Attribute anAttribute)", "Returning - theConverterAttribute: " + converterAttributeBase);
        }
        return converterAttributeBase;
    }

    public String toString() {
        return super.toString() + "\n\tmyId: " + this.myId + "\n\tmyParentLdn: " + this.myParentLdn;
    }
}

