/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class LongConverterAttribute
extends ConverterAttributeBase {
    private Long myValue = null;

    public LongConverterAttribute(String string) {
        super(ConverterAttributeType.LONG, string);
    }

    public LongConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.LONG, string, bl);
    }

    public LongConverterAttribute(String string, Long l, Boolean bl) {
        super(ConverterAttributeType.LONG, string, bl);
        this.myValue = l;
    }

    public LongConverterAttribute(LongAttribute longAttribute) {
        super(ConverterAttributeType.LONG, longAttribute.getName(), longAttribute.isAVCNotifier());
        this.myValue = new Long(longAttribute.getValue(null));
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new LongAttribute(this.myName, this.myIsAVC_Notifier.booleanValue(), this.myValue.longValue());
    }

    public String getValueAsString() {
        return this.myValue.toString();
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreviousValue(String aMoLdn, Attribute theAttribute", "aMoLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = attribute.isAVCNotifier();
        this.myPreviousValues.put(string, new Long(((LongAttribute)attribute).getValue(null)));
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = this.myPreviousValues.get(string).toString();
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValue + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

