/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.cv.interfaces;

import se.ericsson.cello.upgradepackage.trace.Trace;

public class CelloCvArmaInfo {
    private int mySrNumber;
    private int mySlotNumber;
    private int myPiuRole;
    private String myProductNumber;
    private String myProductRevision;
    private static final int PIU_TYPE_BP = 0;
    private static final int PIU_TYPE_REGULAR_MP = 1;
    private static final int PIU_TYPE_CORE_MP = 2;

    public CelloCvArmaInfo(int n, int n2, int n3, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CelloCvArmaInfo(int aSrNumber, int aSlotNumber, int aPiuRole, String aProductNumber, String aProductRevision)", "aSrNumber: " + n + "\n\taSlotNumber: " + n2 + "\n\taPiuRole: " + n3 + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        this.mySrNumber = n;
        this.mySlotNumber = n2;
        this.myProductNumber = string;
        this.myProductRevision = string2;
        this.myPiuRole = n3;
        this.checkPiuRole();
    }

    public int getSrNumber() {
        return this.mySrNumber;
    }

    public Integer getSrNumberIntegerValue() {
        return new Integer(this.mySrNumber);
    }

    public int getSlotNumber() {
        return this.mySlotNumber;
    }

    public int getPiuRole() {
        return this.myPiuRole;
    }

    public String getProductNumber() {
        return this.myProductNumber;
    }

    public String getProductRevision() {
        return this.myProductRevision;
    }

    public boolean isCoreMP() {
        return this.myPiuRole == 2;
    }

    public String toString() {
        return "\n\tsrNumber: " + this.mySrNumber + "\tslotNumber: " + this.mySlotNumber + "\n\t\tproductNumber: " + this.myProductNumber + "\tproductRevision: " + this.myProductRevision + "\tpiuRole: " + this.myPiuRole + "(" + this.getPiuRoleAsString() + ")";
    }

    private String getPiuRoleAsString() {
        if (this.myPiuRole == 0) {
            return "BP";
        }
        if (this.myPiuRole == 1) {
            return "REGULAR MP";
        }
        if (this.myPiuRole == 2) {
            return "CORE MP";
        }
        return "UNKNOWN VALUE";
    }

    private void checkPiuRole() {
        if (this.myPiuRole == 0 || this.myPiuRole == 1 || this.myPiuRole == 2) {
            return;
        }
        Trace.warning(this.getClass(), "checkAndGetPiuRole(int aPiuRole)", "The PIU role is unexpected. Assuming piuRole 0 (BP).\n\tsrNumber: " + this.mySrNumber + "\n\tslotNumber: " + this.mySlotNumber + "\n\tPIU_ProductNumber: " + this.myProductNumber + "\n\tPIU_ProductRevision: " + this.myProductRevision + "\n\tPIU_Role: " + this.myPiuRole);
    }
}

