/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.oneclickupgrade;

import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandler;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.util.library.Lib;

public class OneClickUpgradeController
implements Runnable,
Resource {
    public static final int CREATE_FINISHED = 1;
    public static final int INSTALL_FINISHED = 2;
    public static final int UPGRADE_AWAITING_CONFIRMATION = 3;
    private int myStage = -1;
    private Coordinator myCoordinator = null;
    private UpgradePackageMoImpl myUP_Mo = null;

    public OneClickUpgradeController(int n, UpgradePackageMoImpl upgradePackageMoImpl, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OneClickUpgradeController(int aStage, Coordinator aCoordinator)", "aStage: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.myStage = n;
        this.myUP_Mo = upgradePackageMoImpl;
        this.registerResource(coordinator);
    }

    public OneClickUpgradeController(int n, UpgradePackageMoImpl upgradePackageMoImpl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OneClickUpgradeController(int aStage, Coordinator aCoordinator)", "aStage: " + n + "\n\tanUP_Mo: " + upgradePackageMoImpl);
        }
        this.myStage = n;
        this.myUP_Mo = upgradePackageMoImpl;
    }

    public void initiateThread() {
        new Thread((Runnable)this, "OneClickUpgradeController").start();
    }

    private synchronized void registerResource(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "registerResource(Coordinator key)", "\n\tkey: " + Lib.toString((Coordinator)coordinator));
        }
        if (this.myCoordinator != null) {
            throw new TransactionRequiredException();
        }
        this.myCoordinator = coordinator;
        try {
            this.myCoordinator.registerResource((Resource)this);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            UpgradeTrace.error(this.getClass(), (String)"registerResource(Coordinator key)", (String)("InactiveTransactionException caught when trying to register a resource in a transaction.\n\tkey: " + Lib.toString((Coordinator)coordinator)), (Throwable)inactiveTransactionException);
            throw new TransactionRequiredException();
        }
    }

    public void commit() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "commit()");
        }
        if (this.myCoordinator != null) {
            new Thread((Runnable)this, "OneClickUpgradeController").start();
            this.myCoordinator = null;
        } else {
            Trace.info(this.getClass(), "commit()", "No transaction saved so this commit is ignored (not expected)");
        }
    }

    public boolean prepare() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepare()");
        }
        return true;
    }

    public void rollback() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rollback()");
        }
        if (this.myCoordinator != null) {
            UpgradeCoordinator.instance().unlock(ServiceSubType.createUP);
            try {
                UpgradeDB_StorageUtil.removeOneClickUpgrade();
            }
            catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                Trace.error(this.getClass(), "rollback()", "Exception caught when removing, one click-upgrade from DB");
            }
            Trace.info(this.getClass(), "rollback()", "One-Click-Upgrade cancelled since the transaction for the creation of the UP MO has been rolled back.\n\tmyCoordinator: " + SuLib.toString(this.myCoordinator));
            this.myCoordinator = null;
        } else {
            Trace.info(this.getClass(), "rollback", "No transaction saved so this rollback is ignored (not expected)");
        }
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        try {
            if (this.myStage == 1) {
                Trace.log1(this.getClass(), "run()", "Continues with installation of the Upgrade Package Mo.");
                UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(true);
                ServiceController.instance().swapTo(ServiceType.SystemUpgrade, ServiceSubType.install);
                this.myUP_Mo.actionNonBlockingInstall(null, true);
            } else if (this.myStage == 2) {
                Trace.log1(this.getClass(), "run()", "Waits 1000 ms for the installation to clean up before continuing with the upgrade.");
                TimeHandler.sleep(1000L);
                ServiceController.instance().swapTo(ServiceType.SystemUpgrade, ServiceSubType.upgrade);
                this.myUP_Mo.actionRebootNodeUpgrade(null, true);
            } else if (this.myStage == 3) {
                this.myUP_Mo.actionConfirmUpgrade(null);
            } else {
                Trace.info(this.getClass(), "run()", "Unexpected stage value received (ignored)");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Throwable caught when requesting for upgrade, one click-upgrade is aborted");
            UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(false);
        }
    }

    public static boolean isOneClickUpgrade(String string, String string2) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(OneClickUpgradeController.class, 20)) {
            Trace.debug(OneClickUpgradeController.class, 20, "isOneClickUpgrade(String aProdNo, String aRev)", "aProdNo: " + string + "\n\taProdRev: " + string2 + "\n\tUpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductNumber(): " + UpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductNumber() + "\n\tUpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductRevision(): " + UpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductRevision());
        }
        boolean bl = false;
        if (string.equals(UpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductNumber()) && string2.equals(UpgradeDB_StorageUtil.getOneClickUpgradeUP_ProductRevision())) {
            bl = true;
        }
        if (Trace.valid(OneClickUpgradeController.class, 20)) {
            Trace.debug(OneClickUpgradeController.class, 20, "isOneClickUpgrade(String aProdNo, String aRev)", "RETURNS - theIsTrue: " + bl);
        }
        return bl;
    }
}

