/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.verify;

import java.util.Collection;
import java.util.Vector;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallDiskSpaceCheckResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.install.FileInstaller;
import se.ericsson.cello.upgradepackage.install.InitUP_Information;
import se.ericsson.cello.upgradepackage.install.InstallRejectedInsufficientDiskSpaceException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedLoadListFileException;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.util.LoadModulesToBeInstalledAnalyser;
import se.ericsson.cello.upgradepackage.install.util.LoadModulesToBeInstalledAnalyserException;
import se.ericsson.cello.upgradepackage.install.verify.InstallVerifier;
import se.ericsson.cello.upgradepackage.install.verify.InstallVerifyException;
import se.ericsson.cello.upgradepackage.install.verify.event.ConfigurationMissmatchForLM;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyRejectedEvent;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyResponseEvent;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingAvailableDiskSpaceIsSufficientForInstallInformation;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;

public class DiskSpaceVerifier {
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
    private String myLoadListFilePath = this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "simftpget.xml";
    private InitUP_Information myInitUP_Information = null;

    public DiskSpaceVerifier(InitUP_Information initUP_Information) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "DiskSpaceVerifier(InitUP_Information anInitUP_Information)", "anInitUP_Information: " + initUP_Information);
        }
        this.myInitUP_Information = initUP_Information;
    }

    public VerificationResult verifyDiskSpaceSufficientForInstall(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyDiskSpaceSufficientForInstall(boolean anIsVerificationOfForcedInstall)", "anIsVerificationOfForcedInstall: " + bl);
        }
        VerificationResult verificationResult = null;
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingAvailableDiskSpaceIsSufficientForInstallInformation(this));
            Vector vector = this.verifyDiskSpaceForUCF_AndLM_Configuration(this.myInitUP_Information.getUP_InstallRequestEvent());
            Collection collection = this.getLoadModulesToBeInstalled(bl, vector);
            if (!collection.isEmpty()) {
                this.createLoadListFile(this.myLoadListFilePath, collection);
                this.sendSignalForInstallDiskSpaceCheck(this.myLoadListFilePath);
            }
            verificationResult = this.createVerificationResultOK();
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            verificationResult = this.createVerificationResult(hW_SensitiveAdapterException);
        }
        catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
            verificationResult = this.createVerificationResult(installRejectedInsufficientDiskSpaceException);
        }
        catch (Throwable throwable) {
            verificationResult = this.createVerificationResult(throwable);
        }
        return verificationResult;
    }

    private VerificationResult createVerificationResult(HW_SensitiveAdapterException hW_SensitiveAdapterException) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResult(InstallRejectedInsufficientDiskSpaceException anInstallRejectedInsufficientDiskSpaceException)", "aHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
        }
        ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.UNSPECIFIED, "Install verification: Verification of that disk space is sufficient for install was not possible to execute.\n\t" + hW_SensitiveAdapterException.toString());
        return new VerificationResult(false, false, actionResultData);
    }

    private VerificationResult createVerificationResult(InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResult(InstallRejectedInsufficientDiskSpaceException anInstallRejectedInsufficientDiskSpaceException)", "anInstallRejectedInsufficientDiskSpaceException: " + (Object)((Object)installRejectedInsufficientDiskSpaceException));
        }
        ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.LACK_OF_DISK_SPACE_ON_C_DISK, installRejectedInsufficientDiskSpaceException.getErrorInfo());
        return new VerificationResult(true, false, actionResultData);
    }

    private VerificationResult createVerificationResult(Throwable throwable) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResult(Throwable aThrowable)", "aThrowable: " + throwable);
        }
        ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.LACK_OF_DISK_SPACE_ON_C_DISK, "Install verification: Verification of that disk space is sufficient for install was not possible to execute.Reason: Throwable caught,\n\tThrowable: " + throwable);
        return new VerificationResult(false, actionResultData);
    }

    private VerificationResult createVerificationResultOK() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResultOK( )");
        }
        return new VerificationResult(true);
    }

    private void createLoadListFile(String string, Collection collection) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createLoadListFile(String aLoadListFilePath, Collection aLoadModulesToBeInstalled)", "aLoadListFilePath: " + string + "\n\taLoadModulesToBeInstalled: " + collection);
        }
        FileInstaller fileInstaller = new FileInstaller(string);
        fileInstaller.writeToLoadListFile(this.myInitUP_Information.getUP_AndLM_Information().transformedUP.ucfPath, this.myInitUP_Information.getUP_AndLM_Information().transformedUP.productDataOfUP, collection, this.myInitUP_Information.getUP_InstallRequestEvent().ftpServerInformation, false);
    }

    private Collection getLoadModulesToBeInstalled(boolean bl, Collection collection) throws HW_SensitiveAdapterException, InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesToBeInstalled(boolean anIsVerificationOfForcedInstall, Collection aFaultyLoadModuleIdentifiers)", "anIsVerificationOfForcedInstall: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection);
        }
        try {
            Collection collection2 = null;
            LoadModulesToBeInstalledAnalyser loadModulesToBeInstalledAnalyser = new LoadModulesToBeInstalledAnalyser();
            collection2 = this.myInitUP_Information.getUP_AndLM_Information().isDelta ? loadModulesToBeInstalledAnalyser.getLoadModulesToBeInstalledForDeltaUP(this.myInitUP_Information.getUP_AndLM_Information(), this.myInitUP_Information.getUP_InstallRequestEvent(), bl, collection, true) : loadModulesToBeInstalledAnalyser.getLoadModulesToBeInstalled(this.myInitUP_Information.getUP_AndLM_Information(), this.myInitUP_Information.getUP_InstallRequestEvent(), bl, collection, true);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModulesToBeInstalled(boolean anIsVerificationOfForcedInstall, Collection aFaultyLoadModuleIdentifiers)", "RETURNS - theLoadModulesToBeInstalled: " + collection2);
            }
            return collection2;
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModulesToBeInstalled(boolean anIsVerificationOfForcedInstall, Collection aFaultyLoadModuleIdentifiers)", "The search for load modules that needs to be installed has failed due to an HW_SensitiveAdapterException was caught.\n\tHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
            }
            throw hW_SensitiveAdapterException;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModulesToBeInstalled(boolean anIsVerificationOfForcedInstall, Collection aFaultyLoadModuleIdentifiers)", "The search for load modules that needs to be installed has failed due to an LoadModulesToBeInstalledAnalyserException was caught.\n\tLoadModulesToBeInstalledAnalyserException: " + (Object)((Object)loadModulesToBeInstalledAnalyserException));
            }
            throw new InstallVerifyException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoadModulesToBeInstalled(boolean anIsVerificationOfForcedInstall, Collection aFaultyLoadModuleIdentifiers)" + "\n\tLoadModulesToBeInstalledAnalyserException caught." + "\n\tOrigin LoadModulesToBeInstalledAnalyserException: " + (Object)((Object)loadModulesToBeInstalledAnalyserException));
        }
    }

    private void sendSignalForInstallDiskSpaceCheck(String string) throws InstallRejectedInsufficientDiskSpaceException, InstallVerifyException, FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalForInstallDiskSpaceCheck(String aLoadListFilePath)", "aLoadListFilePath: " + string);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            InstallDiskSpaceCheckResultInformation installDiskSpaceCheckResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallDiskSpaceCheckReq(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendSignalForInstallDiskSpaceCheck(String aLoadListFilePath)", "Signal OsaSwInstallDiskSpaceCheckReq sent to the install proxy at Osa layer.");
            }
            if (installDiskSpaceCheckResultInformation.result != 1) {
                if (installDiskSpaceCheckResultInformation.result == 8) {
                    String string2 = "Available disk space is not sufficient for install.";
                    throw new InstallRejectedInsufficientDiskSpaceException(string2, installDiskSpaceCheckResultInformation.errorInformation);
                }
                if (installDiskSpaceCheckResultInformation.result == 2) {
                    throw new InstallVerifyException("Error in the load list file (according to the resource layer).\n\tload list file path: " + string);
                }
                throw new InstallVerifyException("Unexpected result value received in signal OsaSwInstallDiskSpaceCheckRsp (from resource layer). \n\treceived result value: " + installDiskSpaceCheckResultInformation.result + "\n\tload list file path: " + string);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendSignalForInstallDiskSpaceCheck(String aLoadListFilePath)", "FroNotAccessibleException caught: " + froNotAccessibleException.toString());
            }
            throw froNotAccessibleException;
        }
    }

    private Vector verifyDiskSpaceForUCF_AndLM_Configuration(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallRejectedInsufficientDiskSpaceException, InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyDiskSpaceForUCF_AndLM_Configuration(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            InstallVerifier installVerifier = new InstallVerifier();
            VerifyResponseEvent verifyResponseEvent = installVerifier.verify(uP_InstallRequestEvent);
            Vector<ProductNumberAndRevision> vector = new Vector<ProductNumberAndRevision>(1);
            if (verifyResponseEvent instanceof VerifyRejectedEvent) {
                Object object;
                Object object2;
                VerifyRejectedEvent verifyRejectedEvent = (VerifyRejectedEvent)verifyResponseEvent;
                if (!verifyRejectedEvent.configurationMissmatchForLMs.isEmpty()) {
                    object2 = ((VerifyRejectedEvent)verifyResponseEvent).configurationMissmatchForLMs;
                    object = object2.iterator();
                    ConfigurationMissmatchForLM configurationMissmatchForLM = null;
                    ProductNumberAndRevision productNumberAndRevision = null;
                    while (object.hasNext()) {
                        configurationMissmatchForLM = (ConfigurationMissmatchForLM)object.next();
                        productNumberAndRevision = configurationMissmatchForLM.productNumberAndRevision;
                        vector.addElement(productNumberAndRevision);
                    }
                }
                if (!verifyRejectedEvent.diskspaceInformation.isDiskspaceAvailable) {
                    object2 = "Available disk space is not sufficient for install.";
                    object = "Available disk space (on C-disk) in not sufficient for handling of UCF at install,\n\tavailable disk space: " + verifyRejectedEvent.diskspaceInformation.fileSizeAvailable + " MB" + "\n\tfile size required for original UCF: " + verifyRejectedEvent.diskspaceInformation.fileSizeOriginUCF + " MB" + "\n\tfile size required for root UCF: " + verifyRejectedEvent.diskspaceInformation.fileSizeRootUCF + " MB" + "\n\tfile size required for additional space: " + verifyRejectedEvent.diskspaceInformation.fileSizeAdditionalSpace + " MB";
                    throw new InstallRejectedInsufficientDiskSpaceException((String)object2, (String)object);
                }
            }
            return vector;
        }
        catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
            throw installRejectedInsufficientDiskSpaceException;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyDiskSpaceForUCF_AndLM_Configuration(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught at verification of the UP from an installation perspective." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class: " + this.getClass().getName() + "\n\tMethod: verifyDiskSpaceForUCF_AndLM_Configuration(UP_InstallRequestEvent anUP_InstallRequestEvent)" + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }
}

